/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.actions.TypeDeclarationProvider;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptTypeDeclarationProvider
implements TypeDeclarationProvider {
    public PsiElement[] getSymbolTypeDeclarations(@NotNull PsiElement symbol2) {
        if (symbol2 == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(0);
        }
        return JavaScriptTypeDeclarationProvider.getDeclarationElements(symbol2);
    }

    @Nullable
    public static PsiElement[] getDeclarationElements(@NotNull PsiElement symbol2) {
        if (symbol2 == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(1);
        }
        if (!(symbol2 instanceof JSNamedElement)) {
            return null;
        }
        JSType type2 = null;
        if (symbol2 instanceof JSFunction) {
            type2 = ((JSFunction)symbol2).getReturnType();
        } else if (symbol2 instanceof JSVariable) {
            Collection<PsiElement> constructors = JavaScriptTypeDeclarationProvider.findReferencedModuleConstructors((JSVariable)symbol2);
            if (!constructors.isEmpty()) {
                return constructors.toArray(PsiElement.EMPTY_ARRAY);
            }
            type2 = ((JSVariable)symbol2).getJSType();
        } else if (symbol2 instanceof JSExpression) {
            type2 = JSResolveUtil.getExpressionJSType((JSExpression)((JSExpression)symbol2));
        }
        type2 = JSCompositeTypeFactory.optimizeTypeIfComposite((JSType)JavaScriptTypeDeclarationProvider.getNestedCollectionTypeOrSelf(type2, symbol2), (JSUnionOrIntersectionType.OptimizedKind)JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_REMOVED_NULL_UNDEFINED);
        if (type2 != null && type2.isTypeScript()) {
            PsiElement[] elements = TypeScriptTypeParser.resolveElementsByType((JSType)type2).toArray(PsiElement.EMPTY_ARRAY);
            if (elements.length > 0) {
                return elements;
            }
            PsiElement sourceElement = type2.getSourceElement();
            if (sourceElement instanceof TypeScriptType) {
                PsiElement parent = sourceElement.getContext();
                PsiElement targetElement = parent instanceof TypeScriptTypeAlias ? parent : sourceElement;
                return new PsiElement[]{targetElement};
            }
        }
        if (type2 instanceof JSNamedType) {
            PsiFile containingFile = symbol2.getContainingFile();
            String s = type2.getResolvedTypeText();
            boolean ecmaL4 = DialectDetector.isActionScript((PsiElement)containingFile);
            GlobalSearchScope scope2 = JSResolveUtil.getResolveScope((PsiElement)containingFile);
            PsiElement item = JSDialectSpecificHandlersFactory.forElement((PsiElement)symbol2).getClassResolver().findClassByQName(s, symbol2);
            if (item == null) {
                ArrayList result2 = new ArrayList();
                JSClassResolver.processElementsByNameIncludingImplicit((String)s, (GlobalSearchScope)scope2, (boolean)false, namedElement -> {
                    boolean ecmalL4File = DialectDetector.isActionScript((PsiElement)namedElement.getContainingFile());
                    if (ecmalL4File != ecmaL4) {
                        return true;
                    }
                    result2.add(0, namedElement);
                    return true;
                });
                if (!result2.isEmpty()) {
                    item = (PsiElement)result2.get(0);
                }
            }
            if (item != null && item.isPhysical()) {
                return new PsiElement[]{item};
            }
        }
        return new PsiElement[]{symbol2};
    }

    @NotNull
    private static Collection<PsiElement> findReferencedModuleConstructors(JSVariable element2) {
        if (element2 instanceof JSParameter) {
            JSLiteralExpression argument = JSSymbolUtil.getParameterInitializationIfRequireArgument((JSParameter)((JSParameter)element2));
            if (argument != null) {
                Collection modules = JSFileReferencesUtil.resolveModuleReferences((PsiElement)argument);
                for (PsiElement resolve : modules) {
                    if (!(resolve instanceof JSFile)) continue;
                    List exportedElements = JSResolveUtil.getExportedElements((JSExecutionScope)((JSFile)resolve));
                    Collection<Object> collection = exportedElements.isEmpty() ? Collections.singleton(resolve) : Collections.unmodifiableCollection(exportedElements);
                    if (collection == null) {
                        JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(2);
                    }
                    return collection;
                }
            }
        } else {
            JSExpression initializer = element2.getInitializer();
            if (initializer instanceof JSCallExpression) {
                return JavaScriptTypeDeclarationProvider.findReferencedModuleConstructorIfRequireCall((JSCallExpression)initializer);
            }
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static JSType getNestedCollectionTypeOrSelf(@Nullable JSType type2, @NotNull PsiElement symbol2) {
        JSType nested;
        if (symbol2 == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(4);
        }
        return (nested = JavaScriptTypeDeclarationProvider.getNestedType(type2 = JSTypeUtils.getValuableType((JSType)type2, (PsiElement)symbol2))) instanceof JSNamedType ? nested : type2;
    }

    @Nullable
    private static JSType getNestedType(@Nullable JSType type2) {
        if (type2 instanceof JSAliasTypeImpl) {
            JSAliasTypeImpl aliasType = (JSAliasTypeImpl)type2;
            return aliasType.getAlias();
        }
        if (type2 instanceof JSGenericTypeImpl) {
            if (JSTypeUtils.isMapType((JSType)type2)) {
                return (JSType)ContainerUtil.getLastItem((List)((JSGenericTypeImpl)type2).getArguments());
            }
            return JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)((JSGenericTypeImpl)type2), (boolean)false, baseType -> JSNamedType.isNamedTypeWithNames((JSType)baseType, (Set)JSCommonTypeNames.UTIL_TYPES) ? Function.identity() : JSTypeUtils.isSingleGenericComponentType((JSType)baseType, (boolean)true));
        }
        return JSTypeUtils.getIndexableComponentType((JSType)type2, (boolean)false, (boolean)true);
    }

    @NotNull
    private static Collection<PsiElement> findReferencedModuleConstructorIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(5);
        }
        SmartList result2 = new SmartList();
        PsiElement module = CommonJSUtil.findReferencedModuleIfRequireCall((JSCallExpression)callExpression);
        if (module instanceof JSFile) {
            List exportedElements = JSResolveUtil.getExportedElements((JSExecutionScope)((JSFile)module));
            for (PsiElement exportedElement : exportedElements) {
                PsiElement element2;
                String reference;
                if (exportedElement instanceof JSDefinitionExpression && (reference = JSPsiImplUtils.getInitializerReference((JSInitializerOwner)((JSDefinitionExpression)exportedElement))) != null && (element2 = JSStubBasedPsiTreeUtil.resolveLocally((String)reference, (PsiElement)exportedElement)) != null) {
                    result2.add(element2);
                    continue;
                }
                if (exportedElement == null) continue;
                result2.add(exportedElement);
            }
        }
        if (result2.isEmpty() && module != null) {
            result2.add(module);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            JavaScriptTypeDeclarationProvider.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/navigation/JavaScriptTypeDeclarationProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModuleConstructors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModuleConstructorIfRequireCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolTypeDeclarations";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationElements";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNestedCollectionTypeOrSelf";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModuleConstructorIfRequireCall";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

