/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.stubs.JSEmbeddedContentStub;
import com.intellij.lang.javascript.psi.stubs.TypeScriptModuleStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileCachedData;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubImpl;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BackendStubTreeUtil {
    @Nullable
    public static Language getJSLanguage(@NotNull StubElement<?> stub) {
        if (stub == null) {
            BackendStubTreeUtil.$$$reportNull$$$0(0);
        }
        for (StubElement parent = stub; parent != null; parent = parent.getParentStub()) {
            stub = parent;
        }
        return stub instanceof JSFileStubImpl ? ((JSFileStubImpl)stub).getLanguage() : null;
    }

    public static boolean isFromGlobalNamespace(StubElement<?> startElement) {
        if (startElement instanceof TypeScriptModuleStub && !((TypeScriptModuleStub)startElement).isAugmentation() && BackendStubTreeUtil.isExternalModule(startElement)) {
            return true;
        }
        for (StubElement parentStub = startElement.getParentStub(); parentStub != null; parentStub = parentStub.getParentStub()) {
            if (parentStub instanceof PsiFileStub) {
                if (parentStub instanceof JSFileStubImpl) {
                    JSFileStubImpl fileStub = (JSFileStubImpl)parentStub;
                    JSFileCachedData data2 = fileStub.getCachedData();
                    if (data2 == null) {
                        return true;
                    }
                    JSModuleStatusOwner.ModuleStatus status = data2.getModuleStatus();
                    return status != JSModuleStatusOwner.ModuleStatus.ES6 && status != JSModuleStatusOwner.ModuleStatus.COMMONJS;
                }
                return true;
            }
            if (parentStub instanceof TypeScriptModuleStub) {
                StubElement possibleModuleElement = parentStub.getParentStub();
                if (possibleModuleElement instanceof JSFileStubImpl) {
                    String name = ((TypeScriptModuleStub)parentStub).getName();
                    return TypeScriptUtil.convertToExternalModuleText((String)name) == null;
                }
                if (!BackendStubTreeUtil.isExternalModule(possibleModuleElement)) continue;
                return ((TypeScriptModuleStub)parentStub).getName() == null;
            }
            if (!(parentStub instanceof JSEmbeddedContentStub)) continue;
            IElementType type2 = parentStub.getElementType();
            return !JSExtendedLanguagesTokenSetProvider.MODULE_EMBEDDED_CONTENTS.contains(type2);
        }
        return true;
    }

    private static boolean isExternalModule(StubElement<?> possibleModuleElement) {
        if (!(possibleModuleElement instanceof TypeScriptModuleStub)) {
            return false;
        }
        String name = ((TypeScriptModuleStub)possibleModuleElement).getName();
        return TypeScriptUtil.convertToExternalModuleText((String)name) != null;
    }

    public static boolean checkParentStubShouldCreate(@NotNull ASTNode node) {
        ASTNode owner;
        if (node == null) {
            BackendStubTreeUtil.$$$reportNull$$$0(1);
        }
        if ((owner = node.getTreeParent()) != null) {
            IElementType ownerType = owner.getElementType();
            StubElementFactory stubFactory = StubElementRegistryService.getInstance().getStubFactory(ownerType);
            if (stubFactory != null) {
                return stubFactory.shouldCreateStub(owner);
            }
            if (ownerType instanceof JSFileElementType) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/BackendStubTreeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getJSLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParentStubShouldCreate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

