/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceStatisticsCollector;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtilKt;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceConnector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ObjectUtils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0002\b\u0004\b\u0016\u0018\u0000 V*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002UVB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0004\u0018\u00018\u0000H\u0086@\u00a2\u0006\u0002\u00107J\u0010\u00108\u001a\u0004\u0018\u00018\u0000H\u0082@\u00a2\u0006\u0002\u00107J\u0010\u00109\u001a\u0004\u0018\u00018\u0000H\u0082@\u00a2\u0006\u0002\u00107J\u000f\u0010:\u001a\t\u0018\u00010%\u00a2\u0006\u0002\b;H\u0002J\u0010\u0010<\u001a\u0002052\u0006\u0010=\u001a\u00020/H\u0002J\b\u0010>\u001a\u000205H\u0002J\u0010\u0010?\u001a\u0002052\u0006\u0010=\u001a\u00020/H\u0014J\b\u0010@\u001a\u000205H\u0004J\u0017\u0010A\u001a\u0002052\r\u0010B\u001a\t\u0018\u00010%\u00a2\u0006\u0002\b&H\u0002J\b\u0010C\u001a\u000205H\u0016J\b\u0010D\u001a\u000205H\u0014J\b\u0010E\u001a\u000205H\u0004J\u0010\u0010F\u001a\u0002052\u0006\u0010G\u001a\u00020HH\u0004J\u0017\u0010F\u001a\u0002052\r\u0010I\u001a\t\u0018\u00010%\u00a2\u0006\u0002\b;H\u0004J\b\u0010J\u001a\u000205H\u0004J\u001c\u0010Q\u001a\u0002052\u0006\u0010B\u001a\u00020%2\n\b\u0002\u0010R\u001a\u0004\u0018\u00010SH\u0004J\u0010\u0010T\u001a\u0002052\u0006\u0010B\u001a\u00020%H\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010$\u001a\t\u0018\u00010%\u00a2\u0006\u0002\b&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00100\u001a\u0004\u0018\u000101X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0014\u0010K\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0014\u0010M\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010LR\u0016\u0010N\u001a\u0004\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\u00a8\u0006W"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl;", "T", "Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "protocol", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceConnector;", "myProcessConnector", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ProcessConnector;", "myReporter", "Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;", "startImmediately", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceConnector;Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ProcessConnector;Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProtocol", "()Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceConnector;", "getMyReporter", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceQueue$ServiceInfoReporter;", "myInitialized", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "serviceStateLock", "Lkotlinx/coroutines/sync/Mutex;", "getServiceStateLock", "()Lkotlinx/coroutines/sync/Mutex;", "commandCoroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "getCommandCoroutineScope$annotations", "()V", "getCommandCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "myDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "myStartErrorMessage", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "value", "Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutor$State;", "state", "getState", "()Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutor$State;", "setState", "(Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutor$State;)V", "myProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "myLifecycleSpan", "Lio/opentelemetry/api/trace/Span;", "getMyLifecycleSpan", "()Lio/opentelemetry/api/trace/Span;", "scheduleStartService", "", "startAndWaitForReadyNotification", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startServiceWithProgress", "startService", "getProgressIndicatorTitle", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "connectProcessHandler", "processHandler", "createProcessHandler", "registerProcessListeners", "processTerminated", "reportUserError", "message", "dispose", "doDispose", "shutdownPool", "startAction", "command", "Lcom/intellij/lang/javascript/service/protocol/JSLanguageServiceCommand;", "text", "endAction", "isStarted", "()Z", "isValid", "startErrorMessage", "getStartErrorMessage", "()Ljava/lang/String;", "infoLog", "exception", "", "debugLog", "JSLanguageServiceExecutorCoroutineScope", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSLanguageServiceExecutorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSLanguageServiceExecutorImpl.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,401:1\n30#2,2:402\n116#3,11:404\n*S KotlinDebug\n*F\n+ 1 JSLanguageServiceExecutorImpl.kt\ncom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl\n*L\n54#1:402,2\n114#1:404,11\n*E\n"})
public class JSLanguageServiceExecutorImpl<T>
implements JSLanguageServiceExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JSLanguageServiceConnector<T> protocol;
    @Nullable
    private final JSLanguageServiceQueue.ProcessConnector myProcessConnector;
    @NotNull
    private final JSLanguageServiceQueue.ServiceInfoReporter myReporter;
    private final boolean startImmediately;
    @NotNull
    private final CompletableFuture<Void> myInitialized;
    @NotNull
    private final Mutex serviceStateLock;
    @NotNull
    private final CoroutineScope commandCoroutineScope;
    @NotNull
    private final AtomicBoolean myDisposed;
    @Nullable
    private volatile String myStartErrorMessage;
    @NotNull
    private volatile JSLanguageServiceExecutor.State state;
    @Nullable
    private ProcessHandler myProcessHandler;
    @Nullable
    private final Span myLifecycleSpan;

    public JSLanguageServiceExecutorImpl(@NotNull Project project, @NotNull JSLanguageServiceConnector<T> protocol, @Nullable JSLanguageServiceQueue.ProcessConnector myProcessConnector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter myReporter, boolean startImmediately) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)myReporter, (String)"myReporter");
        this.project = project;
        this.protocol = protocol;
        this.myProcessConnector = myProcessConnector;
        this.myReporter = myReporter;
        this.startImmediately = startImmediately;
        this.myInitialized = new CompletableFuture();
        this.serviceStateLock = MutexKt.Mutex((boolean)false);
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<JSLanguageServiceExecutorCoroutineScope> serviceClass$iv = JSLanguageServiceExecutorCoroutineScope.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.commandCoroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)((JSLanguageServiceExecutorCoroutineScope)object).getCoroutineScope(), (String)("JS external service " + this.myReporter.getPresentableServiceName()), null, (boolean)false, (int)6, null);
        this.myDisposed = new AtomicBoolean(false);
        this.state = JSLanguageServiceExecutor.State.STARTING;
        this.myLifecycleSpan = Span.current();
        if (this.startImmediately) {
            this.scheduleStartService();
        }
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public JSLanguageServiceConnector<T> getProtocol() {
        return this.protocol;
    }

    @NotNull
    protected final JSLanguageServiceQueue.ServiceInfoReporter getMyReporter() {
        return this.myReporter;
    }

    @NotNull
    protected final Mutex getServiceStateLock() {
        return this.serviceStateLock;
    }

    @NotNull
    protected final CoroutineScope getCommandCoroutineScope() {
        return this.commandCoroutineScope;
    }

    protected static /* synthetic */ void getCommandCoroutineScope$annotations() {
    }

    @Override
    @NotNull
    public JSLanguageServiceExecutor.State getState() {
        return this.state;
    }

    protected void setState(@NotNull JSLanguageServiceExecutor.State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
        this.state = state;
    }

    @Nullable
    protected final Span getMyLifecycleSpan() {
        return this.myLifecycleSpan;
    }

    private final void scheduleStartService() {
        CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ JSLanguageServiceExecutorImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Mutex coroutineStarted = MutexKt.Mutex((boolean)true);
                        Mutex startServiceMutex = MutexKt.Mutex((boolean)false);
                        BuildersKt.launch$default((CoroutineScope)this.this$0.getCommandCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, coroutineStarted, startServiceMutex, null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            int I$0;
                            int I$1;
                            int label;
                            final /* synthetic */ JSLanguageServiceExecutorImpl<T> this$0;
                            final /* synthetic */ Mutex $coroutineStarted;
                            final /* synthetic */ Mutex $startServiceMutex;
                            {
                                this.this$0 = $receiver;
                                this.$coroutineStarted = $coroutineStarted;
                                this.$startServiceMutex = $startServiceMutex;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Unable to fully structure code
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public final Object invokeSuspend(Object $result) {
                                block11: {
                                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var2_3 = this.this$0.getServiceStateLock();
                                            var4_4 = this.$coroutineStarted;
                                            var5_5 = this.$startServiceMutex;
                                            var6_6 = this.this$0;
                                            owner$iv = null;
                                            $i$f$withLock = 0;
                                            this.L$0 = $this$withLock_u24default$iv;
                                            this.L$1 = var4_4;
                                            this.L$2 = var5_5;
                                            this.L$3 = var6_6;
                                            this.I$0 = $i$f$withLock;
                                            this.label = 1;
                                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                            if (v0 == var11_2) {
                                                return var11_2;
                                            }
                                            ** GOTO lbl31
                                        }
                                        case 1: {
                                            $i$f$withLock = this.I$0;
                                            var6_6 = (JSLanguageServiceExecutorImpl<T>)this.L$3;
                                            var5_5 = (Mutex)this.L$2;
                                            var4_4 = (Mutex)this.L$1;
                                            owner$iv = null;
                                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl31:
                                            // 3 sources

                                            $i$a$-withLock$default-JSLanguageServiceExecutorImpl$scheduleStartService$1$1$1 = 0;
                                            Mutex.DefaultImpls.unlock$default((Mutex)var4_4, null, (int)1, null);
                                            if (!Mutex.DefaultImpls.tryLock$default((Mutex)var5_5, null, (int)1, null)) break;
                                            this.L$0 = $this$withLock_u24default$iv;
                                            this.L$1 = null;
                                            this.L$2 = null;
                                            this.L$3 = null;
                                            this.I$0 = $i$f$withLock;
                                            this.I$1 = $i$a$-withLock$default-JSLanguageServiceExecutorImpl$scheduleStartService$1$1$1;
                                            this.label = 2;
                                            v1 = JSLanguageServiceExecutorImpl.access$startServiceWithProgress(var6_6, (Continuation)this);
                                            v2 = v1;
                                            if (v1 == var11_2) {
                                                return var11_2;
                                            }
                                            break block11;
                                        }
                                        case 2: {
                                            $i$a$-withLock$default-JSLanguageServiceExecutorImpl$scheduleStartService$1$1$1 = this.I$1;
                                            $i$f$withLock = this.I$0;
                                            owner$iv = null;
                                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                                            ** try [egrp 1[TRYBLOCK] [1 : 271->298)] { 
lbl56:
                                            // 1 sources

                                            ResultKt.throwOnFailure((Object)$result);
                                            v2 = $result;
                                            break block11;
                                        }
                                    }
                                    var6_6.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
                                    v2 = Unit.INSTANCE;
                                }
                                var9_12 = Unit.INSTANCE;
                                return Unit.INSTANCE;
lbl66:
                                // 1 sources

                                finally {
                                    $this$withLock_u24default$iv.unlock(owner$iv);
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)coroutineStarted);
                        this.L$1 = startServiceMutex;
                        this.label = 1;
                        Object object2 = TimeoutKt.withTimeout((long)JSLanguageServiceUtil.getShortTimeout(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(coroutineStarted, null){
                            int label;
                            final /* synthetic */ Mutex $coroutineStarted;
                            {
                                this.$coroutineStarted = $coroutineStarted;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = Mutex.DefaultImpls.lock$default((Mutex)this.$coroutineStarted, null, (Continuation)((Continuation)this), (int)1, null);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        Mutex startServiceMutex = (Mutex)this.L$1;
                        Mutex coroutineStarted = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (TimeoutCancellationException e) {
                            if (!Mutex.DefaultImpls.tryLock$default((Mutex)startServiceMutex, null, (int)1, null)) return Unit.INSTANCE;
                            this.this$0.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
                            throw e;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object startAndWaitForReadyNotification(@NotNull Continuation<? super T> $completion) {
        if (!($completion instanceof startAndWaitForReadyNotification.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ JSLanguageServiceExecutorImpl<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startAndWaitForReadyNotification((Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.startImmediately) {
                    throw new IllegalStateException("JSLanguageServiceExecutorImpl started twice");
                }
                $this$withLock_u24default$iv = this.serviceStateLock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl31
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl31:
                // 3 sources

                $i$a$-withLock$default-JSLanguageServiceExecutorImpl$startAndWaitForReadyNotification$2 = 0;
                $continuation.L$0 = $this$withLock_u24default$iv;
                $continuation.I$0 = $i$f$withLock;
                $continuation.I$1 = $i$a$-withLock$default-JSLanguageServiceExecutorImpl$startAndWaitForReadyNotification$2;
                $continuation.label = 2;
                v1 = this.startServiceWithProgress((Continuation<? super T>)$continuation);
                ** if (v1 != var9_4) goto lbl40
lbl39:
                // 1 sources

                return var9_4;
lbl40:
                // 1 sources

                ** GOTO lbl51
            }
            case 2: {
                $i$a$-withLock$default-JSLanguageServiceExecutorImpl$startAndWaitForReadyNotification$2 = $continuation.I$1;
                $i$f$withLock = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl51:
                    // 2 sources

                    var6_12 = v1;
                }
                catch (Throwable var5_11) {
                    throw var5_11;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                return var6_12;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object startServiceWithProgress(Continuation<? super T> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object startService(Continuation<? super T> $completion) {
        if (!($completion instanceof startService.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ JSLanguageServiceExecutorImpl<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSLanguageServiceExecutorImpl.access$startService(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                try {
                    if (this.getState() == JSLanguageServiceExecutor.State.DISPOSED) {
                        this.debugLog("StartService: already disposed");
                        var2_5 = null;
                        return var2_5;
                    }
                    this.debugLog("Creating OS Handler");
                    JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this, "createProcessHandler", null, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, startService$lambda$0(com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl ), ()Lkotlin/Unit;)((JSLanguageServiceExecutorImpl)this), 2, null);
                    if (this.myProcessHandler == null) {
                        var2_6 = null;
                        return var2_6;
                    }
                    this.debugLog("OS Handler created successfully");
                    JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this, "connectProcessHandler", null, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, startService$lambda$1(com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl ), ()Lkotlin/Unit;)((JSLanguageServiceExecutorImpl)this), 2, null);
                }
                finally {
                    this.myInitialized.complete(null);
                }
                exception = null;
                $continuation.label = 1;
                v0 = JSLanguageServiceTracerUtilKt.withScopedServiceTraceSpan$default(this, "awaitReadyNotification", null, (Function2)new Function2<Span, Continuation<? super T>, Object>(this, null){
                    int label;
                    final /* synthetic */ JSLanguageServiceExecutorImpl<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                JSLanguageServiceConnector<T> jSLanguageServiceConnector = this.this$0.getProtocol();
                                ProcessHandler processHandler = JSLanguageServiceExecutorImpl.access$getMyProcessHandler$p(this.this$0);
                                Intrinsics.checkNotNull((Object)processHandler);
                                this.label = 1;
                                Object object2 = jSLanguageServiceConnector.awaitReadyNotification(processHandler, (Continuation)this);
                                if (object2 != object) return object2;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return object2;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Span p1, Continuation<? super T> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, (Continuation)$continuation, 2, null);
                ** if (v0 != var8_4) goto lbl39
lbl38:
                // 1 sources

                return var8_4;
lbl39:
                // 1 sources

                ** GOTO lbl46
            }
            case 1: {
                exception = null;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl46:
                    // 2 sources

                    var4_9 = v0;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
                catch (Exception e) {
                    exception = e;
                    var4_9 = null;
                }
                readyNotification = var4_9;
                if (this.getState() == JSLanguageServiceExecutor.State.DISPOSED) {
                    this.debugLog("StartService after awaitReadyNotification. Already disposed.");
                    return null;
                }
                if (exception != null) {
                    this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
                    v1 = com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl$Companion.access$getPresentableExceptionMessage(JSLanguageServiceExecutorImpl.Companion, exception);
                    Intrinsics.checkNotNull((Object)v1);
                    this.reportUserError(v1);
                    this.infoLog("Exception while waiting for ready notification", exception);
                    return null;
                }
                if (readyNotification != null) {
                    this.setState(JSLanguageServiceExecutor.State.STARTED);
                } else {
                    this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
                    this.reportUserError((String)ObjectUtils.coalesce((Object)this.getProtocol().getInitializeError(), (Object)JavaScriptBundle.message((String)"javascript.language.service.start.timeout", (Object[])new Object[0])));
                    JSLanguageServiceExecutorImpl.infoLog$default(this, "Timed out waiting for ready notification", null, 2, null);
                }
                return readyNotification;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getProgressIndicatorTitle() {
        return this.myProcessConnector != null ? this.myReporter.getPresentableServiceName() : null;
    }

    private final void connectProcessHandler(ProcessHandler processHandler) {
        block0: {
            JSLanguageServiceQueue.ProcessConnector processConnector = this.myProcessConnector;
            if (processConnector == null) break block0;
            processConnector.connectToProcessHandler(processHandler);
        }
    }

    private final void createProcessHandler() {
        try {
            ProcessHandler processHandler;
            this.myProcessHandler = processHandler = this.getProtocol().connect();
            if (processHandler == null) {
                this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
                this.reportUserError((String)ObjectUtils.coalesce((Object)this.getProtocol().getInitializeError(), (Object)JavaScriptBundle.message((String)"javascript.language.service.start.timeout", (Object[])new Object[0])));
                JSLanguageServiceExecutorImpl.infoLog$default(this, "Error creating process handler", null, 2, null);
                return;
            }
            this.registerProcessListeners(processHandler);
        }
        catch (Exception e) {
            this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
            String string = JSLanguageServiceExecutorImpl.Companion.getPresentableExceptionMessage(e);
            Intrinsics.checkNotNull((Object)string);
            this.reportUserError(string);
            JSLanguageServiceQueue.Holder.LOGGER.info("Error while creating OS Handler: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void registerProcessListeners(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        processHandler.addProcessListener(new ProcessListener(this){
            final /* synthetic */ JSLanguageServiceExecutorImpl<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (outputType == ProcessOutputTypes.STDERR) {
                    if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
                        JSLanguageServiceQueue.Holder.LOGGER.debug("Stderr output: " + StringUtil.escapeLineBreak((String)event.getText()));
                    }
                    return;
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                        JSLanguageServiceQueue.Holder.LOGGER.trace("Stdout output: " + StringUtil.escapeLineBreak((String)event.getText()));
                    }
                    if (ApplicationKt.getApplication().isUnitTestMode()) {
                        ComponentManager $this$service$iv = (ComponentManager)ApplicationKt.getApplication();
                        boolean $i$f$service = false;
                        Class<JSLanguageServiceStatisticsCollector> serviceClass$iv = JSLanguageServiceStatisticsCollector.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        ((JSLanguageServiceStatisticsCollector)object).responseReceived(event.getText().length());
                    }
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.processTerminated();
                if (JSLanguageServiceQueue.Holder.LOGGER.isTraceEnabled()) {
                    JSLanguageServiceQueue.Holder.LOGGER.trace("Process [" + event.getProcessHandler() + "] was killed " + event.getText());
                }
            }
        });
    }

    protected final void processTerminated() {
        if (this.getState() == JSLanguageServiceExecutor.State.STARTED || this.getState() == JSLanguageServiceExecutor.State.STARTING) {
            this.setState(JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT);
        }
    }

    private final void reportUserError(String message) {
        if (message != null) {
            this.myStartErrorMessage = message;
            this.myReporter.startingError(message);
        }
    }

    public void dispose() {
        if (this.myDisposed.compareAndSet(false, true)) {
            this.doDispose();
        } else {
            this.debugLog("Dispose. already disposed");
        }
    }

    protected void doDispose() {
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            String string = "Disposing service %s with hashCode %s";
            Object[] objectArray = new Object[]{this.myReporter.getPresentableServiceName(), this.hashCode()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            JSLanguageServiceQueue.Holder.LOGGER.debug(string2, new Throwable());
        }
        Span disposeSpan = JSLanguageServiceTracerUtilKt.serviceTraceSpanBuilder(this.getClass(), "dispose", this.myLifecycleSpan).startSpan();
        CompletionStage disposeFuture = ((CompletableFuture)this.myInitialized.thenRunAsync(() -> JSLanguageServiceExecutorImpl.doDispose$lambda$0(disposeSpan, this), PooledThreadExecutor.INSTANCE)).whenComplete((arg_0, arg_1) -> JSLanguageServiceExecutorImpl.doDispose$lambda$2((arg_0, arg_1) -> JSLanguageServiceExecutorImpl.doDispose$lambda$1(disposeSpan, arg_0, arg_1), arg_0, arg_1));
        if (ApplicationKt.getApplication().isUnitTestMode() && this.getState() != JSLanguageServiceExecutor.State.STARTING) {
            try {
                Void cfr_ignored_0 = (Void)((CompletableFuture)disposeFuture).get(11L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed to completely dispose service", e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to completely dispose service", e);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Failed to completely dispose service", e);
            }
        }
    }

    protected final void shutdownPool() {
        try {
            kotlinx.coroutines.CoroutineScopeKt.cancel((CoroutineScope)this.commandCoroutineScope, (CancellationException)new CancellationException("Service shutdown"));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            JSLanguageServiceConnector<T> jSLanguageServiceConnector = this.getProtocol();
            Disposable disposable = jSLanguageServiceConnector instanceof Disposable ? (Disposable)jSLanguageServiceConnector : null;
            if (disposable != null) {
                disposable.dispose();
            }
        }
        catch (Exception e) {
            JSLanguageServiceQueue.Holder.LOGGER.error("Failed to dispose language service protocol", (Throwable)e);
        }
    }

    protected final void startAction(@NotNull JSLanguageServiceCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.startAction(command.getPresentableText(this.project));
    }

    protected final void startAction(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        this.myReporter.setProcess(text);
    }

    protected final void endAction() {
        if (this.getState() == JSLanguageServiceExecutor.State.STARTED) {
            this.myReporter.setProcess(null);
        }
    }

    protected final boolean isStarted() {
        return this.getState() == JSLanguageServiceExecutor.State.STARTED;
    }

    @Override
    public boolean isValid() {
        JSLanguageServiceExecutor.State state = this.getState();
        return state != JSLanguageServiceExecutor.State.DISPOSED && state != JSLanguageServiceExecutor.State.ERROR_OR_TIMEOUT;
    }

    @Override
    @Nullable
    public String getStartErrorMessage() {
        String string = this.getProtocol().getInitializeError();
        if (string == null) {
            string = this.myStartErrorMessage;
        }
        return string;
    }

    protected final void infoLog(@NotNull String message, @Nullable Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JSLanguageServiceQueue.Holder.LOGGER.info(this.myReporter.getPresentableServiceName() + ": " + message, exception);
    }

    public static /* synthetic */ void infoLog$default(JSLanguageServiceExecutorImpl jSLanguageServiceExecutorImpl, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: infoLog");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        jSLanguageServiceExecutorImpl.infoLog(string, throwable);
    }

    protected final void debugLog(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        JSLanguageServiceQueue.Holder.LOGGER.debug(this.myReporter.getPresentableServiceName() + ": " + message);
    }

    private static final Unit startService$lambda$0(JSLanguageServiceExecutorImpl this$0) {
        this$0.createProcessHandler();
        return Unit.INSTANCE;
    }

    private static final Unit startService$lambda$1(JSLanguageServiceExecutorImpl this$0) {
        ProcessHandler processHandler = this$0.myProcessHandler;
        Intrinsics.checkNotNull((Object)processHandler);
        this$0.connectProcessHandler(processHandler);
        return Unit.INSTANCE;
    }

    private static final Unit doDispose$lambda$0$0$0(JSLanguageServiceExecutorImpl this$0) {
        this$0.shutdownPool();
        return Unit.INSTANCE;
    }

    private static final Unit doDispose$lambda$0$0$1(JSLanguageServiceExecutorImpl this$0) {
        ProcessHandler processHandler = this$0.myProcessHandler;
        Intrinsics.checkNotNull((Object)processHandler);
        ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)10000L, null);
        return Unit.INSTANCE;
    }

    private static final Unit doDispose$lambda$0$0$2(JSLanguageServiceExecutorImpl this$0) {
        this$0.myProcessConnector.disconnectFromProcessHandler(false);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doDispose$lambda$0(Span $disposeSpan, JSLanguageServiceExecutorImpl this$0) {
        AutoCloseable autoCloseable = (AutoCloseable)$disposeSpan.makeCurrent();
        Throwable throwable = null;
        try {
            Scope it = (Scope)autoCloseable;
            boolean bl = false;
            this$0.setState(JSLanguageServiceExecutor.State.DISPOSED);
            try {
                JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this$0, "shutdownPool", null, () -> JSLanguageServiceExecutorImpl.doDispose$lambda$0$0$0(this$0), 2, null);
            }
            finally {
                if (this$0.myProcessHandler != null) {
                    ProcessHandler processHandler = this$0.myProcessHandler;
                    Intrinsics.checkNotNull((Object)processHandler);
                    if (!processHandler.isProcessTerminated()) {
                        JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this$0, "terminateProcessHandler", null, () -> JSLanguageServiceExecutorImpl.doDispose$lambda$0$0$1(this$0), 2, null);
                    }
                    this$0.myProcessHandler = null;
                    if (this$0.myProcessConnector != null) {
                        JSLanguageServiceTracerUtilKt.withServiceTraceSpan$default(this$0, "disconnectFromProcessHandler", null, () -> JSLanguageServiceExecutorImpl.doDispose$lambda$0$0$2(this$0), 2, null);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final Unit doDispose$lambda$1(Span $disposeSpan, Void void_, Throwable throwable) {
        $disposeSpan.end();
        return Unit.INSTANCE;
    }

    private static final void doDispose$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Object access$startServiceWithProgress(JSLanguageServiceExecutorImpl $this, Continuation $completion) {
        return $this.startServiceWithProgress($completion);
    }

    public static final /* synthetic */ Object access$startService(JSLanguageServiceExecutorImpl $this, Continuation $completion) {
        return $this.startService($completion);
    }

    public static final /* synthetic */ ProcessHandler access$getMyProcessHandler$p(JSLanguageServiceExecutorImpl $this) {
        return $this.myProcessHandler;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$Companion;", "", "<init>", "()V", "getPresentableExceptionMessage", "", "Lcom/intellij/codeInspection/util/InspectionMessage;", "e", "", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final String getPresentableExceptionMessage(Throwable e) {
            return e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getMessage();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/service/JSLanguageServiceExecutorImpl$JSLanguageServiceExecutorCoroutineScope;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.javascript.backend"})
    private static final class JSLanguageServiceExecutorCoroutineScope {
        @NotNull
        private final CoroutineScope coroutineScope;

        public JSLanguageServiceExecutorCoroutineScope(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }
}

