/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.connection;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.ICodeWithMeWire;
import com.intellij.platform.split.connection.protocol.WireConnectStatus;
import com.intellij.platform.split.connection.protocol.transport.creator.TransportInfo;
import com.jetbrains.rd.platform.util.FutureExKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdserver.connection.ClientAcceptState;
import com.jetbrains.rdserver.startup.RdServerConnectionManager;
import com.jetbrains.rdserver.startup.SecureClientData;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0018\u0010&\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u001bH\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u001bH\u0002J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u00172\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\u00180\u001a0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u001dj\b\u0012\u0004\u0012\u00020\u001b`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/rdserver/connection/CwmClientConnectionGroup;", "", "connectionManager", "Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "data", "Lcom/jetbrains/rdserver/startup/SecureClientData;", "canRequestPassword", "", "<init>", "(Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;Lcom/jetbrains/rdserver/startup/SecureClientData;Z)V", "getConnectionManager", "()Lcom/jetbrains/rdserver/startup/RdServerConnectionManager;", "getData", "()Lcom/jetbrains/rdserver/startup/SecureClientData;", "id", "", "getId", "()Ljava/lang/String;", "groupKey", "getGroupKey", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "userAcceptFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/rdserver/connection/ClientAcceptState;", "selectedWireFuture", "Lkotlin/Pair;", "Lcom/intellij/platform/split/connection/protocol/ICodeWithMeWire;", "wires", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "askedForConfirmation", "Ljava/util/concurrent/atomic/AtomicBoolean;", "wireToUse", "terminateLifetime", "", "selectSingleWire", "state", "askForConfirmation", "wire", "shouldSelectImmediately", "registerWire", "Lcom/intellij/platform/split/connection/protocol/WireConnectStatus;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nCwmClientConnectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmClientConnectionGroup.kt\ncom/jetbrains/rdserver/connection/CwmClientConnectionGroup\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,134:1\n60#2,5:135\n60#2,5:140\n60#2,5:145\n60#2,5:150\n60#2,5:155\n60#2,5:160\n60#2,5:165\n13#2:170\n*S KotlinDebug\n*F\n+ 1 CwmClientConnectionGroup.kt\ncom/jetbrains/rdserver/connection/CwmClientConnectionGroup\n*L\n80#1:135,5\n99#1:140,5\n103#1:145,5\n112#1:150,5\n62#1:155,5\n117#1:160,5\n120#1:165,5\n28#1:170\n*E\n"})
public final class CwmClientConnectionGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RdServerConnectionManager connectionManager;
    @NotNull
    private final SecureClientData data;
    private final boolean canRequestPassword;
    @NotNull
    private final String id;
    @NotNull
    private final String groupKey;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final CompletableFuture<ClientAcceptState> userAcceptFuture;
    @NotNull
    private final CompletableFuture<Pair<ICodeWithMeWire, ClientAcceptState>> selectedWireFuture;
    @NotNull
    private final ArrayList<ICodeWithMeWire> wires;
    @NotNull
    private final AtomicBoolean askedForConfirmation;
    @Nullable
    private ICodeWithMeWire wireToUse;
    @NotNull
    private static final Logger logger;

    public CwmClientConnectionGroup(@NotNull RdServerConnectionManager connectionManager, @NotNull SecureClientData data, boolean canRequestPassword) {
        Intrinsics.checkNotNullParameter((Object)connectionManager, (String)"connectionManager");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.connectionManager = connectionManager;
        this.data = data;
        this.canRequestPassword = canRequestPassword;
        this.id = this.data.getUserName();
        this.groupKey = this.data.getClientFingerprint();
        this.lifetimeDefinition = new LifetimeDefinition();
        this.userAcceptFuture = new CompletableFuture();
        this.selectedWireFuture = new CompletableFuture();
        this.wires = new ArrayList();
        this.askedForConfirmation = new AtomicBoolean();
        this.userAcceptFuture.thenAccept(arg_0 -> CwmClientConnectionGroup._init_$lambda$1(arg_0 -> CwmClientConnectionGroup._init_$lambda$0(this, arg_0), arg_0));
        this.lifetimeDefinition.onTermination(() -> CwmClientConnectionGroup._init_$lambda$2(this));
        this.selectedWireFuture.handle((arg_0, arg_1) -> CwmClientConnectionGroup._init_$lambda$4((arg_0, arg_1) -> CwmClientConnectionGroup._init_$lambda$3(this, arg_0, arg_1), arg_0, arg_1));
    }

    @NotNull
    public final RdServerConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @NotNull
    public final SecureClientData getData() {
        return this.data;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getGroupKey() {
        return this.groupKey;
    }

    public final void terminateLifetime() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
    }

    private final void selectSingleWire(ClientAcceptState state) {
        if (this.selectedWireFuture.isDone()) {
            return;
        }
        ICodeWithMeWire iCodeWithMeWire = this.wireToUse;
        if (iCodeWithMeWire == null) {
            iCodeWithMeWire = (ICodeWithMeWire)CollectionsKt.first((List)this.wires);
        }
        ICodeWithMeWire selectedWire = iCodeWithMeWire;
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Selected wire " + selectedWire.getId() + " for group for " + this.id, t$iv);
        }
        this.selectedWireFuture.complete((Pair<ICodeWithMeWire, ClientAcceptState>)TuplesKt.to((Object)selectedWire, (Object)((Object)state)));
    }

    private final void askForConfirmation(SecureClientData data, ICodeWithMeWire wire) {
        if (!this.askedForConfirmation.compareAndSet(false, true)) {
            return;
        }
        this.connectionManager.askForConfirmationIfNeeded(this.id, data, wire, this.userAcceptFuture);
    }

    private final boolean shouldSelectImmediately(ICodeWithMeWire wire) {
        TransportInfo transportInfo2 = wire.getTransportInfo();
        return transportInfo2 != null && (transportInfo2 = transportInfo2.getTransport()) != null ? transportInfo2.isHighPriorityTransport() : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<WireConnectStatus> registerWire(@NotNull ICodeWithMeWire wire, @NotNull SecureClientData data) {
        Logger logger;
        boolean $i$f$debug;
        ArrayList<ICodeWithMeWire> t$iv;
        Logger $this$debug_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)wire, (String)"wire");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.shouldSelectImmediately(wire) && this.wireToUse == null) {
            $this$debug_u24default$iv = CwmClientConnectionGroup.logger;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Connection group. Fast-track selecting wire " + wire.getId() + " because of its priority", t$iv);
            }
            this.wireToUse = wire;
            if (this.userAcceptFuture.isDone()) {
                $this$debug_u24default$iv = CwmClientConnectionGroup.logger;
                t$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("Connection group. User auto-acceptance is done. Set state: " + (Object)((Object)this.userAcceptFuture.get()), t$iv);
                }
                ClientAcceptState clientAcceptState = this.userAcceptFuture.get();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)clientAcceptState), (String)"get(...)");
                this.selectSingleWire(clientAcceptState);
            }
        }
        t$iv = this.wires;
        synchronized (t$iv) {
            boolean bl = false;
            bl = this.wires.add(wire);
        }
        $this$debug_u24default$iv = CwmClientConnectionGroup.logger;
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Registered wire with id: '" + wire.getId() + "' for client group: '" + this.id + "'", t$iv);
        }
        this.askForConfirmation(data, wire);
        CompletionStage completionStage = this.selectedWireFuture.handle((arg_0, arg_1) -> CwmClientConnectionGroup.registerWire$lambda$5((arg_0, arg_1) -> CwmClientConnectionGroup.registerWire$lambda$4(wire, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"handle(...)");
        return completionStage;
    }

    private static final Unit lambda$0$0(CwmClientConnectionGroup this$0, ClientAcceptState $state, Unit unit) {
        Intrinsics.checkNotNull((Object)((Object)$state));
        this$0.selectSingleWire($state);
        return Unit.INSTANCE;
    }

    private static final void lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit lambda$3$0(CwmClientConnectionGroup this$0, ConnectionState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it, (Object)ConnectionState.CONNECTED.INSTANCE) && !Intrinsics.areEqual((Object)it, (Object)ConnectionState.NOT_CONNECTED.INSTANCE)) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this$0.lifetimeDefinition, (boolean)false, (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(CwmClientConnectionGroup this$0, ClientAcceptState state) {
        ClientAcceptState clientAcceptState = state;
        switch (clientAcceptState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[clientAcceptState.ordinal()]) {
            case 1: 
            case 2: {
                this$0.selectedWireFuture.complete((Pair<ICodeWithMeWire, ClientAcceptState>)TuplesKt.to(null, (Object)((Object)state)));
                break;
            }
            default: {
                if (this$0.wireToUse == null) {
                    Duration duration = Duration.ofSeconds(2L);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
                    FutureExKt.delayFuture$default((Duration)duration, null, (int)2, null).thenAccept(arg_0 -> CwmClientConnectionGroup.lambda$0$1(arg_0 -> CwmClientConnectionGroup.lambda$0$0(this$0, state, arg_0), arg_0));
                    break;
                }
                Intrinsics.checkNotNull((Object)((Object)state));
                this$0.selectSingleWire(state);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$2(CwmClientConnectionGroup this$0) {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Wire group " + this$0.id + " lifetime termination", t$iv);
        }
        this$0.connectionManager.removeGroup$intellij_platform_backend_split(this$0);
        return Unit.INSTANCE;
    }

    private static final Object _init_$lambda$3(CwmClientConnectionGroup this$0, Pair pair, Throwable throwable) {
        Boolean bl;
        ICodeWithMeWire wire = (ICodeWithMeWire)pair.component1();
        ICodeWithMeWire iCodeWithMeWire = wire;
        if (iCodeWithMeWire != null && (iCodeWithMeWire = iCodeWithMeWire.getConnectionState()) != null) {
            iCodeWithMeWire.advise(this$0.lifetimeDefinition.getLifetime(), arg_0 -> CwmClientConnectionGroup.lambda$3$0(this$0, arg_0));
            bl = Unit.INSTANCE;
        } else {
            bl = LifetimeDefinition.terminate$default((LifetimeDefinition)this$0.lifetimeDefinition, (boolean)false, (int)1, null);
        }
        return bl;
    }

    private static final Object _init_$lambda$4(Function2 $tmp0, Object p0, Throwable p1) {
        return $tmp0.invoke(p0, (Object)p1);
    }

    private static final WireConnectStatus registerWire$lambda$4(ICodeWithMeWire $wire, Pair pair, Throwable throwable) {
        Logger logger;
        ICodeWithMeWire selectedWire = (ICodeWithMeWire)pair.component1();
        ClientAcceptState state = (ClientAcceptState)((Object)pair.component2());
        Logger $this$debug_u24default$iv = CwmClientConnectionGroup.logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            ICodeWithMeWire iCodeWithMeWire = selectedWire;
            logger.debug("Connection group. Wire: (id: " + $wire.getId() + "), Selected wire (id: " + (iCodeWithMeWire != null ? iCodeWithMeWire.getId() : null) + ", state: " + state + ")", t$iv);
        }
        boolean isSelectedWire = selectedWire == $wire || selectedWire == null;
        Logger $this$debug_u24default$iv2 = CwmClientConnectionGroup.logger;
        Throwable t$iv2 = null;
        boolean $i$f$debug2 = false;
        if ($this$debug_u24default$iv2.isDebugEnabled()) {
            logger = $this$debug_u24default$iv2;
            boolean bl = false;
            logger.debug("Connection group. Is wire selected: " + isSelectedWire, t$iv2);
        }
        if (!isSelectedWire) {
            return WireConnectStatus.DECLINED;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 3 -> WireConnectStatus.ACCEPTED;
            case 4 -> WireConnectStatus.PASSWORD_REQUIRED;
            case 2 -> WireConnectStatus.GUEST_LIMIT_REACHED;
            case 1 -> WireConnectStatus.USER_DECLINED;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final WireConnectStatus registerWire$lambda$5(Function2 $tmp0, Object p0, Throwable p1) {
        return (WireConnectStatus)$tmp0.invoke(p0, (Object)p1);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CwmClientConnectionGroup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        CwmClientConnectionGroup.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/connection/CwmClientConnectionGroup$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClientAcceptState.values().length];
            try {
                nArray[ClientAcceptState.Declined.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientAcceptState.GuestLimit.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientAcceptState.Accepted.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientAcceptState.Password.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

