/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.connection;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bouncycastle.jcajce.provider.symmetric.AES;
import org.bouncycastle.jcajce.provider.symmetric.PBEPBKDF2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J \u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/connection/TurnServerEncryptionUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "TURN_SECRET_DECRYPTION_KEY", "", "generateTurnSecretKey", "lobbyBuildNumber", "decryptTurnServerSecretData", "key", "data", "tryDecryptTurnServerSecretData", "moniker", "getKeyFromPassword", "Ljavax/crypto/SecretKey;", "password", "salt", "", "AesGcmNoPadding", "PBKDF2SHA256Factory", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nTurnServerEncryptionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TurnServerEncryptionUtil.kt\ncom/jetbrains/rdserver/connection/TurnServerEncryptionUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,138:1\n13485#2,3:139\n13#3:142\n*S KotlinDebug\n*F\n+ 1 TurnServerEncryptionUtil.kt\ncom/jetbrains/rdserver/connection/TurnServerEncryptionUtil\n*L\n76#1:139,3\n53#1:142\n*E\n"})
public final class TurnServerEncryptionUtil {
    @NotNull
    public static final TurnServerEncryptionUtil INSTANCE = new TurnServerEncryptionUtil();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String TURN_SECRET_DECRYPTION_KEY = "HFHrdCdsrbQnZDwxJ_N0QA";

    private TurnServerEncryptionUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String generateTurnSecretKey(@NotNull String lobbyBuildNumber) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)lobbyBuildNumber, (String)"lobbyBuildNumber");
        if (!(((CharSequence)lobbyBuildNumber).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String string = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asStringWithoutProductCode(...)");
        String clientBuildNumber = string;
        String key = clientBuildNumber + TURN_SECRET_DECRYPTION_KEY + lobbyBuildNumber;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        Object object = key;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] digest = md.digest(byArray);
        Intrinsics.checkNotNull((Object)digest);
        object = digest;
        String initial$iv = "";
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void byteVal;
            void element$iv;
            void var13_14 = element$iv = $this$fold$iv[i];
            String acc = accumulator$iv;
            boolean bl = false;
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)byteVal};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            accumulator$iv = acc + string3;
        }
        return accumulator$iv;
    }

    @NotNull
    public final String decryptTurnServerSecretData(@NotNull String key, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(((CharSequence)key).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(((CharSequence)data).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        byte[] dataToDecrypt = Base64.getDecoder().decode(data);
        ByteBuffer byteBuffer = ByteBuffer.wrap(dataToDecrypt);
        AesGcmNoPadding cipher = new AesGcmNoPadding();
        int ivLength = byteBuffer.getInt();
        if (!(ivLength == cipher.getBlockSize())) {
            boolean $i$a$-require-TurnServerEncryptionUtil$decryptTurnServerSecretData$32 = false;
            String $i$a$-require-TurnServerEncryptionUtil$decryptTurnServerSecretData$32 = "IV length doesn't match cipher block size: " + ivLength + " != " + cipher.getBlockSize();
            throw new IllegalArgumentException($i$a$-require-TurnServerEncryptionUtil$decryptTurnServerSecretData$32.toString());
        }
        byte[] ivBuffer = new byte[ivLength];
        byteBuffer.get(ivBuffer);
        IvParameterSpec ivSpec = new IvParameterSpec(ivBuffer);
        int saltLength = byteBuffer.getInt();
        if (!(saltLength == cipher.getBlockSize())) {
            boolean $i$a$-require-TurnServerEncryptionUtil$decryptTurnServerSecretData$42 = false;
            String $i$a$-require-TurnServerEncryptionUtil$decryptTurnServerSecretData$42 = "Salt length doesn't match cipher block size: " + saltLength + " != " + cipher.getBlockSize();
            throw new IllegalArgumentException($i$a$-require-TurnServerEncryptionUtil$decryptTurnServerSecretData$42.toString());
        }
        byte[] saltBuffer = new byte[saltLength];
        byteBuffer.get(saltBuffer);
        SecretKey keySpec = this.getKeyFromPassword(key, saltBuffer);
        AesGcmNoPadding.initialize$default(cipher, 2, keySpec, ivSpec, null, 8, null);
        int dataOffset = byteBuffer.position();
        Intrinsics.checkNotNull((Object)dataToDecrypt);
        byte[] decryptedData = cipher.doFinal(dataToDecrypt, dataOffset, dataToDecrypt.length - dataOffset);
        return new String(decryptedData, Charsets.UTF_8);
    }

    @Nullable
    public final String tryDecryptTurnServerSecretData(@NotNull String moniker, @NotNull String key, @NotNull String data) {
        String string;
        Intrinsics.checkNotNullParameter((Object)moniker, (String)"moniker");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            string = this.decryptTurnServerSecretData(key, data);
        }
        catch (Throwable t) {
            logger.error("Failed to get TURN server data: " + moniker, t);
            string = null;
        }
        return string;
    }

    private final SecretKey getKeyFromPassword(String password, byte[] salt) {
        PBKDF2SHA256Factory keyFactory = new PBKDF2SHA256Factory();
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        PBEKeySpec pbeKeySpec = new PBEKeySpec(cArray, salt, 65536, 256);
        return new SecretKeySpec(keyFactory.generateSecret(pbeKeySpec).getEncoded(), "AES");
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TurnServerEncryptionUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        TurnServerEncryptionUtil.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/connection/TurnServerEncryptionUtil$AesGcmNoPadding;", "Lorg/bouncycastle/jcajce/provider/symmetric/AES$GCM;", "<init>", "()V", "blockSize", "", "getBlockSize", "()I", "initialize", "", "opmode", "key", "Ljava/security/Key;", "params", "Ljava/security/spec/AlgorithmParameterSpec;", "secureRandom", "Ljava/security/SecureRandom;", "doFinal", "", "input", "inputOffset", "inputLen", "intellij.platform.backend.split"})
    public static final class AesGcmNoPadding
    extends AES.GCM {
        public AesGcmNoPadding() {
            this.engineSetPadding("NoPadding");
        }

        public final int getBlockSize() {
            return this.engineGetBlockSize();
        }

        public final void initialize(int opmode, @NotNull Key key, @NotNull AlgorithmParameterSpec params, @Nullable SecureRandom secureRandom) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            this.engineInit(opmode, key, params, secureRandom);
        }

        public static /* synthetic */ void initialize$default(AesGcmNoPadding aesGcmNoPadding, int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom, int n2, Object object) {
            if ((n2 & 8) != 0) {
                secureRandom = new SecureRandom();
            }
            aesGcmNoPadding.initialize(n, key, algorithmParameterSpec, secureRandom);
        }

        @NotNull
        public final byte[] doFinal(@NotNull byte[] input, int inputOffset, int inputLen) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            byte[] byArray = this.engineDoFinal(input, inputOffset, inputLen);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"engineDoFinal(...)");
            return byArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/connection/TurnServerEncryptionUtil$PBKDF2SHA256Factory;", "Lorg/bouncycastle/jcajce/provider/symmetric/PBEPBKDF2$PBKDF2withSHA256;", "<init>", "()V", "generateSecret", "Ljavax/crypto/SecretKey;", "keySpec", "Ljava/security/spec/KeySpec;", "intellij.platform.backend.split"})
    public static final class PBKDF2SHA256Factory
    extends PBEPBKDF2.PBKDF2withSHA256 {
        @NotNull
        public final SecretKey generateSecret(@NotNull KeySpec keySpec) {
            Intrinsics.checkNotNullParameter((Object)keySpec, (String)"keySpec");
            SecretKey secretKey = this.engineGenerateSecret(keySpec);
            Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"engineGenerateSecret(...)");
            return secretKey;
        }
    }
}

