/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\n\u0018\u0000 .2\u00020\u0001:\u0001.B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\nJ\u0013\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020 H\u0086\u0002J\u0018\u0010\u001e\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\nH\u0086\u0002\u00a2\u0006\u0002\u0010!J\u0015\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010\u001b\u001a\u00020\n\u00a2\u0006\u0002\u0010!J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\nJ\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0%J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0%J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0%J\u000e\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010)\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\nJ\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\nJ\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0%J\u0006\u0010-\u001a\u00020\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0015\u001a2\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017 \u000b*\u0017\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00170\u0014\u00a2\u0006\u0002\b\u00160\u0013\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0018\u001a2\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017 \u000b*\u0017\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u00170\u0014\u00a2\u0006\u0002\b\u00160\u0013\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendRangeMarkerStorage;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/Document;)V", "id2Range", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "Lcom/intellij/openapi/editor/ex/RangeMarkerEx;", "kotlin.jvm.PlatformType", "range2Id", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "range2Lifetime", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/editor/RangeMarker;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "queuedAdd", "", "", "queuedUpdate", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "queuedRemove", "checkDocument", "", "rangeMarker", "add", "", "get", "id", "", "(Lcom/intellij/openapi/editor/ex/RangeMarkerEx;)Ljava/lang/Long;", "remove", "getLifetime", "flushPendingToAdd", "", "flushPendingToRemove", "flushPendingToUpdate", "contains", "queueAdd", "queueRemove", "queueUpdate", "getAllRegistered", "isEmpty", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendRangeMarkerStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRangeMarkerStorage.kt\ncom/jetbrains/rdserver/daemon/BackendRangeMarkerStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,143:1\n1#2:144\n1#2:147\n72#3,2:145\n1586#4:148\n1661#4,3:149\n13#5:152\n*S KotlinDebug\n*F\n+ 1 BackendRangeMarkerStorage.kt\ncom/jetbrains/rdserver/daemon/BackendRangeMarkerStorage\n*L\n78#1:147\n78#1:145,2\n132#1:148\n132#1:149,3\n20#1:152\n*E\n"})
public final class BackendRangeMarkerStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Document document;
    private final Long2ObjectMap<RangeMarkerEx> id2Range;
    private final Object2LongMap<RangeMarkerEx> range2Id;
    @NotNull
    private final ConcurrentHashMap<RangeMarker, LifetimeDefinition> range2Lifetime;
    private final Set<RangeMarkerEx> queuedAdd;
    @NotNull
    private final Set<RangeMarkerEx> queuedUpdate;
    @NotNull
    private final Set<RangeMarkerEx> queuedRemove;
    @NotNull
    private static final Logger logger;
    private static final long NOT_FOUND = -1L;

    /*
     * WARNING - void declaration
     */
    public BackendRangeMarkerStorage(@NotNull Lifetime lifetime, @NotNull Document document) {
        void $this$range2Id_u24lambda_u240;
        Object2LongOpenHashMap object2LongOpenHashMap;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.lifetime = lifetime;
        this.document = document;
        this.id2Range = Long2ObjectMaps.synchronize((Long2ObjectMap)((Long2ObjectMap)new Long2ObjectOpenHashMap()));
        Object2LongOpenHashMap object2LongOpenHashMap2 = object2LongOpenHashMap = new Object2LongOpenHashMap();
        BackendRangeMarkerStorage backendRangeMarkerStorage = this;
        boolean bl = false;
        $this$range2Id_u24lambda_u240.defaultReturnValue(-1L);
        backendRangeMarkerStorage.range2Id = Object2LongMaps.synchronize((Object2LongMap)((Object2LongMap)object2LongOpenHashMap));
        this.range2Lifetime = new ConcurrentHashMap();
        this.queuedAdd = Collections.synchronizedSet(new LinkedHashSet());
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.queuedUpdate = set;
        Set set2 = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createConcurrentSet(...)");
        this.queuedRemove = set2;
    }

    private final boolean checkDocument(RangeMarkerEx rangeMarker) {
        if (!Intrinsics.areEqual((Object)rangeMarker.getDocument(), (Object)this.document)) {
            logger.error("RangeMarker doesn't belong to the document. Document:" + this.document + ", rangeMarker:" + rangeMarker);
            return false;
        }
        return true;
    }

    public final void add(@NotNull RangeMarkerEx rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        if (!this.checkDocument(rangeMarker)) {
            return;
        }
        long id = rangeMarker.getId();
        logger.assertTrue(id != -1L, BackendRangeMarkerStorage::add$lambda$0);
        this.id2Range.put(id, (Object)rangeMarker);
        this.range2Id.put((Object)rangeMarker, id);
    }

    @Nullable
    public final RangeMarkerEx get(long id) {
        return (RangeMarkerEx)this.id2Range.get(id);
    }

    @Nullable
    public final Long get(@NotNull RangeMarkerEx rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        Long l = this.range2Id.getLong((Object)rangeMarker);
        long it = ((Number)l).longValue();
        boolean bl = false;
        return it != -1L ? l : null;
    }

    @Nullable
    public final Long remove(@NotNull RangeMarkerEx rangeMarker) {
        long id;
        block3: {
            Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
            if (!this.checkDocument(rangeMarker)) {
                return null;
            }
            if (this.queuedAdd.remove(rangeMarker)) {
                return null;
            }
            this.queuedUpdate.remove(rangeMarker);
            Long l = this.range2Id.removeLong((Object)rangeMarker);
            long it = ((Number)l).longValue();
            boolean bl = false;
            Long l2 = it != -1L ? l : null;
            if (l2 == null) {
                return null;
            }
            id = l2;
            this.id2Range.remove(id);
            LifetimeDefinition lifetimeDefinition = this.range2Lifetime.remove(rangeMarker);
            if (lifetimeDefinition == null) break block3;
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
        }
        return id;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Lifetime getLifetime(@NotNull RangeMarkerEx rangeMarker) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        if (!this.checkDocument(rangeMarker) || !this.range2Id.containsKey((Object)rangeMarker)) {
            logger.error("Trying get lifetime for highlighter not in storage");
            return Lifetime.Companion.getTerminated();
        }
        ConcurrentMap concurrentMap = this.range2Lifetime;
        RangeMarkerEx key$iv = rangeMarker;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            LifetimeDefinition default$iv = this.lifetime.createNested();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (Lifetime)object;
    }

    @NotNull
    public final List<RangeMarkerEx> flushPendingToAdd() {
        Set<RangeMarkerEx> set = this.queuedAdd;
        Intrinsics.checkNotNullExpressionValue(set, (String)"queuedAdd");
        List flush = CollectionsKt.toList((Iterable)set);
        this.queuedAdd.clear();
        return flush;
    }

    @NotNull
    public final List<RangeMarkerEx> flushPendingToRemove() {
        List flush = CollectionsKt.toList((Iterable)this.queuedRemove);
        this.queuedRemove.clear();
        return flush;
    }

    @NotNull
    public final List<RangeMarkerEx> flushPendingToUpdate() {
        List flush = CollectionsKt.toList((Iterable)this.queuedUpdate);
        this.queuedUpdate.clear();
        return flush;
    }

    public final boolean contains(@NotNull RangeMarkerEx rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        return this.range2Id.containsKey((Object)rangeMarker);
    }

    public final void queueAdd(@NotNull RangeMarkerEx rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        if (!this.checkDocument(rangeMarker)) {
            return;
        }
        this.queuedAdd.add(rangeMarker);
    }

    public final void queueRemove(@NotNull RangeMarkerEx rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        if (!this.checkDocument(rangeMarker)) {
            return;
        }
        if (this.queuedAdd.remove(rangeMarker)) {
            return;
        }
        this.queuedUpdate.remove(rangeMarker);
        this.queuedRemove.add(rangeMarker);
    }

    public final void queueUpdate(@NotNull RangeMarkerEx rangeMarker) {
        Intrinsics.checkNotNullParameter((Object)rangeMarker, (String)"rangeMarker");
        if (!this.checkDocument(rangeMarker)) {
            return;
        }
        if (this.queuedAdd.contains(rangeMarker)) {
            return;
        }
        if (this.queuedRemove.contains(rangeMarker)) {
            return;
        }
        this.queuedUpdate.add(rangeMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RangeMarkerEx> getAllRegistered() {
        void $this$mapTo$iv$iv;
        Collection collection = this.id2Range.values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RangeMarkerEx rangeMarkerEx = (RangeMarkerEx)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
            collection2.add(it);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isEmpty() {
        return this.id2Range.isEmpty() && this.range2Id.isEmpty() && this.queuedAdd.isEmpty() && this.queuedRemove.isEmpty() && this.queuedUpdate.isEmpty() && this.range2Lifetime.isEmpty();
    }

    private static final String add$lambda$0() {
        return "Using of reserved RangeMarker id";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendRangeMarkerStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendRangeMarkerStorage.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendRangeMarkerStorage$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "NOT_FOUND", "", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

