/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.inlays;

import com.intellij.codeInsight.hints.declarative.InlayActionData;
import com.intellij.codeInsight.hints.declarative.impl.ActionWithContent;
import com.intellij.codeInsight.hints.declarative.impl.DeclarativeInlayActionService;
import com.intellij.codeInsight.hints.declarative.impl.InlayData;
import com.intellij.codeInsight.hints.declarative.impl.inlayRenderer.DeclarativeInlayRendererBase;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.rd.ide.model.DeclarativeHintActionInvokedEvent;
import com.jetbrains.rd.ide.model.DeclarativeHintEvent;
import com.jetbrains.rd.ide.model.DeclarativeHintOpenMenuEvent;
import com.jetbrains.rd.ide.model.DeclarativeInlayHintEventsModel;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.actions.ClientMouseEvent;
import com.jetbrains.rdserver.actions.ClientRelativePoint;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendProtocolMarkupModelExtensionHandler;
import com.jetbrains.rdserver.daemon.inlays.BackendDeclarativeInlayHintEventsModelExtensionHandlerKt;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/daemon/inlays/BackendDeclarativeInlayHintEventsModelExtensionHandler;", "Lcom/jetbrains/rdserver/daemon/BackendProtocolMarkupModelExtensionHandler;", "<init>", "()V", "consume", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "extensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendDeclarativeInlayHintEventsModelExtensionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendDeclarativeInlayHintEventsModelExtensionHandler.kt\ncom/jetbrains/rdserver/daemon/inlays/BackendDeclarativeInlayHintEventsModelExtensionHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,78:1\n42#2,3:79\n42#2,3:82\n23#3:85\n*S KotlinDebug\n*F\n+ 1 BackendDeclarativeInlayHintEventsModelExtensionHandler.kt\ncom/jetbrains/rdserver/daemon/inlays/BackendDeclarativeInlayHintEventsModelExtensionHandler\n*L\n69#1:79,3\n72#1:82,3\n31#1:85\n*E\n"})
public final class BackendDeclarativeInlayHintEventsModelExtensionHandler
implements BackendProtocolMarkupModelExtensionHandler {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger LOG;

    @Override
    public void consume(@NotNull Lifetime lifetime, @NotNull List<? extends MarkupModelExtension> extensions, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (!(contributor instanceof BackendEditorMarkupModelContributor)) {
            return;
        }
        DeclarativeInlayHintEventsModel declarativeInlayHintEventsModel = (DeclarativeInlayHintEventsModel)contributor.getExtension(BackendDeclarativeInlayHintEventsModelExtensionHandlerKt.access$getKEY$p());
        if (declarativeInlayHintEventsModel == null) {
            return;
        }
        DeclarativeInlayHintEventsModel eventsModel = declarativeInlayHintEventsModel;
        eventsModel.getSendEvent().advise(lifetime, arg_0 -> BackendDeclarativeInlayHintEventsModelExtensionHandler.consume$lambda$0(contributor, arg_0));
    }

    private static final Unit consume$lambda$0(BackendMarkupModelContributor $contributor, DeclarativeHintEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RangeMarkerEx rangeMarkerEx = $contributor.getRangeMarker(it.getRangeMarkerId());
        Inlay inlay = rangeMarkerEx instanceof Inlay ? (Inlay)rangeMarkerEx : null;
        if (inlay == null) {
            return Unit.INSTANCE;
        }
        Inlay inlay2 = inlay;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        DeclarativeInlayRendererBase declarativeInlayRendererBase = editorCustomElementRenderer instanceof DeclarativeInlayRendererBase ? (DeclarativeInlayRendererBase)editorCustomElementRenderer : null;
        if (declarativeInlayRendererBase == null) {
            return Unit.INSTANCE;
        }
        DeclarativeInlayRendererBase renderer = declarativeInlayRendererBase;
        List hints = renderer.toInlayData(false);
        int n = ((Collection)hints).size();
        int n2 = it.getHintIndex();
        if (!(0 <= n2 ? n2 < n : false)) {
            LOG.warn(it.getHintIndex() + " out of bounds " + CollectionsKt.getIndices((Collection)hints));
            return Unit.INSTANCE;
        }
        InlayData hintData = (InlayData)hints.get(it.getHintIndex());
        LogicalPosition logicalPosition = inlay2.getEditor().offsetToLogicalPosition(inlay2.getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPos = logicalPosition;
        Editor editor = inlay2.getEditor();
        JComponent jComponent = inlay2.getEditor().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        Component component = jComponent;
        long l = System.currentTimeMillis();
        int n3 = it.getMouseEvent().getModifiers();
        int n4 = it.getMouseEvent().getX();
        int n5 = it.getMouseEvent().getY();
        int n6 = it.getMouseEvent().getButton();
        Rectangle rectangle = inlay2.getEditor().getContentComponent().getVisibleRect();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleRect(...)");
        EditorMouseEvent event = new EditorMouseEvent(editor, (MouseEvent)new ClientMouseEvent(component, 500, l, n3, n4, n5, 1, false, n6, rectangle), EditorMouseEventArea.EDITING_AREA, inlay2.getOffset(), logicalPos, inlay2.getEditor().logicalToVisualPosition(logicalPos), false, null, inlay2, null);
        DeclarativeHintEvent declarativeHintEvent = it;
        if (declarativeHintEvent instanceof DeclarativeHintActionInvokedEvent) {
            InlayActionData inlayActionData;
            Object nodePayload = hintData.getTree().getDataPayload(((DeclarativeHintActionInvokedEvent)it).getNodeIndex());
            if (nodePayload instanceof ActionWithContent) {
                inlayActionData = ((ActionWithContent)nodePayload).getActionData();
            } else if (nodePayload instanceof InlayActionData) {
                inlayActionData = (InlayActionData)nodePayload;
            } else {
                return Unit.INSTANCE;
            }
            InlayActionData actionData = inlayActionData;
            boolean $i$f$service = false;
            Class<DeclarativeInlayActionService> serviceClass$iv = DeclarativeInlayActionService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((DeclarativeInlayActionService)object).invokeActionHandler(actionData, event);
        } else if (declarativeHintEvent instanceof DeclarativeHintOpenMenuEvent) {
            boolean $i$f$service = false;
            Class<DeclarativeInlayActionService> serviceClass$iv = DeclarativeInlayActionService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            DeclarativeInlayActionService declarativeInlayActionService = (DeclarativeInlayActionService)object;
            JComponent jComponent2 = inlay2.getEditor().getContentComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"getContentComponent(...)");
            declarativeInlayActionService.invokeInlayMenu(hintData, event, (RelativePoint)new ClientRelativePoint(jComponent2, it.getMouseEvent().getX(), it.getMouseEvent().getY()));
        }
        return Unit.INSTANCE;
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/daemon/inlays/BackendDeclarativeInlayHintEventsModelExtensionHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

