/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.inlays;

import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.codeInsight.hints.presentation.ChangeOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.ChangeOnHoverPresentation;
import com.intellij.codeInsight.hints.presentation.DynamicDelegatePresentation;
import com.intellij.codeInsight.hints.presentation.DynamicInsetPresentation;
import com.intellij.codeInsight.hints.presentation.IconPresentation;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetPresentation;
import com.intellij.codeInsight.hints.presentation.LineCenteredInset;
import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.MouseHandlingPresentation;
import com.intellij.codeInsight.hints.presentation.OnClickPresentation;
import com.intellij.codeInsight.hints.presentation.OnHoverPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RoundWithBackgroundBorderedPresentation;
import com.intellij.codeInsight.hints.presentation.RoundWithBackgroundPresentation;
import com.intellij.codeInsight.hints.presentation.ScaleAwareIconPresentation;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactoryKt;
import com.intellij.codeInsight.hints.presentation.ScaledContainerPresentation;
import com.intellij.codeInsight.hints.presentation.ScaledIconPresentation;
import com.intellij.codeInsight.hints.presentation.ScaledInsetPresentation;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.codeInsight.hints.presentation.SpacePresentation;
import com.intellij.codeInsight.hints.presentation.StatefulPresentation;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.codeInsight.hints.presentation.TextInlayPresentation;
import com.intellij.codeInsight.hints.presentation.TextPlaceholderPresentation;
import com.intellij.codeInsight.hints.presentation.WithAttributesPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.Key;
import com.intellij.refactoring.rename.inplace.SelectableInlayPresentation;
import com.jetbrains.rd.ide.model.BePopupPositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionMousePositionContext;
import com.jetbrains.rd.ide.model.ChangeOnMouseEventPresentationModel;
import com.jetbrains.rd.ide.model.InlayMouseEvent;
import com.jetbrains.rd.ide.model.InlayPresentationModel;
import com.jetbrains.rd.ide.model.InlayWithPresentationEventsModel;
import com.jetbrains.rd.ide.model.MarkupModelExtension;
import com.jetbrains.rd.ide.model.MouseClickedEventModel;
import com.jetbrains.rd.ide.model.MouseEventModel;
import com.jetbrains.rd.ide.model.MouseExitedEventModel;
import com.jetbrains.rd.ide.model.MouseMovedEventModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendProtocolMarkupModelExtensionHandler;
import com.jetbrains.rdserver.daemon.inlays.BackendInlayWithPresentationModelCreator;
import com.jetbrains.rdserver.ui.contextProviders.BeBackendCustomContextProvider;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0011H\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 H\u0002\u00a8\u0006\""}, d2={"Lcom/jetbrains/rdserver/daemon/inlays/BackendInlayEventsModelExtensionHandler;", "Lcom/jetbrains/rdserver/daemon/BackendProtocolMarkupModelExtensionHandler;", "<init>", "()V", "consume", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "extensions", "", "Lcom/jetbrains/rd/ide/model/MarkupModelExtension;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "getInlayById", "Lcom/intellij/openapi/editor/Inlay;", "id", "", "Lcom/jetbrains/rdserver/daemon/BackendEditorMarkupModelContributor;", "getPresentationById", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "fromModel", "Ljava/awt/event/MouseEvent;", "Lcom/jetbrains/rd/ide/model/MouseEventModel;", "component", "Ljavax/swing/JComponent;", "getCorrectPoint", "Ljava/awt/Point;", "childIdToFind", "", "model", "Lcom/jetbrains/rd/ide/model/InlayPresentationModel;", "nextId", "Lcom/intellij/openapi/util/IntRef;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendInlayWithPresentationModelHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendInlayWithPresentationModelHandler.kt\ncom/jetbrains/rdserver/daemon/inlays/BackendInlayEventsModelExtensionHandler\n+ 2 BackendInlayWithPresentationModelHandler.kt\ncom/jetbrains/rdserver/daemon/inlays/BackendInlayWithPresentationModelHandlerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,204:1\n197#2,8:205\n197#2,8:213\n13#3:221\n*S KotlinDebug\n*F\n+ 1 BackendInlayWithPresentationModelHandler.kt\ncom/jetbrains/rdserver/daemon/inlays/BackendInlayEventsModelExtensionHandler\n*L\n45#1:205,8\n54#1:213,8\n25#1:221\n*E\n"})
public final class BackendInlayEventsModelExtensionHandler
implements BackendProtocolMarkupModelExtensionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<InlayWithPresentationEventsModel> KEY = new Key("INLAY_WITH_PRESENTATION_EVENTS_MODEL_EXTENSION_KEY");
    @NotNull
    private static final Logger LOG;

    @Override
    public void consume(@NotNull Lifetime lifetime, @NotNull List<? extends MarkupModelExtension> extensions, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(extensions, (String)"extensions");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (!(contributor instanceof BackendEditorMarkupModelContributor)) {
            return;
        }
        InlayWithPresentationEventsModel inlayWithPresentationEventsModel = contributor.getExtension(KEY);
        if (inlayWithPresentationEventsModel == null) {
            return;
        }
        InlayWithPresentationEventsModel inlayEventsModel = inlayWithPresentationEventsModel;
        inlayEventsModel.getSendMouseEvent().advise(lifetime, arg_0 -> BackendInlayEventsModelExtensionHandler.consume$lambda$0(this, contributor, arg_0));
    }

    private final Inlay<?> getInlayById(long id, BackendEditorMarkupModelContributor contributor) {
        RangeMarkerEx rangeMarkerEx = contributor.getRangeMarker(id);
        return rangeMarkerEx instanceof Inlay ? (Inlay)rangeMarkerEx : null;
    }

    private final InlayPresentation getPresentationById(long id, BackendEditorMarkupModelContributor contributor) {
        Object object;
        Inlay<?> inlay = this.getInlayById(id, contributor);
        if (inlay == null) {
            return null;
        }
        Inlay<?> inlay2 = inlay;
        EditorCustomElementRenderer editorCustomElementRenderer = inlay2.getRenderer();
        Intrinsics.checkNotNullExpressionValue((Object)editorCustomElementRenderer, (String)"getRenderer(...)");
        EditorCustomElementRenderer renderer = editorCustomElementRenderer;
        if (renderer instanceof LinearOrderInlayRenderer) {
            InlayPresentation inlayPresentation = ((LinearOrderInlayRenderer)renderer).getCachedPresentation();
            RecursivelyUpdatingRootPresentation recursivelyUpdatingRootPresentation = inlayPresentation instanceof RecursivelyUpdatingRootPresentation ? (RecursivelyUpdatingRootPresentation)inlayPresentation : null;
            object = recursivelyUpdatingRootPresentation != null ? recursivelyUpdatingRootPresentation.getContent() : null;
        } else {
            object = renderer instanceof PresentationRenderer ? ((PresentationRenderer)renderer).getPresentation() : null;
        }
        return object;
    }

    private final MouseEvent fromModel(MouseEventModel $this$fromModel, JComponent component) {
        return new MouseEvent(component, $this$fromModel.getId(), System.currentTimeMillis(), $this$fromModel.getModifiers(), $this$fromModel.getX(), $this$fromModel.getY(), $this$fromModel.getClickCount(), false, $this$fromModel.getButton());
    }

    private final Point getCorrectPoint(InlayPresentation $this$getCorrectPoint, int childIdToFind, InlayPresentationModel model2, IntRef nextId) {
        Point point;
        InlayPresentation inlayPresentation = $this$getCorrectPoint;
        if (inlayPresentation instanceof TextInlayPresentation) {
            point = null;
        } else {
            if (inlayPresentation instanceof SequencePresentation) {
                for (InlayPresentation activePresentation : ((SequencePresentation)$this$getCorrectPoint).getPresentations()) {
                    Point point2 = this.getCorrectPoint(activePresentation, childIdToFind, model2, nextId);
                    if (point2 == null) continue;
                    Point point3 = point2;
                    int xOffset = 0;
                    for (InlayPresentation presentation : ((SequencePresentation)$this$getCorrectPoint).getPresentations()) {
                        int presentationWidth = presentation.getWidth();
                        if (Intrinsics.areEqual((Object)presentation, (Object)activePresentation)) {
                            return new Point(point3.x + xOffset, point3.y);
                        }
                        xOffset += presentationWidth;
                    }
                    return null;
                }
                return null;
            }
            if (inlayPresentation instanceof TextPlaceholderPresentation) {
                point = null;
            } else if (inlayPresentation instanceof SpacePresentation) {
                point = null;
            } else if (inlayPresentation instanceof DynamicInsetPresentation) {
                Point point4 = this.getCorrectPoint(((DynamicInsetPresentation)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId);
                if (point4 == null) {
                    return null;
                }
                Point point5 = point4;
                int left = ((DynamicInsetPresentation)$this$getCorrectPoint).getValueProvider().getLeft();
                int top = ((DynamicInsetPresentation)$this$getCorrectPoint).getValueProvider().getTop();
                point = new Point(point5.x + left, point5.y + top);
            } else if (inlayPresentation instanceof WithAttributesPresentation) {
                point = this.getCorrectPoint(((WithAttributesPresentation)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId);
            } else if (inlayPresentation instanceof RoundWithBackgroundPresentation) {
                point = this.getCorrectPoint(((RoundWithBackgroundPresentation)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId);
            } else if (inlayPresentation instanceof RoundWithBackgroundBorderedPresentation) {
                point = this.getCorrectPoint(((RoundWithBackgroundBorderedPresentation)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId);
            } else if (inlayPresentation instanceof InsetPresentation) {
                Point point6 = this.getCorrectPoint(((InsetPresentation)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId);
                if (point6 == null) {
                    return null;
                }
                Point point7 = point6;
                point = new Point(point7.x + ((InsetPresentation)$this$getCorrectPoint).getLeft(), point7.y + ((InsetPresentation)$this$getCorrectPoint).getTop());
            } else if (inlayPresentation instanceof ScaledIconPresentation) {
                point = null;
            } else if (inlayPresentation instanceof IconPresentation) {
                point = null;
            } else if (inlayPresentation instanceof ScaledInsetPresentation) {
                Point point8 = this.getCorrectPoint(((ScaledInsetPresentation)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId);
                if (point8 == null) {
                    return null;
                }
                Point point9 = point8;
                point = new Point(point9.x + ScaleAwarePresentationFactoryKt.scaleByFont((int)((ScaledInsetPresentation)$this$getCorrectPoint).getLeft(), (float)((ScaledInsetPresentation)$this$getCorrectPoint).getEditor().getColorsScheme().getEditorFontSize2D()), point9.y + ScaleAwarePresentationFactoryKt.scaleByFont((int)((ScaledInsetPresentation)$this$getCorrectPoint).getTop(), (float)((ScaledInsetPresentation)$this$getCorrectPoint).getEditor().getColorsScheme().getEditorFontSize2D()));
            } else if (inlayPresentation instanceof ScaledContainerPresentation) {
                Point point10 = this.getCorrectPoint(((ScaledContainerPresentation)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId);
                if (point10 == null) {
                    return null;
                }
                Point point11 = point10;
                InlayPresentationFactory.Padding padding = ((ScaledContainerPresentation)$this$getCorrectPoint).getPadding();
                InlayPresentationFactory.Padding padding2 = ((ScaledContainerPresentation)$this$getCorrectPoint).getPadding();
                point = new Point(point11.x + ScaleAwarePresentationFactoryKt.scaleByFont((int)(padding != null ? padding.getLeft() : 0), (float)((ScaledContainerPresentation)$this$getCorrectPoint).getEditor().getColorsScheme().getEditorFontSize2D()), point11.y + ScaleAwarePresentationFactoryKt.scaleByFont((int)(padding2 != null ? padding2.getTop() : 0), (float)((ScaledContainerPresentation)$this$getCorrectPoint).getEditor().getColorsScheme().getEditorFontSize2D()));
            } else if (inlayPresentation instanceof LineCenteredInset) {
                Point point12 = this.getCorrectPoint(((LineCenteredInset)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId);
                if (point12 == null) {
                    return null;
                }
                Point point13 = point12;
                point = new Point(point13.x, point13.y + (((LineCenteredInset)$this$getCorrectPoint).getEditor().getLineHeight() - ((LineCenteredInset)$this$getCorrectPoint).getPresentation().getHeight()) / 2);
            } else if (inlayPresentation instanceof ScaleAwareIconPresentation) {
                point = null;
            } else {
                if (inlayPresentation instanceof ChangeOnClickPresentation || inlayPresentation instanceof ChangeOnHoverPresentation || inlayPresentation instanceof MouseHandlingPresentation || inlayPresentation instanceof OnHoverPresentation || inlayPresentation instanceof OnClickPresentation || inlayPresentation instanceof MenuOnClickPresentation || inlayPresentation instanceof SelectableInlayPresentation || inlayPresentation instanceof StatefulPresentation) {
                    InlayPresentation inlayPresentation2;
                    InlayPresentation left = $this$getCorrectPoint;
                    if (left instanceof StatefulPresentation) {
                        inlayPresentation2 = ((StatefulPresentation)$this$getCorrectPoint).getPresentation();
                    } else if (left instanceof StaticDelegatePresentation) {
                        inlayPresentation2 = ((StaticDelegatePresentation)$this$getCorrectPoint).getPresentation();
                    } else if (left instanceof DynamicDelegatePresentation) {
                        inlayPresentation2 = ((DynamicDelegatePresentation)$this$getCorrectPoint).getDelegate();
                    } else {
                        return null;
                    }
                    InlayPresentation presentation = inlayPresentation2;
                    if (nextId.get() == childIdToFind) {
                        int id = nextId.get();
                        nextId.inc();
                        InlayPresentationModel inlayPresentationModel = BackendInlayWithPresentationModelCreator.Companion.toModel$intellij_platform_backend_split(presentation, nextId);
                        if (inlayPresentationModel == null) {
                            return null;
                        }
                        ChangeOnMouseEventPresentationModel currentModel = new ChangeOnMouseEventPresentationModel(id, inlayPresentationModel);
                        return Intrinsics.areEqual((Object)model2, (Object)currentModel) ? new Point(0, 0) : null;
                    }
                    nextId.inc();
                    return this.getCorrectPoint(presentation, childIdToFind, model2, nextId);
                }
                point = inlayPresentation instanceof StaticDelegatePresentation ? this.getCorrectPoint(((StaticDelegatePresentation)$this$getCorrectPoint).getPresentation(), childIdToFind, model2, nextId) : (inlayPresentation instanceof DynamicDelegatePresentation ? this.getCorrectPoint(((DynamicDelegatePresentation)$this$getCorrectPoint).getDelegate(), childIdToFind, model2, nextId) : null);
            }
        }
        return point;
    }

    static /* synthetic */ Point getCorrectPoint$default(BackendInlayEventsModelExtensionHandler backendInlayEventsModelExtensionHandler, InlayPresentation inlayPresentation, int n, InlayPresentationModel inlayPresentationModel, IntRef intRef, int n2, Object object) {
        if ((n2 & 4) != 0) {
            intRef = new IntRef();
        }
        return backendInlayEventsModelExtensionHandler.getCorrectPoint(inlayPresentation, n, inlayPresentationModel, intRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit consume$lambda$0(BackendInlayEventsModelExtensionHandler this$0, BackendMarkupModelContributor $contributor, InlayMouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        InlayPresentation inlayPresentation = this$0.getPresentationById(it.getId(), (BackendEditorMarkupModelContributor)$contributor);
        if (inlayPresentation == null) {
            BackendInlayEventsModelExtensionHandler it2 = this$0;
            boolean bl = false;
            LOG.warn("invalid highlighter id in event received");
            return Unit.INSTANCE;
        }
        InlayPresentation presentation = inlayPresentation;
        JComponent jComponent = ((BackendEditorMarkupModelContributor)$contributor).getEditor().getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent eventComponent = jComponent;
        InlayMouseEvent inlayMouseEvent = it;
        if (inlayMouseEvent instanceof MouseClickedEventModel) {
            Point point = BackendInlayEventsModelExtensionHandler.getCorrectPoint$default(this$0, presentation, ((MouseClickedEventModel)it).getInternalId(), ((MouseClickedEventModel)it).getInnerPresentationModel(), null, 4, null);
            if (point == null) {
                BackendInlayEventsModelExtensionHandler it3 = this$0;
                boolean bl = false;
                LOG.warn("invalid inner presentation id or model in event received");
                return Unit.INSTANCE;
            }
            Point point2 = point;
            JComponent component$iv = eventComponent;
            boolean $i$f$withMousePositionPopupContext = false;
            BeBackendCustomContextProvider.Companion.setPopupContext(component$iv, (BePopupPositionContext)new BePopupPositionMousePositionContext(null, 1, null));
            try {
                boolean bl = false;
                presentation.mouseClicked(this$0.fromModel(((MouseClickedEventModel)it).getMouseEvent(), eventComponent), point2);
            }
            finally {
                BeBackendCustomContextProvider.Companion.setPopupContext(component$iv, null);
            }
        } else if (inlayMouseEvent instanceof MouseMovedEventModel) {
            Point point = BackendInlayEventsModelExtensionHandler.getCorrectPoint$default(this$0, presentation, ((MouseMovedEventModel)it).getInternalId(), ((MouseMovedEventModel)it).getInnerPresentationModel(), null, 4, null);
            if (point == null) {
                BackendInlayEventsModelExtensionHandler it4 = this$0;
                boolean bl = false;
                LOG.warn("invalid inner presentation id or model in event received");
                return Unit.INSTANCE;
            }
            Point point3 = point;
            JComponent component$iv = eventComponent;
            boolean $i$f$withMousePositionPopupContext = false;
            BeBackendCustomContextProvider.Companion.setPopupContext(component$iv, (BePopupPositionContext)new BePopupPositionMousePositionContext(null, 1, null));
            try {
                boolean bl = false;
                presentation.mouseMoved(this$0.fromModel(((MouseMovedEventModel)it).getMouseEvent(), eventComponent), point3);
            }
            finally {
                BeBackendCustomContextProvider.Companion.setPopupContext(component$iv, null);
            }
        } else if (inlayMouseEvent instanceof MouseExitedEventModel) {
            presentation.mouseExited();
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendInlayWithPresentationModelCreator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/daemon/inlays/BackendInlayEventsModelExtensionHandler$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/ide/model/InlayWithPresentationEventsModel;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<InlayWithPresentationEventsModel> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

