/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.diagnostics;

import com.intellij.diagnostic.EditMemorySettingsServiceImpl;
import com.intellij.diagnostic.VMOptions;
import com.intellij.idea.AppMode;
import com.jetbrains.rdserver.diagnostics.BackendOptionsManipulator;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/diagnostics/BackendEditMemorySettingsService;", "Lcom/intellij/diagnostic/EditMemorySettingsServiceImpl;", "<init>", "()V", "getUserOptionsFile", "Ljava/nio/file/Path;", "save", "", "option", "Lcom/intellij/diagnostic/VMOptions$MemoryKind;", "value", "", "intellij.platform.backend.split"})
public final class BackendEditMemorySettingsService
extends EditMemorySettingsServiceImpl {
    @NotNull
    public Path getUserOptionsFile() {
        Path path;
        if (AppMode.isRemoteDevHost() && BackendOptionsManipulator.Companion.shouldEditBundledVmOptions()) {
            Path path2 = VMOptions.getPlatformOptionsFile();
            Intrinsics.checkNotNull((Object)path2);
            path = path2;
        } else {
            Path path3 = super.getUserOptionsFile();
            Intrinsics.checkNotNull((Object)path3);
            path = path3;
        }
        return path;
    }

    public void save(@NotNull VMOptions.MemoryKind option, int value) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        if (AppMode.isRemoteDevHost() && option == VMOptions.MemoryKind.HEAP) {
            BackendOptionsManipulator.Companion.setXmxValue(value);
        } else {
            super.save(option, value);
        }
    }
}

