/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.RuntimeFlagsKt;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.ScrollRequestListener;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.CoroutineHelpersKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SlowOperations;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.ChangeReason;
import com.jetbrains.rd.ide.model.CreationSide;
import com.jetbrains.rd.ide.model.DocumentExtension;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.KernelAwareTextControlId;
import com.jetbrains.rd.ide.model.PatchEngineTextControlModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.RequestResponseModel;
import com.jetbrains.rd.ide.model.TextControlExtension;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlLocation;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.model.VisibleRange;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.platform.util.idea.EditorKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.AppExtListener;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.threading.coroutines.LifetimeCoroutineUtilKt;
import com.jetbrains.rdserver.core.RemoteSessionKt;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import com.jetbrains.rdserver.document.BackendDocumentHostListener;
import com.jetbrains.rdserver.document.BackendProjectAwareDocumentExtensionsProvider;
import com.jetbrains.rdserver.editors.BackendEditorExtensionsProvider;
import com.jetbrains.rdserver.editors.BackendEditorHostKt;
import com.jetbrains.rdserver.editors.BackendEditorHostListener;
import com.jetbrains.rdserver.editors.BackendEditorSynchronizer;
import com.jetbrains.rdserver.editors.DocumentUtilKt;
import com.jetbrains.rdserver.editors.EditorScrollingAccumulator;
import com.jetbrains.rdserver.editors.RemoteEditorData;
import com.jetbrains.rdserver.editors.RemoteEditorDataKt;
import com.jetbrains.rdserver.requests.BackendPatchEngineKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference2;
import kotlin.jvm.internal.MutablePropertyReference2Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 -2\u00020\u0001:\u0005,-./0B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\fJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\fJ\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0018\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\t2\b\b\u0002\u0010\"\u001a\u00020#J(\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010'\u001a\u00020(H\u0014J(\u0010)\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010'\u001a\u00020(2\u0006\u0010!\u001a\u00020\tH\u0002J\u0010\u0010*\u001a\u00020%2\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0010\u0010+\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\fH\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R3\u0010\n\u001a'\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e\u0012\u000e\u0012\f0\t\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e0\u000b\u00a2\u0006\u0002\b\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R3\u0010\u000f\u001a'\u0012\u000e\u0012\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e\u0012\u000e\u0012\f0\u0010\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000e0\u000b\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00061"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "currentlyBindingEditor", "Lcom/intellij/openapi/editor/Editor;", "currentlyStashedEditors", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/rd/ide/model/TextControlId;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "recentlyUnboundEditors", "Ljava/util/concurrent/atomic/AtomicInteger;", "idToSynchronizersMap", "Ljava/util/HashMap;", "Lcom/jetbrains/rdserver/editors/BackendEditorSynchronizer;", "Lkotlin/collections/HashMap;", "documentHost", "Lcom/jetbrains/rdserver/document/BackendDocumentHost;", "getDocumentHost", "()Lcom/jetbrains/rdserver/document/BackendDocumentHost;", "tryGetOwnRemoteEditor", "textControlId", "tryGetSynchronizer", "ensureBackendEditorCreated", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "openEditor", "bindEditor", "editor", "manualBind", "", "attachEditorListeners", "", "editorLifetime", "textControlModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "createSynchronizer", "addRecentlyUnboundEditor", "isRecentlyUnbound", "BackendEditorSynchronizerHolder", "Companion", "MyProtocolListener", "MyDocumentHostListener", "MyEditorFactoryListener", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 9 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,493:1\n67#2,4:494\n67#2,4:499\n67#2,4:515\n1#3:498\n45#4,8:503\n777#5:511\n873#5,2:512\n66#6:514\n67#6,2:527\n66#6,3:530\n10574#7:519\n11007#7,5:520\n37#8,2:525\n23#9:529\n23#9:533\n*S KotlinDebug\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHost\n*L\n193#1:494,4\n214#1:499,4\n284#1:515,4\n263#1:503,8\n271#1:511\n271#1:512,2\n282#1:514\n282#1:527,2\n393#1:530,3\n286#1:519\n286#1:520,5\n288#1:525,2\n326#1:529\n333#1:533\n*E\n"})
public class BackendEditorHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @Nullable
    private Editor currentlyBindingEditor;
    @NotNull
    private ConcurrentMap<TextControlId, Editor> currentlyStashedEditors;
    @NotNull
    private final ConcurrentMap<TextControlId, AtomicInteger> recentlyUnboundEditors;
    @NotNull
    private final HashMap<TextControlId, BackendEditorSynchronizer> idToSynchronizersMap;
    @NotNull
    private static final ReadWriteProperty<? super UserDataHolder, TextControlModel> _textControlModel$delegate = UserDataHolderKt.userData$default(null, (int)1, null);
    @NotNull
    private static final ReadWriteProperty<? super UserDataHolder, TextControlId> _deferredBoundTextControlId$delegate = UserDataHolderKt.userData$default(null, (int)1, null);

    public BackendEditorHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.currentlyStashedEditors = concurrentMap;
        ConcurrentMap concurrentMap2 = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap2, (String)"createConcurrentMap(...)");
        this.recentlyUnboundEditors = concurrentMap2;
        this.idToSynchronizersMap = new HashMap();
    }

    @NotNull
    protected final ClientAppSession getSession() {
        return this.session;
    }

    private final BackendDocumentHost getDocumentHost() {
        return BackendDocumentHost.Companion.getInstance(this.session);
    }

    @Nullable
    public final Editor tryGetOwnRemoteEditor(@NotNull TextControlId textControlId) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        BackendEditorSynchronizer backendEditorSynchronizer = this.tryGetSynchronizer(textControlId);
        return backendEditorSynchronizer != null ? backendEditorSynchronizer.getEditor() : null;
    }

    @Nullable
    public final BackendEditorSynchronizer tryGetSynchronizer(@NotNull TextControlId textControlId) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        return this.idToSynchronizersMap.get(textControlId);
    }

    private final Editor ensureBackendEditorCreated(Lifetime lifetime, TextControlId textControlId) {
        Editor bindingEditor;
        if (!Intrinsics.areEqual((Object)textControlId.getClientId(), (Object)this.session.getClientId().getValue())) {
            boolean $i$a$-require-BackendEditorHost$ensureBackendEditorCreated$22 = false;
            String $i$a$-require-BackendEditorHost$ensureBackendEditorCreated$22 = "ClientId mismatch. session: " + this.session.getClientId() + ", editor: " + textControlId.getClientId();
            throw new IllegalArgumentException($i$a$-require-BackendEditorHost$ensureBackendEditorCreated$22.toString());
        }
        Logger $this$trace$iv = BackendEditorHostKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("ensureBackendEditorCreated for editor " + textControlId + " under " + ClientId.Companion.getCurrent());
        }
        $this$trace$iv = this.tryGetOwnRemoteEditor(textControlId);
        if ($this$trace$iv != null) {
            Logger it = $this$trace$iv;
            boolean bl = false;
            return it;
        }
        Editor editor = (Editor)this.currentlyStashedEditors.remove(textControlId);
        if (editor == null) {
            editor = this.currentlyBindingEditor;
        }
        if ((bindingEditor = editor) != null) {
            if (!Intrinsics.areEqual((Object)bindingEditor.getDocument(), (Object)this.getDocumentHost().getDocument(textControlId.getDocumentId()))) {
                boolean bl = false;
                String string = "Simultaneous binding of editors for different documents";
                throw new IllegalArgumentException(string.toString());
            }
            return bindingEditor;
        }
        BackendEditorHostKt.access$getLOG$p().assertTrue(textControlId.getKind() != TextControlLocation.EditorTab, (Object)("Requiring editor tab creation. " + UtilKt.toDebugString((TextControlId)textControlId)));
        return this.openEditor(lifetime, textControlId);
    }

    private final Editor openEditor(Lifetime lifetime, TextControlId textControlId) {
        ClientProjectSession projectSession;
        ClientProjectSession clientProjectSession;
        Logger $this$trace$iv = BackendEditorHostKt.access$getLOG$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Opening a new editor for " + textControlId + " under " + ClientId.Companion.getCurrent());
        }
        EditorFactory factory = EditorFactory.getInstance();
        Document document = this.getDocumentHost().getDocument(textControlId.getDocumentId());
        EditorKind kind = EditorKt.toEditorKind((TextControlLocation)textControlId.getKind());
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        RdProjectId rdProjectId = textControlId.getProjectId();
        if (rdProjectId != null) {
            RdProjectId it = rdProjectId;
            boolean bl = false;
            clientProjectSession = SessionUtilKt.getProjectSession((ClientAppSession)this.session, (RdProjectId)it);
        } else {
            clientProjectSession = null;
        }
        ClientProjectSession clientProjectSession2 = projectSession = clientProjectSession;
        Project project = clientProjectSession2 != null ? clientProjectSession2.getProject() : null;
        Editor editor = (Editor)ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendEditorHost.openEditor$lambda$2(file2, factory, document, project, kind));
        if (textControlId instanceof KernelAwareTextControlId) {
            editor.putUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY(), (Object)EditorId.Companion.deserializeFromString(((KernelAwareTextControlId)textControlId).getKernelEditorId()));
        } else {
            BackendEditorHostKt.access$getLOG$p().error("Given " + textControlId + " is not KernelAwareTextControlId, but in RD scenario it should be");
        }
        UIUtil.markAsShowing((JComponent)editor.getComponent(), (boolean)true);
        lifetime.onTermination(() -> BackendEditorHost.openEditor$lambda$3(editor, textControlId, this));
        Intrinsics.checkNotNull((Object)editor);
        return editor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final TextControlId bindEditor(@NotNull Editor editor, boolean manualBind) {
        void description$iv;
        void $this$sendAccumulated_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ClientId it = DocumentUtilKt.clientId(editor);
        boolean bl = false;
        if (!(Intrinsics.areEqual((Object)it, (Object)ClientId.Companion.getLocalId()) || Intrinsics.areEqual((Object)it, (Object)this.session.getClientId()))) {
            boolean $i$a$-require-BackendEditorHost$bindEditor$32 = false;
            BackendEditorSynchronizer backendEditorSynchronizer = Companion.synchronizerForSession(editor, this.session);
            String editorId = backendEditorSynchronizer != null && (backendEditorSynchronizer = backendEditorSynchronizer.getTextControlId()) != null ? UtilKt.toDebugString((TextControlId)backendEditorSynchronizer) : null;
            String $i$a$-require-BackendEditorHost$bindEditor$32 = "ClientId mismatch. Trying to bind foreign (" + editorId + ", " + DocumentUtilKt.clientId(editor) + ") to " + this.session.getClientId();
            throw new IllegalArgumentException($i$a$-require-BackendEditorHost$bindEditor$32.toString());
        }
        TextControlId existingId = Companion.textControlIdForSession(editor, this.session);
        if (existingId != null) {
            return existingId;
        }
        PatchEngine $i$a$-require-BackendEditorHost$bindEditor$32 = BackendPatchEngineKt.getEngine(this.session);
        String editorId = "Creating text control";
        ChangeReason changeReason$iv = ChangeReason.INIT;
        Class changeProducer$iv = null;
        boolean $i$f$sendAccumulated = false;
        AutoCloseable autoCloseable = (AutoCloseable)PatchEngine.openAccumulatingSession$default((PatchEngine)$this$sendAccumulated_u24default$iv, (boolean)true, (String)description$iv, (ChangeReason)changeReason$iv, changeProducer$iv, null, (int)16, null);
        Throwable throwable = null;
        try {
            Object object;
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            RdPatchEngine.ChangeAccumulatingSessionToken it$iv = (RdPatchEngine.ChangeAccumulatingSessionToken)autoCloseable;
            boolean bl2 = false;
            ChangeScope $this$bindEditor_u24lambda_u242 = it$iv.getSession().getChangeScope();
            boolean bl3 = false;
            Project project = editor.getProject();
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            List<DocumentExtension> projectAwareDocumentExtensions = BackendProjectAwareDocumentExtensionsProvider.Companion.getAllExtensions(this.session, project, document);
            BackendDocumentHost backendDocumentHost = this.getDocumentHost();
            Document document2 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            RdDocumentId documentId = backendDocumentHost.bindDocument(document2, projectAwareDocumentExtensions);
            DocumentSynchronizer documentSynchronizer = this.getDocumentHost().tryGetSynchronizer(documentId);
            Intrinsics.checkNotNull((Object)documentSynchronizer);
            RdDocumentModel documentModel = documentSynchronizer.getModelDocument();
            EditorKind editorKind = editor.getEditorKind();
            Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
            TextControlLocation location = EditorKt.toLocation((EditorKind)editorKind);
            Iterable iterable = documentModel.getTextControls().keySet();
            boolean $i$f$filter22 = false;
            void var21_28 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TextControlId it2 = (TextControlId)element$iv$iv;
                boolean bl4 = false;
                if (!(it2.getKind() == location && Intrinsics.areEqual((Object)it2.getClientId(), (Object)this.session.getClientId().getValue()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator $i$f$filter22 = ((Iterable)((List)destination$iv$iv)).iterator();
            if (!$i$f$filter22.hasNext()) {
                object = null;
            } else {
                Object it3 = (TextControlId)$i$f$filter22.next();
                boolean bl5 = false;
                it3 = it3.getTabIndex() + 1;
                while ($i$f$filter22.hasNext()) {
                    Object it4 = (TextControlId)$i$f$filter22.next();
                    $i$a$-maxOfOrNull-BackendEditorHost$bindEditor$3$tabIndex$2 = false;
                    if (it3.compareTo(it4 = (Comparable)Integer.valueOf(it4.getTabIndex() + 1)) >= 0) continue;
                    it3 = it4;
                }
                object = it3;
            }
            Integer n = (Integer)object;
            int tabIndex = n != null ? n : 1;
            EditorId kernelEditorId = EditorIdKt.editorId((Editor)editor);
            Project project2 = editor.getProject();
            KernelAwareTextControlId textControlId = new KernelAwareTextControlId(kernelEditorId.serializeToString(), documentId, tabIndex, location, this.session.getClientId().getValue(), (RdProjectId)(project2 != null ? ProjectUtilKt.getRdProjectId((Project)project2) : null));
            try {
                void $this$getOrCreate$iv;
                if (!(this.currentlyBindingEditor == null)) {
                    boolean $i$a$-require-BackendEditorHost$bindEditor$3$22 = false;
                    String $i$a$-require-BackendEditorHost$bindEditor$3$22 = "trying to bind " + editor + " during binding of " + this.currentlyBindingEditor;
                    throw new IllegalArgumentException($i$a$-require-BackendEditorHost$bindEditor$3$22.toString());
                }
                this.currentlyBindingEditor = editor;
                $i$f$filter22 = (Map)documentModel.getTextControls();
                KernelAwareTextControlId key$iv = textControlId;
                boolean $i$f$getOrCreate = false;
                Object object2 = $this$getOrCreate$iv.get(key$iv);
                if (object2 == null) {
                    PatchEngineTextControlModel patchEngineTextControlModel;
                    void $this$toTypedArray$iv;
                    void $this$flatMapTo$iv$iv;
                    TextControlId it5 = (TextControlId)key$iv;
                    boolean bl6 = false;
                    BackendEditorHostKt.access$getLOG$p().info("Adding " + UtilKt.toDebugString((TextControlId)((TextControlId)textControlId)) + " to the model");
                    Logger $this$trace$iv = BackendEditorHostKt.access$getLOG$p();
                    boolean $i$f$trace = false;
                    if ($this$trace$iv.isTraceEnabled()) {
                        Logger logger = $this$trace$iv;
                        boolean bl7 = false;
                        logger.trace("[file] bindEditor: Set new `textControlId=<look in prev log line>` to `documentModel.textControls` map");
                    }
                    Object $this$flatMap$iv = BackendEditorExtensionsProvider.Companion.getEP_NAME().getExtensions();
                    boolean $i$f$flatMap = false;
                    Object[] objectArray = $this$flatMap$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                        BackendEditorExtensionsProvider it6 = (BackendEditorExtensionsProvider)element$iv$iv;
                        boolean bl8 = false;
                        Iterable list$iv$iv = it6.getExtensions(this.getSession(), editor);
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    $this$flatMap$iv = (List)destination$iv$iv2;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    TextControlExtension[] editorExtensions = thisCollection$iv.toArray(new TextControlExtension[0]);
                    PatchEngineTextControlModel $this$bindEditor_u24lambda_u242_u243_u242 = patchEngineTextControlModel = new PatchEngineTextControlModel(null, CreationSide.Backend, editorExtensions, null, manualBind, 8, null);
                    boolean bl9 = false;
                    $this$bindEditor_u24lambda_u242_u243_u242.isReadonly().set((Object)editor.isViewer());
                    TextControlModel it$iv2 = (TextControlModel)patchEngineTextControlModel;
                    boolean bl10 = false;
                    $this$getOrCreate$iv.put(key$iv, it$iv2);
                    object2 = it$iv2;
                }
                if (!Intrinsics.areEqual((Object)DocumentUtilKt.clientId(editor), (Object)this.session.getClientId())) {
                    boolean bl11 = false;
                    String string = "Editor wasn't bound. " + UtilKt.toDebugString((TextControlId)((TextControlId)textControlId));
                    throw new IllegalArgumentException(string.toString());
                }
                JComponent jComponent = editor.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
                Utils.INSTANCE.markAsModalContext(jComponent, Boolean.valueOf(false));
                TextControlId textControlId2 = (TextControlId)textControlId;
                this.currentlyBindingEditor = null;
                TextControlId textControlId3 = textControlId2;
                return textControlId3;
            }
            catch (Throwable throwable2) {
                try {
                    this.currentlyBindingEditor = null;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ TextControlId bindEditor$default(BackendEditorHost backendEditorHost, Editor editor, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bindEditor");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return backendEditorHost.bindEditor(editor, bl);
    }

    protected void attachEditorListeners(@NotNull Lifetime editorLifetime, @NotNull Editor editor, @NotNull TextControlId textControlId, @NotNull TextControlModel textControlModel) {
        ClientProjectSession clientProjectSession;
        ClientProjectSession clientProjectSession2;
        Intrinsics.checkNotNullParameter((Object)editorLifetime, (String)"editorLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"textControlModel");
        if (!Intrinsics.areEqual((Object)textControlId.getClientId(), (Object)this.session.getClientId().getValue())) {
            boolean $i$a$-require-BackendEditorHost$attachEditorListeners$22 = false;
            String $i$a$-require-BackendEditorHost$attachEditorListeners$22 = "ClientId mismatch. session: " + this.session.getClientId() + ", editor: " + textControlId.getClientId();
            throw new IllegalArgumentException($i$a$-require-BackendEditorHost$attachEditorListeners$22.toString());
        }
        Disposable textControlDisposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)editorLifetime, (String)("attachEditorListeners: " + textControlModel));
        BackendEditorSynchronizer editorSynchronizer = this.createSynchronizer(editorLifetime, textControlId, textControlModel, editor);
        CollectionExKt.addUnique((Map)this.idToSynchronizersMap, (Lifetime)editorLifetime, (Object)textControlId, (Object)editorSynchronizer);
        BackendEditorHost.Companion.set_textControlModel(editor, textControlModel);
        ClientEditorManager.Companion.assignClientId(editor, this.session.getClientId());
        ClientSession $this$service$iv = (ClientSession)this.session;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(BackendEditorSynchronizerHolder.class);
        if (object == null) {
            throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
        }
        ((BackendEditorSynchronizerHolder)object).setSynchronizer(editor, editorSynchronizer);
        RemoteEditorDataKt.setRemoteEditorData(editor, new RemoteEditorData());
        BackendEditorHost.Companion.set_deferredBoundTextControlId(editor, null);
        editorLifetime.onTermination(() -> BackendEditorHost.attachEditorListeners$lambda$1(editor, this, textControlId));
        textControlModel.getVisibleRange().advise(editorLifetime, arg_0 -> BackendEditorHost.attachEditorListeners$lambda$2(editor, arg_0));
        if (!RuntimeFlagsKt.isRhizomeAdEnabled()) {
            editor.getSelectionModel().addSelectionListener((SelectionListener)editorSynchronizer, textControlDisposable);
            editor.getCaretModel().addCaretActionListener((CaretActionListener)editorSynchronizer, textControlDisposable);
            editor.getCaretModel().addCaretListener((CaretListener)editorSynchronizer, textControlDisposable);
            editor.getDocument().addDocumentListener((DocumentListener)editorSynchronizer, textControlDisposable);
            if (!Intrinsics.areEqual((Object)textControlModel.getDoNotSyncState().getValueOrNull(), (Object)true)) {
                editorSynchronizer.sendInitialCaretState();
                editorSynchronizer.startSyncEditorSettingsToModel$intellij_platform_backend_split(textControlDisposable);
                editorSynchronizer.startSyncEditorStateToModel$intellij_platform_backend_split(textControlDisposable);
            }
            ScrollingModel scrollingModel = editor.getScrollingModel();
            Intrinsics.checkNotNull((Object)scrollingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.ScrollingModelImpl");
            ((ScrollingModelImpl)scrollingModel).addScrollRequestListener((ScrollRequestListener)editorSynchronizer, textControlDisposable);
        }
        EditorScrollingAccumulator.Companion.finishTracking(editor, editorSynchronizer);
        textControlModel.getBackendReadyForEvents().set((Object)true);
        BackendEditorHostListener publisher = (BackendEditorHostListener)ApplicationKt.getApplication().getMessageBus().syncPublisher(BackendEditorHostListener.Companion.getTOPIC());
        RdProjectId rdProjectId = textControlId.getProjectId();
        if (rdProjectId != null) {
            RdProjectId it = rdProjectId;
            boolean bl = false;
            clientProjectSession2 = SessionUtilKt.getProjectSession((ClientAppSession)this.session, (RdProjectId)it);
        } else {
            clientProjectSession2 = null;
        }
        ClientProjectSession projectSession = clientProjectSession2;
        Project project = editor.getProject();
        if (!(Intrinsics.areEqual((Object)textControlId.getProjectId(), (Object)(project != null ? ProjectUtilKt.getRdProjectId((Project)project) : null)) && Intrinsics.areEqual((Object)((clientProjectSession = projectSession) != null && (clientProjectSession = clientProjectSession.getProject()) != null ? ProjectUtilKt.getRdProjectId((Project)clientProjectSession) : null), (Object)textControlId.getProjectId()))) {
            ClientProjectSession clientProjectSession3;
            boolean bl = false;
            Project project2 = editor.getProject();
            String string = "textControlId.projectId: " + textControlId.getProjectId() + ", editor.project?.rdProjectId: " + (RdProjectId)(project2 != null ? ProjectUtilKt.getRdProjectId((Project)project2) : null) + ", projectSession?.project?.rdProjectId: " + ((clientProjectSession3 = projectSession) != null && (clientProjectSession3 = clientProjectSession3.getProject()) != null ? ProjectUtilKt.getRdProjectId((Project)clientProjectSession3) : null);
            throw new IllegalArgumentException(string.toString());
        }
        publisher.editorBound(editorLifetime, this.session, projectSession, textControlId, textControlModel, editor);
    }

    private final BackendEditorSynchronizer createSynchronizer(Lifetime editorLifetime, TextControlId textControlId, TextControlModel textControlModel, Editor editor) {
        if (!Intrinsics.areEqual((Object)textControlId.getClientId(), (Object)this.session.getClientId().getValue())) {
            boolean $i$a$-require-BackendEditorHost$createSynchronizer$22 = false;
            String $i$a$-require-BackendEditorHost$createSynchronizer$22 = "ClientId mismatch. session: " + this.session.getClientId() + ", editor: " + textControlId.getClientId();
            throw new IllegalArgumentException($i$a$-require-BackendEditorHost$createSynchronizer$22.toString());
        }
        BackendDocumentHost backendDocumentHost = this.getDocumentHost();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        DocumentSynchronizer documentSynchronizer = backendDocumentHost.tryGetSynchronizer(document);
        if (documentSynchronizer == null) {
            throw new IllegalStateException("Document synchronizer is null".toString());
        }
        DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
        ClientProjectSession projectSession = SessionUtilKt.getProjectSession((ClientAppSession)this.session, (RdProjectId)textControlId.getProjectId());
        ClientProjectSession clientProjectSession = projectSession;
        ClientProjectSession clientProjectSession2 = projectSession;
        BackendEditorHostKt.access$getLOG$p().assertTrue(Intrinsics.areEqual((Object)(clientProjectSession != null ? clientProjectSession.getProject() : null), (Object)editor.getProject()), (Object)("projectSession.project: " + (Project)(clientProjectSession2 != null ? clientProjectSession2.getProject() : null) + ", editorProject: " + editor.getProject()));
        return new BackendEditorSynchronizer(editorLifetime, this.session, projectSession, editor, textControlId, textControlModel, documentSynchronizer2, BackendPatchEngineKt.getEngine(this.session));
    }

    /*
     * WARNING - void declaration
     */
    private final void addRecentlyUnboundEditor(TextControlId textControlId) {
        void $this$getOrCreate$iv;
        Map map2 = this.recentlyUnboundEditors;
        TextControlId key$iv = textControlId;
        boolean $i$f$getOrCreate = false;
        Object object = $this$getOrCreate$iv.get(key$iv);
        if (object == null) {
            TextControlId it = key$iv;
            boolean bl = false;
            AtomicInteger it$iv = new AtomicInteger(0);
            boolean bl2 = false;
            $this$getOrCreate$iv.put(key$iv, it$iv);
            object = it$iv;
        }
        ((AtomicInteger)object).getAndIncrement();
        long removeDelay = DurationKt.toDuration((int)Registry.Companion.intValue("rd.server.recent.unbound.delay", 5000), (DurationUnit)DurationUnit.MILLISECONDS);
        LifetimeCoroutineUtilKt.launch$default((Lifetime)this.getServiceLifetime(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(removeDelay, this, textControlId, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ long $removeDelay;
            final /* synthetic */ BackendEditorHost this$0;
            final /* synthetic */ TextControlId $textControlId;
            {
                this.$removeDelay = $removeDelay;
                this.this$0 = $receiver;
                this.$textControlId = $textControlId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)this.$removeDelay, (Continuation)((Continuation)this));
                        if (v0 == var7_3) {
                            return var7_3;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        v1 = (AtomicInteger)BackendEditorHost.access$getRecentlyUnboundEditors$p(this.this$0).get(this.$textControlId);
                        if (v1 != null) {
                            Boxing.boxInt((int)v1.decrementAndGet());
                        } else {
                            var3_4 = $this$launch;
                            var4_5 = this.$textControlId;
                            $this$invokeSuspend_u24lambda_u240 = var3_4;
                            $i$a$-run-BackendEditorHost$addRecentlyUnboundEditor$2$1 = false;
                            BackendEditorHostKt.access$getLOG$p().warn("Failed to get textControlId from recentlyUnboundEditors map. textControlId: " + UtilKt.toDebugString((TextControlId)var4_5));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @ApiStatus.Internal
    public final boolean isRecentlyUnbound(@NotNull TextControlId textControlId) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        AtomicInteger atomicInteger = (AtomicInteger)this.recentlyUnboundEditors.get(textControlId);
        return (atomicInteger != null ? atomicInteger.get() : 0) > 0;
    }

    private static final Unit openEditor$lambda$3$0(Editor $editor) {
        if (!$editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor($editor);
        }
        return Unit.INSTANCE;
    }

    private static final Editor openEditor$lambda$2(VirtualFile $file, EditorFactory $factory, Document $document, Project $project, EditorKind $kind) {
        return $file != null ? $factory.createEditor($document, $project, $file, false, $kind) : $factory.createEditor($document, $project, $kind);
    }

    private static final Unit openEditor$lambda$3(Editor $editor, TextControlId $textControlId, BackendEditorHost this$0) {
        if ($editor.isDisposed()) {
            BackendEditorHostKt.access$getLOG$p().warn("Trying to dispose an already disposed editor. id=" + $textControlId, new Throwable());
            return Unit.INSTANCE;
        }
        ClientId.Companion.withClientId(this$0.session.getClientId(), () -> BackendEditorHost.openEditor$lambda$3$0($editor));
        return Unit.INSTANCE;
    }

    private static final Unit attachEditorListeners$lambda$1(Editor $editor, BackendEditorHost this$0, TextControlId $textControlId) {
        BackendEditorHost.Companion.set_textControlModel($editor, null);
        ClientEditorManager.Companion.assignClientId($editor, null);
        ClientSession $this$service$iv = (ClientSession)this$0.session;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(BackendEditorSynchronizerHolder.class);
        if (object == null) {
            throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
        }
        ((BackendEditorSynchronizerHolder)object).removeSynchronizer($editor);
        RemoteEditorDataKt.setRemoteEditorData($editor, null);
        this$0.addRecentlyUnboundEditor($textControlId);
        return Unit.INSTANCE;
    }

    private static final Unit attachEditorListeners$lambda$2(Editor $editor, VisibleRange it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ProperTextRange textRange = new ProperTextRange(it.getStartOffset(), it.getEndOffset());
        RemoteEditorData remoteEditorData = RemoteEditorDataKt.getRemoteEditorData($editor);
        Intrinsics.checkNotNull((Object)remoteEditorData);
        remoteEditorData.getVisibleRange().set((Object)textRange);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConcurrentMap access$getRecentlyUnboundEditors$p(BackendEditorHost $this) {
        return $this.recentlyUnboundEditors;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u0006\u001a'\u0012\u000e\u0012\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorHost$BackendEditorSynchronizerHolder;", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<init>", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "holder", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/jetbrains/rdserver/editors/BackendEditorSynchronizer;", "getSynchronizer", "editor", "setSynchronizer", "", "synchronizer", "removeSynchronizer", "intellij.platform.backend.split"})
    public static final class BackendEditorSynchronizerHolder {
        @NotNull
        private final ClientAppSession session;
        @NotNull
        private final ConcurrentMap<Editor, BackendEditorSynchronizer> holder;

        public BackendEditorSynchronizerHolder(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
            ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
            this.holder = concurrentMap;
        }

        @Nullable
        public final BackendEditorSynchronizer getSynchronizer(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (BackendEditorSynchronizer)this.holder.get(editor);
        }

        public final void setSynchronizer(@NotNull Editor editor, @NotNull BackendEditorSynchronizer synchronizer) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)synchronizer, (String)"synchronizer");
            ((Map)this.holder).put(editor, synchronizer);
        }

        public final void removeSynchronizer(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.holder.remove(editor);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u001a*\u00020\u000b2\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010%\u001a\u0004\u0018\u00010\u0012*\u00020\u000b2\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0007R3\u0010\n\u001a\u0004\u0018\u00010\t*\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\t8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR3\u0010\u0013\u001a\u0004\u0018\u00010\u0012*\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u00128B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010 \u001a\u0004\u0018\u00010\t*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR \u0010\"\u001a\u0004\u0018\u00010\u0012*\u00020\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b#\u0010\u001c\u001a\u0004\b$\u0010\u0015\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/rdserver/editors/BackendEditorHost;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "<set-?>", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "_textControlModel", "Lcom/intellij/openapi/editor/Editor;", "get_textControlModel", "(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rd/ide/model/TextControlModel;", "set_textControlModel", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlModel;)V", "_textControlModel$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lcom/jetbrains/rd/ide/model/TextControlId;", "_deferredBoundTextControlId", "get_deferredBoundTextControlId", "(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rd/ide/model/TextControlId;", "set_deferredBoundTextControlId", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;)V", "_deferredBoundTextControlId$delegate", "synchronizer", "Lcom/jetbrains/rdserver/editors/BackendEditorSynchronizer;", "getSynchronizer$annotations", "(Lcom/intellij/openapi/editor/Editor;)V", "getSynchronizer", "(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rdserver/editors/BackendEditorSynchronizer;", "synchronizerForSession", "textControlModel", "getTextControlModel", "textControlId", "getTextControlId$annotations", "getTextControlId", "textControlIdForSession", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,493:1\n23#2:494\n23#2:495\n23#2:496\n23#2:497\n*S KotlinDebug\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHost$Companion\n*L\n80#1:494\n92#1:495\n107#1:496\n115#1:497\n*E\n"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final BackendEditorHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendEditorHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (BackendEditorHost)((Object)object);
        }

        private final TextControlModel get_textControlModel(Editor $this$_textControlModel) {
            return (TextControlModel)_textControlModel$delegate.getValue((Object)$this$_textControlModel, $$delegatedProperties[0]);
        }

        private final void set_textControlModel(Editor $this$_textControlModel, TextControlModel textControlModel) {
            _textControlModel$delegate.setValue((Object)$this$_textControlModel, $$delegatedProperties[0], (Object)textControlModel);
        }

        private final TextControlId get_deferredBoundTextControlId(Editor $this$_deferredBoundTextControlId) {
            return (TextControlId)_deferredBoundTextControlId$delegate.getValue((Object)$this$_deferredBoundTextControlId, $$delegatedProperties[1]);
        }

        private final void set_deferredBoundTextControlId(Editor $this$_deferredBoundTextControlId, TextControlId textControlId) {
            _deferredBoundTextControlId$delegate.setValue((Object)$this$_deferredBoundTextControlId, $$delegatedProperties[1], (Object)textControlId);
        }

        @Nullable
        public final BackendEditorSynchronizer getSynchronizer(@NotNull Editor $this$synchronizer) {
            Intrinsics.checkNotNullParameter((Object)$this$synchronizer, (String)"<this>");
            return this.synchronizerForSession($this$synchronizer, ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()));
        }

        @Deprecated(message="Use version with explicit session", replaceWith=@ReplaceWith(expression="synchronizerForSession()", imports={"com.jetbrains.rdserver.editors.BackendEditorHost.Companion.synchronizerForSession"}))
        public static /* synthetic */ void getSynchronizer$annotations(Editor editor) {
        }

        @ApiStatus.Internal
        @Nullable
        public final BackendEditorSynchronizer synchronizerForSession(@NotNull Editor $this$synchronizerForSession, @NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)$this$synchronizerForSession, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendEditorSynchronizerHolder.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            BackendEditorSynchronizerHolder synchronizerHolder = (BackendEditorSynchronizerHolder)object;
            Editor editor = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)$this$synchronizerForSession);
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getTopLevelEditor(...)");
            return synchronizerHolder.getSynchronizer(editor);
        }

        public static /* synthetic */ BackendEditorSynchronizer synchronizerForSession$default(Companion companion, Editor editor, ClientAppSession clientAppSession, int n, Object object) {
            if ((n & 1) != 0) {
                clientAppSession = ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication());
            }
            return companion.synchronizerForSession(editor, clientAppSession);
        }

        @Nullable
        public final TextControlModel getTextControlModel(@NotNull Editor $this$textControlModel) {
            Intrinsics.checkNotNullParameter((Object)$this$textControlModel, (String)"<this>");
            Editor editor = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)$this$textControlModel);
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getTopLevelEditor(...)");
            return this.get_textControlModel(editor);
        }

        @Nullable
        public final TextControlId getTextControlId(@NotNull Editor $this$textControlId) {
            Intrinsics.checkNotNullParameter((Object)$this$textControlId, (String)"<this>");
            Editor it = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)$this$textControlId);
            boolean bl = false;
            ClientSession $this$service$iv = (ClientSession)ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication());
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendEditorSynchronizerHolder.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            BackendEditorSynchronizerHolder holder = (BackendEditorSynchronizerHolder)object;
            Intrinsics.checkNotNull((Object)it);
            BackendEditorSynchronizer backendEditorSynchronizer = holder.getSynchronizer(it);
            if (backendEditorSynchronizer == null || (backendEditorSynchronizer = backendEditorSynchronizer.getTextControlId()) == null) {
                backendEditorSynchronizer = Companion.get_deferredBoundTextControlId(it);
            }
            return backendEditorSynchronizer;
        }

        @Deprecated(message="Use version with explicit session", replaceWith=@ReplaceWith(expression="textControlIdForSession()", imports={"com.jetbrains.rdserver.editors.BackendEditorHost.Companion.textControlIdForSession"}))
        public static /* synthetic */ void getTextControlId$annotations(Editor editor) {
        }

        @ApiStatus.Internal
        @Nullable
        public final TextControlId textControlIdForSession(@NotNull Editor $this$textControlIdForSession, @NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)$this$textControlIdForSession, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Editor it = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)$this$textControlIdForSession);
            boolean bl = false;
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendEditorSynchronizerHolder.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            BackendEditorSynchronizerHolder holder = (BackendEditorSynchronizerHolder)object;
            Intrinsics.checkNotNull((Object)it);
            BackendEditorSynchronizer backendEditorSynchronizer = holder.getSynchronizer(it);
            if (backendEditorSynchronizer == null || (backendEditorSynchronizer = backendEditorSynchronizer.getTextControlId()) == null) {
                backendEditorSynchronizer = Companion.get_deferredBoundTextControlId(it);
            }
            return backendEditorSynchronizer;
        }

        public static /* synthetic */ TextControlId textControlIdForSession$default(Companion companion, Editor editor, ClientAppSession clientAppSession, int n, Object object) {
            if ((n & 1) != 0) {
                clientAppSession = ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication());
            }
            return companion.textControlIdForSession(editor, clientAppSession);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "_textControlModel", "get_textControlModel(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rd/ide/model/TextControlModel;", 0))), Reflection.mutableProperty2((MutablePropertyReference2)((MutablePropertyReference2)new MutablePropertyReference2Impl(Companion.class, "_deferredBoundTextControlId", "get_deferredBoundTextControlId(Lcom/intellij/openapi/editor/Editor;)Lcom/jetbrains/rd/ide/model/TextControlId;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorHost$MyDocumentHostListener;", "Lcom/jetbrains/rdserver/document/BackendDocumentHostListener;", "<init>", "()V", "documentBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "model", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHost$MyDocumentHostListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,493:1\n67#2,4:494\n67#2,4:498\n67#2,4:502\n*S KotlinDebug\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHost$MyDocumentHostListener\n*L\n150#1:494,4\n166#1:498,4\n152#1:502,4\n*E\n"})
    public static final class MyDocumentHostListener
    implements BackendDocumentHostListener {
        @Override
        public void documentBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel model2, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Logger $this$trace$iv = BackendEditorHostKt.access$getLOG$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyDocumentHostListener$documentBound: subscribe on `textControls` model");
            }
            model2.getTextControls().view(lifetime, (arg_0, arg_1, arg_2) -> MyDocumentHostListener.documentBound$lambda$1(session, model2, arg_0, arg_1, arg_2));
        }

        private static final Unit documentBound$lambda$1$2(ClientAppSession $session, RdDocumentModel $model, TextControlId $textControlId) {
            Logger $this$trace$iv = BackendEditorHostKt.access$getLOG$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[file] backendEditorLifetime terminated: textControlId=" + UtilKt.toDebugString((TextControlId)$textControlId));
            }
            DocumentsOperationModel documentsOperationModel = DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel((IProtocol)((IProtocol)RemoteSessionKt.getProtocol($session)));
            TextControlModel removed = (TextControlModel)$model.getTextControls().remove((Object)$textControlId);
            if (removed != null && $model.getTextControls().isEmpty()) {
                documentsOperationModel.getDocuments().remove((Object)$textControlId.getDocumentId());
            }
            documentsOperationModel.getHostReleasedEditor().fire((Object)$textControlId);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit documentBound$lambda$1(ClientAppSession $session, RdDocumentModel $model, Lifetime textControlModelLifetime, TextControlId textControlId, TextControlModel textControlModel) {
            Intrinsics.checkNotNullParameter((Object)textControlModelLifetime, (String)"textControlModelLifetime");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)textControlModel, (String)"textControlModel");
            Logger $this$trace$iv = BackendEditorHostKt.access$getLOG$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[file] MyDocumentHostListener$documentBound$textControls.view called");
            }
            Editor editor = Companion.getInstance($session).ensureBackendEditorCreated(textControlModelLifetime, textControlId);
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            EditorImpl editor2 = (EditorImpl)editor;
            if (Companion.synchronizerForSession((Editor)editor2, $session) != null) {
                return Unit.INSTANCE;
            }
            Disposable disposable = editor2.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            Lifetime backendEditorLifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
            Lifetime editorLifetime = RLifetimeKt.intersect((Lifetime)backendEditorLifetime, (Lifetime)textControlModelLifetime);
            AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162963");
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl = false;
                Companion.getInstance($session).attachEditorListeners(editorLifetime, (Editor)editor2, textControlId, textControlModel);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            backendEditorLifetime.onTermination(() -> MyDocumentHostListener.documentBound$lambda$1$2($session, $model, textControlId));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorHost$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "intellij.platform.backend.split"})
    public static final class MyEditorFactoryListener
    implements EditorFactoryListener {
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (ClientId.Companion.isCurrentlyUnderLocalId()) {
                return;
            }
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            EditorScrollingAccumulator.Companion.startTracking(editor);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/editors/BackendEditorHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/AppExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "Lcom/jetbrains/rd/ide/model/RequestResponseModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "parent", "model", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendEditorHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,493:1\n67#2,4:494\n*S KotlinDebug\n*F\n+ 1 BackendEditorHost.kt\ncom/jetbrains/rdserver/editors/BackendEditorHost$MyProtocolListener\n*L\n135#1:494,4\n*E\n"})
    public static final class MyProtocolListener
    implements AppExtListener<DocumentsOperationModel, RequestResponseModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel parent, @NotNull RequestResponseModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Logger $this$trace$iv = BackendEditorHostKt.access$getLOG$p();
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("[service] MyProtocolListener$extensionCreated: subscribe on `getEditorStates`");
            }
            CoroutineHelpersKt.setSuspendPreserveClientId$default((IRdEndpoint)((IRdEndpoint)model2.getGetEditorStates()), null, null, null, null, (Function3)((Function3)new Function3<Lifetime, List<? extends TextControlId>, Continuation<? super RdPatch>, Object>(session, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ ClientAppSession $session;
                {
                    this.$session = $session;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    List list = (List)this.L$0;
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void ids;
                            ResultKt.throwOnFailure((Object)$result);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ids);
                            this.label = 1;
                            Object object2 = BackendEditorHostKt.access$getEditorStates(this.$session, (List)ids, (Continuation)this);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Object invoke(Lifetime p1, List<? extends TextControlId> p2, Continuation<? super RdPatch> p3) {
                    var var4_4 = new /* invalid duplicate definition of identical inner class */;
                    var4_4.L$0 = p2;
                    return var4_4.invokeSuspend(Unit.INSTANCE);
                }
            }), (int)15, null);
        }
    }
}

