/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding.internal;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPort;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.ForwardedPortListener;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfiguration;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortConfigurationKt;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortPresentation;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.PortType;
import com.jetbrains.rd.platform.codeWithMe.portForwarding.socket.ServerSocketPortState;
import com.jetbrains.rdserver.portForwarding.internal.PortPresentationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.PerClientTcpForwardingConfigurationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.PerClientTcpReversedForwardingConfigurationImpl;
import com.jetbrains.rdserver.portForwarding.internal.configuration.UrlExposureConfigurationImpl;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 G2\u00020\u0001:\u0001GB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0015H\u0016J\u001e\u0010.\u001a\u00020*2\n\b\u0001\u0010/\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u00100\u001a\u0004\u0018\u00010\u0006J\u001e\u00101\u001a\u00020*2\n\b\u0001\u00102\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u00103\u001a\u0004\u0018\u00010\u0006J\u001a\u00104\u001a\u00020*2\b\u00105\u001a\u0004\u0018\u0001062\b\u00107\u001a\u0004\u0018\u000106J\u001e\u00108\u001a\u00020*2\n\b\u0001\u00109\u001a\u0004\u0018\u00010\u00062\n\b\u0001\u0010:\u001a\u0004\u0018\u00010\u0006J\u0012\u0010;\u001a\u00020*2\n\b\u0001\u0010<\u001a\u0004\u0018\u00010\u0006J\u000e\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020\u0006J\u000e\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020AJ\n\u0010B\u001a\u00020\u0006H\u0096\u0080\u0004J\u001c\u0010C\u001a\u00020*2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020*0EH\u0002J\u0010\u0010F\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0013\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\n \u0016*\u0004\u0018\u00010\u00190\u0019X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000e\u00a8\u0006H"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPort;", "targetPortNumber", "", "labels", "", "", "configuration", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration;", "myPresentation", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortPresentation;", "<init>", "(ILjava/util/Set;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration;Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortPresentation;)V", "getTargetPortNumber", "()I", "getLabels", "()Ljava/util/Set;", "getConfiguration", "()Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration;", "myListeners", "Lcom/intellij/util/containers/ConcurrentList;", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/ForwardedPortListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myUuid", "Ljava/util/UUID;", "getMyUuid$intellij_platform_backend_split", "()Ljava/util/UUID;", "isValid", "", "isValid$intellij_platform_backend_split", "()Z", "setValid$intellij_platform_backend_split", "(Z)V", "presentation", "getPresentation", "()Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortPresentation;", "setPresentation", "(Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortPresentation;)V", "counterpartPortNumber", "getCounterpartPortNumber", "addPortListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "nameChanged", "oldName", "newName", "descriptionChanged", "oldDescription", "newDescription", "iconChanged", "oldIcon", "Ljavax/swing/Icon;", "newIcon", "tooltipChanged", "oldTooltip", "newTooltip", "becameReadOnly", "reason", "exposedUrlChanged", "newUrl", "stateChanged", "newState", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/socket/ServerSocketPortState;", "toString", "callListeners", "action", "Lkotlin/Function1;", "getForwardToPortString", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nForwardedPortImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForwardedPortImpl.kt\ncom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,193:1\n1915#2,2:194\n13#3:196\n*S KotlinDebug\n*F\n+ 1 ForwardedPortImpl.kt\ncom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl\n*L\n162#1:194,2\n28#1:196\n*E\n"})
public final class ForwardedPortImpl
implements ForwardedPort {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int targetPortNumber;
    @NotNull
    private final Set<String> labels;
    @NotNull
    private final PortConfiguration configuration;
    @NotNull
    private final PortPresentation myPresentation;
    @NotNull
    private final ConcurrentList<ForwardedPortListener> myListeners;
    private final UUID myUuid;
    private boolean isValid;
    @NotNull
    private PortPresentation presentation;
    @NotNull
    private static final Logger logger;

    public ForwardedPortImpl(int targetPortNumber, @NotNull Set<String> labels, @NotNull PortConfiguration configuration, @NotNull PortPresentation myPresentation) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)myPresentation, (String)"myPresentation");
        this.targetPortNumber = targetPortNumber;
        this.labels = labels;
        this.configuration = configuration;
        this.myPresentation = myPresentation;
        ConcurrentList concurrentList = ContainerUtil.createConcurrentList();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentList, (String)"createConcurrentList(...)");
        this.myListeners = concurrentList;
        this.myUuid = UUID.randomUUID();
        this.isValid = true;
        this.presentation = this.myPresentation;
    }

    public /* synthetic */ ForwardedPortImpl(int n, Set set, PortConfiguration portConfiguration, PortPresentation portPresentation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            portPresentation = new PortPresentationImpl(null, null, null, null, false, null, 63, null);
        }
        this(n, set, portConfiguration, portPresentation);
    }

    public int getTargetPortNumber() {
        return this.targetPortNumber;
    }

    @NotNull
    public Set<String> getLabels() {
        return this.labels;
    }

    @NotNull
    public PortConfiguration getConfiguration() {
        return this.configuration;
    }

    public final UUID getMyUuid$intellij_platform_backend_split() {
        return this.myUuid;
    }

    public final boolean isValid$intellij_platform_backend_split() {
        return this.isValid;
    }

    public final void setValid$intellij_platform_backend_split(boolean bl) {
        this.isValid = bl;
    }

    @NotNull
    public PortPresentation getPresentation() {
        return this.presentation;
    }

    public void setPresentation(@NotNull PortPresentation portPresentation) {
        Intrinsics.checkNotNullParameter((Object)portPresentation, (String)"<set-?>");
        this.presentation = portPresentation;
    }

    public int getCounterpartPortNumber() {
        int n;
        PortConfiguration configurationToCheck = this.getConfiguration();
        PortConfiguration portConfiguration = configurationToCheck;
        if (portConfiguration instanceof PortConfiguration.PerClientTcpReversedForwarding) {
            PortConfiguration portConfiguration2 = configurationToCheck;
            if ((portConfiguration2 instanceof PerClientTcpReversedForwardingConfigurationImpl ? (PerClientTcpReversedForwardingConfigurationImpl)portConfiguration2 : null) == null) {
                throw new IllegalStateException(("Unable to get counterpart port number. Unexpected configuration type for reverse port forwarding: <" + Reflection.getOrCreateKotlinClass(configurationToCheck.getClass()).getSimpleName() + ">").toString());
            }
            n = ((PerClientTcpReversedForwardingConfigurationImpl)configurationToCheck).getAttributes().getPreferredPortNumber();
        } else if (portConfiguration instanceof PortConfiguration.PerClientTcpDirectForwarding) {
            PortConfiguration portConfiguration3 = configurationToCheck;
            if ((portConfiguration3 instanceof PerClientTcpForwardingConfigurationImpl ? (PerClientTcpForwardingConfigurationImpl)portConfiguration3 : null) == null) {
                throw new IllegalStateException(("Unable to get counterpart port number. Unexpected configuration type for direct port forwarding: <" + Reflection.getOrCreateKotlinClass(configurationToCheck.getClass()).getSimpleName() + ">").toString());
            }
            n = ((PerClientTcpForwardingConfigurationImpl)configurationToCheck).getAttributes().getPreferredPortNumber();
        } else {
            n = this.getTargetPortNumber();
        }
        return n;
    }

    public void addPortListener(@NotNull Disposable disposable, @NotNull ForwardedPortListener listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ThreadingAssertions.assertEventDispatchThread();
        ContainerUtil.add((Object)listener2, (Collection)((Collection)this.myListeners), (Disposable)disposable);
    }

    public final void nameChanged(@Nls @Nullable String oldName, @Nls @Nullable String newName) {
        this.callListeners((Function1<? super ForwardedPortListener, Unit>)((Function1)arg_0 -> ForwardedPortImpl.nameChanged$lambda$0(this, oldName, newName, arg_0)));
    }

    public final void descriptionChanged(@Nls @Nullable String oldDescription, @Nls @Nullable String newDescription) {
        this.callListeners((Function1<? super ForwardedPortListener, Unit>)((Function1)arg_0 -> ForwardedPortImpl.descriptionChanged$lambda$0(this, oldDescription, newDescription, arg_0)));
    }

    public final void iconChanged(@Nullable Icon oldIcon, @Nullable Icon newIcon) {
        this.callListeners((Function1<? super ForwardedPortListener, Unit>)((Function1)arg_0 -> ForwardedPortImpl.iconChanged$lambda$0(this, oldIcon, newIcon, arg_0)));
    }

    public final void tooltipChanged(@NlsContexts.Tooltip @Nullable String oldTooltip, @NlsContexts.Tooltip @Nullable String newTooltip) {
        this.callListeners((Function1<? super ForwardedPortListener, Unit>)((Function1)arg_0 -> ForwardedPortImpl.tooltipChanged$lambda$0(this, oldTooltip, newTooltip, arg_0)));
    }

    public final void becameReadOnly(@Nls @Nullable String reason) {
        this.callListeners((Function1<? super ForwardedPortListener, Unit>)((Function1)arg_0 -> ForwardedPortImpl.becameReadOnly$lambda$0(this, reason, arg_0)));
    }

    public final void exposedUrlChanged(@NotNull String newUrl) {
        Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
        this.callListeners((Function1<? super ForwardedPortListener, Unit>)((Function1)arg_0 -> ForwardedPortImpl.exposedUrlChanged$lambda$0(this, newUrl, arg_0)));
    }

    public final void stateChanged(@NotNull ServerSocketPortState newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.callListeners((Function1<? super ForwardedPortListener, Unit>)((Function1)arg_0 -> ForwardedPortImpl.stateChanged$lambda$0(this, newState, arg_0)));
    }

    @NotNull
    public String toString() {
        String leftPrefix = PortConfigurationKt.isPerClientReversedForwardedPort((PortConfiguration)this.getConfiguration()) ? "Local" : "Remote";
        PortConfiguration portConfiguration = this.getConfiguration();
        String rightPrefix = portConfiguration instanceof PortConfiguration.PerClientTcpReversedForwarding ? "remote" : (portConfiguration instanceof PortConfiguration.UrlExposure ? "exposed" : "local");
        String forwardToValue = this.getForwardToPortString(this.getConfiguration());
        PortConfiguration portConfiguration2 = this.getConfiguration();
        PortConfiguration.TcpForwarding tcpForwarding = portConfiguration2 instanceof PortConfiguration.TcpForwarding ? (PortConfiguration.TcpForwarding)portConfiguration2 : null;
        return "Forwarded Port: " + leftPrefix + " <" + this.getTargetPortNumber() + "> -> " + rightPrefix + " <" + forwardToValue + "> (type: " + (PortType)(tcpForwarding != null ? tcpForwarding.getType() : null) + ", labels: " + CollectionsKt.joinToString$default((Iterable)this.getLabels(), null, null, null, (int)0, null, null, (int)63, null) + ")";
    }

    private final void callListeners(Function1<? super ForwardedPortListener, Unit> action) {
        if (!this.isValid) {
            return;
        }
        Iterable $this$forEach$iv = (Iterable)this.myListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ForwardedPortListener listener2 = (ForwardedPortListener)element$iv;
            boolean bl = false;
            try {
                Intrinsics.checkNotNull((Object)listener2);
                action.invoke((Object)listener2);
            }
            catch (Throwable e) {
                logger.warn("listener " + listener2.getClass() + " failed to perform event", e);
            }
        }
    }

    private final String getForwardToPortString(PortConfiguration configuration) {
        String string;
        PortConfiguration portConfiguration = configuration;
        if (portConfiguration instanceof PortConfiguration.UrlExposure) {
            string = ((PortConfiguration.UrlExposure)configuration).getExposedUrl();
        } else if (portConfiguration instanceof PortConfiguration.PerClientTcpForwarding) {
            ServerSocketPortState serverSocketState;
            PerClientTcpForwardingConfigurationImpl exactConfiguration;
            PortConfiguration portConfiguration2 = configuration;
            PerClientTcpForwardingConfigurationImpl perClientTcpForwardingConfigurationImpl = exactConfiguration = portConfiguration2 instanceof PerClientTcpForwardingConfigurationImpl ? (PerClientTcpForwardingConfigurationImpl)portConfiguration2 : null;
            Object object = serverSocketState = perClientTcpForwardingConfigurationImpl != null ? perClientTcpForwardingConfigurationImpl.getServerSocketPortState() : null;
            string = serverSocketState instanceof ServerSocketPortState.Assigned ? String.valueOf(((ServerSocketPortState.Assigned)serverSocketState).getPort()) : (serverSocketState instanceof ServerSocketPortState.NotAssigned ? String.valueOf(exactConfiguration.getAttributes().getPreferredPortNumber()) : "");
        } else {
            string = String.valueOf(this.getTargetPortNumber());
        }
        return string;
    }

    private static final Unit nameChanged$lambda$0(ForwardedPortImpl this$0, String $oldName, String $newName, ForwardedPortListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.nameChanged((ForwardedPort)this$0, $oldName, $newName);
        return Unit.INSTANCE;
    }

    private static final Unit descriptionChanged$lambda$0(ForwardedPortImpl this$0, String $oldDescription, String $newDescription, ForwardedPortListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.descriptionChanged((ForwardedPort)this$0, $oldDescription, $newDescription);
        return Unit.INSTANCE;
    }

    private static final Unit iconChanged$lambda$0(ForwardedPortImpl this$0, Icon $oldIcon, Icon $newIcon, ForwardedPortListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.iconChanged((ForwardedPort)this$0, $oldIcon, $newIcon);
        return Unit.INSTANCE;
    }

    private static final Unit tooltipChanged$lambda$0(ForwardedPortImpl this$0, String $oldTooltip, String $newTooltip, ForwardedPortListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.tooltipChanged((ForwardedPort)this$0, $oldTooltip, $newTooltip);
        return Unit.INSTANCE;
    }

    private static final Unit becameReadOnly$lambda$0(ForwardedPortImpl this$0, String $reason, ForwardedPortListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.becameReadOnly((ForwardedPort)this$0, $reason);
        return Unit.INSTANCE;
    }

    private static final Unit exposedUrlChanged$lambda$0(ForwardedPortImpl this$0, String $newUrl, ForwardedPortListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.exposedUrlChanged((ForwardedPort)this$0, $newUrl);
        return Unit.INSTANCE;
    }

    private static final Unit stateChanged$lambda$0(ForwardedPortImpl this$0, ServerSocketPortState $newState, ForwardedPortListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.stateChanged((ForwardedPort)this$0, $newState);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ForwardedPortImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ForwardedPortImpl.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "create", "Lcom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl;", "portNumber", "", "labels", "", "", "configuration", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortConfiguration;", "presentation", "Lcom/jetbrains/rd/platform/codeWithMe/portForwarding/PortPresentation;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nForwardedPortImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForwardedPortImpl.kt\ncom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,193:1\n60#2,5:194\n*S KotlinDebug\n*F\n+ 1 ForwardedPortImpl.kt\ncom/jetbrains/rdserver/portForwarding/internal/ForwardedPortImpl$Companion\n*L\n50#1:194,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ForwardedPortImpl create(int portNumber, @NotNull Set<String> labels, @NotNull PortConfiguration configuration, @NotNull PortPresentation presentation) {
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            ForwardedPortImpl port = new ForwardedPortImpl(portNumber, labels, configuration, presentation);
            PortConfiguration portConfiguration = configuration;
            if (portConfiguration instanceof UrlExposureConfigurationImpl) {
                ((UrlExposureConfigurationImpl)configuration).setMyPort(port);
            } else if (portConfiguration instanceof PerClientTcpForwardingConfigurationImpl) {
                ((PerClientTcpForwardingConfigurationImpl)configuration).setMyPort(port);
            } else if (portConfiguration instanceof PerClientTcpReversedForwardingConfigurationImpl) {
                ((PerClientTcpReversedForwardingConfigurationImpl)configuration).setMyPort(port);
            }
            if (presentation instanceof PortPresentationImpl) {
                ((PortPresentationImpl)presentation).setMyPort(port);
            }
            Logger $this$debug_u24default$iv = logger;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Create reverse forwarded port: <" + portNumber + ">, configuration: " + configuration.getClass().getSimpleName() + ", labels: " + labels, t$iv);
            }
            return port;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

