/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeHtmlViewer;
import com.jetbrains.ide.model.uiautomation.HyperlinkEventModel;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslStyleKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdserver.ui.converters.EditorPaneConverter;
import com.jetbrains.rdserver.ui.converters.RdConverter;
import com.jetbrains.rdserver.ui.converters.TrackOptions;
import com.jetbrains.rdserver.ui.converters.utils.HyperlinkEventUtilKt;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTMLEditorKit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\"\u0010\u0010\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/ui/converters/EditorPaneConverter;", "Lcom/jetbrains/rdserver/ui/converters/RdConverter;", "Ljavax/swing/JEditorPane;", "<init>", "()V", "convert", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "component", "trackOptions", "Lcom/jetbrains/rdserver/ui/converters/TrackOptions;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "debounce", "Lkotlin/Function0;", "", "task", "addTextChangedListener", "listener", "intellij.platform.backend.split"})
public final class EditorPaneConverter
implements RdConverter<JEditorPane> {
    @Override
    @NotNull
    public BeControl convert(@NotNull JEditorPane component, @NotNull TrackOptions trackOptions, @NotNull Lifetime lifetime) {
        BeHtmlViewer beHtmlViewer;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)trackOptions, (String)"trackOptions");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        BeHtmlViewer $this$convert_u24lambda_u240 = beHtmlViewer = new BeHtmlViewer(false, null, 2, null);
        boolean bl = false;
        $this$convert_u24lambda_u240.getText().setValue((Object)component.getText());
        this.addTextChangedListener(component, lifetime, this.debounce(lifetime, (Function0<Unit>)((Function0)() -> EditorPaneConverter.convert$lambda$0$0($this$convert_u24lambda_u240, component))));
        HyperlinkEventUtilKt.handleHyperLinkClickEvents(component, lifetime, (ISignal<HyperlinkEventModel>)$this$convert_u24lambda_u240.getLinkClicked());
        EditorKit editorKit = component.getEditorKit();
        Serializable serializable = editorKit instanceof HTMLEditorKit ? (HTMLEditorKit)editorKit : null;
        if (serializable != null && (serializable = ((HTMLEditorKit)serializable).getStyleSheet()) != null) {
            Serializable styles = serializable;
            Enumeration<?> rules = ((StyleContext)styles).getStyleNames();
            List cssRules = new ArrayList();
            while (rules.hasMoreElements()) {
                Object obj = rules.nextElement();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.String");
                String name = (String)obj;
                Style rule = ((StyleContext)styles).getStyle(name);
                cssRules.add(rule.toString());
            }
            $this$convert_u24lambda_u240.getCssRules().set((Object)cssRules);
        }
        BeHtmlViewer htmlViewer = beHtmlViewer;
        if (component.isBackgroundSet() && component.getBackground() instanceof JBColor) {
            BeControl beControl = (BeControl)htmlViewer;
            Color color = component.getBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getBackground(...)");
            return BeDslStyleKt.withColor((BeControl)beControl, (Color)color);
        }
        return (BeControl)htmlViewer;
    }

    private final Function0<Unit> debounce(Lifetime lifetime, Function0<Unit> task2) {
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
        MergingUpdateQueue queue = new MergingUpdateQueue("EditorPaneConverter.debounce", 50, true, null, disposable, null, false, 96, null);
        return () -> EditorPaneConverter.debounce$lambda$0(queue, task2);
    }

    private final void addTextChangedListener(JEditorPane $this$addTextChangedListener, Lifetime lifetime, Function0<Unit> listener2) {
        if (RLifetimeKt.isNotAlive((Lifetime)lifetime)) {
            return;
        }
        DocumentAdapter documentListener2 = new DocumentAdapter(listener2){
            final /* synthetic */ Function0<Unit> $listener;
            {
                this.$listener = $listener;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.invoke();
            }
        };
        lifetime.bracketIfAlive(() -> EditorPaneConverter.addTextChangedListener$lambda$0($this$addTextChangedListener, documentListener2), () -> EditorPaneConverter.addTextChangedListener$lambda$1($this$addTextChangedListener, documentListener2));
    }

    private static final Unit convert$lambda$0$0(BeHtmlViewer $this_apply, JEditorPane $component) {
        $this_apply.getText().setValue((Object)$component.getText());
        return Unit.INSTANCE;
    }

    private static final void debounce$lambda$0$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Unit debounce$lambda$0(MergingUpdateQueue $queue, Function0 $task) {
        $queue.queue(Update.Companion.create((Object)"task", () -> EditorPaneConverter.debounce$lambda$0$0($task)));
        return Unit.INSTANCE;
    }

    private static final Unit addTextChangedListener$lambda$0(JEditorPane $this_addTextChangedListener, addTextChangedListener.documentListener.1 $documentListener) {
        $this_addTextChangedListener.getDocument().addDocumentListener((DocumentListener)((Object)$documentListener));
        return Unit.INSTANCE;
    }

    private static final Unit addTextChangedListener$lambda$1(JEditorPane $this_addTextChangedListener, addTextChangedListener.documentListener.1 $documentListener) {
        $this_addTextChangedListener.getDocument().removeDocumentListener((DocumentListener)((Object)$documentListener));
        return Unit.INSTANCE;
    }
}

