/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssMinifiedFileChecker;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.stubs.CssSelectorStub;
import com.intellij.psi.css.impl.stubs.base.CssNamedStub;
import com.intellij.psi.css.impl.stubs.base.CssStubElement;
import com.intellij.psi.css.resolve.CssInclusionContext;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssUtilCore {
    private CssUtilCore() {
    }

    public static SearchScope getUseScope(PsiFile file) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        HashSet<GlobalSearchScope> scopes = new HashSet<GlobalSearchScope>();
        Project project = file.getProject();
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)project);
        files.add(manager.getTopLevelFile((PsiElement)file).getVirtualFile());
        for (CssInclusionContext inclusionContext : CssInclusionContext.EXTENSION_POINT_NAME.getExtensionList()) {
            for (PsiFile ch : inclusionContext.getLocalUseScope(file)) {
                files.add(manager.getTopLevelFile((PsiElement)ch).getVirtualFile());
            }
            GlobalSearchScope globalUseScope = inclusionContext.getGlobalUseScope(file);
            if (globalUseScope == null) continue;
            scopes.add(globalUseScope);
        }
        if (!files.isEmpty()) {
            scopes.add(GlobalSearchScope.filesScope((Project)project, files));
        }
        return GlobalSearchScope.union(scopes);
    }

    public static int getLineNumber(@NotNull CssElement element) {
        if (element == null) {
            CssUtilCore.$$$reportNull$$$0(0);
        }
        if (CssMinifiedFileChecker.isMinifiedFile(element.getContainingFile())) {
            return -1;
        }
        PsiUtilCore.ensureValid((PsiElement)element);
        StubElement stub = element instanceof CssStubElement ? ((CssStubElement)element).getStub() : null;
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
        int textOffset = stub instanceof CssNamedStub ? ((CssNamedStub)stub).getTextOffset() : (stub instanceof CssSelectorStub ? ((CssSelectorStub)stub).getTextOffset() : element.getTextOffset());
        return document != null && textOffset < document.getTextLength() ? document.getLineNumber(textOffset) + 1 : -1;
    }

    public static boolean isSemicolonMissing(@Nullable CssOneLineStatement oneLineStatement) {
        if (oneLineStatement == null) {
            return false;
        }
        ASTNode deepestLast = PsiTreeUtil.getDeepestLast((PsiElement)oneLineStatement).getNode();
        if (deepestLast != null && deepestLast.getElementType() == CssElementTypes.CSS_SEMICOLON) {
            return false;
        }
        PsiElement nextSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)oneLineStatement);
        while (nextSibling instanceof PsiComment || nextSibling instanceof OuterLanguageElement) {
            nextSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)nextSibling);
        }
        return nextSibling == null || CssElementTypes.CSS_SEMICOLON != nextSibling.getNode().getElementType();
    }

    public static CssOneLineStatement findOneLineStatement(@Nullable PsiElement psiElement) {
        IElementType type;
        PsiElement parent;
        CssOneLineStatement oneLineStatement = (CssOneLineStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, CssOneLineStatement.class, (boolean)false);
        if (oneLineStatement != null && (parent = oneLineStatement.getParent()) != null && ((type = parent.getNode().getElementType()) == CssElementTypes.CSS_MEDIA_EXPRESSION || type == CssElementTypes.CSS_SUPPORTS || type == CssElementTypes.CSS_SUPPORTS_CONDITION || type == CssElementTypes.CSS_RULESET)) {
            return null;
        }
        return oneLineStatement;
    }

    public static CssOneLineStatement appendStatementWithSemicolonIfNeeded(@NotNull Project project, @NotNull PsiElement psiElement) {
        CssOneLineStatement oneLineStatement;
        if (project == null) {
            CssUtilCore.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            CssUtilCore.$$$reportNull$$$0(2);
        }
        if ((oneLineStatement = CssUtilCore.findOneLineStatement(psiElement)) != null && CssUtilCore.isSemicolonMissing(oneLineStatement)) {
            CssElementFactory factory = CssElementFactory.getInstance(project);
            Language language = CssPsiUtilCore.getStylesheetLanguage(psiElement);
            PsiElement semicolon = factory.createToken(";", language);
            if (oneLineStatement instanceof CssDeclaration) {
                CssOneLineStatement addAfter = oneLineStatement;
                PsiElement nextSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)oneLineStatement);
                while (nextSibling instanceof OuterLanguageElement) {
                    PsiElement outerElement = nextSibling;
                    nextSibling = PsiTreeUtil.nextVisibleLeaf((PsiElement)nextSibling);
                    if (outerElement.getParent() != oneLineStatement) {
                        addAfter = oneLineStatement.add(outerElement);
                        outerElement.delete();
                        continue;
                    }
                    addAfter = outerElement;
                }
                addAfter.getParent().addAfter(semicolon, (PsiElement)addAfter);
            } else {
                PsiElement element = oneLineStatement.add(semicolon);
                PsiElement prevSibling = element.getPrevSibling();
                if (prevSibling instanceof PsiErrorElement && CssBundle.message((String)"parsing.error.semicolon.expected", (Object[])new Object[0]).equals(((PsiErrorElement)prevSibling).getErrorDescription())) {
                    prevSibling.delete();
                }
            }
        }
        return oneLineStatement;
    }

    public static boolean isHackPropertyName(@NotNull String name) {
        if (name == null) {
            CssUtilCore.$$$reportNull$$$0(3);
        }
        return name.startsWith("*") || name.startsWith("_") || name.startsWith("#");
    }

    @Nullable
    public static CssTerm getEnclosingTerm(@Nullable PsiElement element) {
        PsiElement termList;
        if (element == null) {
            return null;
        }
        CssTerm term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class, (boolean)false);
        if (term != null && (termList = term.getParent()) != null) {
            PsiElement termList2;
            if (termList.getParent() instanceof CssDeclaration) {
                return term;
            }
            if ((term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)term, CssTerm.class, (boolean)true)) != null && (termList2 = term.getParent()) != null && termList2.getParent() instanceof CssDeclaration) {
                return term;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/impl/util/CssUtilCore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineNumber";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendStatementWithSemicolonIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isHackPropertyName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

