/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database;

import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.database.ConfigDataSourcePropertyValueSearcherKt;
import com.intellij.persistence.database.ConfigurationFileInfo;
import com.intellij.persistence.database.DbPropertySearchInfo;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH&J\u001a\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\b\b\u0002\u0010\u0013\u001a\u00020\u0005H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\rH\u0014J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00172\u0006\u0010\u0018\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/persistence/database/ConfigDataSourcePropertyValueSearcher;", "", "fileInfo", "Lcom/intellij/persistence/database/ConfigurationFileInfo;", "documentId", "", "<init>", "(Lcom/intellij/persistence/database/ConfigurationFileInfo;I)V", "getFileInfo", "()Lcom/intellij/persistence/database/ConfigurationFileInfo;", "getDocumentId", "()I", "find", "", "searchInfo", "Lcom/intellij/persistence/database/DbPropertySearchInfo;", "findDbConfigurationValue", "replacePlaceHoldersIfRequired", "configValue", "depth", "findKeyValue", "key", "splitPlaceholder", "Lkotlin/Pair;", "placeholder", "intellij.javaee.persistence"})
@SourceDebugExtension(value={"SMAP\nConfigDataSourcePropertyValueSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigDataSourcePropertyValueSearcher.kt\ncom/intellij/persistence/database/ConfigDataSourcePropertyValueSearcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1849#2,3:57\n*S KotlinDebug\n*F\n+ 1 ConfigDataSourcePropertyValueSearcher.kt\ncom/intellij/persistence/database/ConfigDataSourcePropertyValueSearcher\n*L\n24#1:57,3\n*E\n"})
public abstract class ConfigDataSourcePropertyValueSearcher {
    @NotNull
    private final ConfigurationFileInfo fileInfo;
    private final int documentId;

    public ConfigDataSourcePropertyValueSearcher(@NotNull ConfigurationFileInfo fileInfo, int documentId) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        this.fileInfo = fileInfo;
        this.documentId = documentId;
    }

    @NotNull
    public final ConfigurationFileInfo getFileInfo() {
        return this.fileInfo;
    }

    public final int getDocumentId() {
        return this.documentId;
    }

    @Nullable
    public final String find(@NotNull DbPropertySearchInfo searchInfo) {
        Intrinsics.checkNotNullParameter((Object)searchInfo, (String)"searchInfo");
        String originalValue = this.findDbConfigurationValue(searchInfo);
        CharSequence charSequence = originalValue;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return ConfigDataSourcePropertyValueSearcher.replacePlaceHoldersIfRequired$default(this, originalValue, 0, 2, null);
    }

    @Nullable
    public abstract String findDbConfigurationValue(@NotNull DbPropertySearchInfo var1);

    /*
     * WARNING - void declaration
     */
    private final String replacePlaceHoldersIfRequired(String configValue, int depth) {
        void $this$fold$iv;
        Set<TextRange> ranges = ConfigDataSourcePropertyValueSearcherKt.getDbPropertyPlaceholders(configValue);
        if (ranges.isEmpty() || depth >= 10) {
            return configValue;
        }
        Iterable iterable = ranges;
        String initial$iv = configValue;
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            String placeholder;
            void range;
            TextRange textRange = (TextRange)element$iv;
            String replacedValue = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)configValue.substring(range.getStartOffset(), range.getEndOffset()), (String)"substring(...)");
            Pair<String, String> pair = this.splitPlaceholder(placeholder);
            String configKey = (String)pair.component1();
            String string = (String)pair.component2();
            String valueText = ((CharSequence)configKey).length() > 0 ? this.findKeyValue(configKey) : null;
            String placeholderValue = "${" + placeholder + "}";
            CharSequence charSequence = valueText;
            accumulator$iv = !(charSequence == null || charSequence.length() == 0) ? StringsKt.replace$default((String)replacedValue, (String)placeholderValue, (String)this.replacePlaceHoldersIfRequired(valueText, depth + 1), (boolean)false, (int)4, null) : (string != null ? StringsKt.replace$default((String)replacedValue, (String)placeholderValue, (String)string, (boolean)false, (int)4, null) : replacedValue);
        }
        return accumulator$iv;
    }

    static /* synthetic */ String replacePlaceHoldersIfRequired$default(ConfigDataSourcePropertyValueSearcher configDataSourcePropertyValueSearcher, String string, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: replacePlaceHoldersIfRequired");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return configDataSourcePropertyValueSearcher.replacePlaceHoldersIfRequired(string, n);
    }

    @Nullable
    protected String findKeyValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.findDbConfigurationValue(new DbPropertySearchInfo(key));
    }

    private final Pair<String, String> splitPlaceholder(String placeholder) {
        if (!StringsKt.contains$default((CharSequence)placeholder, (CharSequence)":", (boolean)false, (int)2, null)) {
            return TuplesKt.to((Object)placeholder, null);
        }
        return TuplesKt.to((Object)StringsKt.substringBefore$default((String)placeholder, (String)":", null, (int)2, null), (Object)StringsKt.substringAfter$default((String)placeholder, (String)":", null, (int)2, null));
    }
}

