/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database.config.impl.urlParser;

import com.intellij.persistence.database.config.impl.urlParser.DatabaseUrl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\rJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J<\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0083\u0004J\n\u0010\u001d\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u001e\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/persistence/database/config/impl/urlParser/OracleServiceUrl;", "Lcom/intellij/persistence/database/config/impl/urlParser/DatabaseUrl;", "host", "", "port", "", "service", "sid", "<init>", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "getPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getService", "getSid", "toDbDialogUrl", "dataSourceItemName", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Lcom/intellij/persistence/database/config/impl/urlParser/OracleServiceUrl;", "equals", "", "other", "", "hashCode", "toString", "intellij.javaee.persistence.impl"})
@SourceDebugExtension(value={"SMAP\nOracleUrlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OracleUrlParser.kt\ncom/intellij/persistence/database/config/impl/urlParser/OracleServiceUrl\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n34#2:68\n34#2:69\n34#2:70\n1#3:71\n*S KotlinDebug\n*F\n+ 1 OracleUrlParser.kt\ncom/intellij/persistence/database/config/impl/urlParser/OracleServiceUrl\n*L\n55#1:68\n56#1:69\n59#1:70\n*E\n"})
final class OracleServiceUrl
extends DatabaseUrl {
    @NotNull
    private final String host;
    @Nullable
    private final Integer port;
    @Nullable
    private final String service;
    @Nullable
    private final String sid;

    public OracleServiceUrl(@NotNull String host, @Nullable Integer port, @Nullable String service, @Nullable String sid) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        this.port = port;
        this.service = service;
        this.sid = sid;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @Nullable
    public final String getService() {
        return this.service;
    }

    @Nullable
    public final String getSid() {
        return this.sid;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String toDbDialogUrl() {
        String string;
        if (this.sid == null) {
            String string2;
            String string3;
            void $this$applyIf$iv;
            String string4 = "jdbc:oracle:thin:@//" + this.host;
            boolean condition$iv = this.port != null;
            boolean $i$f$applyIf = false;
            if (condition$iv) {
                void $this$toDbDialogUrl_u24lambda_u240 = $this$applyIf$iv;
                boolean bl = false;
                string3 = (String)$this$toDbDialogUrl_u24lambda_u240 + ":" + this.port;
            } else {
                string3 = $this$applyIf$iv;
            }
            $this$applyIf$iv = string3;
            condition$iv = this.service != null;
            $i$f$applyIf = false;
            if (condition$iv) {
                void $this$toDbDialogUrl_u24lambda_u241 = $this$applyIf$iv;
                boolean bl = false;
                String string5 = this.service;
                Intrinsics.checkNotNull((Object)string5);
                string2 = (String)$this$toDbDialogUrl_u24lambda_u241 + "/" + StringsKt.removePrefix((String)string5, (CharSequence)"/");
            } else {
                string2 = $this$applyIf$iv;
            }
            return string2;
        }
        String $this$applyIf$iv = "jdbc:oracle:thin:@" + this.host;
        boolean condition$iv = this.port != null;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            String $this$toDbDialogUrl_u24lambda_u242 = $this$applyIf$iv;
            boolean bl = false;
            string = $this$toDbDialogUrl_u24lambda_u242 + ":" + this.port;
        } else {
            void var1_2;
            string = var1_2;
        }
        void it = string;
        boolean bl = false;
        return (String)it + ":" + this.sid;
    }

    @Override
    @NotNull
    public String dataSourceItemName() {
        Object object;
        block5: {
            block4: {
                Object object2 = this.sid;
                if (object2 == null) {
                    object2 = object = this.service;
                }
                if (object2 == null) break block4;
                String it = object;
                boolean bl = false;
                String string = it + "@" + this.host;
                object = string;
                if (string != null) break block5;
            }
            object = "oracle-service";
        }
        return object;
    }

    @NotNull
    public final String component1() {
        return this.host;
    }

    @Nullable
    public final Integer component2() {
        return this.port;
    }

    @Nullable
    public final String component3() {
        return this.service;
    }

    @Nullable
    public final String component4() {
        return this.sid;
    }

    @NotNull
    public final OracleServiceUrl copy(@NotNull String host, @Nullable Integer port, @Nullable String service, @Nullable String sid) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return new OracleServiceUrl(host, port, service, sid);
    }

    public static /* synthetic */ OracleServiceUrl copy$default(OracleServiceUrl oracleServiceUrl, String string, Integer n, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = oracleServiceUrl.host;
        }
        if ((n2 & 2) != 0) {
            n = oracleServiceUrl.port;
        }
        if ((n2 & 4) != 0) {
            string2 = oracleServiceUrl.service;
        }
        if ((n2 & 8) != 0) {
            string3 = oracleServiceUrl.sid;
        }
        return oracleServiceUrl.copy(string, n, string2, string3);
    }

    @NotNull
    public String toString() {
        return "OracleServiceUrl(host=" + this.host + ", port=" + this.port + ", service=" + this.service + ", sid=" + this.sid + ")";
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = result * 31 + (this.port == null ? 0 : ((Object)this.port).hashCode());
        result = result * 31 + (this.service == null ? 0 : this.service.hashCode());
        result = result * 31 + (this.sid == null ? 0 : this.sid.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OracleServiceUrl)) {
            return false;
        }
        OracleServiceUrl oracleServiceUrl = (OracleServiceUrl)other;
        if (!Intrinsics.areEqual((Object)this.host, (Object)oracleServiceUrl.host)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)oracleServiceUrl.port)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.service, (Object)oracleServiceUrl.service)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sid, (Object)oracleServiceUrl.sid);
    }
}

