/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.jpa.engine.JakartaConsoleRunContext;
import com.intellij.jpa.engine.JakartaEelCoroutineService;
import com.intellij.jpa.jakarta.remote.JakartaFacade;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelTunnelsApi;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.IjentTunnelsUtil;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0006\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0002H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/jpa/engine/JakartaRemoteConsoleProcessSupport;", "Lcom/intellij/database/console/RemoteConsoleProcessSupport;", "Lcom/intellij/persistence/model/PersistencePackagePointer;", "Lcom/intellij/jpa/jakarta/remote/JakartaFacade;", "project", "Lcom/intellij/openapi/project/Project;", "fireModificationCountChanged", "Ljava/lang/Runnable;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Runnable;)V", "eel", "Lcom/intellij/platform/eel/EelApi;", "", "createRunContext", "Lcom/intellij/database/run/ConsoleRunConfiguration$RunContext;", "target", "getName", "", "file", "publishPort", "", "port", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nJakartaRemoteConsoleProcessSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JakartaRemoteConsoleProcessSupport.kt\ncom/intellij/jpa/engine/JakartaRemoteConsoleProcessSupport\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,45:1\n30#2,2:46\n*S KotlinDebug\n*F\n+ 1 JakartaRemoteConsoleProcessSupport.kt\ncom/intellij/jpa/engine/JakartaRemoteConsoleProcessSupport\n*L\n38#1:46,2\n*E\n"})
public final class JakartaRemoteConsoleProcessSupport
extends RemoteConsoleProcessSupport<PersistencePackagePointer, JakartaFacade> {
    @NotNull
    private final Project project;
    @NotNull
    private final Runnable fireModificationCountChanged;
    @NotNull
    private final EelApi eel;

    public JakartaRemoteConsoleProcessSupport(@NotNull Project project, @NotNull Runnable fireModificationCountChanged) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fireModificationCountChanged, (String)"fireModificationCountChanged");
        super(JakartaFacade.class);
        this.project = project;
        this.fireModificationCountChanged = fireModificationCountChanged;
        this.eel = EelProviderUtil.toEelApiBlocking((EelDescriptor)EelProviderUtil.getEelDescriptor((Project)this.project));
    }

    protected void fireModificationCountChanged() {
        this.fireModificationCountChanged.run();
    }

    @NotNull
    protected ConsoleRunConfiguration.RunContext createRunContext(@NotNull PersistencePackagePointer target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new JakartaConsoleRunContext(target);
    }

    @Nullable
    protected String getName(@NotNull PersistencePackagePointer file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.getElementName();
    }

    protected int publishPort(int port, @NotNull PersistencePackagePointer target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Project project = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (EelProviderUtil.getEelDescriptor((Project)project) instanceof LocalEelDescriptor) {
            return super.publishPort(port, (Object)target);
        }
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<JakartaEelCoroutineService> serviceClass$iv = JakartaEelCoroutineService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        CoroutineScope coroutineScope = ((JakartaEelCoroutineService)object).getCoroutineScope();
        EelTunnelsApi eelTunnelsApi = this.eel.getTunnels();
        EelTunnelsApi.HostAddress.Builder builder = EelTunnelsApi.HostAddress.Companion.Builder-xj2QHRw(UShort.constructor-impl((short)((short)port)));
        String string = this.getRemoteHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRemoteHost(...)");
        IjentTunnelsUtil.forwardLocalPort((CoroutineScope)coroutineScope, (EelTunnelsApi)eelTunnelsApi, (int)port, (EelTunnelsApi.HostAddress)builder.hostname(string).build());
        return port;
    }
}

