/*
 * Decompiled with CFR 0.152.
 */
package ai.koog.prompt.text;

import ai.koog.prompt.dsl.PromptDSL;
import ai.koog.prompt.text.TextContentBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PromptDSL
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0086\u0002J\r\u0010\u0011\u001a\u00020\u000f*\u00020\u0010H\u0096\u0002J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0010J'\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00102\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000f0\u0016\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ\u0006\u0010\u001a\u001a\u00020\u000fJ\r\u0010\u001b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001cR\u0018\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lai/koog/prompt/text/TextContentBuilderBase;", "TContent", "", "<init>", "()V", "textBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTextBuilder", "()Ljava/lang/StringBuilder;", "caret", "Lai/koog/prompt/text/TextContentBuilderBase$Caret;", "getCaret", "()Lai/koog/prompt/text/TextContentBuilderBase$Caret;", "not", "", "", "unaryPlus", "text", "textWithNewLine", "padding", "body", "Lkotlin/Function1;", "Lai/koog/prompt/text/TextContentBuilder;", "Lkotlin/ExtensionFunctionType;", "newline", "br", "build", "()Ljava/lang/Object;", "Caret", "prompt-model"})
public abstract class TextContentBuilderBase<TContent> {
    @NotNull
    private final StringBuilder textBuilder = new StringBuilder();

    @NotNull
    protected final StringBuilder getTextBuilder() {
        return this.textBuilder;
    }

    @NotNull
    public final Caret getCaret() {
        String string = (String)CollectionsKt.lastOrNull((List)StringsKt.lines((CharSequence)this.textBuilder));
        return new Caret(StringsKt.lines((CharSequence)this.textBuilder).size(), string != null ? string.length() : 0);
    }

    public final void not(@NotNull String $this$not) {
        Intrinsics.checkNotNullParameter((Object)$this$not, (String)"<this>");
        this.text($this$not);
    }

    public void unaryPlus(@NotNull String $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        this.textWithNewLine($this$unaryPlus);
    }

    public final void text(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.textBuilder.append(text);
    }

    public final void textWithNewLine(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.getCaret().getOffset() > 0) {
            this.newline();
        }
        this.text(text);
    }

    public final void padding(@NotNull String padding, @NotNull Function1<? super TextContentBuilder, Unit> body) {
        Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        TextContentBuilder textContentBuilder = new TextContentBuilder();
        body.invoke((Object)textContentBuilder);
        String content = textContentBuilder.build();
        for (String line : StringsKt.lines((CharSequence)content)) {
            this.unaryPlus(padding + line);
        }
    }

    public final void newline() {
        this.textBuilder.append("\n");
    }

    public final void br() {
        this.newline();
        this.newline();
    }

    public abstract TContent build();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lai/koog/prompt/text/TextContentBuilderBase$Caret;", "", "line", "", "offset", "<init>", "(II)V", "getLine", "()I", "getOffset", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "prompt-model"})
    public static final class Caret {
        private final int line;
        private final int offset;

        public Caret(int line, int offset) {
            this.line = line;
            this.offset = offset;
        }

        public final int getLine() {
            return this.line;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int component1() {
            return this.line;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final Caret copy(int line, int offset) {
            return new Caret(line, offset);
        }

        public static /* synthetic */ Caret copy$default(Caret caret, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = caret.line;
            }
            if ((n3 & 2) != 0) {
                n2 = caret.offset;
            }
            return caret.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Caret(line=" + this.line + ", offset=" + this.offset + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.line);
            result2 = result2 * 31 + Integer.hashCode(this.offset);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Caret)) {
                return false;
            }
            Caret caret = (Caret)other;
            if (this.line != caret.line) {
                return false;
            }
            return this.offset == caret.offset;
        }
    }
}

