/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.cli.CliComponent;
import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliPanelDecorator;
import com.intellij.database.cli.CliProperties;
import com.intellij.database.cli.CliRunTarget;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.component.CliPathTextFieldWithBrowseButton;
import com.intellij.database.cli.lexer.DbCliTokenType;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbUIUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.matching.MatchingMode;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliModel
implements Disposable {
    private static final int INSET = 10;
    private final LocalDataSource myDataSource;
    private final List<CliComponent> myComponents;
    private final CliConfiguration myConfiguration;
    private final CliPanelDecorator myPanelDecorator;
    private final CliPathTextFieldWithBrowseButton myExecutableField;
    private final TextFieldWithAutoCompletion<String> myArgumentsField;
    private final HideableTitledPanel myPanel;
    private final CliProperties myProperties;
    private List<String> myParameterizable;
    private boolean myBusy;

    public CliModel(@NotNull Project project, @NotNull Collection<DbElement> elements, @NotNull CliConfiguration configuration, @Nullable LocalDataSource dataSource) {
        if (project == null) {
            CliModel.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            CliModel.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            CliModel.$$$reportNull$$$0(2);
        }
        this.myDataSource = dataSource;
        this.myConfiguration = configuration;
        this.myComponents = configuration.createComponents(this);
        this.myProperties = new CliProperties(configuration, this);
        Disposer.register((Disposable)this, (Disposable)this.myProperties);
        this.myPanel = new HideableTitledPanel(DatabaseBundle.message((String)"database.cli.integration.options.panel.title", (Object[])new Object[0]));
        this.myPanel.setOn(true);
        this.myParameterizable = ContainerUtil.emptyList();
        this.myArgumentsField = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)new MyCompletionProvider(configuration.getInfoMap()), true, null);
        this.myArgumentsField.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBUI.insets((int)10, (int)0, (int)0, (int)0)));
        this.myExecutableField = new CliPathTextFieldWithBrowseButton(this, target -> target.createExecutableFileChooserDescriptor());
        this.myPanelDecorator = new CliPanelDecorator((JComponent)((Object)this.myExecutableField), this.myComponents, project);
        this.setPathToExecutable(this.myConfiguration.getDefaultSearchPath() == null ? "" : this.myConfiguration.getDefaultSearchPath());
        this.configureComponents();
        this.myProperties.restore();
        this.myArgumentsField.setText(configuration.sanitizeArguments(elements, this.myArgumentsField.getText()));
        List<CliLexeme> lexemes = DbCliUtil.filteredLexemes(this.myArgumentsField.getText(), this.myConfiguration.getParameterizableArguments());
        CliContextDescriptor state = new CliContextDescriptor(lexemes, CliContextDescriptor.Operation.UNKNOWN);
        ArrayList configured = new ArrayList();
        this.runProtected(() -> this.myComponents.stream().filter(component -> component.configure(elements, state)).forEach(configured::add));
        this.runProtected(() -> this.componentsChanged((CliComponent[])ContainerUtil.toArray((Collection)configured, CliComponent[]::new)));
        Disposer.register((Disposable)this, (Disposable)this.myPanelDecorator);
        this.myProperties.restoreRunTarget();
        this.myComponents.forEach(component -> component.initialize(this.myPanelDecorator));
        this.myExecutableField.updateFileDescriptor();
        this.myPanelDecorator.addRunTargetChangeListener(() -> this.myExecutableField.updateFileDescriptor());
    }

    public void store() {
        this.myProperties.store();
    }

    @NotNull
    public JComponent getComponent() {
        JComponent settingsPanel = this.myPanelDecorator.getComponent();
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)settingsPanel, "North");
        panel2.add((Component)this.myArgumentsField, "Center");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            CliModel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    public CliContextDescriptor getContext() {
        return new CliContextDescriptor(DbCliUtil.filteredLexemes(this.myArgumentsField.getText(), this.myParameterizable), CliContextDescriptor.Operation.UNKNOWN);
    }

    public boolean isExpanded() {
        return this.myPanel.isExpanded();
    }

    public void setExpanded(boolean expanded) {
        if (this.myPanel.isExpanded() != expanded) {
            this.myPanel.setOn(expanded);
        }
    }

    public void restoreRunTarget(@NotNull String providerId, @NotNull PropertiesComponent properties2, @NotNull String keyPrefix) {
        if (providerId == null) {
            CliModel.$$$reportNull$$$0(4);
        }
        if (properties2 == null) {
            CliModel.$$$reportNull$$$0(5);
        }
        if (keyPrefix == null) {
            CliModel.$$$reportNull$$$0(6);
        }
        this.myPanelDecorator.setRunTargetInfo(providerId, properties2, keyPrefix);
    }

    @NotNull
    public String getCommand() {
        String string = this.myArgumentsField.getText();
        if (string == null) {
            CliModel.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public CliConfiguration getConfiguration() {
        CliConfiguration cliConfiguration = this.myConfiguration;
        if (cliConfiguration == null) {
            CliModel.$$$reportNull$$$0(8);
        }
        return cliConfiguration;
    }

    @NotNull
    public List<CliComponent> getCliComponents() {
        List<CliComponent> list = this.myComponents;
        if (list == null) {
            CliModel.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public String getPathToExecutable() {
        String string = StringUtil.trim((String)this.myExecutableField.getText());
        if (string == null) {
            CliModel.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setPathToExecutable(@NotNull String path) {
        if (path == null) {
            CliModel.$$$reportNull$$$0(11);
        }
        this.myExecutableField.setText(path);
        this.myProperties.storeVariants();
    }

    public void setCommand(@NotNull String command) {
        if (command == null) {
            CliModel.$$$reportNull$$$0(12);
        }
        this.myArgumentsField.setText(command);
    }

    public void setVariants(@NotNull List<String> variants) {
        if (variants == null) {
            CliModel.$$$reportNull$$$0(13);
        }
        List<String> tweaked = this.myConfiguration.tweakAutocompletion(variants);
        this.myParameterizable = JBIterable.from(tweaked).filter(s -> s.endsWith("=")).transform(s -> s.substring(0, s.length() - 1)).append(this.myConfiguration.getParameterizableArguments()).toList();
        this.myArgumentsField.setVariants(tweaked);
    }

    @NotNull
    public List<String> getParameterizable() {
        List<String> list = this.myParameterizable;
        if (list == null) {
            CliModel.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public JComponent getPreferredFocusableComponent() {
        CliPathTextFieldWithBrowseButton cliPathTextFieldWithBrowseButton = this.myExecutableField;
        if (cliPathTextFieldWithBrowseButton == null) {
            CliModel.$$$reportNull$$$0(15);
        }
        return cliPathTextFieldWithBrowseButton;
    }

    @NotNull
    public JComponent getCommandComponent() {
        JComponent jComponent = this.myArgumentsField.getFocusTarget();
        if (jComponent == null) {
            CliModel.$$$reportNull$$$0(16);
        }
        return jComponent;
    }

    @NotNull
    public String getExecutableCommand() {
        String string = DbCliUtil.quote(this.getPathToExecutable()) + " " + this.getCommand();
        if (string == null) {
            CliModel.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public LocalDataSource getDataSource() {
        return this.myDataSource;
    }

    @NotNull
    public CliRunTarget getRunTarget() {
        CliRunTarget cliRunTarget = this.myPanelDecorator.getRunTarget();
        if (cliRunTarget == null) {
            CliModel.$$$reportNull$$$0(18);
        }
        return cliRunTarget;
    }

    private void configureComponents() {
        Consumer consumer = source -> this.runProtected(() -> {
            this.componentChanged((CliComponent)source);
            DbUIUtil.invokeLater(() -> this.updateFromText((CliComponent)source));
        });
        this.myComponents.forEach(component -> component.addListener((Consumer<CliComponent>)consumer));
        this.myExecutableField.getTextField().getDocument().addDocumentListener((javax.swing.event.DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull javax.swing.event.DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CliModel.this.myProperties.storeVariants();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/cli/CliModel$1", "textChanged"));
            }
        });
        this.myArgumentsField.setFontInheritedFromLAF(false);
        this.myArgumentsField.addSettingsProvider(editor2 -> {
            editor2.setEmbeddedIntoDialogWrapper(true);
            editor2.getSettings().setWheelFontChangeEnabled(true);
            editor2.setHorizontalScrollbarVisible(true);
            editor2.setVerticalScrollbarVisible(true);
            editor2.getSettings().setUseSoftWraps(true);
            editor2.setOneLineMode(false);
        });
        this.myArgumentsField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CliModel.this.runProtected(CliModel.this::stateChanged);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/cli/CliModel$2", "documentChanged"));
            }
        });
    }

    private void updateFromText(@NotNull CliComponent source) {
        if (source == null) {
            CliModel.$$$reportNull$$$0(19);
        }
        this.runProtected(() -> {
            this.clearWhitespaces();
            this.stateChanged(source);
        });
    }

    private void clearWhitespaces() {
        this.myArgumentsField.setText(CliModel.clearWhitespaces(this.myArgumentsField.getText()));
    }

    @NotNull
    private static String clearWhitespaces(@NotNull String s) {
        if (s == null) {
            CliModel.$$$reportNull$$$0(20);
        }
        List<CliLexeme> lexemes = DbCliUtil.rawLexemes(s);
        ArrayList<CliLexeme> filtered = new ArrayList<CliLexeme>();
        boolean delimited = false;
        for (CliLexeme lexeme : lexemes) {
            if (delimited && lexeme.isWhitespaceOrBad()) continue;
            delimited = lexeme.isWhitespaceOrBad();
            filtered.add(lexeme);
        }
        String string = StringUtil.join(filtered, CliLexeme::getText, (String)"");
        if (string == null) {
            CliModel.$$$reportNull$$$0(21);
        }
        return string;
    }

    private void stateChanged() {
        this.stateChanged(null);
    }

    private void stateChanged(@Nullable CliComponent exclude) {
        String text = this.myArgumentsField.getText();
        List<CliLexeme> lexemes = DbCliUtil.filteredLexemes(text, this.myParameterizable);
        CliContextDescriptor state = new CliContextDescriptor(lexemes, CliContextDescriptor.Operation.TEXT_CHANGED);
        for (CliComponent component : this.myComponents) {
            if (component == exclude || CliModel.processComponent(component, state, text, lexemes)) continue;
            component.reset(state);
        }
    }

    private static boolean processComponent(@NotNull CliComponent component, @NotNull CliContextDescriptor state, @NotNull String text, @NotNull List<CliLexeme> lexemes) {
        if (component == null) {
            CliModel.$$$reportNull$$$0(22);
        }
        if (state == null) {
            CliModel.$$$reportNull$$$0(23);
        }
        if (text == null) {
            CliModel.$$$reportNull$$$0(24);
        }
        if (lexemes == null) {
            CliModel.$$$reportNull$$$0(25);
        }
        Ref changed = Ref.create((Object)false);
        DbCliUtil.iterateOverLexemes(text, lexemes, (cur, next) -> {
            if (!component.isMyLexeme(text, cur, next, state)) {
                return;
            }
            component.changeState(text, cur, next, state);
            changed.set((Object)true);
        });
        return (Boolean)changed.get();
    }

    private void componentChanged(@NotNull CliComponent component) {
        if (component == null) {
            CliModel.$$$reportNull$$$0(26);
        }
        this.componentsChanged(component);
    }

    private void componentsChanged(CliComponent ... components) {
        if (components == null) {
            CliModel.$$$reportNull$$$0(27);
        }
        String text = StringUtil.trim((String)this.myArgumentsField.getText());
        this.myArgumentsField.setText(CliModel.clearWhitespaces(this.changeCommand(text, components)));
    }

    @NotNull
    private String changeCommand(@NotNull String text, CliComponent ... sources) {
        if (text == null) {
            CliModel.$$$reportNull$$$0(28);
        }
        if (sources == null) {
            CliModel.$$$reportNull$$$0(29);
        }
        ArrayList<CliLexeme> rawLexemes = new ArrayList<CliLexeme>(DbCliUtil.rawLexemes(text));
        List<CliLexeme> lexemes = DbCliUtil.filterLexemes(rawLexemes, this.myParameterizable);
        CliContextDescriptor cd = new CliContextDescriptor(lexemes, CliContextDescriptor.Operation.COMPONENT_CHANGED);
        LinkedHashMap<CliComponent, List<Pair<CliLexeme, CliLexeme>>> map2 = new LinkedHashMap<CliComponent, List<Pair<CliLexeme, CliLexeme>>>();
        for (CliComponent component : sources) {
            map2.put(component, DbCliUtil.lexemePairs(cd, lexemes, text, component));
        }
        for (CliComponent component : map2.keySet()) {
            List pairs = (List)map2.get(component);
            if (pairs.isEmpty()) {
                rawLexemes.add(DbCliUtil.createLexeme(component, cd));
                continue;
            }
            int min = Integer.MAX_VALUE;
            for (Pair pair : pairs) {
                int idx = CliModel.removeAllBetween(rawLexemes, (Pair<CliLexeme, CliLexeme>)pair);
                min = Math.min(idx, min);
            }
            CliModel.insertArgument(rawLexemes, cd, component, min);
        }
        String string = StringUtil.join(rawLexemes, CliLexeme::getText, (String)"");
        if (string == null) {
            CliModel.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static int removeAllBetween(@NotNull List<CliLexeme> lexemes, @NotNull Pair<CliLexeme, CliLexeme> pair) {
        if (lexemes == null) {
            CliModel.$$$reportNull$$$0(31);
        }
        if (pair == null) {
            CliModel.$$$reportNull$$$0(32);
        }
        int start = ((CliLexeme)pair.getFirst()).getStart();
        int end = ((CliLexeme)pair.getSecond()).getStart();
        Iterator<CliLexeme> iterator = lexemes.iterator();
        int idx = -1;
        while (iterator.hasNext()) {
            CliLexeme next = iterator.next();
            int nextStart = next.getStart();
            if (next.getType() == DbCliTokenType.SYNTHETIC || nextStart < start || nextStart >= end) continue;
            if (idx == -1) {
                idx = lexemes.indexOf(next);
            }
            iterator.remove();
        }
        return idx;
    }

    private void runProtected(@NotNull Runnable runnable) {
        if (runnable == null) {
            CliModel.$$$reportNull$$$0(33);
        }
        if (this.myBusy) {
            return;
        }
        try {
            this.myBusy = true;
            runnable.run();
        }
        finally {
            this.myBusy = false;
        }
    }

    public void dispose() {
    }

    private static void insertArgument(@NotNull List<CliLexeme> lexemes, @NotNull CliContextDescriptor cd, @NotNull CliComponent source, int idx) {
        if (lexemes == null) {
            CliModel.$$$reportNull$$$0(34);
        }
        if (cd == null) {
            CliModel.$$$reportNull$$$0(35);
        }
        if (source == null) {
            CliModel.$$$reportNull$$$0(36);
        }
        if (source.isAppendInTheEnd(cd) || idx == -1 || idx >= lexemes.size()) {
            lexemes.add(DbCliUtil.createLexeme(source, cd));
            return;
        }
        lexemes.add(idx, DbCliUtil.createLexeme(source, cd, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 9, 10, 14, 15, 16, 17, 18, 21, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPrefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 19: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 25: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexemes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCliComponents";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToExecutable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterizable";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusableComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandComponent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutableCommand";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunTarget";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "clearWhitespaces";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "changeCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 30: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "restoreRunTarget";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setPathToExecutable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCommand";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setVariants";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateFromText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "clearWhitespaces";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processComponent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "componentChanged";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "componentsChanged";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "changeCommand";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeAllBetween";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "runProtected";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "insertArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 9, 10, 14, 15, 16, 17, 18, 21, 30 -> new IllegalStateException(string);
        };
    }

    private static class MyCompletionProvider
    extends TextFieldWithAutoCompletion.StringsCompletionProvider {
        private final Map<String, String> myInfoMap;

        MyCompletionProvider(@NotNull Map<String, String> infoMap) {
            if (infoMap == null) {
                MyCompletionProvider.$$$reportNull$$$0(0);
            }
            super((Collection)ContainerUtil.emptyList(), null);
            this.myInfoMap = infoMap;
        }

        @Nullable
        protected String getTypeText(@NotNull String item) {
            if (item == null) {
                MyCompletionProvider.$$$reportNull$$$0(1);
            }
            return this.myInfoMap.get(item);
        }

        @Nullable
        public PrefixMatcher createPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                MyCompletionProvider.$$$reportNull$$$0(2);
            }
            return new MyPrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "infoMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/cli/CliModel$MyCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTypeText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createPrefixMatcher";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPrefixMatcher
    extends PlainPrefixMatcher {
        private final MinusculeMatcher myMatcher;

        protected MyPrefixMatcher(String prefix) {
            super(prefix);
            this.myMatcher = NameUtil.buildMatcher((String)prefix, (MatchingMode)MatchingMode.IGNORE_CASE);
        }

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                MyPrefixMatcher.$$$reportNull$$$0(0);
            }
            return super.prefixMatches(name) || this.myMatcher.matches(name);
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                MyPrefixMatcher.$$$reportNull$$$0(1);
            }
            return new MyPrefixMatcher(prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/cli/CliModel$MyPrefixMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prefixMatches";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "cloneWithPrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

