/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.GrantData;
import com.intellij.database.schemaEditor.StateKey;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.ui.BaseRenderer;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.GrantsColumnInfo;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.update.UiNotifyConnector;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.BitSet;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00010\u0003:\u0004\"#$%B\u0017\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\b\u0010\u0014\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\f0\u000bR\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006&"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo;", "D", "Lcom/intellij/database/schemaEditor/GrantData;", "Lcom/intellij/util/ui/ColumnInfo;", "grantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "<init>", "(Lcom/intellij/database/model/properties/Grants$Controller;)V", "myRenderer", "Ljavax/swing/table/TableCellRenderer;", "myEditor", "Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor;", "getMyEditor", "()Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor;", "valueOf", "o", "(Lcom/intellij/database/schemaEditor/GrantData;)Lcom/intellij/database/schemaEditor/GrantData;", "setValue", "", "user", "value", "(Lcom/intellij/database/schemaEditor/GrantData;Lcom/intellij/database/schemaEditor/GrantData;)V", "getRenderer", "(Lcom/intellij/database/schemaEditor/GrantData;)Ljavax/swing/table/TableCellRenderer;", "isCellEditable", "", "(Lcom/intellij/database/schemaEditor/GrantData;)Z", "getEditor", "Ljavax/swing/table/TableCellEditor;", "(Lcom/intellij/database/schemaEditor/GrantData;)Ljavax/swing/table/TableCellEditor;", "getColName", "", "idx", "", "GrantsRenderer", "PermData", "ColumnPermData", "GrantsEditor", "intellij.database.impl"})
public class GrantsColumnInfo<D extends GrantData>
extends ColumnInfo<D, D> {
    @NotNull
    private final TableCellRenderer myRenderer;
    @NotNull
    private final GrantsEditor myEditor;

    public GrantsColumnInfo(@NotNull Grants.Controller<?, ?> grantCtl) {
        Intrinsics.checkNotNullParameter(grantCtl, (String)"grantCtl");
        super("");
        this.myRenderer = new GrantsRenderer();
        this.myEditor = new GrantsEditor(grantCtl);
    }

    @NotNull
    public final GrantsEditor getMyEditor() {
        return this.myEditor;
    }

    @NotNull
    public D valueOf(@NotNull D o) {
        Intrinsics.checkNotNullParameter(o, (String)"o");
        return o;
    }

    public void setValue(@NotNull D user, @Nullable D value) {
        Intrinsics.checkNotNullParameter(user, (String)"user");
        user.getGrants().clear();
        if (value != null) {
            user.getGrants().putAll(value.getGrants());
        }
    }

    @NotNull
    public TableCellRenderer getRenderer(@NotNull D user) {
        Intrinsics.checkNotNullParameter(user, (String)"user");
        return this.myRenderer;
    }

    public boolean isCellEditable(@NotNull D user) {
        Intrinsics.checkNotNullParameter(user, (String)"user");
        return true;
    }

    @NotNull
    public TableCellEditor getEditor(@Nullable D user) {
        return (TableCellEditor)((Object)this.myEditor);
    }

    private final String getColName(int idx) {
        return (String)this.myEditor.getCNames().get(idx);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B&\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0013\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\bH\u00c6\u0003J.\u0010\u0016\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001a\u001a\u00020\u0006H\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$ColumnPermData;", "", "colName", "", "Lorg/jetbrains/annotations/Nls;", "position", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "<init>", "(Ljava/lang/String;ILcom/intellij/database/model/properties/Grants$State;)V", "getColName", "()Ljava/lang/String;", "getPosition", "()I", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "setState", "(Lcom/intellij/database/model/properties/Grants$State;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.database.impl"})
    public static final class ColumnPermData {
        @NotNull
        private final String colName;
        private final int position;
        @Nullable
        private Grants.State state;

        public ColumnPermData(@NotNull String colName, int position, @Nullable Grants.State state) {
            Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
            this.colName = colName;
            this.position = position;
            this.state = state;
        }

        @NotNull
        public final String getColName() {
            return this.colName;
        }

        public final int getPosition() {
            return this.position;
        }

        @Nullable
        public final Grants.State getState() {
            return this.state;
        }

        public final void setState(@Nullable Grants.State state) {
            this.state = state;
        }

        @NotNull
        public final String component1() {
            return this.colName;
        }

        public final int component2() {
            return this.position;
        }

        @Nullable
        public final Grants.State component3() {
            return this.state;
        }

        @NotNull
        public final ColumnPermData copy(@NotNull String colName, int position, @Nullable Grants.State state) {
            Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
            return new ColumnPermData(colName, position, state);
        }

        public static /* synthetic */ ColumnPermData copy$default(ColumnPermData columnPermData, String string, int n, Grants.State state, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = columnPermData.colName;
            }
            if ((n2 & 2) != 0) {
                n = columnPermData.position;
            }
            if ((n2 & 4) != 0) {
                state = columnPermData.state;
            }
            return columnPermData.copy(string, n, state);
        }

        @NotNull
        public String toString() {
            return "ColumnPermData(colName=" + this.colName + ", position=" + this.position + ", state=" + this.state + ")";
        }

        public int hashCode() {
            int result2 = this.colName.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.position);
            result2 = result2 * 31 + (this.state == null ? 0 : this.state.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColumnPermData)) {
                return false;
            }
            ColumnPermData columnPermData = (ColumnPermData)other;
            if (!Intrinsics.areEqual((Object)this.colName, (Object)columnPermData.colName)) {
                return false;
            }
            if (this.position != columnPermData.position) {
                return false;
            }
            return this.state == columnPermData.state;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0002J\u001c\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 J$\u0010!\u001a\u00020\"2\f\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rJ\u0012\u0010'\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010\u001aH\u0002J2\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000202H\u0016J\b\u00104\u001a\u000200H\u0016J\b\u00105\u001a\u00020.H\u0016J\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020\t072\u0006\u00108\u001a\u00020\tR\u0019\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor;", "Lcom/intellij/util/ui/AbstractTableCellEditor;", "myGrantCtl", "Lcom/intellij/database/model/properties/Grants$Controller;", "<init>", "(Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo;Lcom/intellij/database/model/properties/Grants$Controller;)V", "getMyGrantCtl", "()Lcom/intellij/database/model/properties/Grants$Controller;", "root", "Ljavax/swing/tree/DefaultMutableTreeNode;", "getRoot", "()Ljavax/swing/tree/DefaultMutableTreeNode;", "cNames", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "", "getCNames", "()Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "myMeta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "myModel", "Lcom/intellij/ui/treeStructure/treetable/ListTreeTableModelOnColumns;", "myTable", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "current", "Lcom/intellij/openapi/ui/popup/JBPopup;", "editedValue", "Lcom/intellij/database/schemaEditor/GrantData;", "extractColNames", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "owner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "identity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "updateStructure", "", "controller", "Lcom/intellij/database/schemaEditor/ui/DbEditorController;", "meta", "colNames", "updateValues", "grants", "getTableCellEditorComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "row", "", "column", "stopCellEditing", "getCellEditorValue", "children", "Lcom/intellij/util/containers/JBIterable;", "node", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbGrantsEditorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbGrantsEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,418:1\n1#2:419\n1915#3,2:420\n1220#3,2:427\n1249#3,4:429\n221#4,2:422\n221#4,2:424\n18#5:426\n*S KotlinDebug\n*F\n+ 1 DbGrantsEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsEditor\n*L\n224#1:420,2\n341#1:427,2\n341#1:429,4\n288#1:422,2\n301#1:424,2\n314#1:426\n*E\n"})
    public final class GrantsEditor
    extends AbstractTableCellEditor {
        @NotNull
        private final Grants.Controller<?, ?> myGrantCtl;
        @NotNull
        private final DefaultMutableTreeNode root;
        @NotNull
        private final Int2ObjectMap<String> cNames;
        @Nullable
        private BasicMetaObject<?> myMeta;
        @NotNull
        private final ListTreeTableModelOnColumns myModel;
        @NotNull
        private final TreeTable myTable;
        @Nullable
        private JBPopup current;
        @Nullable
        private GrantData editedValue;

        public GrantsEditor(Grants.Controller<?, ?> myGrantCtl) {
            Intrinsics.checkNotNullParameter(myGrantCtl, (String)"myGrantCtl");
            this.myGrantCtl = myGrantCtl;
            this.root = new DefaultMutableTreeNode("ROOT");
            this.cNames = (Int2ObjectMap)new Int2ObjectOpenHashMap();
            ListTreeTableModelOnColumns listTreeTableModelOnColumns = new ListTreeTableModelOnColumns[]{new TreeColumnInfo(""), new ColumnInfo<DefaultMutableTreeNode, Grants.State>(this){
                final /* synthetic */ GrantsEditor this$0;
                {
                    this.this$0 = $receiver;
                    super("");
                }

                public Grants.State valueOf(DefaultMutableTreeNode o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    Object uo = o.getUserObject();
                    return uo instanceof PermData ? ((PermData)uo).getState() : (uo instanceof ColumnPermData ? ((ColumnPermData)uo).getState() : null);
                }

                public void setValue(DefaultMutableTreeNode node, Grants.State value) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Object uo = node.getUserObject();
                    if (uo instanceof PermData) {
                        ((PermData)uo).setState(value);
                    } else if (uo instanceof ColumnPermData) {
                        ((ColumnPermData)uo).setState(value);
                    }
                }

                public boolean isCellEditable(DefaultMutableTreeNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return true;
                }

                public TableCellRenderer getRenderer(DefaultMutableTreeNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    return (TableCellRenderer)new ColoredTableCellRenderer(this){
                        final /* synthetic */ myModel.1 this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                            myModel.1.access$render(this.this$0, (SimpleColoredComponent)this, value);
                        }
                    };
                }

                private final void render(SimpleColoredComponent c2, Object value) {
                    Object object = value;
                    if (object == Grants.State.GRANT) {
                        SimpleColoredComponent simpleColoredComponent = c2.append(DatabaseBundle.message((String)"DbObjectGrantsEditor.state.label.grant", (Object[])new Object[0]));
                        v1 = simpleColoredComponent;
                        Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
                    } else if (object == Grants.State.GRANT_WITH_GRANT_OPTION) {
                        SimpleColoredComponent simpleColoredComponent = c2.append(DatabaseBundle.message((String)"DbObjectGrantsEditor.state.label.grant.with.option", (Object[])new Object[0]));
                        v1 = simpleColoredComponent;
                        Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
                    } else if (object == Grants.State.REVOKE) {
                        SimpleColoredComponent simpleColoredComponent = c2.append(DatabaseBundle.message((String)"DbObjectGrantsEditor.state.label.revoke", (Object[])new Object[0]));
                        v1 = simpleColoredComponent;
                        Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
                    } else if (object == Grants.State.DENY) {
                        SimpleColoredComponent simpleColoredComponent = c2.append(DatabaseBundle.message((String)"DbObjectGrantsEditor.state.label.deny", (Object[])new Object[0]));
                        v1 = simpleColoredComponent;
                        Intrinsics.checkNotNullExpressionValue((Object)simpleColoredComponent, (String)"append(...)");
                    } else {
                        c2.append(DatabaseBundle.message((String)"DbObjectGrantsEditor.state.label.not.granted", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        v1 = Unit.INSTANCE;
                    }
                }

                public TableCellEditor getEditor(DefaultMutableTreeNode node) {
                    Grants.State[] stateArray;
                    block8: {
                        block7: {
                            Grants.State[] meta;
                            Grants.State[] stateArray2;
                            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                            if (node.getUserObject() instanceof ColumnPermData) {
                                stateArray2 = BasicMetaUtils.findChild((BasicMetaObject)GrantsEditor.access$getMyMeta$p(this.this$0), (ObjectKind)ObjectKind.COLUMN);
                                if (stateArray2 == null) {
                                    stateArray2 = GrantsEditor.access$getMyMeta$p(this.this$0);
                                }
                            } else {
                                stateArray2 = GrantsEditor.access$getMyMeta$p(this.this$0);
                            }
                            stateArray = meta = stateArray2;
                            if (meta == null) break block7;
                            Grants.State[] stateArray3 = stateArray;
                            GrantsEditor grantsEditor = this.this$0;
                            Grants.State[] it = stateArray3;
                            boolean bl = false;
                            Grants.State[] stateArray4 = grantsEditor.getMyGrantCtl().possibleStates((BasicMetaObject)it);
                            stateArray = stateArray4;
                            if (stateArray4 != null) break block8;
                        }
                        stateArray = Grants.State.values();
                    }
                    List states = ArraysKt.toMutableList((Object[])stateArray);
                    states.add(0, null);
                    Collection $this$toTypedArray$iv = states;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    ComboBox box = new ComboBox((Object[])thisCollection$iv.toArray(new Grants.State[0]));
                    box.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Grants.State>(this){
                        final /* synthetic */ myModel.1 this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        protected void customizeCellRenderer(JList<? extends Grants.State> list, Grants.State value, int index, boolean selected, boolean hasFocus) {
                            Intrinsics.checkNotNullParameter(list, (String)"list");
                            myModel.1.access$render(this.this$0, (SimpleColoredComponent)this, value);
                        }
                    });
                    UiNotifyConnector.Companion.doWhenFirstShown((JComponent)box, () -> box.showPopup());
                    return new DefaultCellEditor((JComboBox)box);
                }

                public static final /* synthetic */ void access$render(myModel.1 $this, SimpleColoredComponent c2, Object value) {
                    $this.render(c2, value);
                }
            }};
            listTreeTableModelOnColumns = this.myModel = new ListTreeTableModelOnColumns((TreeNode)this.root, (ColumnInfo[])listTreeTableModelOnColumns);
            this.myTable = new TreeTable(listTreeTableModelOnColumns){

                public TableCellRenderer getCellRenderer(int row, int column) {
                    Object object;
                    block6: {
                        block5: {
                            TableCellRenderer tableCellRenderer;
                            object = this.getColumnInfo(column);
                            if (object == null) break block5;
                            ColumnInfo<Object, ?> colInfo = object;
                            boolean bl = false;
                            Object object2 = this.getRow(row);
                            if (object2 != null) {
                                Object it = object2;
                                boolean bl2 = false;
                                tableCellRenderer = colInfo.getRenderer(it);
                            } else {
                                tableCellRenderer = null;
                            }
                            object = tableCellRenderer;
                            if (tableCellRenderer != null) break block6;
                        }
                        TableCellRenderer tableCellRenderer = super.getCellRenderer(row, column);
                        object = tableCellRenderer;
                        Intrinsics.checkNotNullExpressionValue((Object)tableCellRenderer, (String)"getCellRenderer(...)");
                    }
                    return object;
                }

                public TableCellEditor getCellEditor(int row, int column) {
                    Object object;
                    block6: {
                        block5: {
                            TableCellEditor tableCellEditor;
                            object = this.getColumnInfo(column);
                            if (object == null) break block5;
                            ColumnInfo<Object, ?> colInfo = object;
                            boolean bl = false;
                            Object object2 = this.getRow(row);
                            if (object2 != null) {
                                Object it = object2;
                                boolean bl2 = false;
                                tableCellEditor = colInfo.getEditor(it);
                            } else {
                                tableCellEditor = null;
                            }
                            object = tableCellEditor;
                            if (tableCellEditor != null) break block6;
                        }
                        TableCellEditor tableCellEditor = super.getCellEditor(row, column);
                        object = tableCellEditor;
                        Intrinsics.checkNotNullExpressionValue((Object)tableCellEditor, (String)"getCellEditor(...)");
                    }
                    return object;
                }

                public boolean editCellAt(int row, int column, EventObject e) {
                    return super.editCellAt(row, column, e) || column == 0 && super.editCellAt(row, 1, e);
                }

                public boolean editCellAt(int row, int column) {
                    return super.editCellAt(row, column) || column == 0 && super.editCellAt(row, 1);
                }

                private final Object getRow(int row) {
                    TreePath treePath = this.getTree().getPathForRow(row);
                    return treePath != null ? treePath.getLastPathComponent() : null;
                }

                private final ColumnInfo<Object, ?> getColumnInfo(int column) {
                    ColumnInfo[] columnInfoArray;
                    TreeTableModel $this$asSafely$iv = this.getTableModel();
                    boolean $i$f$asSafely = false;
                    TreeTableModel treeTableModel = $this$asSafely$iv;
                    if (!(treeTableModel instanceof ListTreeTableModelOnColumns)) {
                        treeTableModel = null;
                    }
                    return (columnInfoArray = (ColumnInfo[])treeTableModel) != null && (columnInfoArray = columnInfoArray.getColumns()) != null ? columnInfoArray[this.convertColumnIndexToModel(column)] : null;
                }
            };
            this.myTable.setRootVisible(false);
            this.myTable.setTableHeader(null);
            this.myTable.setTreeCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

                public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Object uo;
                    Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Object $this$asSafely$iv = value;
                    boolean $i$f$asSafely = false;
                    Object object = $this$asSafely$iv;
                    if (!(object instanceof DefaultMutableTreeNode)) {
                        object = null;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                    Object object2 = uo = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                    if (uo instanceof PermData) {
                        this.append(((PermData)uo).getPerm(), ((PermData)uo).getUnknown() ? SimpleTextAttributes.GRAY_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else if (uo instanceof ColumnPermData) {
                        String string = StringKt.nullize$default((String)((ColumnPermData)uo).getColName(), (boolean)false, (int)1, null);
                        if (string != null) {
                            String string2;
                            String it = string2 = string;
                            boolean bl = false;
                            this.append(it);
                        } else {
                            Object[] objectArray = new Object[]{((ColumnPermData)uo).getPosition()};
                            this.append(DatabaseBundle.message((String)"column.0", (Object[])objectArray), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        }
                    }
                }
            });
        }

        @NotNull
        public final Grants.Controller<?, ?> getMyGrantCtl() {
            return this.myGrantCtl;
        }

        @NotNull
        public final DefaultMutableTreeNode getRoot() {
            return this.root;
        }

        @NotNull
        public final Int2ObjectMap<String> getCNames() {
            return this.cNames;
        }

        private final Int2ObjectOpenHashMap<String> extractColNames(ElementOwner owner, ElementIdentity<?> identity) {
            Int2ObjectOpenHashMap colNames;
            block3: {
                colNames = new Int2ObjectOpenHashMap();
                BasicMetaObject cMeta = BasicMetaUtils.findChild((BasicMetaObject)identity.getMetaObject(), (ObjectKind)ObjectKind.COLUMN);
                colNames.clear();
                BasicMetaObject basicMetaObject = cMeta;
                if (basicMetaObject == null) break block3;
                BasicMetaObject it = basicMetaObject;
                boolean bl = false;
                JBIterable jBIterable = owner.getChildren(identity, it);
                basicMetaObject = jBIterable;
                if (jBIterable != null) {
                    Iterable $this$forEach$iv = (Iterable)basicMetaObject;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ElementIdentity it2 = (ElementIdentity)element$iv;
                        boolean bl2 = false;
                        if ((BasicArrangedElement)owner.find(it2) != null) {
                            BasicArrangedElement c2;
                            boolean bl3 = false;
                            colNames.put((int)c2.getPosition(), (Object)c2.getName());
                        }
                    }
                }
            }
            return colNames;
        }

        public final void updateStructure(@NotNull DbEditorController controller, @Nullable ElementIdentity<?> identity) {
            ElementOwner owner;
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            DbEditorModelController dbEditorModelController = controller.getModelController();
            Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
            DbEditorModelController modelController = dbEditorModelController;
            ElementOwner elementOwner = modelController.getActualOwner();
            if (elementOwner == null) {
                elementOwner = modelController.getMatcher().getOriginalOwner();
            }
            Int2ObjectOpenHashMap<String> colNames = (owner = elementOwner) != null && identity != null ? this.extractColNames(owner, identity) : null;
            ElementIdentity<?> elementIdentity = identity;
            this.updateStructure((BasicMetaObject<?>)(elementIdentity != null ? elementIdentity.getMetaObject() : null), (Int2ObjectMap<String>)((Int2ObjectMap)colNames));
        }

        public final void updateStructure(@Nullable BasicMetaObject<?> meta, @Nullable Int2ObjectMap<String> colNames) {
            Object object;
            List privs;
            IntSet poses;
            block10: {
                block9: {
                    this.root.removeAllChildren();
                    this.cNames.clear();
                    Object object2 = colNames;
                    if (object2 == null || (object2 = (IntSet)object2.keySet()) == null || (object2 = CollectionsKt.sorted((Iterable)((Iterable)object2))) == null) {
                        object2 = CollectionsKt.emptyList();
                    }
                    poses = object2;
                    for (Integer pos : poses) {
                        Intrinsics.checkNotNull((Object)pos);
                        Object object3 = colNames;
                        this.cNames.put(pos.intValue(), object3 != null ? (String)object3.get(pos.intValue()) : null);
                    }
                    this.myMeta = meta;
                    if (meta == null) {
                        return;
                    }
                    privs = CollectionsKt.sorted((Iterable)this.myGrantCtl.possiblePrivileges(meta));
                    object = BasicMetaUtils.findChild(meta, (ObjectKind)ObjectKind.COLUMN);
                    if (object == null) break block9;
                    BasicMetaObject it = object;
                    boolean bl = false;
                    Set set = CollectionsKt.toSet((Iterable)this.myGrantCtl.possiblePrivileges(it));
                    object = set;
                    if (set != null) break block10;
                }
                object = SetsKt.emptySet();
            }
            BasicMetaObject colPrivs = object;
            for (String p : privs) {
                DefaultMutableTreeNode pNode = new DefaultMutableTreeNode(new PermData(p, null, false));
                if (!this.cNames.isEmpty() && colPrivs.contains(p)) {
                    for (Integer pos : poses) {
                        Intrinsics.checkNotNull((Object)pos);
                        Object object4 = this.cNames.get(pos.intValue());
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                        pNode.add(new DefaultMutableTreeNode(new ColumnPermData((String)object4, pos, null)));
                    }
                }
                this.root.add(pNode);
            }
            this.myModel.reload();
        }

        private final void updateValues(GrantData grants) {
            DefaultMutableTreeNode pNode;
            StateKey k;
            Map.Entry element$iv;
            this.editedValue = grants;
            Object object = grants;
            Map values = object != null && (object = object.getGrants()) != null ? (Map)object : MapsKt.emptyMap();
            LinkedHashMap processed = new LinkedHashMap();
            for (DefaultMutableTreeNode pNode2 : this.children(this.root)) {
                Object object2 = pNode2.getUserObject();
                PermData permData = object2 instanceof PermData ? (PermData)object2 : null;
                if (permData == null) continue;
                PermData p = permData;
                if (p.getUnknown()) {
                    pNode2.removeFromParent();
                    continue;
                }
                StateKey key = new StateKey(p.getPerm(), null);
                boolean bl = false;
                p.setState((Grants.State)values.get(key));
                ((Map)processed).put(key, pNode2);
                Intrinsics.checkNotNull((Object)pNode2);
                for (DefaultMutableTreeNode cNode : this.children(pNode2)) {
                    ColumnPermData cp;
                    Object object3 = cNode.getUserObject();
                    if ((object3 instanceof ColumnPermData ? (ColumnPermData)object3 : null) == null) continue;
                    cp = cp;
                    StateKey key2 = new StateKey(p.getPerm(), Integer.valueOf(cp.getPosition()));
                    boolean bl2 = false;
                    cp.setState((Grants.State)values.get(key2));
                    ((Map)processed).put(key2, cNode);
                    if (!(((CharSequence)cp.getColName()).length() == 0)) continue;
                    cNode.removeFromParent();
                }
            }
            Set set = this.cNames.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            List poses = CollectionsKt.sorted((Iterable)set);
            Map $this$forEach$iv = values;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                k = (StateKey)entry.getKey();
                Grants.State s = (Grants.State)entry.getValue();
                if (k.getPos() != null || processed.containsKey(k)) continue;
                pNode = new DefaultMutableTreeNode(new PermData(k.getPerm(), s, true));
                this.root.add(pNode);
                ((Map)processed).put(k, pNode);
                for (Integer pos : poses) {
                    StateKey key = new StateKey(k.getPerm(), pos);
                    Intrinsics.checkNotNull((Object)pos);
                    Object object4 = this.cNames.get(pos.intValue());
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                    DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(new ColumnPermData((String)object4, pos, (Grants.State)values.get(key)));
                    pNode.add(cNode);
                    ((Map)processed).put(key, cNode);
                }
            }
            $this$forEach$iv = values;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                k = (StateKey)entry.getKey();
                Grants.State s = (Grants.State)entry.getValue();
                if (k.getPos() == null || processed.containsKey(k) || (DefaultMutableTreeNode)processed.get(new StateKey(k.getPerm(), null)) == null) continue;
                Integer n = k.getPos();
                Intrinsics.checkNotNull((Object)n);
                DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(new ColumnPermData("", n, s));
                pNode.add(cNode);
            }
            this.myModel.reload();
        }

        @NotNull
        public Component getTableCellEditorComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Component component = new GrantsRenderer().getTableCellRendererComponent(table, value, isSelected, true, row, column);
            Object $this$asSafely$iv = value;
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof GrantData)) {
                object = null;
            }
            this.updateValues((GrantData)object);
            UiNotifyConnector.Companion.doWhenFirstShown$default((UiNotifyConnector.Companion)UiNotifyConnector.Companion, (Component)component, (boolean)false, () -> GrantsEditor.getTableCellEditorComponent$lambda$0(this, component), (int)2, null);
            return component;
        }

        public boolean stopCellEditing() {
            block0: {
                JBPopup popup2;
                JBPopup jBPopup = popup2 = this.current;
                if (jBPopup == null) break block0;
                jBPopup.closeOk(null);
            }
            return super.stopCellEditing();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Object getCellEditorValue() {
            Object object;
            void $this$associateByTo$iv$iv;
            Object object2 = this.editedValue;
            Iterable $this$associateBy$iv = object2 != null && (object2 = object2.getGrants()) != null && (object2 = ((LinkedHashMap)object2).keySet()) != null ? (Collection)object2 : (Collection)CollectionsKt.emptyList();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo2 = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                object = (StateKey)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it, element$iv$iv);
            }
            Map existingKeys = destination$iv$iv;
            GrantData res2 = new GrantData();
            for (DefaultMutableTreeNode pNode : this.children(this.root)) {
                Object $i$f$associateByTo2 = pNode.getUserObject();
                PermData permData = $i$f$associateByTo2 instanceof PermData ? (PermData)$i$f$associateByTo2 : null;
                if (permData == null) continue;
                PermData p = permData;
                if (p.getState() != null) {
                    Grants.State it;
                    boolean bl = false;
                    ((Map)res2.getGrants()).put(GrantsEditor.getCellEditorValue$useExisting(new StateKey(p.getPerm(), null), existingKeys), it);
                }
                Intrinsics.checkNotNull((Object)pNode);
                for (DefaultMutableTreeNode cNode : this.children(pNode)) {
                    Grants.State it;
                    object = cNode.getUserObject();
                    ColumnPermData columnPermData = object instanceof ColumnPermData ? (ColumnPermData)object : null;
                    if (columnPermData == null) continue;
                    ColumnPermData cp = columnPermData;
                    if (cp.getState() == null) continue;
                    boolean bl = false;
                    ((Map)res2.getGrants()).put(GrantsEditor.getCellEditorValue$useExisting(new StateKey(p.getPerm(), Integer.valueOf(cp.getPosition())), existingKeys), it);
                }
            }
            return res2;
        }

        @NotNull
        public final JBIterable<DefaultMutableTreeNode> children(@NotNull DefaultMutableTreeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            JBIterable jBIterable = JBIterable.once(node.children().asIterator()).filter(DefaultMutableTreeNode.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
            return jBIterable;
        }

        private static final Unit getTableCellEditorComponent$lambda$0(GrantsEditor this$0, Component $component) {
            JBPopup prev2;
            JBPopup jBPopup = prev2 = this$0.current;
            if (jBPopup != null) {
                jBPopup.closeOk(null);
            }
            JBPopup jBPopup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)ScrollPaneFactory.createScrollPane((Component)((Component)this$0.myTable), (boolean)true), (JComponent)this$0.myTable).addListener(new JBPopupListener(this$0){
                final /* synthetic */ GrantsEditor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onClosed(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.this$0.stopCellEditing();
                }
            }).setMinSize((Dimension)JBUI.size((int)300, (int)250)).setRequestFocus(true).createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup2, (String)"createPopup(...)");
            JBPopup popup2 = jBPopup2;
            popup2.show(new RelativePoint($component, new Point(0, 0)));
            this$0.current = popup2;
            return Unit.INSTANCE;
        }

        private static final StateKey getCellEditorValue$useExisting(StateKey $this$getCellEditorValue_u24useExisting, Map<StateKey, StateKey> existingKeys) {
            StateKey stateKey = existingKeys.get($this$getCellEditorValue_u24useExisting);
            if (stateKey == null) {
                stateKey = $this$getCellEditorValue_u24useExisting;
            }
            return stateKey;
        }

        public static final /* synthetic */ BasicMetaObject access$getMyMeta$p(GrantsEditor $this) {
            return $this.myMeta;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J(\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00052\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001cH\u0002J \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001c2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsRenderer;", "Lcom/intellij/database/schemaEditor/ui/BaseRenderer;", "<init>", "(Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo;)V", "myGrant", "Lcom/intellij/ui/SimpleColoredComponent;", "myRevoke", "myDeny", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "setUp", "", "line", "appendGrants", "comp", "title", "", "perms", "", "extractPermissions", "grants", "Lcom/intellij/database/schemaEditor/GrantData;", "state", "Lcom/intellij/database/model/properties/Grants$State;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbGrantsEditorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbGrantsEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsRenderer\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,418:1\n18#2:419\n*S KotlinDebug\n*F\n+ 1 DbGrantsEditorUtils.kt\ncom/intellij/database/schemaEditor/ui/GrantsColumnInfo$GrantsRenderer\n*L\n72#1:419\n*E\n"})
    public final class GrantsRenderer
    extends BaseRenderer {
        @NotNull
        private final SimpleColoredComponent myGrant;
        @NotNull
        private final SimpleColoredComponent myRevoke;
        @NotNull
        private final SimpleColoredComponent myDeny;

        public GrantsRenderer() {
            super((JComponent)new JBBox(1));
            this.myGrant = new SimpleColoredComponent();
            this.myRevoke = new SimpleColoredComponent();
            this.myDeny = new SimpleColoredComponent();
            this.setUp(this.myGrant);
            this.setUp(this.myRevoke);
            this.setUp(this.myDeny);
            this.getMyComponent().add((Component)this.myGrant);
            this.getMyComponent().add((Component)this.myRevoke);
            this.getMyComponent().add((Component)this.myDeny);
            this.getMyComponent().setBorder((Border)JBUI.Borders.empty((int)JBUI.scale((int)2), (int)0));
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Object $this$asSafely$iv = value;
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof GrantData)) {
                object = null;
            }
            GrantData g = (GrantData)object;
            String string = DatabaseBundle.message((String)"DbObjectGrantsEditor.label.grant", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.appendGrants(this.myGrant, string, this.extractPermissions(g, Grants.State.GRANT));
            String string2 = DatabaseBundle.message((String)"DbObjectGrantsEditor.label.revoke", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            this.appendGrants(this.myRevoke, string2, this.extractPermissions(g, Grants.State.REVOKE));
            String string3 = DatabaseBundle.message((String)"DbObjectGrantsEditor.label.deny", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            this.appendGrants(this.myDeny, string3, this.extractPermissions(g, Grants.State.DENY));
            if (g == null || g.getGrants().isEmpty()) {
                this.myGrant.setVisible(true);
                this.myGrant.append(DatabaseBundle.message((String)"DbObjectGrantsEditor.label.no.grants", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        private final void setUp(SimpleColoredComponent line) {
            line.setOpaque(false);
            line.setIpad((Insets)JBInsets.emptyInsets());
        }

        private final void appendGrants(SimpleColoredComponent comp, @Nls String title, Set<String> perms) {
            boolean visible = !((Collection)perms).isEmpty();
            comp.setVisible(visible);
            comp.clear();
            if (!visible) {
                return;
            }
            comp.append(title, SimpleTextAttributes.GRAY_ATTRIBUTES);
            comp.append(" ");
            comp.append(StringUtil.join((Collection)perms, (String)", "));
        }

        private final Set<String> extractPermissions(GrantData grants, Grants.State state) {
            if (grants == null) {
                return SetsKt.emptySet();
            }
            Set res2 = new TreeSet();
            Map items = grants.groupColumnsForState(state);
            for (Map.Entry entry : items.entrySet()) {
                String perm;
                StringBuilder text = new StringBuilder();
                text.append((String)entry.getKey());
                if (state.getWithGrantOption()) {
                    text.append("+");
                }
                if (!((BitSet)entry.getValue()).isEmpty()) {
                    text.append('(');
                    StringUtil.join((Iterable)((Iterable)JBIterable.once(((BitSet)entry.getValue()).stream().boxed().iterator())), arg_0 -> GrantsRenderer.extractPermissions$lambda$1(arg_0 -> GrantsRenderer.extractPermissions$lambda$0(GrantsColumnInfo.this, arg_0), arg_0), (String)",", (StringBuilder)text);
                    text.append(')');
                }
                Intrinsics.checkNotNullExpressionValue((Object)text.toString(), (String)"toString(...)");
                res2.add(perm);
            }
            if (state == Grants.State.GRANT) {
                res2.addAll((Collection)this.extractPermissions(grants, Grants.State.GRANT_WITH_GRANT_OPTION));
            }
            return res2;
        }

        private static final CharSequence extractPermissions$lambda$0(GrantsColumnInfo this$0, Integer idx) {
            Intrinsics.checkNotNull((Object)idx);
            return this$0.getColName(idx);
        }

        private static final CharSequence extractPermissions$lambda$1(Function1 $tmp0, Object p0) {
            return (CharSequence)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0015\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\u0019H\u00d6\u0081\u0004J\n\u0010\u001a\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/schemaEditor/ui/GrantsColumnInfo$PermData;", "", "perm", "", "state", "Lcom/intellij/database/model/properties/Grants$State;", "unknown", "", "<init>", "(Ljava/lang/String;Lcom/intellij/database/model/properties/Grants$State;Z)V", "getPerm", "()Ljava/lang/String;", "getState", "()Lcom/intellij/database/model/properties/Grants$State;", "setState", "(Lcom/intellij/database/model/properties/Grants$State;)V", "getUnknown", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.database.impl"})
    public static final class PermData {
        @NotNull
        private final String perm;
        @Nullable
        private Grants.State state;
        private final boolean unknown;

        public PermData(@Nls @NotNull String perm, @Nullable Grants.State state, boolean unknown) {
            Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
            this.perm = perm;
            this.state = state;
            this.unknown = unknown;
        }

        @NotNull
        public final String getPerm() {
            return this.perm;
        }

        @Nullable
        public final Grants.State getState() {
            return this.state;
        }

        public final void setState(@Nullable Grants.State state) {
            this.state = state;
        }

        public final boolean getUnknown() {
            return this.unknown;
        }

        @NotNull
        public final String component1() {
            return this.perm;
        }

        @Nullable
        public final Grants.State component2() {
            return this.state;
        }

        public final boolean component3() {
            return this.unknown;
        }

        @NotNull
        public final PermData copy(@Nls @NotNull String perm, @Nullable Grants.State state, boolean unknown) {
            Intrinsics.checkNotNullParameter((Object)perm, (String)"perm");
            return new PermData(perm, state, unknown);
        }

        public static /* synthetic */ PermData copy$default(PermData permData, String string, Grants.State state, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = permData.perm;
            }
            if ((n & 2) != 0) {
                state = permData.state;
            }
            if ((n & 4) != 0) {
                bl = permData.unknown;
            }
            return permData.copy(string, state, bl);
        }

        @NotNull
        public String toString() {
            return "PermData(perm=" + this.perm + ", state=" + this.state + ", unknown=" + this.unknown + ")";
        }

        public int hashCode() {
            int result2 = this.perm.hashCode();
            result2 = result2 * 31 + (this.state == null ? 0 : this.state.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.unknown);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PermData)) {
                return false;
            }
            PermData permData = (PermData)other;
            if (!Intrinsics.areEqual((Object)this.perm, (Object)permData.perm)) {
                return false;
            }
            if (this.state != permData.state) {
                return false;
            }
            return this.unknown == permData.unknown;
        }
    }
}

