/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.backend.konan.InteropFqNames;
import org.jetbrains.kotlin.backend.konan.cgen.InteropIrUtilsKt;
import org.jetbrains.kotlin.backend.konan.lower.BackendChecker;
import org.jetbrains.kotlin.backend.konan.lower.TypeLocation;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0001\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a,\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\"\u0010\u000e\u001a\u00020\u0001*\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0006H\u0002\u001a,\u0010\u0013\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0002\u001a,\u0010\u0018\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a,\u0010\u001e\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u001c\u0010!\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\nH\u0002\u001a6\u0010\"\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0012\u001a\u00020\nH\u0002\u001a$\u0010'\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020(H\u0002\u001a\u001c\u0010)\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020(H\u0002\u001a\u001c\u0010*\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020(H\u0002\u001a$\u0010+\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020(H\u0002\u001a8\u0010+\u001a\u00020\u0001*\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00062\u0006\u0010,\u001a\u00020(2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.H\u0002\u001a$\u0010-\u001a\u000200*\u00020\u00022\u0006\u00101\u001a\u00020/2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020(H\u0002\u00a8\u00062"}, d2={"checkCanGenerateCFunctionCallOrGlobalAccess", "", "Lorg/jetbrains/kotlin/backend/konan/lower/BackendChecker;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "isInvoke", "", "checkCanAddArguments", "arguments", "", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isObjCMethod", "checkCanUnwrapVariadicArguments", "elements", "Lorg/jetbrains/kotlin/ir/expressions/IrVarargElement;", "checkCanHandleArgumentForVarargParameter", "argument", "checkCanGenerateObjCCall", "method", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "checkParameter", "it", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "functionParameter", "location", "Lorg/jetbrains/kotlin/ir/IrElement;", "checkCanGenerateCFunction", "function", "signature", "checkCanGenerateCFunctionPointer", "checkCanMapCalleeFunctionParameter", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "variadic", "parameter", "checkCanMapFunctionParameterType", "Lorg/jetbrains/kotlin/backend/konan/lower/TypeLocation;", "checkCanMapReturnType", "checkCanMapBlockType", "checkCanMapType", "typeLocation", "reportUnsupportedType", "Lkotlin/Function1;", "", "", "reason", "ir.backend.native"})
@SourceDebugExtension(value={"SMAP\nSpecialBackendChecksTraversal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialBackendChecksTraversal.kt\norg/jetbrains/kotlin/backend/konan/lower/SpecialBackendChecksTraversalKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,878:1\n777#2:879\n873#2,2:880\n1915#2,2:882\n1924#2,3:884\n*S KotlinDebug\n*F\n+ 1 SpecialBackendChecksTraversal.kt\norg/jetbrains/kotlin/backend/konan/lower/SpecialBackendChecksTraversalKt\n*L\n621#1:879\n621#1:880,2\n722#1:882,2\n794#1:884,3\n*E\n"})
public final class SpecialBackendChecksTraversalKt {
    /*
     * WARNING - void declaration
     */
    private static final void checkCanGenerateCFunctionCallOrGlobalAccess(BackendChecker $this$checkCanGenerateCFunctionCallOrGlobalAccess, IrCall expression, boolean isInvoke) {
        IrSimpleFunction callee = (IrSimpleFunction)expression.getSymbol().getOwner();
        if (isInvoke) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = callee.getParameters();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrValueParameter it = (IrValueParameter)element$iv$iv;
                boolean bl = false;
                if (!(it.getKind() == IrParameterKind.Regular)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int idx = n++;
                IrValueParameter param = (IrValueParameter)iterator.next();
                IrType irType = expression.getTypeArguments().get(idx);
                Intrinsics.checkNotNull((Object)irType);
                IrExpression irExpression = expression.getArguments().get(param);
                Intrinsics.checkNotNull((Object)irExpression);
                SpecialBackendChecksTraversalKt.checkCanMapCalleeFunctionParameter($this$checkCanGenerateCFunctionCallOrGlobalAccess, irType, false, false, null, irExpression);
            }
            Object object = CollectionsKt.last(expression.getTypeArguments());
            Intrinsics.checkNotNull((Object)object);
            IrType returnType = (IrType)object;
            SpecialBackendChecksTraversalKt.checkCanMapReturnType($this$checkCanGenerateCFunctionCallOrGlobalAccess, returnType, new TypeLocation.FunctionCallResult(expression));
        } else {
            SpecialBackendChecksTraversalKt.checkCanAddArguments($this$checkCanGenerateCFunctionCallOrGlobalAccess, expression.getArguments(), callee, false);
            SpecialBackendChecksTraversalKt.checkCanMapReturnType($this$checkCanGenerateCFunctionCallOrGlobalAccess, callee.getReturnType(), new TypeLocation.FunctionCallResult(expression));
        }
    }

    private static final void checkCanAddArguments(BackendChecker $this$checkCanAddArguments, List<? extends IrExpression> arguments, IrFunction callee, boolean isObjCMethod) {
        for (Pair pair : CollectionsKt.zip((Iterable)arguments, (Iterable)callee.getParameters())) {
            IrExpression argument = (IrExpression)pair.component1();
            IrValueParameter parameter = (IrValueParameter)pair.component2();
            if (AdditionalIrUtilsKt.isVararg(parameter)) {
                SpecialBackendChecksTraversalKt.checkCanHandleArgumentForVarargParameter($this$checkCanAddArguments, argument, isObjCMethod);
                continue;
            }
            IrType irType = parameter.getType();
            IrExpression irExpression = argument;
            Intrinsics.checkNotNull((Object)irExpression);
            SpecialBackendChecksTraversalKt.checkCanMapCalleeFunctionParameter($this$checkCanAddArguments, irType, isObjCMethod, false, parameter, irExpression);
        }
    }

    private static final void checkCanUnwrapVariadicArguments(BackendChecker $this$checkCanUnwrapVariadicArguments, List<? extends IrVarargElement> elements, boolean isObjCMethod) {
        for (IrVarargElement irVarargElement : elements) {
            IrVarargElement irVarargElement2 = irVarargElement;
            if (irVarargElement2 instanceof IrExpression) {
                SpecialBackendChecksTraversalKt.checkCanMapCalleeFunctionParameter($this$checkCanUnwrapVariadicArguments, ((IrExpression)irVarargElement).getType(), isObjCMethod, true, null, (IrExpression)irVarargElement);
                continue;
            }
            if (!(irVarargElement2 instanceof IrSpreadElement)) continue;
            IrExpression expression = ((IrSpreadElement)irVarargElement).getExpression();
            if (expression instanceof IrCall && Intrinsics.areEqual((Object)((IrCall)expression).getSymbol(), (Object)$this$checkCanUnwrapVariadicArguments.getIrBuiltIns().getArrayOf())) {
                SpecialBackendChecksTraversalKt.checkCanHandleArgumentForVarargParameter($this$checkCanUnwrapVariadicArguments, (IrExpression)((IrCall)expression).getArguments().get(0), isObjCMethod);
                continue;
            }
            $this$checkCanUnwrapVariadicArguments.reportError(irVarargElement, "When calling variadic " + (isObjCMethod ? "Objective-C methods " : "C functions ") + "spread operator is supported only for *arrayOf(...)");
            throw new KotlinNothingValueException();
        }
    }

    private static final void checkCanHandleArgumentForVarargParameter(BackendChecker $this$checkCanHandleArgumentForVarargParameter, IrExpression argument, boolean isObjCMethod) {
        IrValueDeclaration variable;
        IrExpression irExpression = argument;
        if (irExpression instanceof IrVararg) {
            SpecialBackendChecksTraversalKt.checkCanUnwrapVariadicArguments($this$checkCanHandleArgumentForVarargParameter, ((IrVararg)argument).getElements(), isObjCMethod);
        } else if (irExpression instanceof IrGetValue && (variable = ((IrGetValue)argument).getSymbol().getOwner()) instanceof IrVariable && Intrinsics.areEqual((Object)variable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE()) && !((IrVariable)variable).isVar()) {
            IrExpression irExpression2 = ((IrVariable)variable).getInitializer();
            Intrinsics.checkNotNull((Object)irExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrVararg");
            SpecialBackendChecksTraversalKt.checkCanUnwrapVariadicArguments($this$checkCanHandleArgumentForVarargParameter, ((IrVararg)irExpression2).getElements(), isObjCMethod);
        }
    }

    private static final void checkCanGenerateObjCCall(BackendChecker $this$checkCanGenerateObjCCall, IrSimpleFunction method, IrFunctionAccessExpression call, List<? extends IrExpression> arguments) {
        SpecialBackendChecksTraversalKt.checkCanAddArguments($this$checkCanGenerateObjCCall, arguments, method, true);
        SpecialBackendChecksTraversalKt.checkCanMapReturnType($this$checkCanGenerateObjCCall, method.getReturnType(), new TypeLocation.FunctionCallResult(call));
    }

    private static final void checkParameter(BackendChecker $this$checkParameter, IrValueParameter it, IrValueParameter functionParameter, boolean isObjCMethod, IrElement location) {
        TypeLocation typeLocation;
        TypeLocation typeLocation2 = typeLocation = isObjCMethod ? (TypeLocation)new TypeLocation.ObjCMethodParameter(functionParameter) : (TypeLocation)new TypeLocation.FunctionPointerParameter(it.getIndexInParameters(), location);
        if (AdditionalIrUtilsKt.isVararg(functionParameter)) {
            $this$checkParameter.reportError(typeLocation.getElement(), isObjCMethod ? "overriding variadic Objective-C methods is not supported" : "variadic function pointers are not supported");
            throw new KotlinNothingValueException();
        }
        SpecialBackendChecksTraversalKt.checkCanMapFunctionParameterType($this$checkParameter, it.getType(), false, typeLocation);
    }

    private static final void checkCanGenerateCFunction(BackendChecker $this$checkCanGenerateCFunction, IrSimpleFunction function, IrSimpleFunction signature, boolean isObjCMethod, IrElement location) {
        Iterable $this$forEach$iv = signature.getParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            SpecialBackendChecksTraversalKt.checkParameter($this$checkCanGenerateCFunction, it, function.getParameters().get(it.getIndexInParameters()), isObjCMethod, location);
        }
    }

    private static final void checkCanGenerateCFunctionPointer(BackendChecker $this$checkCanGenerateCFunctionPointer, IrSimpleFunction function, IrExpression expression) {
        SpecialBackendChecksTraversalKt.checkCanGenerateCFunction($this$checkCanGenerateCFunctionPointer, function, function, false, expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void checkCanMapCalleeFunctionParameter(BackendChecker $this$checkCanMapCalleeFunctionParameter, IrType type, boolean isObjCMethod, boolean variadic, IrValueParameter parameter, IrExpression argument) {
        IrClassifierSymbol classifier;
        block15: {
            block16: {
                boolean bl;
                boolean bl2;
                classifier = IrTypesKt.getClassifierOrNull(type);
                IrClassifierSymbol irClassifierSymbol = classifier;
                if (irClassifierSymbol != null) {
                    if (IrTypePredicatesKt.isClassWithFqName(irClassifierSymbol, InteropFqNames.INSTANCE.getCValues().toUnsafe())) {
                        return;
                    }
                    bl2 = false;
                } else {
                    bl2 = false;
                }
                if (bl2) return;
                IrClassifierSymbol irClassifierSymbol2 = classifier;
                if (irClassifierSymbol2 != null) {
                    if (IrTypePredicatesKt.isClassWithFqName(irClassifierSymbol2, InteropFqNames.INSTANCE.getCValuesRef().toUnsafe())) {
                        return;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)classifier, (Object)$this$checkCanMapCalleeFunctionParameter.getIrBuiltIns().getStringClass())) break block15;
                if (variadic) break block16;
                IrValueParameter irValueParameter = parameter;
                boolean bl3 = irValueParameter != null ? InteropIrUtilsKt.isCStringParameter(irValueParameter) : false;
                if (!bl3) break block15;
            }
            if (!variadic) return;
            if (!isObjCMethod) return;
            $this$checkCanMapCalleeFunctionParameter.reportError(argument, "Passing String as variadic Objective-C argument is ambiguous; cast it to NSString or pass with '.cstr' as C string");
            throw new KotlinNothingValueException();
        }
        if (Intrinsics.areEqual((Object)classifier, (Object)$this$checkCanMapCalleeFunctionParameter.getIrBuiltIns().getStringClass())) {
            boolean bl;
            IrValueParameter irValueParameter = parameter;
            if (irValueParameter != null) {
                if (InteropIrUtilsKt.isWCStringParameter(irValueParameter)) {
                    return;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
        }
        SpecialBackendChecksTraversalKt.checkCanMapFunctionParameterType($this$checkCanMapCalleeFunctionParameter, type, variadic, new TypeLocation.FunctionArgument(argument));
    }

    private static final void checkCanMapFunctionParameterType(BackendChecker $this$checkCanMapFunctionParameterType, IrType type, boolean variadic, TypeLocation location) {
        if (!IrTypePredicatesKt.isUnit(type) || variadic) {
            SpecialBackendChecksTraversalKt.checkCanMapType($this$checkCanMapFunctionParameterType, type, variadic, location);
        }
    }

    private static final void checkCanMapReturnType(BackendChecker $this$checkCanMapReturnType, IrType type, TypeLocation location) {
        if (!IrTypePredicatesKt.isUnit(type)) {
            SpecialBackendChecksTraversalKt.checkCanMapType($this$checkCanMapReturnType, type, false, location);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkCanMapBlockType(BackendChecker $this$checkCanMapBlockType, IrType type, TypeLocation location) {
        Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrTypeArgument returnTypeArgument = (IrTypeArgument)CollectionsKt.last(((IrSimpleType)type).getArguments());
        if (returnTypeArgument instanceof IrTypeProjection) {
            if (((IrTypeProjection)returnTypeArgument).getVariance() != Variance.INVARIANT) {
                SpecialBackendChecksTraversalKt.reportUnsupportedType($this$checkCanMapBlockType, ((IrTypeProjection)returnTypeArgument).getVariance().getLabel() + "-variance of return type", type, location);
                throw new KotlinNothingValueException();
            }
        } else {
            if (returnTypeArgument instanceof IrStarProjection) {
                SpecialBackendChecksTraversalKt.reportUnsupportedType($this$checkCanMapBlockType, "* as return type", type, location);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        SpecialBackendChecksTraversalKt.checkCanMapReturnType($this$checkCanMapBlockType, ((IrTypeProjection)returnTypeArgument).getType(), new TypeLocation.BlockReturnValue(location));
        Iterable $this$forEachIndexed$iv = CollectionsKt.dropLast(((IrSimpleType)type).getArguments(), (int)1);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void argument;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv;
            int index = n;
            boolean bl = false;
            void var12_12 = argument;
            if (var12_12 instanceof IrTypeProjection) {
                if (((IrTypeProjection)argument).getVariance() == Variance.INVARIANT) {
                    SpecialBackendChecksTraversalKt.checkCanMapType($this$checkCanMapBlockType, ((IrTypeProjection)argument).getType(), false, new TypeLocation.BlockParameter(index, location));
                    continue;
                }
                SpecialBackendChecksTraversalKt.reportUnsupportedType($this$checkCanMapBlockType, ((IrTypeProjection)argument).getVariance().getLabel() + "-variance of " + (index + 1) + " parameter type", type, location);
                throw new KotlinNothingValueException();
            }
            if (var12_12 instanceof IrStarProjection) {
                SpecialBackendChecksTraversalKt.reportUnsupportedType($this$checkCanMapBlockType, "* as " + (index + 1) + " parameter type", type, location);
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void checkCanMapType(BackendChecker $this$checkCanMapType, IrType type, boolean variadic, TypeLocation location) {
        SpecialBackendChecksTraversalKt.checkCanMapType($this$checkCanMapType, type, variadic, location, new Function1($this$checkCanMapType, type, location){
            final /* synthetic */ BackendChecker $this_checkCanMapType;
            final /* synthetic */ IrType $type;
            final /* synthetic */ TypeLocation $location;
            {
                this.$this_checkCanMapType = $receiver;
                this.$type = $type;
                this.$location = $location;
            }

            public final Void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                SpecialBackendChecksTraversalKt.access$reportUnsupportedType(this.$this_checkCanMapType, it, this.$type, this.$location);
                throw new KotlinNothingValueException();
            }
        });
    }

    private static final void checkCanMapType(BackendChecker $this$checkCanMapType, IrType type, boolean variadic, TypeLocation typeLocation, Function1 reportUnsupportedType) {
        Object object;
        if (IrTypePredicatesKt.isBoolean(type)) {
            if (InteropIrUtilsKt.cBoolType($this$checkCanMapType.getTarget()) == null) {
                reportUnsupportedType.invoke((Object)"unavailable on target platform");
                throw new KotlinNothingValueException();
            }
            object = Unit.INSTANCE;
        } else {
            if (IrTypePredicatesKt.isByte(type)) {
                return;
            }
            if (IrTypePredicatesKt.isShort(type)) {
                return;
            }
            if (IrTypePredicatesKt.isInt(type)) {
                return;
            }
            if (IrTypePredicatesKt.isLong(type)) {
                return;
            }
            if (IrTypePredicatesKt.isFloat(type)) {
                return;
            }
            if (IrTypePredicatesKt.isDouble(type)) {
                return;
            }
            if (InteropIrUtilsKt.isCPointer(type, $this$checkCanMapType.getSymbols())) {
                return;
            }
            if (InteropIrUtilsKt.isTypeOfNullLiteral(type) && variadic) {
                return;
            }
            if (IrTypePredicatesKt.isUByte(type)) {
                return;
            }
            if (IrTypePredicatesKt.isUShort(type)) {
                return;
            }
            if (IrTypePredicatesKt.isUInt(type)) {
                return;
            }
            if (IrTypePredicatesKt.isULong(type)) {
                return;
            }
            if (InteropIrUtilsKt.isVector(type)) {
                return;
            }
            if (InteropIrUtilsKt.isCEnumType(type)) {
                return;
            }
            if (InteropIrUtilsKt.isCValue(type, $this$checkCanMapType.getSymbols())) {
                if (IrTypeUtilsKt.isNullable(type)) {
                    reportUnsupportedType.invoke((Object)"must not be nullable");
                    throw new KotlinNothingValueException();
                }
                Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
                Object object2 = (IrTypeArgument)CollectionsKt.singleOrNull(((IrSimpleType)type).getArguments());
                if (object2 == null || (object2 = IrTypesKt.getTypeOrNull((IrTypeArgument)object2)) == null || (object2 = IrTypesKt.getClass((IrType)object2)) == null) {
                    reportUnsupportedType.invoke((Object)"must be parameterized with concrete class");
                    throw new KotlinNothingValueException();
                }
                Object kotlinClass = object2;
                object = InteropIrUtilsKt.getCStructSpelling((IrClass)kotlinClass);
                if (object == null) {
                    reportUnsupportedType.invoke((Object)"not a structure or too complex");
                    throw new KotlinNothingValueException();
                }
            } else {
                if (InteropIrUtilsKt.isNativePointed(type, $this$checkCanMapType.getSymbols())) {
                    return;
                }
                if (IrTypeUtilsKt.isFunction(type)) {
                    if (variadic) {
                        reportUnsupportedType.invoke((Object)"not supported as variadic argument");
                        throw new KotlinNothingValueException();
                    }
                    SpecialBackendChecksTraversalKt.checkCanMapBlockType($this$checkCanMapType, type, typeLocation);
                    object = Unit.INSTANCE;
                } else {
                    if (InteropIrUtilsKt.isObjCReferenceType(type, $this$checkCanMapType.getTarget(), $this$checkCanMapType.getIrBuiltIns())) {
                        return;
                    }
                    reportUnsupportedType.invoke((Object)"doesn't correspond to any C type");
                    throw new KotlinNothingValueException();
                }
            }
        }
    }

    private static final Void reportUnsupportedType(BackendChecker $this$reportUnsupportedType, String reason, IrType type, TypeLocation location) {
        String typeLocation = SpecialBackendChecksTraversalKt.reportUnsupportedType$render(location);
        $this$reportUnsupportedType.reportError(location.getElement(), "type " + RenderIrElementKt.render$default(type, null, 1, null) + ' ' + typeLocation + " is not supported here" + (((CharSequence)reason).length() > 0 ? ": " + reason : ""));
        throw new KotlinNothingValueException();
    }

    private static final String reportUnsupportedType$render(TypeLocation $this$reportUnsupportedType_u24render) {
        String string;
        TypeLocation typeLocation = $this$reportUnsupportedType_u24render;
        if (typeLocation instanceof TypeLocation.FunctionArgument) {
            string = "";
        } else if (typeLocation instanceof TypeLocation.FunctionCallResult) {
            string = " of return value";
        } else if (typeLocation instanceof TypeLocation.FunctionPointerParameter) {
            string = " of callback parameter " + (((TypeLocation.FunctionPointerParameter)$this$reportUnsupportedType_u24render).getIndex() + 1);
        } else if (typeLocation instanceof TypeLocation.FunctionPointerReturnValue) {
            string = " of callback return value";
        } else if (typeLocation instanceof TypeLocation.ObjCMethodParameter) {
            string = " of overridden Objective-C method parameter";
        } else if (typeLocation instanceof TypeLocation.ObjCMethodReturnValue) {
            string = " of overridden Objective-C method return value";
        } else if (typeLocation instanceof TypeLocation.BlockParameter) {
            string = " of " + (((TypeLocation.BlockParameter)$this$reportUnsupportedType_u24render).getIndex() + 1) + " parameter in Objective-C block type" + SpecialBackendChecksTraversalKt.reportUnsupportedType$render(((TypeLocation.BlockParameter)$this$reportUnsupportedType_u24render).getBlockLocation());
        } else if (typeLocation instanceof TypeLocation.BlockReturnValue) {
            string = " of return value of Objective-C block type" + SpecialBackendChecksTraversalKt.reportUnsupportedType$render(((TypeLocation.BlockReturnValue)$this$reportUnsupportedType_u24render).getBlockLocation());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final /* synthetic */ void access$checkCanGenerateCFunction(BackendChecker $receiver, IrSimpleFunction function, IrSimpleFunction signature, boolean isObjCMethod, IrElement location) {
        SpecialBackendChecksTraversalKt.checkCanGenerateCFunction($receiver, function, signature, isObjCMethod, location);
    }

    public static final /* synthetic */ void access$checkCanGenerateObjCCall(BackendChecker $receiver, IrSimpleFunction method, IrFunctionAccessExpression call, List arguments) {
        SpecialBackendChecksTraversalKt.checkCanGenerateObjCCall($receiver, method, call, arguments);
    }

    public static final /* synthetic */ void access$checkCanGenerateCFunctionCallOrGlobalAccess(BackendChecker $receiver, IrCall expression, boolean isInvoke) {
        SpecialBackendChecksTraversalKt.checkCanGenerateCFunctionCallOrGlobalAccess($receiver, expression, isInvoke);
    }

    public static final /* synthetic */ void access$checkCanGenerateCFunctionPointer(BackendChecker $receiver, IrSimpleFunction function, IrExpression expression) {
        SpecialBackendChecksTraversalKt.checkCanGenerateCFunctionPointer($receiver, function, expression);
    }

    public static final /* synthetic */ Void access$reportUnsupportedType(BackendChecker $receiver, String reason, IrType type, TypeLocation location) {
        return SpecialBackendChecksTraversalKt.reportUnsupportedType($receiver, reason, type, location);
    }
}

