/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.registry.cloud;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.AppMode;
import com.intellij.internal.DebugAttachDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.util.registry.ManagedRegistryKt;
import com.intellij.platform.registry.cloud.ConfigRefreshActivity;
import com.intellij.platform.registry.cloud.ConfigRefreshServiceKt;
import com.intellij.util.ApplicationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "checkIsApplicable", "", "isRefreshNeeded", "", "intellij.platform.registry.cloud"})
@SourceDebugExtension(value={"SMAP\nactivities.kt\nKotlin\n*S Kotlin\n*F\n+ 1 activities.kt\ncom/intellij/platform/registry/cloud/ActivitiesKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,59:1\n13#2:60\n*S KotlinDebug\n*F\n+ 1 activities.kt\ncom/intellij/platform/registry/cloud/ActivitiesKt\n*L\n17#1:60\n*E\n"})
public final class ActivitiesKt {
    @NotNull
    private static final Logger LOG;

    private static final void checkIsApplicable() {
        boolean allowed;
        if (ConfigRefreshServiceKt.getDEBUG()) {
            LOG.warn("DEBUG mode of is enabled for cloud registry");
        }
        boolean bl = allowed = ConfigRefreshServiceKt.getDEBUG() || ActivitiesKt.isRefreshNeeded();
        if (!allowed) {
            ExtensionNotApplicableException extensionNotApplicableException = ExtensionNotApplicableException.create();
            Intrinsics.checkNotNullExpressionValue((Object)extensionNotApplicableException, (String)"create(...)");
            throw (Throwable)extensionNotApplicableException;
        }
    }

    private static final boolean isRefreshNeeded() {
        return !AppMode.isDevServer() && !PluginManagerCore.isRunningFromSources() && !ApplicationKt.getApplication().isUnitTestMode() && !ApplicationKt.getApplication().isHeadlessEnvironment() && !ApplicationKt.getApplication().isCommandLine() && !DebugAttachDetector.isAttached() && ManagedRegistryKt.getManagedRegistry() == null;
    }

    public static final /* synthetic */ void access$checkIsApplicable() {
        ActivitiesKt.checkIsApplicable();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConfigRefreshActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

