/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.fieldnameconstants;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFieldNameConstantsProcessor
extends AbstractClassProcessor {
    private static final String FIELD_NAME_CONSTANTS_INCLUDE = "lombok.experimental.FieldNameConstants.Include";
    private static final String FIELD_NAME_CONSTANTS_EXCLUDE = "lombok.experimental.FieldNameConstants.Exclude";

    AbstractFieldNameConstantsProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    @Override
    protected boolean supportAnnotationVariant(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(2);
        }
        if (null != psiAnnotation.findDeclaredAttributeValue("asEnum")) {
            return true;
        }
        return null != psiAnnotation.findAttributeValue("asEnum");
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(5);
        }
        return AbstractFieldNameConstantsProcessor.validateAnnotationOnRightType(psiClass, builder) && LombokProcessorUtil.isLevelVisible(psiAnnotation);
    }

    private static boolean validateAnnotationOnRightType(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(7);
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface()) {
            builder.addErrorMessage("inspection.message.field.name.constants.only.supported.on.class.or.enum", new Object[0]);
            return false;
        }
        return true;
    }

    @NotNull
    Collection<PsiMember> filterMembers(@NotNull PsiClass psiClass, PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(8);
        }
        ArrayList<PsiMember> result = new ArrayList<PsiMember>();
        boolean onlyExplicitlyIncluded = AbstractFieldNameConstantsProcessor.isOnlyExplicitlyIncluded(psiAnnotation);
        Collection<Object> psiMembers = psiClass.isRecord() ? List.of(psiClass.getRecordComponents()) : PsiClassUtil.collectClassFieldsIntern(psiClass);
        for (PsiMember psiMember : psiMembers) {
            if (!AbstractFieldNameConstantsProcessor.shouldUseField(psiMember, onlyExplicitlyIncluded)) continue;
            result.add(psiMember);
        }
        ArrayList<PsiMember> arrayList = result;
        if (arrayList == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static boolean shouldUseField(@NotNull PsiMember psiMember, boolean onlyExplicitlyIncluded) {
        if (psiMember == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(10);
        }
        boolean useField = true;
        if (onlyExplicitlyIncluded) {
            useField = PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiMember, FIELD_NAME_CONSTANTS_INCLUDE);
        } else {
            PsiModifierList modifierList = psiMember.getModifierList();
            if (null != modifierList) {
                useField = !modifierList.hasModifierProperty("static");
                useField &= !modifierList.hasModifierProperty("transient");
            }
            useField &= !StringUtil.notNullize((String)psiMember.getName()).startsWith("$");
            useField &= !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiMember, FIELD_NAME_CONSTANTS_EXCLUDE);
        }
        return useField;
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(11);
        }
        Collection<PsiAnnotation> result = super.collectProcessedAnnotations(psiClass);
        this.addFieldsAnnotation(result, psiClass, FIELD_NAME_CONSTANTS_INCLUDE, FIELD_NAME_CONSTANTS_EXCLUDE);
        Collection<PsiAnnotation> collection = result;
        if (collection == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        boolean onlyExplicitlyIncluded;
        PsiClass containingClass;
        if (psiField == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(13);
        }
        if (psiAnnotation == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(14);
        }
        if (null != (containingClass = psiField.getContainingClass()) && AbstractFieldNameConstantsProcessor.shouldUseField((PsiMember)psiField, onlyExplicitlyIncluded = AbstractFieldNameConstantsProcessor.isOnlyExplicitlyIncluded(psiAnnotation))) {
            return LombokPsiElementUsage.USAGE;
        }
        return LombokPsiElementUsage.NONE;
    }

    private static boolean isOnlyExplicitlyIncluded(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractFieldNameConstantsProcessor.$$$reportNull$$$0(15);
        }
        return PsiAnnotationUtil.getBooleanAnnotationValue(psiAnnotation, "onlyExplicitlyIncluded", false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/fieldnameconstants/AbstractFieldNameConstantsProcessor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/fieldnameconstants/AbstractFieldNameConstantsProcessor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMembers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "supportAnnotationVariant";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateAnnotationOnRightType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterMembers";
                break;
            }
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isOnlyExplicitlyIncluded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 12 -> new IllegalStateException(string);
        };
    }
}

