/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.impl.RecordAugmentProvider;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemProcessingSink;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.problem.ProblemValidationSink;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.processor.field.FieldProcessor;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFieldProcessor
extends AbstractProcessor
implements FieldProcessor {
    AbstractFieldProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    AbstractFieldProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass, @NotNull String equivalentAnnotationClass) {
        if (supportedClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(2);
        }
        if (supportedAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(3);
        }
        if (equivalentAnnotationClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(4);
        }
        super(supportedClass, supportedAnnotationClass, equivalentAnnotationClass);
    }

    @Override
    @NotNull
    public List<? super PsiElement> process(@NotNull PsiClass psiClass, @Nullable String nameHint) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(5);
        }
        ArrayList result = new ArrayList();
        Collection<Object> fields = psiClass.isRecord() ? RecordAugmentProvider.getFieldAugments((PsiClass)psiClass) : PsiClassUtil.collectClassFieldsIntern(psiClass);
        for (PsiField psiField : fields) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, this.getSupportedAnnotationClasses());
            if (null == psiAnnotation || !this.possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation, psiField) || !this.validate(psiAnnotation, psiField, new ProblemProcessingSink())) continue;
            this.generatePsiElements(psiField, psiAnnotation, result, nameHint);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private boolean possibleToGenerateElementNamed(@Nullable String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(8);
        }
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(9);
        }
        if (null == nameHint) {
            return true;
        }
        Collection<String> namesOfGeneratedElements = this.getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation, psiField);
        return namesOfGeneratedElements.isEmpty() || namesOfGeneratedElements.contains(nameHint);
    }

    protected abstract Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass var1, @NotNull PsiAnnotation var2, @NotNull PsiField var3);

    protected abstract void generatePsiElements(@NotNull PsiField var1, @NotNull PsiAnnotation var2, @NotNull List<? super PsiElement> var3, @Nullable String var4);

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(10);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, this.getSupportedAnnotationClasses());
            if (null == psiAnnotation) continue;
            result.add(psiAnnotation);
        }
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(12);
        }
        Collection<LombokProblem> result = Collections.emptyList();
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiField.class);
        if (null != psiField) {
            ProblemValidationSink problemNewBuilder = new ProblemValidationSink();
            this.validate(psiAnnotation, psiField, problemNewBuilder);
            result = problemNewBuilder.getProblems();
        }
        List<LombokProblem> list = result;
        if (list == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    protected abstract boolean validate(@NotNull PsiAnnotation var1, @NotNull PsiField var2, @NotNull ProblemSink var3);

    protected void validateOnXAnnotations(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemSink problemSink, @NotNull String parameterName) {
        if (psiAnnotation == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(14);
        }
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(15);
        }
        if (problemSink == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(16);
        }
        if (parameterName == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(17);
        }
        if (problemSink.deepValidation()) {
            Iterable<String> onMethodAnnotations;
            @NotNull List<PsiAnnotation> copyableAnnotations = LombokCopyableAnnotations.BASE_COPYABLE.collectCopyableAnnotations((PsiModifierListOwner)psiField, psiField.getContainingClass());
            if (!copyableAnnotations.isEmpty()) {
                Iterable<String> onXAnnotations = LombokProcessorUtil.getOnX(psiAnnotation, parameterName);
                List copyableAnnotationsFQNs = ContainerUtil.map(copyableAnnotations, PsiAnnotation::getQualifiedName);
                for (String copyableAnnotationFQN : copyableAnnotationsFQNs) {
                    for (String onXAnnotation : onXAnnotations) {
                        if (!onXAnnotation.startsWith(copyableAnnotationFQN)) continue;
                        problemSink.addErrorMessage("inspection.message.annotation.copy.duplicate", copyableAnnotationFQN);
                    }
                }
            }
            if (psiField.isDeprecated() && ContainerUtil.exists(onMethodAnnotations = LombokProcessorUtil.getOnX(psiAnnotation, "onMethod"), "java.lang.Deprecated"::equals)) {
                problemSink.addErrorMessage("inspection.message.annotation.copy.duplicate", "java.lang.Deprecated");
            }
        }
    }

    protected boolean validateExistingMethods(@NotNull PsiField psiField, @NotNull ProblemSink builder, boolean isGetter) {
        PsiClass psiClass;
        if (psiField == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(18);
        }
        if (builder == null) {
            AbstractFieldProcessor.$$$reportNull$$$0(19);
        }
        if (null != (psiClass = psiField.getContainingClass())) {
            List ownSignatures = (List)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
                List signatures = ContainerUtil.map(PsiClassUtil.collectClassMethodsIntern(psiClass), m -> MethodSignatureBackedByPsiMethod.create((PsiMethod)m, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                return new CachedValueProvider.Result((Object)signatures, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            });
            ArrayList<MethodSignatureBackedByPsiMethod> classMethods = new ArrayList<MethodSignatureBackedByPsiMethod>(ownSignatures);
            boolean isBoolean = PsiTypes.booleanType().equals((Object)psiField.getType());
            AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField);
            String fieldName = psiField.getName();
            Collection<String> accessorNames = isGetter ? LombokUtils.toAllGetterNames(accessorsInfo, fieldName, isBoolean) : LombokUtils.toAllSetterNames(accessorsInfo, fieldName, isBoolean);
            classMethods.removeIf(m -> !accessorNames.contains(m.getName()));
            int paramCount = isGetter ? 0 : 1;
            classMethods.removeIf(m -> AbstractFieldProcessor.checkLombokParameterCount(m, paramCount));
            classMethods.removeIf(definedMethod -> PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)definedMethod.getMethod(), "lombok.experimental.Tolerate"));
            if (!classMethods.isEmpty()) {
                String accessorName = isGetter ? LombokUtils.toGetterName(accessorsInfo, fieldName, isBoolean) : LombokUtils.toSetterName(accessorsInfo, fieldName, isBoolean);
                builder.addWarningMessage("inspection.message.not.generated.s.method.with.similar.name.s.already.exists", accessorName, classMethods.get(0));
                return false;
            }
        }
        return true;
    }

    private static boolean checkLombokParameterCount(MethodSignatureBackedByPsiMethod m, int paramCount) {
        int methodParameterCount = m.getParameterTypes().length;
        if (methodParameterCount != paramCount) {
            if (methodParameterCount > 0 && m.getMethod().getParameterList().getParameters()[methodParameterCount - 1].isVarArgs()) {
                return paramCount < methodParameterCount - 1;
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalentAnnotationClass";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/AbstractFieldProcessor";
                break;
            }
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 9: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/AbstractFieldProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "validateOnXAnnotations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "validateExistingMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 11, 13 -> new IllegalStateException(string);
        };
    }
}

