/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.initScript.listener;

import com.intellij.gradle.toolingExtension.impl.initScript.listener.RunAppTaskActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.JavaExec;
import org.gradle.process.CommandLineArgumentProvider;

public class ClasspathFileTaskActionListener
extends RunAppTaskActionListener {
    private final String myMainClass;
    private final String myIntelliJRtPath;

    public ClasspathFileTaskActionListener(String taskName, String mainClass, String intelliJRtPath) {
        super(taskName);
        this.myMainClass = mainClass;
        this.myIntelliJRtPath = intelliJRtPath;
    }

    @Override
    public File patchTaskClasspath(JavaExec task) throws IOException {
        File file = File.createTempFile("generated-", "-classpathFile");
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter(osw);){
            FileCollection classpath = task.getClasspath();
            Set classpathFiles = classpath.getFiles();
            classpathFiles.forEach(f -> writer.println(f.getPath()));
        }
        final ArrayList<String> args = new ArrayList<String>();
        args.add(file.getAbsolutePath());
        args.add(this.myMainClass);
        args.addAll(task.getArgs());
        task.setArgs(new ArrayList());
        task.getArgumentProviders().add(new CommandLineArgumentProvider(){

            public Iterable<String> asArguments() {
                return args;
            }
        });
        task.setProperty("main", (Object)"com.intellij.rt.execution.CommandLineWrapper");
        task.setClasspath((FileCollection)task.getProject().files(new Object[]{Arrays.asList(this.myIntelliJRtPath)}));
        return file;
    }
}

