/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.connectivity.ex.dataSource.artifacts;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.ClasspathModificationTracker;
import com.intellij.database.dataSource.EelParametersTuner;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aD\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\bH\u0000\u001a<\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0016"}, d2={"resolveMavenItem", "", "Ljava/nio/file/Path;", "dir", "defaultDir", "item", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactList$Item;", "download", "", "repos", "", "Lorg/eclipse/aether/repository/RemoteRepository;", "useEel", "resolveInDefaultDir", "consumer", "Lorg/jetbrains/idea/maven/aether/ProgressConsumer;", "createProgressConsumer", "url", "", "getArtifactKind", "Lorg/jetbrains/idea/maven/aether/ArtifactKind;", "classifier", "intellij.database.connectivity.ex"})
@SourceDebugExtension(value={"SMAP\nMavenItemResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenItemResolver.kt\ncom/intellij/database/connectivity/ex/dataSource/artifacts/MavenItemResolverKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1661#2,3:89\n1642#2,10:92\n1915#2:102\n1916#2:104\n1652#2:105\n1#3:103\n*S KotlinDebug\n*F\n+ 1 MavenItemResolver.kt\ncom/intellij/database/connectivity/ex/dataSource/artifacts/MavenItemResolverKt\n*L\n34#1:89,3\n62#1:92,10\n62#1:102\n62#1:104\n62#1:105\n62#1:103\n*E\n"})
public final class MavenItemResolverKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Path> resolveMavenItem(@NotNull Path dir, @NotNull Path defaultDir, @NotNull DatabaseArtifactList.Item item, boolean download, @NotNull List<RemoteRepository> repos, boolean useEel) throws Exception {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)defaultDir, (String)"defaultDir");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(repos, (String)"repos");
        String string = item.url;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
        ProgressConsumer consumer = MavenItemResolverKt.createProgressConsumer(download, string);
        Collection<Path> localPaths = MavenItemResolverKt.resolveInDefaultDir(defaultDir, item, download, consumer, repos);
        if (!useEel) {
            return localPaths;
        }
        ClasspathModificationTracker modificationService = ClasspathModificationTracker.Companion.getInstance();
        Iterable iterable = localPaths;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Path path = (Path)item$iv;
            void var18_18 = destination$iv;
            boolean bl = false;
            Path withPrefix = defaultDir.relativize((Path)it);
            Path expected = dir.resolve(withPrefix);
            if ((!Files.exists(expected, new LinkOption[0]) || modificationService.checkAndUpdate((Path)it)) && download) {
                Files.createDirectories(expected.getParent(), new FileAttribute[0]);
                Intrinsics.checkNotNull((Object)expected);
                EelPathUtils.transferLocalContentToRemote$default((Path)it, (EelPathUtils.TransferTarget)((EelPathUtils.TransferTarget)new EelPathUtils.TransferTarget.Explicit(expected)), (EelPathUtils.FileTransferAttributesStrategy)((EelPathUtils.FileTransferAttributesStrategy)EelParametersTuner.Companion.getAllPermissions()), null, (int)8, null);
            }
            var18_18.add(expected);
        }
        return destination$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Collection<Path> resolveInDefaultDir(Path defaultDir, DatabaseArtifactList.Item item, boolean download, ProgressConsumer consumer, List<RemoteRepository> repos) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        boolean shortForm;
        ArtifactRepositoryManager manager = new ArtifactRepositoryManager(defaultDir.toFile(), repos, consumer, !download);
        List list = StringUtil.split((String)item.url, (String)":");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"split(...)");
        List coords = list;
        boolean bl = shortForm = coords.size() == 3;
        if (!shortForm && coords.size() != 4) {
            throw new IOException("Illegal maven coordinates " + item.url + " should be group:artifact:version");
        }
        String version = shortForm ? (String)coords.get(2) : (String)coords.get(3);
        ArtifactKind kind = MavenItemResolverKt.getArtifactKind(item, shortForm ? "" : (String)coords.get(2));
        Collection collection = manager.resolveDependencyAsArtifactStrict((String)coords.get(0), (String)coords.get(1), version, kind, true, (List)new ArrayList());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"resolveDependencyAsArtifactStrict(...)");
        Iterable iterable = collection;
        boolean $i$f$mapNotNull = false;
        void var12_12 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            Artifact it = (Artifact)element$iv$iv;
            boolean bl3 = false;
            if (it.getFile().toPath() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
    }

    private static final ProgressConsumer createProgressConsumer(boolean download, String url) {
        ProgressConsumer progressConsumer;
        ProgressIndicator indicator;
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            ProgressIndicator progressIndicator2;
            ProgressIndicator it = progressIndicator2 = progressIndicator;
            boolean bl = false;
            Object[] objectArray = new Object[]{download ? 0 : 1, url};
            it.setText(DatabaseBundle.message("progress.text.choice.downloading.resolving", objectArray));
            v1 = progressIndicator2;
        } else {
            v1 = indicator = null;
        }
        if (indicator == null) {
            ProgressConsumer progressConsumer2 = ProgressConsumer.DEAF;
            progressConsumer = progressConsumer2;
            Intrinsics.checkNotNullExpressionValue((Object)progressConsumer2, (String)"DEAF");
        } else {
            progressConsumer = new ProgressConsumer(indicator){
                final /* synthetic */ ProgressIndicator $indicator;
                {
                    this.$indicator = $indicator;
                }

                public void consume(String message) {
                    this.$indicator.setText2(message);
                }

                public boolean isCanceled() {
                    return this.$indicator.isCanceled();
                }
            };
        }
        return progressConsumer;
    }

    private static final ArtifactKind getArtifactKind(DatabaseArtifactList.Item item, String classifier) throws IOException {
        String string = classifier;
        boolean bl = string != null ? ((CharSequence)string).length() == 0 : false;
        if (bl) {
            return ArtifactKind.ARTIFACT;
        }
        ArtifactKind artifactKind = ArtifactKind.find((String)classifier, (String)"jar");
        if (artifactKind == null && (artifactKind = ArtifactKind.find((String)"", (String)classifier)) == null) {
            throw new IOException("Unknown kind " + classifier + " in " + item.url);
        }
        return artifactKind;
    }
}

