/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.functional.logical;

import com.intellij.ide.structureView.logical.LogicalStructureElementsProvider;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.logical.OneOrManySpringBeansLogicalModel;
import com.intellij.spring.model.logical.SpringBeanLogicalModel;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/mvc/functional/logical/SpringFunctionalRouteBeanProvider;", "Lcom/intellij/ide/structureView/logical/LogicalStructureElementsProvider;", "Lcom/intellij/psi/PsiMethod;", "Lcom/intellij/spring/model/logical/OneOrManySpringBeansLogicalModel;", "<init>", "()V", "getElements", "", "parent", "intellij.spring.mvc.impl"})
public final class SpringFunctionalRouteBeanProvider
implements LogicalStructureElementsProvider<PsiMethod, OneOrManySpringBeansLogicalModel> {
    @NotNull
    public List<OneOrManySpringBeansLogicalModel> getElements(@NotNull PsiMethod parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (!parent.hasModifierProperty("static")) {
            return CollectionsKt.emptyList();
        }
        PsiType psiType = parent.getReturnType();
        if (psiType == null) {
            return CollectionsKt.emptyList();
        }
        PsiType type = psiType;
        if (PsiTypesUtil.classNameEquals((PsiType)type, (String)"org.springframework.web.servlet.function.RouterFunction")) {
            CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModel((PsiElement)parent);
            Intrinsics.checkNotNullExpressionValue((Object)commonSpringModel, (String)"getSpringModel(...)");
            CommonSpringModel springModel = commonSpringModel;
            List list = SpringModelSearchers.findBeans((CommonSpringModel)springModel, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byType((PsiType)type).searchInLibraries(false));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findBeans(...)");
            List beanPointers = list;
            for (SpringBeanPointer beanPointer : beanPointers) {
                UExpression it;
                UExpression uExpression;
                PsiElement psiElement = beanPointer.getPsiElement();
                PomTargetPsiElement pomTargetPsiElement = psiElement instanceof PomTargetPsiElement ? (PomTargetPsiElement)psiElement : null;
                PsiElement navigationElement = pomTargetPsiElement != null ? pomTargetPsiElement.getNavigationElement() : null;
                psiElement = UastContextKt.toUElement((PsiElement)navigationElement);
                UExpression uExpression2 = uExpression = psiElement instanceof UExpression ? (UExpression)psiElement : null;
                if (uExpression == null) continue;
                boolean bl = false;
                Ref.BooleanRef found = new Ref.BooleanRef();
                it.accept((UastVisitor)new AbstractUastVisitor(parent, found){
                    final /* synthetic */ PsiMethod $parent;
                    final /* synthetic */ Ref.BooleanRef $found;
                    {
                        this.$parent = $parent;
                        this.$found = $found;
                    }

                    public boolean visitExpression(UExpression node) {
                        String name;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        UCallExpression uCallExpression = node instanceof UCallExpression ? (UCallExpression)node : null;
                        String string = name = uCallExpression != null ? uCallExpression.getMethodName() : null;
                        if (Intrinsics.areEqual((Object)this.$parent.getName(), (Object)name) && Intrinsics.areEqual((Object)UastUtils.tryResolve((UElement)((UElement)node)), (Object)this.$parent)) {
                            this.$found.element = true;
                            return true;
                        }
                        return super.visitExpression(node);
                    }
                });
                if (!found.element) continue;
                CommonSpringBean commonSpringBean = beanPointer.getSpringBean();
                Intrinsics.checkNotNullExpressionValue((Object)commonSpringBean, (String)"getSpringBean(...)");
                CommonSpringBean springBean = commonSpringBean;
                return CollectionsKt.listOf((Object)new SpringBeanLogicalModel((PsiElement)parent, springBean));
            }
        }
        return CollectionsKt.emptyList();
    }
}

