/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.model.ModulesSorter;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/spring/mvc/model/DumpSpringModulesSorterAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "intellij.spring.mvc.impl"})
public final class DumpSpringModulesSorterAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null && SpringCommonUtils.isSpringConfigured((Project)project));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        ModulesSorter modulesSorter = ModulesSorter.Companion.getInstance(project2);
        String string = "SpringModulesSorterDump-%s.txt";
        Object[] objectArray = new Object[]{DateFormatUtil.formatDateTime((long)System.currentTimeMillis())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String fileName = string2;
        StringBuilder dump = new StringBuilder();
        modulesSorter.dump(dump);
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)dump);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project2, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project2).openEditor(descriptor, true);
    }
}

