/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.pathVariables;

import com.intellij.jam.JamService;
import com.intellij.microservices.jvm.pathvars.PathVariableConsumerInfo;
import com.intellij.microservices.jvm.pathvars.PathVariableContext;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.model.SpringUrlPathSpecificationProviderKt;
import com.intellij.spring.mvc.model.jam.MVCPathVariable;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.model.jam.SpringMVCModelAttribute;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeUrlPathSpecification;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J(\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006\u001f"}, d2={"Lcom/intellij/spring/mvc/pathVariables/SpringPathVariableContext;", "Lcom/intellij/microservices/jvm/pathvars/PathVariableContext;", "<init>", "()V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "getUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "getConsumedPathVariables", "", "", "Lcom/intellij/microservices/jvm/pathvars/PathVariableConsumerInfo;", "getUnconsumedPathVariablePsiElement", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "method", "pathVariableName", "getTextSegmentForHighlighting", "psiElement", "text", "getClassLevelVariables", "containingClass", "Lorg/jetbrains/uast/UClass;", "extractPathVariableUsageFromParameter", "uParameter", "Lorg/jetbrains/uast/UParameter;", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringPathVariableContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringPathVariableContext.kt\ncom/intellij/spring/mvc/pathVariables/SpringPathVariableContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,94:1\n1#2:95\n18#3:96\n*S KotlinDebug\n*F\n+ 1 SpringPathVariableContext.kt\ncom/intellij/spring/mvc/pathVariables/SpringPathVariableContext\n*L\n76#1:96\n*E\n"})
public final class SpringPathVariableContext
extends PathVariableContext {
    @NotNull
    public static final SpringPathVariableContext INSTANCE = new SpringPathVariableContext();

    private SpringPathVariableContext() {
        super("org.springframework.web.bind.annotation.PathVariable");
    }

    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SpringCommonUtils.isSpringConfigured((Module)module);
    }

    @NotNull
    public UrlPathContext getUrlPathContext(@NotNull UMethod uMethod) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        PsiMethod psiMethod = uMethod.getJavaPsi();
        UrlPathContext urlPathContext = SpringUrlPathSpecificationProviderKt.getSpringFrameworkUrlPathSpecification().getUrlPathContext((PsiElement)psiMethod);
        if (!urlPathContext.isEmpty()) {
            return urlPathContext;
        }
        return SpringExchangeUrlPathSpecification.INSTANCE.getUrlPathContext((PsiElement)psiMethod);
    }

    @NotNull
    public Map<String, PathVariableConsumerInfo> getConsumedPathVariables(@NotNull UMethod uMethod) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Map consumedPathVariables = super.getConsumedPathVariables(uMethod);
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)uMethod));
        if (uClass == null) {
            return consumedPathVariables;
        }
        UClass containingClass = uClass;
        return MapsKt.plus((Map)consumedPathVariables, this.getClassLevelVariables(containingClass));
    }

    @Nullable
    public Pair<PsiElement, TextRange> getUnconsumedPathVariablePsiElement(@NotNull UMethod method, @NotNull String pathVariableName) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pathVariableName, (String)"pathVariableName");
        RequestMapping.Method requestMapping = (RequestMapping.Method)JamService.getJamService((Project)method.getProject()).getJamElement(RequestMapping.METHOD_JAM_KEY, (PsiElement)method.getJavaPsi());
        RequestMapping.Method method2 = requestMapping;
        if (method2 == null || (method2 = method2.getIdentifyingAnnotation()) == null) {
            return null;
        }
        RequestMapping.Method annotation = method2;
        Object[] objectArray = new String[]{"value", "path"};
        for (String attributeName : CollectionsKt.listOf((Object[])objectArray)) {
            PsiAnnotationMemberValue declaredValue;
            if (annotation.findDeclaredAttributeValue(attributeName) == null) continue;
            if (declaredValue instanceof PsiArrayInitializerMemberValue) {
                PsiAnnotationMemberValue[] initializers;
                Intrinsics.checkNotNullExpressionValue((Object)((PsiArrayInitializerMemberValue)declaredValue).getInitializers(), (String)"getInitializers(...)");
                for (PsiAnnotationMemberValue initializer : initializers) {
                    PsiElement sourcePsi;
                    String string = initializer.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)("{" + pathVariableName + "}"), (boolean)false, (int)2, null) || UElementKt.getSourcePsiElement((UElement)UastContextKt.toUElement((PsiElement)((PsiElement)initializer))) == null) continue;
                    Pair<PsiElement, TextRange> pair = this.getTextSegmentForHighlighting(sourcePsi, pathVariableName);
                    if (pair == null) continue;
                    return pair;
                }
            }
            Pair<PsiElement, TextRange> pair = this.getTextSegmentForHighlighting((PsiElement)declaredValue, pathVariableName);
            if (pair == null) continue;
            return pair;
        }
        return super.getUnconsumedPathVariablePsiElement(method, pathVariableName);
    }

    private final Pair<PsiElement, TextRange> getTextSegmentForHighlighting(PsiElement psiElement, String text) {
        String attributeText = psiElement.getText();
        Intrinsics.checkNotNull((Object)attributeText);
        int start = StringsKt.indexOf$default((CharSequence)attributeText, (String)("{" + text + "}"), (int)0, (boolean)false, (int)6, null);
        if (start >= 0) {
            TextRange textRange = new TextRange(start, start + ("{" + text + "}").length());
            return TuplesKt.to((Object)psiElement, (Object)textRange);
        }
        return null;
    }

    private final Map<String, PathVariableConsumerInfo> getClassLevelVariables(UClass containingClass) {
        List list = RequestMapping.MODEL_ATTRIBUTE_METHODS_QUERY.findChildren(PsiElementRef.real((PsiElement)((PsiElement)containingClass.getJavaPsi())));
        Object object = list != null ? CollectionsKt.asSequence((Iterable)list) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)object, SpringPathVariableContext::getClassLevelVariables$lambda$0), SpringPathVariableContext::getClassLevelVariables$lambda$1), SpringPathVariableContext::getClassLevelVariables$lambda$2));
    }

    @Nullable
    public PathVariableConsumerInfo extractPathVariableUsageFromParameter(@NotNull UParameter uParameter) {
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        PathVariableConsumerInfo pathVariableConsumerInfo = super.extractPathVariableUsageFromParameter(uParameter);
        if (pathVariableConsumerInfo != null) {
            PathVariableConsumerInfo it = pathVariableConsumerInfo;
            boolean bl = false;
            return it;
        }
        UAnnotation uAnnotation = uParameter.findAnnotation("org.springframework.web.bind.annotation.MatrixVariable");
        if (uAnnotation == null) {
            return null;
        }
        UAnnotation matrixVariableUAnno = uAnnotation;
        UExpression pathVariableNameExpression = matrixVariableUAnno.findDeclaredAttributeValue("pathVar");
        Object object = pathVariableNameExpression;
        if (object == null || (object = UastUtils.evaluateString((UExpression)object)) == null) {
            return null;
        }
        Object pathVarName = object;
        return new PathVariableConsumerInfo((String)pathVarName, pathVariableNameExpression.getSourcePsi(), true);
    }

    private static final PsiMethod getClassLevelVariables$lambda$0(SpringMVCModelAttribute springMVCModelAttribute) {
        PsiElement $this$asSafely$iv = springMVCModelAttribute.getPsiElement();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        return (PsiMethod)psiElement;
    }

    private static final Sequence getClassLevelVariables$lambda$1(PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        return ArraysKt.asSequence((Object[])psiParameterArray);
    }

    private static final Pair getClassLevelVariables$lambda$2(PsiParameter param) {
        Pair pair;
        MVCPathVariable mVCPathVariable = (MVCPathVariable)MVCPathVariable.META.getJamElement((PsiModifierListOwner)param);
        if (mVCPathVariable != null) {
            MVCPathVariable pv = mVCPathVariable;
            boolean bl = false;
            String string = pv.getName();
            String string2 = pv.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-name>(...)");
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)param));
            pair = TuplesKt.to((Object)string, (Object)new PathVariableConsumerInfo(string2, (PsiElement)(uElement != null ? uElement.getSourcePsi() : null), false));
        } else {
            pair = null;
        }
        return pair;
    }
}

