/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.restTestClient;

import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientModel;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import com.intellij.spring.mvc.webClient.restTestClient.RestTestClientConstants;
import com.intellij.spring.mvc.webClient.restTestClient.RestTestClientUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0014J\b\u0010\u0017\u001a\u00020\u0005H\u0014J\b\u0010\u0018\u001a\u00020\u0005H\u0014J\b\u0010\u0019\u001a\u00020\u0005H\u0014J\b\u0010\u001a\u001a\u00020\u0013H\u0014J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bH\u0014J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000b2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J\b\u0010$\u001a\u00020\u0013H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/spring/mvc/webClient/restTestClient/RestTestClientModel;", "Lcom/intellij/spring/mvc/functional/webClient/WebClientModel;", "<init>", "()V", "HTTP_METHODS_PATTERN", "Lcom/intellij/patterns/uast/UCallExpressionPattern;", "HTTP_METHOD_PATTERN", "REST_TEST_CLIENT_CREATE_PATTERN", "REST_TEST_CLIENT_BUILDER_BASE_URL_PATTERN", "URL_BUILDER_FACTORY_PATTERN", "getEndpoints", "", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "group", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "findRestTestClientEndpoints", "holderPsi", "Lcom/intellij/psi/PsiElement;", "findBaseUrl", "", "uExpression", "Lorg/jetbrains/uast/UExpression;", "getCreatePattern", "getBuilderUrlPattern", "getHttpMethodsPattern", "getHttpMethodPattern", "getWebClientClassName", "getPackageBlackList", "getUrlApiMethods", "Lcom/intellij/psi/PsiMethod;", "module", "Lcom/intellij/openapi/module/Module;", "getApiClasses", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/jvm/cache/ScopedCacheValueHolder;", "getWebClientPackage", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nRestTestClientModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestTestClientModel.kt\ncom/intellij/spring/mvc/webClient/restTestClient/RestTestClientModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1391#2:99\n1480#2,5:100\n*S KotlinDebug\n*F\n+ 1 RestTestClientModel.kt\ncom/intellij/spring/mvc/webClient/restTestClient/RestTestClientModel\n*L\n67#1:99\n67#1:100,5\n*E\n"})
public final class RestTestClientModel
extends WebClientModel {
    @NotNull
    public static final RestTestClientModel INSTANCE = new RestTestClientModel();
    @NotNull
    private static final UCallExpressionPattern HTTP_METHODS_PATTERN;
    @NotNull
    private static final UCallExpressionPattern HTTP_METHOD_PATTERN;
    @NotNull
    private static final UCallExpressionPattern REST_TEST_CLIENT_CREATE_PATTERN;
    @NotNull
    private static final UCallExpressionPattern REST_TEST_CLIENT_BUILDER_BASE_URL_PATTERN;
    @NotNull
    private static final UCallExpressionPattern URL_BUILDER_FACTORY_PATTERN;

    private RestTestClientModel() {
    }

    @NotNull
    public final List<WebClientUrl> getEndpoints(@NotNull WebClientHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PsiElement holderPsi = group.getPsiElement();
        if (UastContextKt.toUElement((PsiElement)holderPsi) == null) {
            return CollectionsKt.emptyList();
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)holderPsi.getProject());
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)holderPsi, () -> RestTestClientModel.getEndpoints$lambda$0(holderPsi));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebClientUrl> findRestTestClientEndpoints(PsiElement holderPsi) {
        List list;
        HashSet methodCalls = new HashSet();
        Project project = holderPsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        for (PsiMethod apiMethod : RestTestClientUtils.INSTANCE.getRestTestClientMethods(project)) {
            methodCalls.addAll(SpringFunctionalSearchersUtils.findMethodCalls((PsiMethod)apiMethod, (SearchScope)((SearchScope)new LocalSearchScope(holderPsi))));
        }
        if (methodCalls.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = methodCalls;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                UCallExpression it = (UCallExpression)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.findUrl(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        return list;
    }

    @Override
    @Nullable
    public String findBaseUrl(@Nullable UExpression uExpression) {
        UExpression argument;
        String baseUrl;
        String string = baseUrl = super.findBaseUrl(uExpression);
        if (string != null) {
            return string;
        }
        UCallExpressionPattern[] uCallExpressionPatternArray = new UCallExpressionPattern[]{URL_BUILDER_FACTORY_PATTERN};
        UCallExpression firstCallExpressionsInChain = SpringFunctionalSearchersUtils.findFirstCallExpressionsInChain((UExpression)uExpression, (UCallExpressionPattern[])uCallExpressionPatternArray);
        if (firstCallExpressionsInChain != null && (argument = firstCallExpressionsInChain.getArgumentForParameter(0)) instanceof UReferenceExpression) {
            UCallExpression initExpression;
            PsiVariable resolve2;
            PsiElement psiElement = ((UReferenceExpression)argument).resolve();
            PsiVariable psiVariable = resolve2 = psiElement instanceof PsiVariable ? (PsiVariable)psiElement : null;
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)(psiVariable != null ? psiVariable.getInitializer() : null)), UExpression.class);
            UCallExpression uCallExpression = initExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
            return this.getExpressionValue((UExpression)(uCallExpression != null ? uCallExpression.getArgumentForParameter(0) : null));
        }
        return null;
    }

    @Override
    @NotNull
    protected UCallExpressionPattern getCreatePattern() {
        return REST_TEST_CLIENT_CREATE_PATTERN;
    }

    @Override
    @NotNull
    protected UCallExpressionPattern getBuilderUrlPattern() {
        return REST_TEST_CLIENT_BUILDER_BASE_URL_PATTERN;
    }

    @Override
    @NotNull
    protected UCallExpressionPattern getHttpMethodsPattern() {
        return HTTP_METHODS_PATTERN;
    }

    @Override
    @NotNull
    protected UCallExpressionPattern getHttpMethodPattern() {
        return HTTP_METHOD_PATTERN;
    }

    @Override
    @NotNull
    protected String getWebClientClassName() {
        return "org.springframework.test.web.servlet.client.RestTestClient";
    }

    @Override
    @NotNull
    protected List<String> getPackageBlackList() {
        return RestTestClientConstants.INSTANCE.getPACKAGE_SEARCH_BLACK_LIST();
    }

    @Override
    @NotNull
    protected List<PsiMethod> getUrlApiMethods(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return RestTestClientUtils.INSTANCE.getRestTestClientMethods(project);
    }

    @Override
    @NotNull
    public List<PsiClass> getApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return RestTestClientUtils.INSTANCE.getRestTestClientApiClasses(query);
    }

    @Override
    @NotNull
    protected String getWebClientPackage() {
        return "org.springframework.test.web.servlet.client";
    }

    private static final CachedValueProvider.Result getEndpoints$lambda$0(PsiElement $holderPsi) {
        return CachedValueProvider.Result.createSingleDependency(INSTANCE.findRestTestClientEndpoints($holderPsi), (Object)$holderPsi.getContainingFile());
    }

    static {
        UCallExpressionPattern uCallExpressionPattern = UastPatterns.callExpression();
        PsiMethodPattern psiMethodPattern = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)StandardPatterns.string().oneOf((Collection)WebClientModel.Companion.getHTTP_METHOD_NAMES()))).definedInClass("org.springframework.test.web.servlet.client.RestTestClient");
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern, (String)"definedInClass(...)");
        HTTP_METHODS_PATTERN = uCallExpressionPattern.withResolvedMethod((ElementPattern)psiMethodPattern, false);
        UCallExpressionPattern uCallExpressionPattern2 = UastPatterns.callExpression();
        PsiMethodPattern psiMethodPattern2 = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("method")).definedInClass("org.springframework.test.web.servlet.client.RestTestClient");
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern2, (String)"definedInClass(...)");
        HTTP_METHOD_PATTERN = uCallExpressionPattern2.withResolvedMethod((ElementPattern)psiMethodPattern2, false);
        UCallExpressionPattern uCallExpressionPattern3 = UastPatterns.callExpression();
        PsiMethodPattern psiMethodPattern3 = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("create")).definedInClass("org.springframework.test.web.servlet.client.RestTestClient");
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern3, (String)"definedInClass(...)");
        REST_TEST_CLIENT_CREATE_PATTERN = uCallExpressionPattern3.withResolvedMethod((ElementPattern)psiMethodPattern3, false);
        UCallExpressionPattern uCallExpressionPattern4 = UastPatterns.callExpression();
        PsiMethodPattern psiMethodPattern4 = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("baseUrl")).definedInClass("org.springframework.web.client.RestClient.Builder");
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern4, (String)"definedInClass(...)");
        REST_TEST_CLIENT_BUILDER_BASE_URL_PATTERN = uCallExpressionPattern4.withResolvedMethod((ElementPattern)psiMethodPattern4, false);
        UCallExpressionPattern uCallExpressionPattern5 = UastPatterns.callExpression();
        PsiMethodPattern psiMethodPattern5 = ((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName("uriBuilderFactory")).definedInClass("org.springframework.web.client.RestClient.Builder");
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodPattern5, (String)"definedInClass(...)");
        URL_BUILDER_FACTORY_PATTERN = uCallExpressionPattern5.withResolvedMethod((ElementPattern)psiMethodPattern5, false);
    }
}

