/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.data;

import org.jetbrains.annotations.Nullable;

public enum CodeState {
    compiled(0, ""),
    optimizable(1, "~"),
    optimized(2, "*");

    private final int myCode;
    private final String myPrefix;

    private CodeState(int code, String prefix) {
        this.myCode = code;
        this.myPrefix = prefix;
    }

    public int getCode() {
        return this.myCode;
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    @Nullable
    public static CodeState fromCode(int code) {
        for (CodeState state : CodeState.values()) {
            if (state.getCode() != code) continue;
            return state;
        }
        return null;
    }

    @Nullable
    public static CodeState fromStrState(String state) {
        for (CodeState codeState : CodeState.values()) {
            if (!codeState.getPrefix().equals(state)) continue;
            return codeState;
        }
        return null;
    }

    public static CodeState safeValueOf(String name) {
        try {
            return CodeState.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

