/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.frontend.split.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.platform.vcs.impl.shared.RepositoryId;
import com.intellij.platform.vcs.impl.shared.VcsMappingsHolder;
import com.intellij.vcs.git.frontend.split.changes.GitRepositoryChangesBrowserNode;
import com.intellij.vcs.git.repo.GitRepositoriesHolder;
import com.intellij.vcs.git.repo.GitRepositoryModel;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0014J\u0014\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/git/frontend/split/changes/GitRepositoryChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/SimpleChangesGroupingPolicy;", "Lcom/intellij/vcs/git/repo/GitRepositoryModel;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "repositoriesHolder", "Lcom/intellij/vcs/git/repo/GitRepositoriesHolder;", "mappingsHolder", "Lcom/intellij/platform/vcs/impl/shared/VcsMappingsHolder;", "getGroupRootValueFor", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "createGroupRootNode", "value", "Factory", "intellij.vcs.git.frontend.split"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryChangesGroupingPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryChangesGroupingPolicy.kt\ncom/intellij/vcs/git/frontend/split/changes/GitRepositoryChangesGroupingPolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,36:1\n1#2:37\n*E\n"})
public final class GitRepositoryChangesGroupingPolicy
extends SimpleChangesGroupingPolicy<GitRepositoryModel> {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoriesHolder repositoriesHolder;
    @NotNull
    private final VcsMappingsHolder mappingsHolder;

    public GitRepositoryChangesGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
        this.project = project;
        this.repositoriesHolder = GitRepositoriesHolder.Companion.getInstance(this.project);
        this.mappingsHolder = VcsMappingsHolder.Companion.getInstance(this.project);
    }

    @Nullable
    protected GitRepositoryModel getGroupRootValueFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        List repositories = this.repositoriesHolder.getAll();
        if (repositories.size() <= 1) {
            return null;
        }
        FilePath filePath = nodePath.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        RepositoryId repositoryId = this.mappingsHolder.getRepositoryIdFor(filePath);
        if (repositoryId == null) {
            return null;
        }
        RepositoryId repoId = repositoryId;
        return this.repositoriesHolder.get(repoId);
    }

    @NotNull
    protected ChangesBrowserNode<?> createGroupRootNode(@NotNull GitRepositoryModel value) {
        GitRepositoryChangesBrowserNode gitRepositoryChangesBrowserNode;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GitRepositoryChangesBrowserNode it = gitRepositoryChangesBrowserNode = new GitRepositoryChangesBrowserNode(this.project, value);
        boolean bl = false;
        it.markAsHelperNode();
        return (ChangesBrowserNode)gitRepositoryChangesBrowserNode;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/git/frontend/split/changes/GitRepositoryChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "<init>", "()V", "createGroupingPolicy", "Lcom/intellij/vcs/git/frontend/split/changes/GitRepositoryChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.vcs.git.frontend.split"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @NotNull
        public GitRepositoryChangesGroupingPolicy createGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new GitRepositoryChangesGroupingPolicy(project, model);
        }
    }
}

