/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.cs;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrSpreadArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.refactoring.DefaultGroovyVariableNameValidator;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\b\u0010\u0019\u001a\u00020\u0011H\u0016J\b\u0010\u001a\u001a\u00020\u0011H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/cs/SpreadArgumentFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "size", "", "<init>", "(I)V", "getSize", "()I", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "handleListLiteral", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/arguments/GrSpreadArgument;", "genReplaceText", "generateVariableName", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "generateFixLine", "varName", "getName", "getFamilyName", "intellij.groovy"})
public final class SpreadArgumentFix
extends PsiUpdateModCommandQuickFix {
    private final int size;

    public SpreadArgumentFix(int size) {
        this.size = size;
    }

    public final int getSize() {
        return this.size;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (!(element instanceof GrSpreadArgument)) {
            return;
        }
        GrArgumentList grArgumentList = (GrArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, GrArgumentList.class);
        if (grArgumentList == null) {
            return;
        }
        GrArgumentList grArgumentList2 = grArgumentList;
        String string = this.handleListLiteral((GrSpreadArgument)element);
        if (string == null && (string = this.genReplaceText((GrSpreadArgument)element)) == null) {
            return;
        }
        String replaceText = string;
        GrArgumentList grArgumentList3 = GroovyPsiElementFactory.getInstance(((GrSpreadArgument)element).getProject()).createArgumentListFromText(replaceText);
        Intrinsics.checkNotNullExpressionValue((Object)grArgumentList3, (String)"createArgumentListFromText(...)");
        GrArgumentList newArgumentList = grArgumentList3;
        grArgumentList2.replaceWithArgumentList(newArgumentList);
    }

    private final String handleListLiteral(GrSpreadArgument element) {
        GrExpression grExpression = element.getArgument();
        GrListOrMap grListOrMap = grExpression instanceof GrListOrMap ? (GrListOrMap)grExpression : null;
        if (grListOrMap == null) {
            return null;
        }
        GrListOrMap grListOrMap2 = grListOrMap;
        if (grListOrMap2.isMap()) {
            return null;
        }
        GrExpression[] grExpressionArray = grListOrMap2.getInitializers();
        Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"getInitializers(...)");
        return ArraysKt.joinToString$default((Object[])grExpressionArray, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, SpreadArgumentFix::handleListLiteral$lambda$0, (int)24, null);
    }

    private final String genReplaceText(GrSpreadArgument element) {
        GrStatementOwner grStatementOwner = (GrStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)element, GrStatementOwner.class);
        if (grStatementOwner == null) {
            return null;
        }
        GrStatementOwner grStatementOwner2 = grStatementOwner;
        PsiElement psiElement = PsiTreeUtil.findPrevParent((PsiElement)grStatementOwner2, (PsiElement)element);
        GrStatement grStatement = psiElement instanceof GrStatement ? (GrStatement)psiElement : null;
        if (grStatement == null) {
            return null;
        }
        GrStatement prevStatement = grStatement;
        GrExpression grExpression = element.getArgument();
        Intrinsics.checkNotNullExpressionValue((Object)grExpression, (String)"getArgument(...)");
        GrExpression expression = grExpression;
        String initializer = expression.getText();
        if (!(expression instanceof GrReferenceExpression) || !(((GrReferenceExpression)expression).resolve() instanceof GrVariable)) {
            GroovyPsiElementFactory groovyPsiElementFactory = GroovyPsiElementFactory.getInstance(element.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)groovyPsiElementFactory, (String)"getInstance(...)");
            GroovyPsiElementFactory factory = groovyPsiElementFactory;
            String fixVariableName = this.generateVariableName(element);
            GrStatement grStatement2 = factory.createStatementFromText("def " + fixVariableName + " = " + initializer);
            Intrinsics.checkNotNullExpressionValue((Object)grStatement2, (String)"createStatementFromText(...)");
            GrStatement varDefinition = grStatement2;
            grStatementOwner2.addStatementBefore(varDefinition, prevStatement);
            initializer = fixVariableName;
        }
        String string = initializer;
        Intrinsics.checkNotNull((Object)string);
        return this.generateFixLine(string);
    }

    private final String generateVariableName(GrExpression expression) {
        String string;
        DefaultGroovyVariableNameValidator validator = new DefaultGroovyVariableNameValidator(expression);
        String[] suggestedNames = GroovyNameSuggestionUtil.suggestVariableNameByType(expression.getType(), validator);
        Intrinsics.checkNotNull((Object)suggestedNames);
        if (!(suggestedNames.length == 0)) {
            String string2 = suggestedNames[0];
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        } else {
            string = "storedList";
        }
        return string;
    }

    private final String generateFixLine(String varName) {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)this.size)), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, arg_0 -> SpreadArgumentFix.generateFixLine$lambda$0(varName, arg_0), (int)24, null);
    }

    @NotNull
    public String getName() {
        String string = GroovyBundle.message("replace.with.get.at", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("replace.with.get.at", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final CharSequence handleListLiteral$lambda$0(GrExpression it) {
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final CharSequence generateFixLine$lambda$0(String $varName, int it) {
        return $varName + "[" + it + "]";
    }
}

