/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.style.string;

import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.style.string.GrStringStyleViolationInspection;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u001a.\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"QUOTE_TO_KIND", "", "", "Lorg/jetbrains/plugins/groovy/codeInspection/style/string/GrStringStyleViolationInspection$InspectionStringQuotationKind;", "findBestQuotationForEscaping", "Lkotlin/Pair;", "", "literalText", "fallbackKindForEscapedStrings", "mainStringKind", "countScores", "text", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nescaping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 escaping.kt\norg/jetbrains/plugins/groovy/codeInspection/style/string/EscapingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class EscapingKt {
    @NotNull
    private static final Map<String, GrStringStyleViolationInspection.InspectionStringQuotationKind> QUOTE_TO_KIND;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Pair<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> findBestQuotationForEscaping(@NotNull String literalText, @NotNull GrStringStyleViolationInspection.InspectionStringQuotationKind fallbackKindForEscapedStrings, @NotNull GrStringStyleViolationInspection.InspectionStringQuotationKind mainStringKind) {
        Map.Entry bestEscaping;
        Intrinsics.checkNotNullParameter((Object)literalText, (String)"literalText");
        Intrinsics.checkNotNullParameter((Object)((Object)fallbackKindForEscapedStrings), (String)"fallbackKindForEscapedStrings");
        Intrinsics.checkNotNullParameter((Object)((Object)mainStringKind), (String)"mainStringKind");
        String startQuote = GrStringUtil.getStartQuote(literalText);
        String unescapedText = GrStringUtil.unescapeString(GrStringUtil.removeQuotes(literalText));
        GrStringStyleViolationInspection.InspectionStringQuotationKind inspectionStringQuotationKind = QUOTE_TO_KIND.get(startQuote);
        if (inspectionStringQuotationKind == null) {
            return null;
        }
        GrStringStyleViolationInspection.InspectionStringQuotationKind currentQuotation = inspectionStringQuotationKind;
        Intrinsics.checkNotNull((Object)unescapedText);
        Map<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> scores = EscapingKt.countScores(unescapedText);
        Integer n = scores.get((Object)currentQuotation);
        if (n == null) return null;
        int currentScore = n;
        Map<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> map2 = scores;
        Object object = (arg_0, arg_1) -> EscapingKt.findBestQuotationForEscaping$lambda$1((arg_0, arg_1) -> EscapingKt.findBestQuotationForEscaping$lambda$0(mainStringKind, currentQuotation, fallbackKindForEscapedStrings, arg_0, arg_1), arg_0, arg_1);
        Map.Entry entry = bestEscaping = (Map.Entry)CollectionsKt.minWithOrNull((Iterable)map2.entrySet(), (Comparator)object);
        Map.Entry entry2 = entry;
        if (entry == null) return null;
        Object it = entry2;
        boolean bl = false;
        Pair pair = TuplesKt.to(it.getKey(), (Object)(currentScore - ((Number)it.getValue()).intValue()));
        entry2 = pair;
        if (pair == null) return null;
        it = object = entry2;
        boolean bl2 = false;
        if (((Number)it.getSecond()).intValue() < 0) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Object object2 = object;
        return object2;
    }

    private static final Map<GrStringStyleViolationInspection.InspectionStringQuotationKind, Integer> countScores(String text) {
        int doubleQuotes = 0;
        int singleQuotes = 0;
        int dollars = 0;
        int doubleQuoteSequence = 0;
        int tripleQuotes = 0;
        int tripleDoubleQuotes = 0;
        int singleQuoteSequence = 0;
        int slashes = 0;
        int reversedSlashes = 0;
        int n = text.length();
        block5: for (int j = 0; j < n; ++j) {
            char c = text.charAt(j);
            if (c == '\"') {
                ++doubleQuotes;
                ++doubleQuoteSequence;
            } else {
                tripleDoubleQuotes += doubleQuoteSequence / 3;
                doubleQuoteSequence = 0;
            }
            if (c == '\'') {
                ++singleQuotes;
                ++singleQuoteSequence;
            } else {
                tripleQuotes += singleQuoteSequence / 3;
                singleQuoteSequence = 0;
            }
            switch (c) {
                case '$': {
                    ++dollars;
                    continue block5;
                }
                case '/': {
                    ++slashes;
                    continue block5;
                }
                case '\\': {
                    ++reversedSlashes;
                }
            }
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOUBLE_QUOTED), (Object)(doubleQuotes + reversedSlashes + dollars)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SINGLE_QUOTED), (Object)(singleQuotes + reversedSlashes)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_QUOTED), (Object)(tripleQuotes * 3 + reversedSlashes)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED), (Object)(tripleDoubleQuotes * 3 + reversedSlashes + dollars)), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED), (Object)dollars), TuplesKt.to((Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SLASHY), (Object)slashes)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final int findBestQuotationForEscaping$lambda$0(GrStringStyleViolationInspection.InspectionStringQuotationKind $mainStringKind, GrStringStyleViolationInspection.InspectionStringQuotationKind $currentQuotation, GrStringStyleViolationInspection.InspectionStringQuotationKind $fallbackKindForEscapedStrings, Map.Entry entry, Map.Entry entry2) {
        Intrinsics.checkNotNull((Object)entry);
        GrStringStyleViolationInspection.InspectionStringQuotationKind leftKind = (GrStringStyleViolationInspection.InspectionStringQuotationKind)((Object)entry.getKey());
        int leftScore = ((Number)entry.getValue()).intValue();
        Intrinsics.checkNotNull((Object)entry2);
        GrStringStyleViolationInspection.InspectionStringQuotationKind rightKind = (GrStringStyleViolationInspection.InspectionStringQuotationKind)((Object)entry2.getKey());
        int rightScore = ((Number)entry2.getValue()).intValue();
        return leftScore == rightScore ? (leftKind == $mainStringKind ? -1 : (rightKind == $mainStringKind ? 1 : (leftKind == $currentQuotation ? -1 : (rightKind == $currentQuotation ? 1 : (leftKind == $fallbackKindForEscapedStrings ? -1 : (rightKind == $fallbackKindForEscapedStrings ? 1 : leftKind.toString().compareTo(rightKind.toString()))))))) : Intrinsics.compare((int)leftScore, (int)rightScore);
    }

    private static final int findBestQuotationForEscaping$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"'", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SINGLE_QUOTED)), TuplesKt.to((Object)"\"", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOUBLE_QUOTED)), TuplesKt.to((Object)"'''", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_QUOTED)), TuplesKt.to((Object)"\"\"\"", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.TRIPLE_DOUBLE_QUOTED)), TuplesKt.to((Object)"/", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.SLASHY)), TuplesKt.to((Object)"$/", (Object)((Object)GrStringStyleViolationInspection.InspectionStringQuotationKind.DOLLAR_SLASHY_QUOTED))};
        QUOTE_TO_KIND = MapsKt.toMap((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }
}

