/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.type;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.FileTypeInspectionDisablerKt;
import org.jetbrains.plugins.groovy.codeInspection.type.GroovyStaticTypeCheckVisitorBase;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J7\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/groovy/codeInspection/type/GroovyStaticTypeCheckVisitor;", "Lorg/jetbrains/plugins/groovy/codeInspection/type/GroovyStaticTypeCheckVisitorBase;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "<init>", "(Lcom/intellij/lang/annotation/AnnotationHolder;)V", "registerError", "", "location", "Lcom/intellij/psi/PsiElement;", "description", "", "fixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "highlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/codeInspection/LocalQuickFix;Lcom/intellij/codeInspection/ProblemHighlightType;)V", "intellij.groovy.psi"})
public final class GroovyStaticTypeCheckVisitor
extends GroovyStaticTypeCheckVisitorBase {
    @NotNull
    private final AnnotationHolder holder;

    public GroovyStaticTypeCheckVisitor(@NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    @Override
    protected void registerError(@NotNull PsiElement location, @InspectionMessage @NotNull String description, @Nullable LocalQuickFix[] fixes, @NotNull ProblemHighlightType highlightType) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)highlightType, (String)"highlightType");
        if (FileTypeInspectionDisablerKt.isTypecheckingDisabled(location.getContainingFile())) {
            return;
        }
        if (highlightType != ProblemHighlightType.GENERIC_ERROR) {
            return;
        }
        AnnotationBuilder annotationBuilder = this.holder.newAnnotation(HighlightSeverity.ERROR, description).range(location);
        Intrinsics.checkNotNullExpressionValue((Object)annotationBuilder, (String)"range(...)");
        AnnotationBuilder builder = annotationBuilder;
        if (fixes == null) {
            builder.create();
            return;
        }
        InspectionManager manager = InspectionManager.getInstance((Project)location.getProject());
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(location, description, fixes, highlightType, fixes.length == 1, false);
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        ProblemDescriptor problemDescriptor2 = problemDescriptor;
        for (LocalQuickFix fix : fixes) {
            Intrinsics.checkNotNullExpressionValue((Object)builder.newLocalQuickFix(fix, problemDescriptor2).registerFix(), (String)"registerFix(...)");
        }
        builder.create();
    }
}

