/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess.requests.CreateMethodFromUsageKt;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.GrCreateClassKind;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0012\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u001a\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0010H\u0002\u00a8\u0006\u0013"}, d2={"generateCreateClassActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "ref", "Lorg/jetbrains/plugins/groovy/lang/psi/GrReferenceElement;", "classExpected", "", "parent", "Lcom/intellij/psi/PsiElement;", "interfaceExpected", "annotationExpected", "resolvesToGroovy", "qualifier", "generateAddImportActions", "generateAddImportAction", "generateReferenceExpressionFixes", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "generateAddDynamicMemberAction", "referenceExpression", "intellij.groovy.psi"})
@SourceDebugExtension(value={"SMAP\nreferenceFixes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 referenceFixes.kt\norg/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/ReferenceFixesKt\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n66#2,2:163\n66#2,2:166\n1#3:165\n*S KotlinDebug\n*F\n+ 1 referenceFixes.kt\norg/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/ReferenceFixesKt\n*L\n35#1:163,2\n138#1:166,2\n*E\n"})
public final class ReferenceFixesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<IntentionAction> generateCreateClassActions(@NotNull GrReferenceElement<?> ref2) {
        Collection collection;
        Intrinsics.checkNotNullParameter(ref2, (String)"ref");
        PsiElement $this$parentOfType_u24default$iv = ref2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType2 = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GrPackageDefinition.class, (boolean)true) != null) {
            return CollectionsKt.emptyList();
        }
        GroovyQuickFixFactory factory = GroovyQuickFixFactory.getInstance();
        PsiElement parent = ref2.getParent();
        if (parent instanceof GrNewExpression && ((GrNewExpression)parent).getReferenceElement() == ref2) {
            return CollectionsKt.listOf((Object)factory.createClassFromNewAction((GrNewExpression)parent));
        }
        if (ref2 instanceof GrReferenceExpression && !ResolveUtil.canBeClassOrPackage((GrReferenceExpression)ref2)) {
            return CollectionsKt.emptyList();
        }
        if (ReferenceFixesKt.classExpected(parent)) {
            Object[] $i$f$parentOfType2 = new IntentionAction[]{factory.createClassFixAction(ref2, GrCreateClassKind.CLASS), factory.createClassFixAction(ref2, GrCreateClassKind.ENUM)};
            collection = CollectionsKt.listOf((Object[])$i$f$parentOfType2);
        } else if (ReferenceFixesKt.interfaceExpected(parent)) {
            Object[] $i$f$parentOfType2 = new IntentionAction[]{factory.createClassFixAction(ref2, GrCreateClassKind.INTERFACE), factory.createClassFixAction(ref2, GrCreateClassKind.TRAIT)};
            collection = CollectionsKt.listOf((Object[])$i$f$parentOfType2);
        } else if (ReferenceFixesKt.annotationExpected(parent)) {
            collection = CollectionsKt.listOf((Object)factory.createClassFixAction(ref2, GrCreateClassKind.ANNOTATION));
        } else {
            void var3_7;
            Object[] objectArray = new IntentionAction[]{factory.createClassFixAction(ref2, GrCreateClassKind.CLASS), factory.createClassFixAction(ref2, GrCreateClassKind.INTERFACE)};
            List result2 = CollectionsKt.mutableListOf((Object[])objectArray);
            if (!ref2.isQualified() || ReferenceFixesKt.resolvesToGroovy(ref2.getQualifier())) {
                ((Collection)result2).add(factory.createClassFixAction(ref2, GrCreateClassKind.TRAIT));
            }
            ((Collection)result2).add(factory.createClassFixAction(ref2, GrCreateClassKind.ENUM));
            ((Collection)result2).add(factory.createClassFixAction(ref2, GrCreateClassKind.ANNOTATION));
            if (GroovyConfigUtils.isAtLeastGroovy40(ref2)) {
                ((Collection)result2).add(factory.createClassFixAction(ref2, GrCreateClassKind.RECORD));
            }
            collection = (Collection)var3_7;
        }
        return collection;
    }

    private static final boolean classExpected(PsiElement parent) {
        return parent instanceof GrExtendsClause && !(((GrExtendsClause)parent).getParent() instanceof GrInterfaceDefinition);
    }

    private static final boolean interfaceExpected(PsiElement parent) {
        return parent instanceof GrImplementsClause || parent instanceof GrExtendsClause && ((GrExtendsClause)parent).getParent() instanceof GrInterfaceDefinition;
    }

    private static final boolean annotationExpected(PsiElement parent) {
        return parent instanceof GrAnnotation;
    }

    private static final boolean resolvesToGroovy(PsiElement qualifier) {
        boolean bl;
        PsiElement psiElement = qualifier;
        if (psiElement instanceof GrReferenceElement) {
            bl = ((GrReferenceElement)qualifier).resolve() instanceof GroovyPsiElement;
        } else if (psiElement instanceof GrExpression) {
            PsiClassType type;
            PsiType psiType = ((GrExpression)qualifier).getType();
            PsiClassType psiClassType = type = psiType instanceof PsiClassType ? (PsiClassType)psiType : null;
            bl = (psiClassType != null ? psiClassType.resolve() : null) instanceof GroovyPsiElement;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final Collection<IntentionAction> generateAddImportActions(@NotNull GrReferenceElement<?> ref2) {
        Collection collection;
        Intrinsics.checkNotNullParameter(ref2, (String)"ref");
        Object object = ReferenceFixesKt.generateAddImportAction(ref2);
        if (object != null) {
            IntentionAction p0 = object;
            boolean bl = false;
            List list = CollectionsKt.listOf((Object)p0);
            object = list;
            if (list != null) {
                collection = (Collection)object;
                return collection;
            }
        }
        collection = CollectionsKt.emptyList();
        return collection;
    }

    private static final IntentionAction generateAddImportAction(GrReferenceElement<?> ref2) {
        if (ref2.isQualified()) {
            return null;
        }
        String string = ref2.getReferenceName();
        if (string == null) {
            return null;
        }
        String referenceName = string;
        if (((CharSequence)referenceName).length() == 0) {
            return null;
        }
        if (!(ref2 instanceof GrCodeReferenceElement) && Character.isLowerCase(referenceName.charAt(0))) {
            return null;
        }
        return GroovyQuickFixFactory.getInstance().createGroovyAddImportAction(ref2);
    }

    @NotNull
    public static final Collection<IntentionAction> generateReferenceExpressionFixes(@NotNull GrReferenceExpression ref2) {
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        PsiClass psiClass = QuickfixUtil.findTargetClass(ref2);
        if (psiClass == null) {
            return CollectionsKt.emptyList();
        }
        PsiClass targetClass = psiClass;
        GroovyQuickFixFactory factory = GroovyQuickFixFactory.getInstance();
        ArrayList<IntentionAction> actions = new ArrayList<IntentionAction>();
        IntentionAction intentionAction = ReferenceFixesKt.generateAddDynamicMemberAction(ref2);
        if (intentionAction != null) {
            IntentionAction p0 = intentionAction;
            boolean bl = false;
            actions.add(p0);
        }
        if (!(targetClass instanceof SyntheticElement) || targetClass instanceof GroovyScriptClass) {
            PsiElement parent = ref2.getParent();
            if (parent instanceof GrMethodCall) {
                CollectionsKt.addAll((Collection)actions, (Iterable)CreateMethodFromUsageKt.generateCreateMethodActions((GrMethodCall)parent));
            } else {
                ((Collection)actions).add(factory.createCreateFieldFromUsageFix(ref2));
                if (PsiUtil.isAccessedForReading(ref2)) {
                    ((Collection)actions).add(factory.createCreateGetterFromUsageFix(ref2, targetClass));
                }
                if (PsiUtil.isLValue(ref2)) {
                    ((Collection)actions).add(factory.createCreateSetterFromUsageFix(ref2));
                }
            }
        }
        if (!ref2.isQualified()) {
            PsiElement $this$parentOfType_u24default$iv = ref2;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GrVariableDeclarationOwner.class, (boolean)true);
            if (!(owner instanceof GroovyFileBase) || ((GroovyFileBase)owner).isScript()) {
                ((Collection)actions).add(factory.createCreateLocalVariableFromUsageFix(ref2, owner));
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)ref2, GrMethod.class) != null) {
                ((Collection)actions).add(factory.createCreateParameterFromUsageFix(ref2));
            }
        }
        return actions;
    }

    private static final IntentionAction generateAddDynamicMemberAction(GrReferenceExpression referenceExpression) {
        PsiFile psiFile = referenceExpression.getContainingFile();
        if ((psiFile != null ? psiFile.getVirtualFile() : null) == null) {
            return null;
        }
        if (PsiUtil.isCall(referenceExpression)) {
            PsiType[] psiTypeArray = PsiUtil.getArgumentTypes(referenceExpression, false);
            if (psiTypeArray == null) {
                return null;
            }
            PsiType[] argumentTypes = psiTypeArray;
            return GroovyQuickFixFactory.getInstance().createDynamicMethodFix(referenceExpression, argumentTypes);
        }
        return GroovyQuickFixFactory.getInstance().createDynamicPropertyFix(referenceExpression);
    }
}

