/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.run.gradle.tooling;

import com.intellij.gradle.toolingExtension.impl.util.applicationPluginUtil.ApplicationPluginUtil;
import com.intellij.ktor.run.gradle.tooling.KtorApplicationGradleModel;
import com.intellij.ktor.run.gradle.tooling.KtorApplicationGradleModelImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.tooling.Message;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderContext;
import org.jetbrains.plugins.gradle.tooling.ModelBuilderService;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ktor/run/gradle/tooling/KtorModelBuilderService;", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderService;", "<init>", "()V", "canBuild", "", "modelName", "", "buildAll", "Lcom/intellij/ktor/run/gradle/tooling/KtorApplicationGradleModel;", "gradleProject", "Lorg/gradle/api/Project;", "reportErrorMessage", "", "project", "context", "Lorg/jetbrains/plugins/gradle/tooling/ModelBuilderContext;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.ktor.run.gradle.tooling"})
public final class KtorModelBuilderService
implements ModelBuilderService {
    public boolean canBuild(@NotNull String modelName) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        return Intrinsics.areEqual((Object)KtorApplicationGradleModel.class.getName(), (Object)modelName);
    }

    @Nullable
    public KtorApplicationGradleModel buildAll(@NotNull String modelName, @NotNull Project gradleProject) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)gradleProject, (String)"gradleProject");
        if (!gradleProject.getPlugins().hasPlugin("io.ktor.plugin")) {
            return null;
        }
        return new KtorApplicationGradleModelImpl(ApplicationPluginUtil.getMainClass((Project)gradleProject));
    }

    public void reportErrorMessage(@NotNull String modelName, @NotNull Project project, @NotNull ModelBuilderContext context, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)modelName, (String)"modelName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        context.getMessageReporter().createMessage().withGroup((ModelBuilderService)this).withKind(Message.Kind.WARNING).withTitle("Gradle import errors").withText("Unable to read 'mainClassName'").withException(exception).reportMessage(project);
    }
}

