/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization;

import com.intellij.notebooks.ui.editor.actions.command.mode.NotebookCellCaretTracker;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/notebooks/visualization/NotebookCellCaretTrackerImpl;", "Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookCellCaretTracker;", "<init>", "()V", "saveCaretPositions", "", "Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookCellCaretTracker$CellCaretPosition;", "editor", "Lcom/intellij/openapi/editor/Editor;", "restoreCaretPositions", "", "positions", "SavedPosition", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nNotebookCellCaretTrackerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookCellCaretTrackerImpl.kt\ncom/intellij/notebooks/visualization/NotebookCellCaretTrackerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n812#2,12:62\n1642#2,10:74\n1915#2:84\n1916#2:86\n1652#2:87\n2792#2,3:88\n812#2,12:91\n1#3:85\n*S KotlinDebug\n*F\n+ 1 NotebookCellCaretTrackerImpl.kt\ncom/intellij/notebooks/visualization/NotebookCellCaretTrackerImpl\n*L\n36#1:62,12\n36#1:74,10\n36#1:84\n36#1:86\n36#1:87\n38#1:88,3\n43#1:91,12\n36#1:85\n*E\n"})
public final class NotebookCellCaretTrackerImpl
implements NotebookCellCaretTracker {
    @Override
    @Nullable
    public List<NotebookCellCaretTracker.CellCaretPosition> saveCaretPositions(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        if (!NotebookCellLines.Companion.hasSupport(document)) {
            return null;
        }
        Document document2 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(document2);
        NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(editor);
        if (notebookIntervalPointerFactory == null) {
            return null;
        }
        NotebookIntervalPointerFactory pointerFactory = notebookIntervalPointerFactory;
        List positions = new ArrayList();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            NotebookCellLines.Interval interval;
            int offset = caret.getOffset();
            int line = editor.getDocument().getLineNumber(offset);
            if (cellLines.getCellByLineNumber(line) == null) continue;
            NotebookIntervalPointer pointer = pointerFactory.create(interval);
            Document document3 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
            int offsetInCell = offset - interval.getCellStartOffset(document3);
            positions.add(new SavedPosition(pointer, offsetInCell));
        }
        return positions;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean restoreCaretPositions(@NotNull Editor editor, @NotNull List<? extends NotebookCellCaretTracker.CellCaretPosition> positions) {
        void $this$filterIsInstanceTo$iv$iv;
        boolean isNewCell;
        Object it;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(positions, (String)"positions");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        if (!NotebookCellLines.Companion.hasSupport(document)) {
            return false;
        }
        Document document2 = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(document2);
        int currentLine = editor.getDocument().getLineNumber(editor.getCaretModel().getOffset());
        NotebookCellLines.Interval currentCell = cellLines.getCellByLineNumber(currentLine);
        Iterable $this$filterIsInstance$iv = positions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof SavedPosition)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NotebookCellLines.Interval it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SavedPosition it2 = (SavedPosition)element$iv$iv;
            boolean bl2 = false;
            if (it2.getIntervalPointer().get() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List savedPointers = (List)destination$iv$iv;
        if (currentCell != null) {
            Iterable $this$none$iv = savedPointers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                return false;
            }
            destination$iv$iv = $this$none$iv.iterator();
            do {
                if (!destination$iv$iv.hasNext()) return false;
                Object element$iv = destination$iv$iv.next();
                it = (NotebookCellLines.Interval)element$iv;
                boolean bl = false;
            } while (!(((NotebookCellLines.Interval)it).getOrdinal() == currentCell.getOrdinal()));
            boolean bl = false;
            if (bl) {
                return false;
            }
        }
        boolean bl = isNewCell = false;
        if (isNewCell) {
            return false;
        }
        List validOffsets = new ArrayList();
        Iterable $this$filterIsInstance$iv2 = positions;
        boolean $i$f$filterIsInstance2 = false;
        it = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof SavedPosition)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        for (SavedPosition position : (List)destination$iv$iv2) {
            NotebookCellLines.Interval interval;
            if (position.getIntervalPointer().get() == null) continue;
            Document document3 = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
            int cellStartOffset = interval.getCellStartOffset(document3);
            int offset = cellStartOffset + position.getOffsetInCell();
            boolean bl4 = 0 <= offset ? offset <= editor.getDocument().getTextLength() : false;
            if (!bl4) continue;
            validOffsets.add(offset);
        }
        if (validOffsets.isEmpty()) {
            return false;
        }
        editor.getCaretModel().moveToOffset(((Number)CollectionsKt.first((List)validOffsets)).intValue());
        int i = 1;
        int n = validOffsets.size();
        while (i < n) {
            editor.getCaretModel().addCaret(editor.offsetToVisualPosition(((Number)validOffsets.get(i)).intValue()));
            ++i;
        }
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/notebooks/visualization/NotebookCellCaretTrackerImpl$SavedPosition;", "Lcom/intellij/notebooks/ui/editor/actions/command/mode/NotebookCellCaretTracker$CellCaretPosition;", "intervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "offsetInCell", "", "<init>", "(Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;I)V", "getIntervalPointer", "()Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "getOffsetInCell", "()I", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.notebooks.visualization"})
    private static final class SavedPosition
    implements NotebookCellCaretTracker.CellCaretPosition {
        @NotNull
        private final NotebookIntervalPointer intervalPointer;
        private final int offsetInCell;

        public SavedPosition(@NotNull NotebookIntervalPointer intervalPointer, int offsetInCell) {
            Intrinsics.checkNotNullParameter((Object)intervalPointer, (String)"intervalPointer");
            this.intervalPointer = intervalPointer;
            this.offsetInCell = offsetInCell;
        }

        @NotNull
        public final NotebookIntervalPointer getIntervalPointer() {
            return this.intervalPointer;
        }

        public final int getOffsetInCell() {
            return this.offsetInCell;
        }

        @NotNull
        public final NotebookIntervalPointer component1() {
            return this.intervalPointer;
        }

        public final int component2() {
            return this.offsetInCell;
        }

        @NotNull
        public final SavedPosition copy(@NotNull NotebookIntervalPointer intervalPointer, int offsetInCell) {
            Intrinsics.checkNotNullParameter((Object)intervalPointer, (String)"intervalPointer");
            return new SavedPosition(intervalPointer, offsetInCell);
        }

        public static /* synthetic */ SavedPosition copy$default(SavedPosition savedPosition, NotebookIntervalPointer notebookIntervalPointer, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                notebookIntervalPointer = savedPosition.intervalPointer;
            }
            if ((n2 & 2) != 0) {
                n = savedPosition.offsetInCell;
            }
            return savedPosition.copy(notebookIntervalPointer, n);
        }

        @NotNull
        public String toString() {
            return "SavedPosition(intervalPointer=" + this.intervalPointer + ", offsetInCell=" + this.offsetInCell + ")";
        }

        public int hashCode() {
            int result = this.intervalPointer.hashCode();
            result = result * 31 + Integer.hashCode(this.offsetInCell);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SavedPosition)) {
                return false;
            }
            SavedPosition savedPosition = (SavedPosition)other;
            if (!Intrinsics.areEqual((Object)this.intervalPointer, (Object)savedPosition.intervalPointer)) {
                return false;
            }
            return this.offsetInCell == savedPosition.offsetInCell;
        }
    }
}

