/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.outputs;

import com.intellij.notebooks.visualization.outputs.NotebookOutputDefaultScrollPane;
import com.intellij.notebooks.visualization.outputs.NotebookOutputScrollPanesKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0002'(B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020!H\u0002J#\u0010\"\u001a\u0004\u0018\u0001H#\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%H\u0002\u00a2\u0006\u0002\u0010&R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputDefaultScrollPane;", "view", "Ljava/awt/Component;", "validateRoot", "", "<init>", "(Ljava/awt/Component;Z)V", "latestMouseWheelEventTime", "", "mouseEnteredTime", "reachedTopOrBottomTime", "consequentialUpRotationEvents", "", "consequentialDownRotationEvents", "consequentialScrollsSensitivity", "threshold", "isScrollCaptured", "mouseAdapter", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane$MyMouseHandler;", "containerAdapter", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane$MyContainerAdapter;", "processMouseWheelEvent", "", "e", "Ljava/awt/event/MouseWheelEvent;", "handleScrollEventTopBottomAware", "hasReachedTop", "hasReachedBottom", "rememberRotationDirection", "isUpRotation", "isDownRotation", "delegateToParentScrollPane", "Ljava/awt/event/MouseEvent;", "findParentOfType", "T", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "MyMouseHandler", "MyContainerAdapter", "intellij.notebooks.visualization"})
public class NotebookOutputNonStickyScrollPane
extends NotebookOutputDefaultScrollPane {
    private long latestMouseWheelEventTime;
    private long mouseEnteredTime;
    private long reachedTopOrBottomTime;
    private int consequentialUpRotationEvents;
    private int consequentialDownRotationEvents;
    private final int consequentialScrollsSensitivity;
    private final long threshold;
    private boolean isScrollCaptured;
    @NotNull
    private final MyMouseHandler mouseAdapter;
    @NotNull
    private final MyContainerAdapter containerAdapter;

    public NotebookOutputNonStickyScrollPane(@NotNull Component view, boolean validateRoot) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super(view, validateRoot);
        this.consequentialScrollsSensitivity = 2;
        this.threshold = Registry.Companion.get("python.ds.jupyter.scrolling.innerScrollCooldownTime").asInteger();
        this.mouseAdapter = new MyMouseHandler();
        this.containerAdapter = new MyContainerAdapter();
        NotebookOutputScrollPanesKt.access$recursivelyAddMouseListenerToComponent((JComponent)((Object)this), (MouseListener)((Object)this.mouseAdapter));
        NotebookOutputScrollPanesKt.access$recursivelyAddMouseMotionListenerToComponent((JComponent)((Object)this), (MouseMotionListener)((Object)this.mouseAdapter));
        NotebookOutputScrollPanesKt.access$recursivelyAddContainerListenerToComponent((JComponent)((Object)this), this.containerAdapter);
    }

    public /* synthetic */ NotebookOutputNonStickyScrollPane(Component component, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(component, bl);
    }

    protected void processMouseWheelEvent(@NotNull MouseWheelEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.rememberRotationDirection(e);
        long eventTime = e.getWhen();
        if (this.isScrollCaptured) {
            this.handleScrollEventTopBottomAware(e);
        } else if (eventTime - this.mouseEnteredTime < this.threshold || eventTime - this.latestMouseWheelEventTime < this.threshold) {
            this.latestMouseWheelEventTime = eventTime;
            this.delegateToParentScrollPane(e);
        } else {
            this.isScrollCaptured = true;
            this.handleScrollEventTopBottomAware(e);
        }
    }

    private final void handleScrollEventTopBottomAware(MouseWheelEvent e) {
        if (this.hasReachedTop() || this.hasReachedBottom()) {
            if (this.reachedTopOrBottomTime == 0L) {
                this.reachedTopOrBottomTime = e.getWhen();
            } else {
                long delta = e.getWhen() - this.reachedTopOrBottomTime;
                if (delta > this.threshold / (long)10) {
                    super.processMouseWheelEvent(e);
                } else {
                    this.reachedTopOrBottomTime = e.getWhen();
                }
            }
        } else {
            this.reachedTopOrBottomTime = 0L;
            super.processMouseWheelEvent(e);
        }
    }

    private final boolean hasReachedTop() {
        if (this.consequentialDownRotationEvents > this.consequentialScrollsSensitivity) {
            return false;
        }
        if (this.verticalScrollBar == null) {
            return false;
        }
        return this.verticalScrollBar.getValue() == this.verticalScrollBar.getMinimum();
    }

    private final boolean hasReachedBottom() {
        if (this.consequentialUpRotationEvents > this.consequentialScrollsSensitivity) {
            return false;
        }
        if (this.verticalScrollBar == null) {
            return false;
        }
        return this.verticalScrollBar.getValue() == this.verticalScrollBar.getMaximum() - this.verticalScrollBar.getModel().getExtent();
    }

    private final void rememberRotationDirection(MouseWheelEvent e) {
        if (this.isUpRotation(e)) {
            this.consequentialDownRotationEvents = 0;
            int n = this.consequentialUpRotationEvents;
            this.consequentialUpRotationEvents = n + 1;
        } else if (this.isDownRotation(e)) {
            this.consequentialUpRotationEvents = 0;
            int n = this.consequentialDownRotationEvents;
            this.consequentialDownRotationEvents = n + 1;
        }
    }

    private final boolean isUpRotation(MouseWheelEvent e) {
        return e.getWheelRotation() < 0;
    }

    private final boolean isDownRotation(MouseWheelEvent e) {
        return e.getWheelRotation() > 0;
    }

    private final void delegateToParentScrollPane(MouseEvent e) {
        JScrollPane parentScrollPane = this.findParentOfType(JScrollPane.class);
        if (parentScrollPane != null) {
            e.setSource(parentScrollPane);
            parentScrollPane.dispatchEvent(e);
        }
    }

    private final <T> T findParentOfType(Class<T> type) {
        if (this.getParent() == null) {
            return null;
        }
        return (T)ComponentUtil.getParentOfType(type, (Component)this.getParent());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane$MyContainerAdapter;", "Ljava/awt/event/ContainerAdapter;", "<init>", "(Lcom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane;)V", "componentAdded", "", "e", "Ljava/awt/event/ContainerEvent;", "componentRemoved", "intellij.notebooks.visualization"})
    public final class MyContainerAdapter
    extends ContainerAdapter {
        @Override
        public void componentAdded(@NotNull ContainerEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component = e.getChild();
                JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
                if (jComponent == null) break block0;
                component = jComponent;
                NotebookOutputNonStickyScrollPane notebookOutputNonStickyScrollPane = NotebookOutputNonStickyScrollPane.this;
                Component it = component;
                boolean bl = false;
                NotebookOutputScrollPanesKt.access$recursivelyAddMouseListenerToComponent((JComponent)it, (MouseListener)((Object)notebookOutputNonStickyScrollPane.mouseAdapter));
                NotebookOutputScrollPanesKt.access$recursivelyAddMouseMotionListenerToComponent((JComponent)it, (MouseMotionListener)((Object)notebookOutputNonStickyScrollPane.mouseAdapter));
            }
        }

        @Override
        public void componentRemoved(@NotNull ContainerEvent e) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component component = e.getChild();
                JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
                if (jComponent == null) break block0;
                JComponent it = jComponent;
                boolean bl = false;
                NotebookOutputScrollPanesKt.access$recursivelyRemoveListeners(it);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\n\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane$MyMouseHandler;", "Lcom/intellij/util/ui/MouseEventHandler;", "<init>", "(Lcom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane;)V", "mouseEntered", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "mousePressed", "mouseMoved", "handle", "contentFitsViewport", "", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nNotebookOutputScrollPanes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookOutputScrollPanes.kt\ncom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane$MyMouseHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,319:1\n1#2:320\n18#3:321\n*S KotlinDebug\n*F\n+ 1 NotebookOutputScrollPanes.kt\ncom/intellij/notebooks/visualization/outputs/NotebookOutputNonStickyScrollPane$MyMouseHandler\n*L\n230#1:321\n*E\n"})
    public final class MyMouseHandler
    extends MouseEventHandler {
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (NotebookOutputNonStickyScrollPane.this.mouseEnteredTime == 0L) {
                NotebookOutputNonStickyScrollPane.this.mouseEnteredTime = e.getWhen();
                NotebookOutputNonStickyScrollPane.this.latestMouseWheelEventTime = 0L;
            }
            super.mouseEntered(e);
        }

        public void mouseExited(@NotNull MouseEvent e) {
            block4: {
                block5: {
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (NotebookOutputNonStickyScrollPane.this.isShowing()) break block3;
                        NotebookOutputNonStickyScrollPane.this.delegateToParentScrollPane(e);
                        break block4;
                    }
                    Point eventPointOnScreen = new Point(e.getXOnScreen(), e.getYOnScreen());
                    IntRange xRange = new IntRange(NotebookOutputNonStickyScrollPane.this.getLocationOnScreen().x, NotebookOutputNonStickyScrollPane.this.getLocationOnScreen().x + NotebookOutputNonStickyScrollPane.this.getWidth());
                    IntRange yRange = new IntRange(NotebookOutputNonStickyScrollPane.this.getLocationOnScreen().y, NotebookOutputNonStickyScrollPane.this.getLocationOnScreen().y + NotebookOutputNonStickyScrollPane.this.getHeight());
                    int n = xRange.getFirst();
                    int n2 = xRange.getLast();
                    int n3 = eventPointOnScreen.x;
                    boolean bl = n <= n3 ? n3 <= n2 : false;
                    if (!bl) break block5;
                    n = yRange.getFirst();
                    n2 = yRange.getLast();
                    n3 = eventPointOnScreen.y;
                    if (n <= n3 ? n3 <= n2 : false) break block4;
                }
                NotebookOutputNonStickyScrollPane.this.mouseEnteredTime = 0L;
                NotebookOutputNonStickyScrollPane.this.latestMouseWheelEventTime = 0L;
                NotebookOutputNonStickyScrollPane.this.isScrollCaptured = false;
            }
            super.mouseExited(e);
        }

        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            NotebookOutputNonStickyScrollPane.this.isScrollCaptured = true;
            super.mousePressed(e);
        }

        public void mouseMoved(@Nullable MouseEvent e) {
            if (!this.contentFitsViewport()) {
                NotebookOutputNonStickyScrollPane.this.isScrollCaptured = true;
            }
            super.mouseMoved(e);
        }

        protected void handle(@NotNull MouseEvent e) {
            block2: {
                MouseEvent mouseEvent;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Object object = e.getSource();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.awt.Component");
                Component source = (Component)object;
                MouseEvent it = mouseEvent = e;
                boolean bl = false;
                Object object2 = !it.isConsumed() ? mouseEvent : null;
                if (object2 == null || (object2 = ((EventObject)object2).getSource()) == null) break block2;
                Object $this$asSafely$iv = object2;
                boolean $i$f$asSafely = false;
                Object object3 = $this$asSafely$iv;
                if (!(object3 instanceof Component)) {
                    object3 = null;
                }
                if ((object2 = (Component)object3) != null && (object2 = ((Component)object2).getParent()) != null) {
                    Object it2 = object2;
                    boolean bl2 = false;
                    Point adjustedPoint = SwingUtilities.convertPoint(source, e.getPoint(), (Component)it2);
                    ((Component)it2).dispatchEvent(new MouseEvent((Component)it2, e.getID(), e.getWhen(), e.getModifiersEx(), adjustedPoint.x, adjustedPoint.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
            }
        }

        private final boolean contentFitsViewport() {
            Component component = NotebookOutputNonStickyScrollPane.this.viewport.getView();
            if (component == null) {
                return true;
            }
            Component view = component;
            Rectangle viewRect = NotebookOutputNonStickyScrollPane.this.viewport.getViewRect();
            return viewRect.x == 0 && viewRect.y == 0 && viewRect.height == view.getHeight() && viewRect.width == view.getWidth();
        }
    }
}

