/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.parsing.modifiers;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.LineTerminators;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.psi.tree.IElementType;
import java.util.EnumSet;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructureLeaf;", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "allowNewlineAfter", "", "<init>", "(Lcom/intellij/psi/tree/IElementType;Z)V", "parseOptimistically", "Ljava/util/EnumSet;", "Lcom/intellij/lang/javascript/parsing/modifiers/JSModifiersStructure$JSModifiersParseResult;", "builder", "Lcom/intellij/lang/PsiBuilder;", "parse", "isPossibleLookahead", "Ljava/util/function/Predicate;", "getResultForToken", "intellij.javascript.parser"})
public final class JSModifiersStructureLeaf
implements JSModifiersStructure {
    @NotNull
    private final IElementType tokenType;
    private final boolean allowNewlineAfter;

    @JvmOverloads
    public JSModifiersStructureLeaf(@NotNull IElementType tokenType, boolean allowNewlineAfter) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        this.tokenType = tokenType;
        this.allowNewlineAfter = allowNewlineAfter;
    }

    public /* synthetic */ JSModifiersStructureLeaf(IElementType iElementType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(iElementType, bl);
    }

    @Override
    @NotNull
    public EnumSet<JSModifiersStructure.JSModifiersParseResult> parseOptimistically(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (this.isPossibleLookahead(builder)) {
            builder.advanceLexer();
            return this.getResultForToken();
        }
        EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet = EnumSet.noneOf(JSModifiersStructure.JSModifiersParseResult.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        return enumSet;
    }

    @Override
    @NotNull
    public EnumSet<JSModifiersStructure.JSModifiersParseResult> parse(@NotNull PsiBuilder builder, @NotNull Predicate<? super PsiBuilder> isPossibleLookahead) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter(isPossibleLookahead, (String)"isPossibleLookahead");
        if (this.isPossibleLookahead(builder)) {
            PsiBuilder.Marker marker = builder.mark();
            Intrinsics.checkNotNullExpressionValue((Object)marker, (String)"mark(...)");
            PsiBuilder.Marker temp = marker;
            builder.advanceLexer();
            if (isPossibleLookahead.test((PsiBuilder)builder)) {
                temp.drop();
                return this.getResultForToken();
            }
            temp.rollbackTo();
        }
        EnumSet<JSModifiersStructure.JSModifiersParseResult> enumSet = EnumSet.noneOf(JSModifiersStructure.JSModifiersParseResult.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
        return enumSet;
    }

    private final EnumSet<JSModifiersStructure.JSModifiersParseResult> getResultForToken() {
        EnumSet<Enum> enumSet;
        JSModifiersStructure.JSModifiersParseResult resultForToken;
        JSModifiersStructure.JSModifiersParseResult jSModifiersParseResult = this.tokenType == JSTokenTypes.ASYNC_KEYWORD ? JSModifiersStructure.JSModifiersParseResult.ASYNC_FOUND : (this.tokenType == JSTokenTypes.MULT ? JSModifiersStructure.JSModifiersParseResult.MULT_FOUND : (resultForToken = this.tokenType == JSTokenTypes.GET_KEYWORD || this.tokenType == JSTokenTypes.SET_KEYWORD ? JSModifiersStructure.JSModifiersParseResult.GET_SET_FOUND : null));
        if (resultForToken != null) {
            EnumSet<Enum> enumSet2 = EnumSet.of((Enum)resultForToken, (Enum)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
            enumSet = enumSet2;
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(...)");
        } else {
            EnumSet<Enum> enumSet3 = EnumSet.of((Enum)JSModifiersStructure.JSModifiersParseResult.LEXER_ADVANCED);
            enumSet = enumSet3;
            Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
        }
        return enumSet;
    }

    @Override
    public boolean isPossibleLookahead(@NotNull PsiBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return (this.allowNewlineAfter || !LineTerminators.INSTANCE.hasLineTerminatorAfter(builder)) && builder.getTokenType() == this.tokenType;
    }

    @JvmOverloads
    public JSModifiersStructureLeaf(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        this(tokenType, false, 2, null);
    }
}

