/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells;

import com.intellij.dataspell.jupyter.customCells.JupyterCellDataFrameProvider;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/JupyterCodeCellDataFrameProvider;", "Lcom/intellij/dataspell/jupyter/customCells/JupyterCellDataFrameProvider;", "<init>", "()V", "getDataFrameVariableName", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "ordinal", "", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "isPandasDataFrameType", "", "expression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lcom/jetbrains/python/psi/types/PyType;", "Companion", "intellij.dataspell.jupyter.customCells"})
public final class JupyterCodeCellDataFrameProvider
implements JupyterCellDataFrameProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public String getDataFrameVariableName(@NotNull Editor editor, int ordinal, @NotNull JupyterCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        if (!Intrinsics.areEqual((Object)cell.getCellType(), (Object)JupyterCellType.Companion.getCODE())) {
            return null;
        }
        NotebookCellLines.Interval interval = NotebookVisualizationUiUtilKt.getCellByOrdinal((Editor)editor, (int)ordinal);
        PsiElement expr = Companion.getLastPsiElement(editor, interval.getLines().getLast());
        if (expr instanceof PyReferenceExpression) {
            PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)expr;
            Project project = editor.getProject();
            Intrinsics.checkNotNull((Object)project);
            if (this.isPandasDataFrameType(pyReferenceExpression, project)) {
                return ((PyReferenceExpression)expr).getName();
            }
        }
        return null;
    }

    private final boolean isPandasDataFrameType(PyReferenceExpression expression, Project project) {
        TypeEvalContext context = TypeEvalContext.deepCodeInsight((Project)project);
        PyType expressionType = context.getType((PyTypedElement)expression);
        return this.isPandasDataFrameType(expressionType);
    }

    private final boolean isPandasDataFrameType(PyType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof PyClassType) {
            PyClass pyClass = ((PyClassType)type).getPyClass();
            Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
            PyClass pyClass2 = pyClass;
            String qualifiedName = pyClass2.getQualifiedName();
            return Intrinsics.areEqual((Object)qualifiedName, (Object)"pandas.core.frame.DataFrame");
        }
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0003\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/JupyterCodeCellDataFrameProvider$Companion;", "", "<init>", "()V", "getLastPsiElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "lastLine", "", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/Integer;)Lcom/intellij/psi/PsiElement;", "getLastPsiElementImpl", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "offset", "intellij.dataspell.jupyter.customCells"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PsiElement getLastPsiElement(@Nullable Editor editor, @Nullable Integer lastLine) {
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getProject()) == null) {
                return null;
            }
            Editor project = editor2;
            BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
            if (backedNotebookVirtualFile == null || (backedNotebookVirtualFile = backedNotebookVirtualFile.getFile()) == null) {
                return null;
            }
            BackedNotebookVirtualFile virtualFile = backedNotebookVirtualFile;
            Integer n = lastLine;
            if (n == null) {
                return null;
            }
            n.intValue();
            int offset = editor.getDocument().getLineStartOffset(lastLine.intValue());
            return this.getLastPsiElementImpl((Project)project, (VirtualFile)virtualFile, offset);
        }

        @RequiresReadLock
        @RequiresBackgroundThread
        private final PsiElement getLastPsiElementImpl(Project project, VirtualFile virtualFile, int offset) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = psiFile;
            PsiElement psiElement = psiFile2.findElementAt(offset);
            if (psiElement == null && (psiElement = PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)psiFile2)) == offset ? psiFile2.findElementAt(offset - 1) : null) == null) {
                return null;
            }
            PsiElement element = psiElement;
            if (!com.intellij.dataspell.jupyter.customCells.JupyterCodeCellDataFrameProvider$Companion.getLastPsiElementImpl$isSpaceOrComment(element)) {
                PyExpressionStatement pyExpressionStatement = (PyExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyExpressionStatement.class);
                if (pyExpressionStatement == null) {
                    return null;
                }
                element = (PsiElement)pyExpressionStatement;
            }
            while (com.intellij.dataspell.jupyter.customCells.JupyterCodeCellDataFrameProvider$Companion.getLastPsiElementImpl$isSpaceOrComment(element)) {
                if (element.getPrevSibling() != null) continue;
                return null;
            }
            return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)PyElementTypes.EXPRESSION_STATEMENT) ? element.getFirstChild() : null;
        }

        private static final boolean getLastPsiElementImpl$isSpaceOrComment(PsiElement element) {
            return element instanceof PsiWhiteSpace || element instanceof PsiComment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

