/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.introspector;

import com.intellij.database.introspection.query.CascadeMapEvaluator;
import com.intellij.database.introspection.query.CommonPreprocessor;
import com.intellij.database.introspection.query.Evaluator;
import com.intellij.database.introspection.query.MapEvaluator;
import com.intellij.database.introspection.query.PreprocessedQuery;
import com.intellij.database.introspection.query.QueryStats;
import com.intellij.database.layoutedQueries.DBQueryRunner;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.exceptions.DBException;
import com.intellij.database.remote.jdba.sql.SqlQuery;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 r2\u00020\u0001:\u0002qrB!\b\u0016\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001J\u0010\u0010 \u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\tJ\u0014\u0010!\u001a\u00020\"2\n\u0010#\u001a\u00060$j\u0002`%H\u0014J \u0010&\u001a\u00020'2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010)H\u0004J\u0012\u0010*\u001a\u00020'2\b\b\u0002\u0010\f\u001a\u00020\rH\u0014JS\u0010+\u001a\b\u0012\u0004\u0012\u0002H-0,\"\u0004\b\u0000\u0010-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010)2\u0012\b\u0002\u00100\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u000101H\u0004\u00a2\u0006\u0002\u00102J#\u00103\u001a\u0002H4\"\u0004\b\u0000\u00104*\u0002052\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H40/\u00a2\u0006\u0002\u00106JD\u00107\u001a\u00020\u001d\"\u0004\b\u0000\u0010-*\u0002052\u0014\u0010.\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H-080/2\b\b\u0002\u00109\u001a\u00020:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u0002H-\u0012\u0004\u0012\u00020\u001d0<JO\u00103\u001a\u0002H-\"\u0004\b\u0000\u0010-*\u0002052\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H-0/2\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010)2\u0012\u00100\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000101\"\u00020\u0001H\u0004\u00a2\u0006\u0002\u0010=JP\u0010>\u001a\b\u0012\u0004\u0012\u0002H40?\"\u0004\b\u0000\u00104*\u0002052\u0014\u0010.\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H4080/2\u0016\b\u0002\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010)2\b\b\u0002\u00109\u001a\u00020:H\u0004JJ\u0010@\u001a\b\u0012\u0004\u0012\u0002H40?\"\u0004\b\u0000\u00104*\u0002052\u0014\u0010A\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H4080,2\b\b\u0002\u00109\u001a\u00020:2\u0010\b\u0002\u0010B\u001a\n\u0012\u0004\u0012\u0002H4\u0018\u00010CH\u0002J\u0010\u0010D\u001a\u00020\"2\u0006\u0010E\u001a\u00020FH\u0004J\u00a8\u0001\u0010G\u001a\u00020\u001d\"\u0004\b\u0000\u00104*\u0002052\u0014\u0010.\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H4080/2\u0012\b\u0002\u0010H\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u0001012\b\b\u0002\u00109\u001a\u00020:2\u0016\b\u0002\u0010I\u001a\u0010\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\"\u0018\u00010<2$\b\u0002\u0010J\u001a\u001e\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H4080K\u0012\u0004\u0012\u00020\u001d\u0018\u00010<2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u00020\u001d0<H\u0004\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0006\u00a2\u0006\u0002\u0010LJ\u00ae\u0001\u0010M\u001a\u00020\u001d\"\u0004\b\u0000\u00104*\u0002052\u0014\u0010.\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H4080/2\u0012\b\u0002\u0010H\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u0001012\b\b\u0002\u00109\u001a\u00020:2\u0016\b\u0002\u0010I\u001a\u0010\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\"\u0018\u00010<2$\b\u0002\u0010J\u001a\u001e\u0012\u0012\u0012\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H4080K\u0012\u0004\u0012\u00020\u001d\u0018\u00010<2\u0018\u0010;\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H408\u0012\u0004\u0012\u00020\u001d0<H\u0002\u0082\u0002\b\n\u0006\b\u0001\u0012\u0002\u0010\u0006\u00a2\u0006\u0002\u0010LJ\u0012\u00109\u001a\u00020:2\b\u0010N\u001a\u0004\u0018\u00010\u0001H\u0002JC\u0010O\u001a\u0002H4\"\u0004\b\u0000\u00104*\u0002052\b\b\u0001\u0010P\u001a\u00020\t2\f\u0010Q\u001a\b\u0012\u0004\u0012\u0002H40R2\u0012\b\u0002\u0010H\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u000101H\u0004\u00a2\u0006\u0002\u0010SJQ\u0010O\u001a\u0002H4\"\u0004\b\u0000\u00104*\u0002052\f\u0010.\u001a\b\u0012\u0004\u0012\u0002H40/2\u0012\b\u0002\u0010H\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0001\u0018\u0001012\u0016\b\u0002\u0010I\u001a\u0010\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020\"\u0018\u00010<H\u0004\u00a2\u0006\u0002\u0010TJ \u0010U\u001a\u00020\u001d2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/2\n\b\u0002\u0010V\u001a\u0004\u0018\u00010WH\u0002J$\u0010X\u001a\u00020\u001d2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010[\u001a\u00020\t2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010]H\u0002J\"\u0010^\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020\t2\u0010\b\u0002\u0010E\u001a\n\u0018\u00010`j\u0004\u0018\u0001`aH\u0007J\"\u0010b\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020\t2\u0010\b\u0002\u0010E\u001a\n\u0018\u00010`j\u0004\u0018\u0001`aH\u0007J8\u0010c\u001a\u00020\u001d2\u001d\b\u0004\u0010d\u001a\u0017\u0012\b\u0012\u00060$j\u0002`%\u0012\u0004\u0012\u00020\u001d0<\u00a2\u0006\u0002\beH\u0084\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J\u001a\u0010f\u001a\u00020\u001d2\b\u0010_\u001a\u0004\u0018\u00010\t2\u0006\u0010E\u001a\u00020]H\u0004J)\u0010g\u001a\u00020\u001d2\u000e\b\u0004\u0010h\u001a\b\u0012\u0004\u0012\u00020\t0iH\u0084\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0000J\u0010\u0010g\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020\tH\u0007J,\u0010j\u001a\u00020\u001d2\n\u0010k\u001a\u00060lj\u0002`m2\u0006\u0010_\u001a\u00020\t2\u000e\u0010E\u001a\n\u0018\u00010`j\u0004\u0018\u0001`aH\u0014R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010n\u001a\u00020\"8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\bo\u0010p\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006s"}, d2={"Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;", "", "parentContext", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;Lcom/intellij/openapi/diagnostic/Logger;)V", "parametersMap", "", "", "getParametersMap", "()Ljava/util/Map;", "parametersEvaluator", "Lcom/intellij/database/introspection/query/Evaluator;", "ignoreQueryErrors", "", "getIgnoreQueryErrors", "()[I", "setIgnoreQueryErrors", "([I)V", "getLog$annotations", "()V", "statistics", "Lcom/intellij/database/introspection/query/QueryStats;", "getStatistics", "()Lcom/intellij/database/introspection/query/QueryStats;", "setStatistics", "(Lcom/intellij/database/introspection/query/QueryStats;)V", "setQueryParameter", "", "name", "value", "getQueryParameter", "queryPostPreprocess", "", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "makePreprocessor", "Lcom/intellij/database/introspection/query/CommonPreprocessor;", "namedParameters", "", "createPreprocessor", "preprocessQuery", "Lcom/intellij/database/introspection/query/PreprocessedQuery;", "X", "query", "Lcom/intellij/database/remote/jdba/sql/SqlQuery;", "freeParameters", "", "(Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/util/Map;[Ljava/lang/Object;)Lcom/intellij/database/introspection/query/PreprocessedQuery;", "performQuery", "R", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/remote/jdba/sql/SqlQuery;)Ljava/lang/Object;", "performQueryHandleEachRow", "", "packSize", "", "action", "Lkotlin/Function1;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/remote/jdba/sql/SqlQuery;Ljava/util/Map;[Ljava/lang/Object;)Ljava/lang/Object;", "performQueryForList", "", "runQueryForList", "preprocessedQuery", "listToCollect", "", "ignoreThisDbException", "exception", "Lcom/intellij/database/remote/jdba/exceptions/DBException;", "runQueryHandleEachRow", "parameters", "exceptionHandler", "queryExtraHandler", "Lcom/intellij/database/layoutedQueries/DBQueryRunner;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/remote/jdba/sql/SqlQuery;[Ljava/lang/Object;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "runQueryByPackIteratePack", "pack", "runQuery", "queryText", "layout", "Lcom/intellij/database/remote/jdba/core/ResultLayout;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Ljava/lang/String;Lcom/intellij/database/remote/jdba/core/ResultLayout;[Ljava/lang/Object;)Ljava/lang/Object;", "(Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/remote/jdba/sql/SqlQuery;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "traceQueryText", "headerSuffix", "", "traceQueryDebugInfo", "time1", "", "queryDisplayName", "e", "", "logWarn", "message", "Ljava/lang/Exception;", "Lkotlin/Exception;", "logError", "traceBuildingString", "builderAction", "Lkotlin/ExtensionFunctionType;", "traceException", "trace", "messageProducer", "Lkotlin/Function0;", "logMessage", "level", "Lcom/intellij/openapi/diagnostic/LogLevel;", "Lcom/intellij/database/dialects/base/introspector/LogLevel;", "tracing", "getTracing", "()Z", "QueryPreprocessor", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nIntrospectionQueryContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,456:1\n387#1,6:458\n411#1,2:464\n18#2:457\n*S KotlinDebug\n*F\n+ 1 IntrospectionQueryContext.kt\ncom/intellij/database/dialects/base/introspector/IntrospectionQueryContext\n*L\n352#1:458,6\n362#1:464,2\n322#1:457\n*E\n"})
public class IntrospectionQueryContext {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @Nullable
    private final IntrospectionQueryContext parentContext;
    @NotNull
    private final Map<String, Object> parametersMap;
    @NotNull
    private final Evaluator parametersEvaluator;
    @Nullable
    private int[] ignoreQueryErrors;
    @JvmField
    @NotNull
    public final Logger log;
    @Nullable
    private QueryStats statistics;

    @NotNull
    protected final Map<String, Object> getParametersMap() {
        return this.parametersMap;
    }

    @Nullable
    protected final int[] getIgnoreQueryErrors() {
        return this.ignoreQueryErrors;
    }

    protected final void setIgnoreQueryErrors(@Nullable int[] nArray) {
        this.ignoreQueryErrors = nArray;
    }

    public static /* synthetic */ void getLog$annotations() {
    }

    @Nullable
    public final QueryStats getStatistics() {
        return this.statistics;
    }

    public final void setStatistics(@Nullable QueryStats queryStats) {
        this.statistics = queryStats;
    }

    public IntrospectionQueryContext(@Nullable IntrospectionQueryContext parentContext, @Nullable Logger log) {
        this.parametersMap = Companion.newParametersMap();
        if (parentContext == null) {
            this.parentContext = null;
            this.parametersEvaluator = new MapEvaluator(this.parametersMap);
            this.ignoreQueryErrors = null;
            Logger logger2 = log;
            if (logger2 == null) {
                Logger logger3 = Logger.getInstance(IntrospectionQueryContext.class);
                logger2 = logger3;
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            }
            this.log = logger2;
        } else {
            this.parentContext = parentContext;
            this.parametersEvaluator = new CascadeMapEvaluator(this.parametersMap, parentContext.parametersEvaluator);
            this.ignoreQueryErrors = parentContext.ignoreQueryErrors;
            Logger logger4 = log;
            if (logger4 == null) {
                logger4 = parentContext.log;
            }
            this.log = logger4;
        }
    }

    public /* synthetic */ IntrospectionQueryContext(IntrospectionQueryContext introspectionQueryContext, Logger logger2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            introspectionQueryContext = null;
        }
        if ((n & 2) != 0) {
            logger2 = null;
        }
        this(introspectionQueryContext, logger2);
    }

    public final void setQueryParameter(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = value != null ? this.parametersMap.put(name, value) : this.parametersMap.remove(name);
    }

    @Nullable
    public final Object getQueryParameter(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.parametersMap.get(name);
    }

    protected boolean queryPostPreprocess(@NotNull StringBuilder buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return false;
    }

    @NotNull
    protected final CommonPreprocessor makePreprocessor(@Nullable Map<String, ? extends Object> namedParameters) {
        Map<String, ? extends Object> map = namedParameters;
        return !(map == null || map.isEmpty()) ? this.createPreprocessor(new CascadeMapEvaluator(namedParameters, this.parametersEvaluator)) : this.createPreprocessor(this.parametersEvaluator);
    }

    public static /* synthetic */ CommonPreprocessor makePreprocessor$default(IntrospectionQueryContext introspectionQueryContext, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: makePreprocessor");
        }
        if ((n & 1) != 0) {
            map = null;
        }
        return introspectionQueryContext.makePreprocessor(map);
    }

    @NotNull
    protected CommonPreprocessor createPreprocessor(@NotNull Evaluator parametersEvaluator) {
        Intrinsics.checkNotNullParameter((Object)parametersEvaluator, (String)"parametersEvaluator");
        return new QueryPreprocessor(parametersEvaluator);
    }

    public static /* synthetic */ CommonPreprocessor createPreprocessor$default(IntrospectionQueryContext introspectionQueryContext, Evaluator evaluator, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createPreprocessor");
        }
        if ((n & 1) != 0) {
            evaluator = introspectionQueryContext.parametersEvaluator;
        }
        return introspectionQueryContext.createPreprocessor(evaluator);
    }

    @NotNull
    protected final <X> PreprocessedQuery<X> preprocessQuery(@NotNull SqlQuery<X> query, @Nullable Map<String, ? extends Object> namedParameters, @Nullable Object[] freeParameters) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        CommonPreprocessor preprocessor = this.makePreprocessor(namedParameters);
        if (freeParameters != null && !(freeParameters.length == 0)) {
            Object[] objectArray = freeParameters;
            preprocessor.setFreeParameters(Arrays.copyOf(objectArray, objectArray.length));
        }
        PreprocessedQuery<X> preprocessedQuery = preprocessor.preprocess(query);
        Intrinsics.checkNotNullExpressionValue(preprocessedQuery, (String)"preprocess(...)");
        return preprocessedQuery;
    }

    public static /* synthetic */ PreprocessedQuery preprocessQuery$default(IntrospectionQueryContext introspectionQueryContext, SqlQuery sqlQuery, Map map, Object[] objectArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: preprocessQuery");
        }
        if ((n & 2) != 0) {
            map = null;
        }
        if ((n & 4) != 0) {
            objectArray = null;
        }
        return introspectionQueryContext.preprocessQuery(sqlQuery, map, objectArray);
    }

    public final <R> R performQuery(@NotNull DBTransaction $this$performQuery, @NotNull SqlQuery<R> query) {
        Intrinsics.checkNotNullParameter((Object)$this$performQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, null, null, 6, null);
        SqlQuery sqlQuery = pq.query;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
        return (R)IntrospectionQueryContext.runQuery$default(this, $this$performQuery, sqlQuery, pq.bindableParameters, null, 4, null);
    }

    public final <X> void performQueryHandleEachRow(@NotNull DBTransaction $this$performQueryHandleEachRow, @NotNull SqlQuery<? extends Iterable<? extends X>> query, int packSize, @NotNull Function1<? super X, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$performQueryHandleEachRow, (String)"<this>");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, null, null, 6, null);
        SqlQuery sqlQuery = pq.query;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
        this.runQueryHandleEachRow($this$performQueryHandleEachRow, sqlQuery, pq.bindableParameters, packSize, (Function1<? super DBException, Boolean>)((Function1)new Function1<DBException, Boolean>((Object)this){

            public final Boolean invoke(DBException p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return ((IntrospectionQueryContext)this.receiver).ignoreThisDbException(p0);
            }
        }), null, action);
    }

    public static /* synthetic */ void performQueryHandleEachRow$default(IntrospectionQueryContext introspectionQueryContext, DBTransaction dBTransaction, SqlQuery sqlQuery, int n, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryHandleEachRow");
        }
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        introspectionQueryContext.performQueryHandleEachRow(dBTransaction, sqlQuery, n, function1);
    }

    protected final <X> X performQuery(@NotNull DBTransaction $this$performQuery, @NotNull SqlQuery<X> query, @Nullable Map<String, ? extends Object> namedParameters, Object ... freeParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$performQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)freeParameters, (String)"freeParameters");
        PreprocessedQuery<X> pq = this.preprocessQuery(query, namedParameters, freeParameters);
        SqlQuery sqlQuery = pq.query;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
        return (X)IntrospectionQueryContext.runQuery$default(this, $this$performQuery, sqlQuery, pq.bindableParameters, null, 4, null);
    }

    @NotNull
    protected final <R> List<R> performQueryForList(@NotNull DBTransaction $this$performQueryForList, @NotNull SqlQuery<? extends Iterable<? extends R>> query, @Nullable Map<String, ? extends Object> namedParameters, int packSize) {
        Intrinsics.checkNotNullParameter((Object)$this$performQueryForList, (String)"<this>");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        PreprocessedQuery pq = IntrospectionQueryContext.preprocessQuery$default(this, query, namedParameters, null, 4, null);
        return IntrospectionQueryContext.runQueryForList$default(this, $this$performQueryForList, pq, packSize, null, 4, null);
    }

    public static /* synthetic */ List performQueryForList$default(IntrospectionQueryContext introspectionQueryContext, DBTransaction dBTransaction, SqlQuery sqlQuery, Map map, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: performQueryForList");
        }
        if ((n2 & 2) != 0) {
            map = null;
        }
        if ((n2 & 4) != 0) {
            n = 4096;
        }
        return introspectionQueryContext.performQueryForList(dBTransaction, sqlQuery, map, n);
    }

    private final <R> List<R> runQueryForList(DBTransaction $this$runQueryForList, PreprocessedQuery<? extends Iterable<? extends R>> preprocessedQuery, int packSize, List<R> listToCollect) {
        List list = listToCollect;
        if (list == null) {
            list = new ArrayList();
        }
        List list2 = list;
        SqlQuery sqlQuery = preprocessedQuery.query;
        Intrinsics.checkNotNullExpressionValue(sqlQuery, (String)"query");
        IntrospectionQueryContext.runQueryByPackIteratePack$default(this, $this$runQueryForList, sqlQuery, preprocessedQuery.bindableParameters, packSize, (Function1)new Function1<DBException, Boolean>((Object)this){

            public final Boolean invoke(DBException p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                return ((IntrospectionQueryContext)this.receiver).ignoreThisDbException(p0);
            }
        }, null, arg_0 -> IntrospectionQueryContext.runQueryForList$lambda$0(list2, arg_0), 16, null);
        return list2;
    }

    static /* synthetic */ List runQueryForList$default(IntrospectionQueryContext introspectionQueryContext, DBTransaction dBTransaction, PreprocessedQuery preprocessedQuery, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runQueryForList");
        }
        if ((n2 & 2) != 0) {
            n = 4096;
        }
        if ((n2 & 4) != 0) {
            list = null;
        }
        return introspectionQueryContext.runQueryForList(dBTransaction, preprocessedQuery, n, list);
    }

    protected final boolean ignoreThisDbException(@NotNull DBException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        int[] ignoreErrors = this.ignoreQueryErrors;
        return ignoreErrors != null && ArraysKt.contains((int[])ignoreErrors, (int)exception.vendorErrorCode);
    }

    protected final <R> void runQueryHandleEachRow(@NotNull DBTransaction $this$runQueryHandleEachRow, @NotNull SqlQuery<? extends Iterable<? extends R>> query, @Nullable Object[] parameters, int packSize, @Nullable Function1<? super DBException, Boolean> exceptionHandler, @Nullable Function1<? super DBQueryRunner<? extends Iterable<? extends R>>, Unit> queryExtraHandler, @NotNull Function1<? super R, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$runQueryHandleEachRow, (String)"<this>");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.runQueryByPackIteratePack($this$runQueryHandleEachRow, query, parameters, packSize, exceptionHandler, queryExtraHandler, arg_0 -> IntrospectionQueryContext.runQueryHandleEachRow$lambda$0(action, arg_0));
    }

    public static /* synthetic */ void runQueryHandleEachRow$default(IntrospectionQueryContext introspectionQueryContext, DBTransaction dBTransaction, SqlQuery sqlQuery, Object[] objectArray, int n, Function1 function1, Function1 function12, Function1 function13, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runQueryHandleEachRow");
        }
        if ((n2 & 2) != 0) {
            objectArray = null;
        }
        if ((n2 & 4) != 0) {
            n = 4096;
        }
        if ((n2 & 8) != 0) {
            function1 = null;
        }
        if ((n2 & 0x10) != 0) {
            function12 = null;
        }
        introspectionQueryContext.runQueryHandleEachRow(dBTransaction, sqlQuery, objectArray, n, (Function1<? super DBException, Boolean>)function1, function12, function13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <R> void runQueryByPackIteratePack(DBTransaction $this$runQueryByPackIteratePack, SqlQuery<? extends Iterable<? extends R>> query, Object[] parameters, int packSize, Function1<? super DBException, Boolean> exceptionHandler, Function1<? super DBQueryRunner<? extends Iterable<? extends R>>, Unit> queryExtraHandler, Function1<? super Iterable<? extends R>, Unit> action) {
        Iterable<? extends R> pack;
        QueryStats stats;
        String string = query.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String queryDisplayName = string;
        this.traceQueryText(query, "by portions of " + packSize);
        QueryStats queryStats = this.statistics;
        if (queryStats == null) {
            IntrospectionQueryContext introspectionQueryContext = this.parentContext;
            queryStats = introspectionQueryContext != null ? introspectionQueryContext.statistics : null;
        }
        QueryStats queryStats2 = stats = queryStats;
        QueryStats.StatEntry rec = queryStats2 != null ? queryStats2.registerStart(queryDisplayName) : null;
        DBQueryRunner<Iterable<R>> queryRunner = null;
        int countOfPacks = 0;
        int countOfRows = 0;
        boolean failed = false;
        long time1 = System.currentTimeMillis();
        try {
            queryRunner = $this$runQueryByPackIteratePack.query(query);
            if (parameters != null && !(parameters.length == 0)) {
                Object[] objectArray = parameters;
                queryRunner.withParams(Arrays.copyOf(objectArray, objectArray.length));
            }
            queryRunner.packBy(packSize);
            pack = null;
            queryRunner.start();
            Function1<? super DBQueryRunner<? extends Iterable<? extends R>>, Unit> function1 = queryExtraHandler;
            if (function1 != null) {
                function1.invoke(queryRunner);
            }
        }
        catch (DBException e) {
            failed = true;
            Function1<? super DBException, Boolean> function1 = exceptionHandler;
            boolean bl = function1 != null ? ((Boolean)function1.invoke((Object)e)).booleanValue() : false;
            if (bl) {
                return;
            }
            this.traceQueryDebugInfo(time1, queryDisplayName, e);
            throw e;
        }
        catch (Throwable e) {
            failed = true;
            this.traceQueryDebugInfo(time1, queryDisplayName, e);
            throw e;
        }
        while (true) {
            try {
                pack = queryRunner.nextPack();
                if (pack == null) break;
                ++countOfPacks;
                countOfRows += this.packSize(pack);
            }
            catch (DBException e) {
                Function1<? super DBException, Boolean> function1 = exceptionHandler;
                if (!(function1 != null ? ((Boolean)function1.invoke((Object)e)).booleanValue() : false)) throw e;
                DBQueryRunner<Iterable<R>> dBQueryRunner = queryRunner;
                if (dBQueryRunner != null) {
                    dBQueryRunner.close();
                }
                QueryStats.StatEntry statEntry = rec;
                if (statEntry == null) return;
                statEntry.registerFinish(System.currentTimeMillis() - time1, countOfPacks, countOfRows, failed);
                return;
            }
            action.invoke(pack);
        }
        this.trace("Fetched " + countOfPacks + " portions with " + countOfRows + " rows");
        IntrospectionQueryContext.traceQueryDebugInfo$default(this, time1, queryDisplayName, null, 4, null);
        return;
        finally {
            DBQueryRunner<Iterable<R>> dBQueryRunner = queryRunner;
            if (dBQueryRunner != null) {
                dBQueryRunner.close();
            }
            QueryStats.StatEntry statEntry = rec;
            if (statEntry != null) {
                statEntry.registerFinish(System.currentTimeMillis() - time1, countOfPacks, countOfRows, failed);
            }
        }
    }

    static /* synthetic */ void runQueryByPackIteratePack$default(IntrospectionQueryContext introspectionQueryContext, DBTransaction dBTransaction, SqlQuery sqlQuery, Object[] objectArray, int n, Function1 function1, Function1 function12, Function1 function13, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runQueryByPackIteratePack");
        }
        if ((n2 & 2) != 0) {
            objectArray = null;
        }
        if ((n2 & 4) != 0) {
            n = 4096;
        }
        if ((n2 & 8) != 0) {
            function1 = null;
        }
        if ((n2 & 0x10) != 0) {
            function12 = null;
        }
        introspectionQueryContext.runQueryByPackIteratePack(dBTransaction, sqlQuery, objectArray, n, (Function1<? super DBException, Boolean>)function1, function12, function13);
    }

    private final int packSize(Object pack) {
        Object object = pack;
        return object == null ? 0 : (object instanceof Collection ? ((Collection)pack).size() : (object instanceof Object[] ? ((Object[])pack).length : (object instanceof Map ? ((Map)pack).size() : 1)));
    }

    protected final <R> R runQuery(@NotNull DBTransaction $this$runQuery, @Language(value="SQL") @NotNull String queryText, @NotNull ResultLayout<R> layout, @Nullable Object[] parameters) {
        Intrinsics.checkNotNullParameter((Object)$this$runQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)queryText, (String)"queryText");
        Intrinsics.checkNotNullParameter(layout, (String)"layout");
        SqlQuery query = new SqlQuery(queryText, layout);
        return (R)IntrospectionQueryContext.runQuery$default(this, $this$runQuery, query, parameters, null, 4, null);
    }

    public static /* synthetic */ Object runQuery$default(IntrospectionQueryContext introspectionQueryContext, DBTransaction dBTransaction, String string, ResultLayout resultLayout, Object[] objectArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runQuery");
        }
        if ((n & 4) != 0) {
            objectArray = null;
        }
        return introspectionQueryContext.runQuery(dBTransaction, string, resultLayout, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final <R> R runQuery(@NotNull DBTransaction $this$runQuery, @NotNull SqlQuery<R> query, @Nullable Object[] parameters, @Nullable Function1<? super DBException, Boolean> exceptionHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$runQuery, (String)"<this>");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        QueryStats queryStats = this.statistics;
        if (queryStats == null) {
            IntrospectionQueryContext introspectionQueryContext = this.parentContext;
            queryStats = introspectionQueryContext != null ? introspectionQueryContext.statistics : null;
        }
        QueryStats stats = queryStats;
        String string = query.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String queryDisplayName = string;
        IntrospectionQueryContext.traceQueryText$default(this, query, null, 2, null);
        R result = null;
        DBQueryRunner<R> dBQueryRunner = $this$runQuery.query(query);
        Intrinsics.checkNotNullExpressionValue(dBQueryRunner, (String)"query(...)");
        try (DBQueryRunner<R> queryRunner = dBQueryRunner;){
            if (parameters != null && !(parameters.length == 0)) {
                Object[] objectArray = parameters;
                queryRunner.withParams(Arrays.copyOf(objectArray, objectArray.length));
            }
            QueryStats queryStats2 = stats;
            QueryStats.StatEntry rec = queryStats2 != null ? queryStats2.registerStart(queryDisplayName) : null;
            int rows = 0;
            boolean failed = false;
            long time1 = System.currentTimeMillis();
            try {
                R r = result = (R)queryRunner.runOnce();
                if (r instanceof Collection) {
                    rows = ((Collection)result).size();
                    this.trace("Fetched " + rows + " rows");
                } else if (r instanceof Object[]) {
                    rows = ((Object[])result).length;
                    this.trace("Fetched " + rows + " items");
                } else if (r instanceof Map) {
                    rows = ((Map)result).size();
                    this.trace("Fetched " + rows + " association pairs");
                } else if (r instanceof Boolean) {
                    int n;
                    if (query.getLayout().kind == ResultLayout.Kind.EXISTENCE) {
                        int _true_$iv;
                        void $this$choose$iv;
                        boolean bl = (Boolean)result;
                        boolean bl2 = true;
                        int _false_$iv = 0;
                        boolean $i$f$choose = false;
                        n = $this$choose$iv != false ? _true_$iv : _false_$iv;
                    } else {
                        n = 1;
                    }
                    rows = n;
                    this.trace("Fetched '" + result + "'");
                } else {
                    rows = 1;
                }
                IntrospectionQueryContext.traceQueryDebugInfo$default(this, time1, queryDisplayName, null, 4, null);
            }
            catch (DBException e) {
                failed = true;
                Function1<? super DBException, Boolean> function1 = exceptionHandler;
                boolean bl = function1 != null ? ((Boolean)function1.invoke((Object)e)).booleanValue() : false;
                if (bl) {
                    throw new ProcessCanceledException();
                }
                this.traceQueryDebugInfo(time1, queryDisplayName, e);
                throw e;
            }
            finally {
                QueryStats.StatEntry statEntry = rec;
                if (statEntry != null) {
                    statEntry.registerFinish(System.currentTimeMillis() - time1, 1, rows, failed);
                }
            }
        }
        return result;
    }

    public static /* synthetic */ Object runQuery$default(IntrospectionQueryContext introspectionQueryContext, DBTransaction dBTransaction, SqlQuery sqlQuery, Object[] objectArray, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runQuery");
        }
        if ((n & 2) != 0) {
            objectArray = null;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return introspectionQueryContext.runQuery(dBTransaction, sqlQuery, objectArray, (Function1<? super DBException, Boolean>)function1);
    }

    private final void traceQueryText(SqlQuery<?> query, CharSequence headerSuffix) {
        IntrospectionQueryContext this_$iv = this;
        boolean $i$f$traceBuildingString = false;
        if (this_$iv.getTracing()) {
            StringBuilder b$iv;
            StringBuilder $this$traceQueryText_u24lambda_u240 = b$iv = new StringBuilder();
            boolean bl = false;
            $this$traceQueryText_u24lambda_u240.append("Performing query ").append(query.getDisplayName());
            if (headerSuffix != null) {
                $this$traceQueryText_u24lambda_u240.append(' ').append(headerSuffix);
            }
            $this$traceQueryText_u24lambda_u240.append('\n');
            $this$traceQueryText_u24lambda_u240.append("-------- 8< ---------------------------------------------------------- SQL -----").append('\n');
            $this$traceQueryText_u24lambda_u240.append(query.getSourceText()).append('\n');
            $this$traceQueryText_u24lambda_u240.append("-------- >8 --------------------------------------------------------------------").append('\n');
            String string = b$iv.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this_$iv.trace(string);
        }
    }

    static /* synthetic */ void traceQueryText$default(IntrospectionQueryContext introspectionQueryContext, SqlQuery sqlQuery, CharSequence charSequence, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: traceQueryText");
        }
        if ((n & 2) != 0) {
            charSequence = null;
        }
        introspectionQueryContext.traceQueryText(sqlQuery, charSequence);
    }

    private final void traceQueryDebugInfo(long time1, String queryDisplayName, Throwable e) {
        IntrospectionQueryContext this_$iv = this;
        boolean $i$f$trace = false;
        if (this_$iv.getTracing()) {
            IntrospectionQueryContext introspectionQueryContext = this_$iv;
            boolean bl = false;
            long time2 = System.currentTimeMillis();
            double delta = (double)(time2 - time1) / 1000.0;
            Throwable throwable = e;
            introspectionQueryContext.trace(throwable == null ? "Query " + queryDisplayName + " completed in " + delta + " s." : (throwable instanceof DBException ? "Query " + queryDisplayName + " failed in " + delta + " s. with DB exception: " + ((DBException)e).getMessage() : "Query " + queryDisplayName + " failed in " + delta + " s. with exception " + e.getClass().getSimpleName() + ": " + e.getMessage()));
        }
    }

    static /* synthetic */ void traceQueryDebugInfo$default(IntrospectionQueryContext introspectionQueryContext, long l, String string, Throwable throwable, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: traceQueryDebugInfo");
        }
        if ((n & 4) != 0) {
            throwable = null;
        }
        introspectionQueryContext.traceQueryDebugInfo(l, string, throwable);
    }

    @JvmOverloads
    public final void logWarn(@NotNull String message, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logMessage(LogLevel.WARNING, message, exception);
    }

    public static /* synthetic */ void logWarn$default(IntrospectionQueryContext introspectionQueryContext, String string, Exception exception, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logWarn");
        }
        if ((n & 2) != 0) {
            exception = null;
        }
        introspectionQueryContext.logWarn(string, exception);
    }

    @JvmOverloads
    public final void logError(@NotNull String message, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logMessage(LogLevel.ERROR, message, exception);
    }

    public static /* synthetic */ void logError$default(IntrospectionQueryContext introspectionQueryContext, String string, Exception exception, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logError");
        }
        if ((n & 2) != 0) {
            exception = null;
        }
        introspectionQueryContext.logError(string, exception);
    }

    protected final void traceBuildingString(@NotNull Function1<? super StringBuilder, Unit> builderAction) {
        Intrinsics.checkNotNullParameter(builderAction, (String)"builderAction");
        boolean $i$f$traceBuildingString = false;
        if (this.getTracing()) {
            StringBuilder b = new StringBuilder();
            builderAction.invoke((Object)b);
            String string = b.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.trace(string);
        }
    }

    protected final void traceException(@Nullable String message, @NotNull Throwable exception) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        StringBuilder $this$traceException_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String string = message;
        if (string == null) {
            string = "Exception";
        }
        $this$traceException_u24lambda_u240.append(string);
        $this$traceException_u24lambda_u240.append(' ');
        $this$traceException_u24lambda_u240.append(exception.getClass().getSimpleName());
        String em = exception.getMessage();
        if (em != null) {
            $this$traceException_u24lambda_u240.append(": ");
            $this$traceException_u24lambda_u240.append(em);
        }
        String msg = stringBuilder.toString();
        this.trace(msg);
    }

    protected final void trace(@NotNull Function0<String> messageProducer) {
        Intrinsics.checkNotNullParameter(messageProducer, (String)"messageProducer");
        boolean $i$f$trace = false;
        if (this.getTracing()) {
            this.trace((String)messageProducer.invoke());
        }
    }

    @ApiStatus.Internal
    public final void trace(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logMessage(LogLevel.TRACE, message, null);
    }

    protected void logMessage(@NotNull LogLevel level, @NotNull String message, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.parentContext != null) {
            this.parentContext.logMessage(level, message, exception);
        } else {
            Companion.logMessageIntoLogger(this.log, level, message, exception);
        }
    }

    protected boolean getTracing() {
        IntrospectionQueryContext introspectionQueryContext = this.parentContext;
        return introspectionQueryContext != null ? introspectionQueryContext.getTracing() : this.log.isTraceEnabled();
    }

    @JvmOverloads
    public final void logWarn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IntrospectionQueryContext.logWarn$default(this, message, null, 2, null);
    }

    @JvmOverloads
    public final void logError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IntrospectionQueryContext.logError$default(this, message, null, 2, null);
    }

    private static final Unit runQueryForList$lambda$0(List $list, Iterable pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        CollectionsKt.addAll((Collection)$list, (Iterable)pack);
        return Unit.INSTANCE;
    }

    private static final Unit runQueryHandleEachRow$lambda$0(Function1 $action, Iterable pack) {
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        for (Object row : pack) {
            $action.invoke(row);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u0005J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00062\u000e\u0010\u000f\u001a\n\u0018\u00010\u0010j\u0004\u0018\u0001`\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext$Companion;", "", "<init>", "()V", "newParametersMap", "", "", "logMessageIntoLogger", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "level", "Lcom/intellij/openapi/diagnostic/LogLevel;", "Lcom/intellij/database/dialects/base/introspector/LogLevel;", "message", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "intellij.database.core.impl"})
    protected static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Object> newParametersMap() {
            return new TreeMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        }

        public final void logMessageIntoLogger(@NotNull Logger logger2, @NotNull LogLevel level, @NotNull String message, @Nullable Exception exception) {
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: 
                case 2: {
                    logger2.error(message, (Throwable)exception);
                    break;
                }
                case 3: {
                    logger2.warn(message, (Throwable)exception);
                    break;
                }
                case 4: {
                    logger2.info(message, (Throwable)exception);
                    break;
                }
                case 5: {
                    logger2.debug(message, (Throwable)exception);
                    break;
                }
                case 6: {
                    logger2.trace(message);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LogLevel.values().length];
                try {
                    nArray[LogLevel.ALL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogLevel.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogLevel.WARNING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogLevel.INFO.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogLevel.DEBUG.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LogLevel.TRACE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext$QueryPreprocessor;", "Lcom/intellij/database/introspection/query/CommonPreprocessor;", "evaluator", "Lcom/intellij/database/introspection/query/Evaluator;", "<init>", "(Lcom/intellij/database/dialects/base/introspector/IntrospectionQueryContext;Lcom/intellij/database/introspection/query/Evaluator;)V", "postPreprocess", "", "buf", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.database.core.impl"})
    public final class QueryPreprocessor
    extends CommonPreprocessor {
        public QueryPreprocessor(Evaluator evaluator) {
            Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
            super(true, evaluator);
        }

        @Override
        protected boolean postPreprocess(@NotNull StringBuilder buf) {
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            return IntrospectionQueryContext.this.queryPostPreprocess(buf);
        }
    }
}

