/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.forest;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.explorer.forest.DvArm;
import com.intellij.database.explorer.forest.DvBushRef;
import com.intellij.database.explorer.forest.DvFolder;
import com.intellij.database.explorer.forest.DvForest;
import com.intellij.database.explorer.forest.DvForestGartner;
import com.intellij.database.explorer.forest.DvForestRootFolder;
import com.intellij.database.explorer.forest.DvForestService;
import com.intellij.database.explorer.forest.DvForestService$listAllFolderPaths$;
import com.intellij.database.explorer.forest.DvForestService$recoverProblems$lambda$1$;
import com.intellij.database.explorer.forest.DvNiceFolder;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicUniqueBush;
import com.intellij.database.util.common.StringFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@State(name="db-tree-configuration", storages={@Storage(value="db-forest-config.xml")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003-./B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\u0012\u0010\u0017\u001a\u00020\u00142\b\b\u0002\u0010\u0018\u001a\u00020\u000fH\u0007J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0006\u0010\u001c\u001a\u00020\u0014J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001eH\u0002J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001aJ\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001a2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u000e\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020%J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0$J\u0010\u0010*\u001a\u0004\u0018\u00010%2\u0006\u0010+\u001a\u00020\"J\b\u0010,\u001a\u00020\u0014H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/database/explorer/forest/DvForestService;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/database/explorer/forest/DvForestService$ForestState;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "forest", "Lcom/intellij/database/explorer/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "getForest", "()Lcom/intellij/database/explorer/forest/DvForest;", "stateLoaded", "", "serviceInitialized", "getState", "collectAndPackTheState", "loadState", "", "state", "initializeComponent", "importRestDataSources", "force", "selfInspect", "", "Lcom/intellij/database/explorer/forest/DvForestService$Problem;", "recoverProblems", "listAllDataSourcesForThisProject", "", "listAllFolderPaths", "", "convertArmsToVisibleNodes", "Lcom/intellij/database/model/basic/BasicNode;", "arms", "", "Lcom/intellij/database/explorer/forest/DvArm;", "convertArmToVisibleNode", "arm", "convertVisibleNodesToArms", "nodes", "convertVisibleNodeToArm", "node", "clearAll", "ForestState", "ProblemType", "Problem", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvForestService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestService.kt\ncom/intellij/database/explorer/forest/DvForestService\n+ 2 DvForest.kt\ncom/intellij/database/explorer/forest/DvForest$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n30#2:325\n1220#3,2:326\n1249#3,4:328\n1512#3:332\n1538#3,3:333\n1541#3,3:343\n1586#3:347\n1661#3,3:348\n1642#3,10:351\n1915#3:361\n1916#3:363\n1652#3:364\n1586#3:365\n1661#3,3:366\n812#3,12:369\n383#4,7:336\n479#5:346\n479#5:381\n479#5:382\n628#5:383\n1#6:362\n*S KotlinDebug\n*F\n+ 1 DvForestService.kt\ncom/intellij/database/explorer/forest/DvForestService\n*L\n36#1:325\n84#1:326,2\n84#1:328,4\n185#1:332\n185#1:333,3\n185#1:343,3\n258#1:347\n258#1:348,3\n267#1:351,10\n267#1:361\n267#1:363\n267#1:364\n191#1:365\n191#1:366,3\n191#1:369,12\n185#1:336,7\n253#1:346\n216#1:381\n228#1:382\n229#1:383\n267#1:362\n*E\n"})
public final class DvForestService
implements PersistentStateComponent<ForestState> {
    @NotNull
    private final Project project;
    @NotNull
    private final DvForest<DataSourceNode> forest;
    private boolean stateLoaded;
    private boolean serviceInitialized;

    public DvForestService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        DvForest.Companion this_$iv = DvForest.Companion;
        boolean $i$f$createForest = false;
        this.forest = new DvForest<DataSourceNode>(DataSourceNode.class);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final DvForest<DataSourceNode> getForest() {
        return this.forest;
    }

    @Nullable
    public ForestState getState() {
        boolean toStore;
        DvForestRootFolder root = this.forest.getRoot();
        boolean bl = toStore = this.stateLoaded || root.getHasInnerFolders() || SequencesKt.count(root.getInnerBushes()) >= 2;
        if (toStore) {
            return this.collectAndPackTheState();
        }
        return null;
    }

    private final ForestState collectAndPackTheState() {
        DvForestGartner<DataSourceNode> gartner = new DvForestGartner<DataSourceNode>(this.forest);
        String stateText = gartner.exportState();
        ForestState state = new ForestState(stateText);
        return state;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull ForestState state) {
        String text2;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.serviceInitialized) {
            this.serviceInitialized = false;
            DvForest.modifyTree$default(this.forest, false, (Function0)new Function0<Unit>(this.forest){

                public final void invoke() {
                    ((DvForest)this.receiver).clearAll$intellij_database_core_impl();
                }
            }, 1, null);
        }
        if ((text2 = StringKt.nullize$default((String)state.data, (boolean)false, (int)1, null)) != null) {
            void $this$associateByTo$iv$iv;
            DvForestGartner<DataSourceNode> gartner = new DvForestGartner<DataSourceNode>(this.forest);
            Set<DataSourceNode> dsNodes = this.listAllDataSourcesForThisProject();
            Iterable $this$associateBy$iv = dsNodes;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                DataSourceNode dataSourceNode = (DataSourceNode)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                map.put(it.dataSource.getUniqueId(), element$iv$iv);
            }
            Map dsMap = destination$iv$iv;
            gartner.importState(text2, (Function1<String, DataSourceNode>)((Function1)new Function1<String, DataSourceNode>((Object)dsMap){

                public final DataSourceNode invoke(String p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return (DataSourceNode)((Map)this.receiver).get(p0);
                }
            }));
        }
        this.stateLoaded = true;
    }

    public void initializeComponent() {
        this.importRestDataSources(!this.stateLoaded && !this.serviceInitialized);
        this.serviceInitialized = true;
    }

    @ApiStatus.Internal
    public final void importRestDataSources(boolean force) {
        Set<DataSourceNode> dsNodes = this.listAllDataSourcesForThisProject();
        DvForest.modifyTree$default(this.forest, false, () -> DvForestService.importRestDataSources$lambda$0(dsNodes, this, force), 1, null);
    }

    public static /* synthetic */ void importRestDataSources$default(DvForestService dvForestService, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        dvForestService.importRestDataSources(bl);
    }

    @NotNull
    public final List<Problem> selfInspect() {
        Set<DataSourceNode> dataSources = this.listAllDataSourcesForThisProject();
        HashSet orphans = new HashSet(dataSources);
        ArrayList problems = new ArrayList();
        this.forest.readTree(() -> DvForestService.selfInspect$lambda$0(this, problems, orphans));
        Iterator iterator = orphans.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            DataSourceNode dsn = (DataSourceNode)iterator2.next();
            Collection collection = problems;
            Intrinsics.checkNotNull((Object)dsn);
            collection.add(new Problem(dsn, ProblemType.problemOrphanDataSource, "Data source '" + dsn + "' is not found in the forest."));
        }
        return problems;
    }

    /*
     * WARNING - void declaration
     */
    public final void recoverProblems() {
        void $this$groupByTo$iv$iv;
        List<Problem> allProblems = this.selfInspect();
        Iterable $this$groupBy$iv = allProblems;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            Problem it = (Problem)element$iv$iv;
            boolean bl = false;
            ProblemType key$iv$iv = it.type;
            Map map = destination$iv$iv;
            ProblemType key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedProblems = destination$iv$iv;
        DvForest.modifyTree$default(this.forest, false, () -> DvForestService.recoverProblems$lambda$1(groupedProblems, this), 1, null);
    }

    private final Set<DataSourceNode> listAllDataSourcesForThisProject() {
        BasicModelRegistry mRegistry = BasicModelRegistry.Companion.instance();
        return SequencesKt.toSet(mRegistry.listDataSourceNodesForProject(this.project));
    }

    @NotNull
    public final List<String> listAllFolderPaths() {
        Sequence $this$filterIsInstance$iv = SequencesKt.asSequence((Iterator)this.forest.getFoldersTree().traverseDepthFirst());
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)listAllFolderPaths$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)listAllFolderPaths.1.INSTANCE)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BasicNode> convertArmsToVisibleNodes(@NotNull Collection<? extends DvArm> arms) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(arms, (String)"arms");
        Iterable $this$map$iv = arms;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DvArm dvArm = (DvArm)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.convertArmToVisibleNode((DvArm)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final BasicNode convertArmToVisibleNode(@NotNull DvArm arm) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)arm, (String)"arm");
        if (arm instanceof DvBushRef) {
            Object b = ((DvBushRef)arm).getBush();
            Intrinsics.checkNotNull(b, (String)"null cannot be cast to non-null type com.intellij.database.view.DataSourceNode");
            basicNode = (DataSourceNode)b;
        } else {
            basicNode = arm;
        }
        return basicNode;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DvArm> convertVisibleNodesToArms(@NotNull Collection<? extends BasicNode> nodes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Iterable $this$mapNotNull$iv = nodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DvArm it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BasicNode p0 = (BasicNode)element$iv$iv;
            boolean bl2 = false;
            if (this.convertVisibleNodeToArm(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final DvArm convertVisibleNodeToArm(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof DvArm ? (DvArm)node : (basicNode instanceof DataSourceNode ? (DvArm)this.forest.getBushRef((DataSourceNode)((BasicUniqueBush)node)) : null);
    }

    @ApiStatus.Internal
    @TestOnly
    public final void clearAll() {
        DvForest.modifyTree$default(this.forest, false, () -> DvForestService.clearAll$lambda$0(this), 1, null);
    }

    private static final Unit importRestDataSources$lambda$0(Set $dsNodes, DvForestService this$0, boolean $force) {
        for (DataSourceNode dsNode : $dsNodes) {
            DvBushRef<DataSourceNode> br;
            if (this$0.forest.isBushRegistered((DataSourceNode)((BasicUniqueBush)dsNode)) && !$force) continue;
            DvBushRef<DataSourceNode> dvBushRef = br = this$0.forest.getBushRef((DataSourceNode)((BasicUniqueBush)dsNode));
            DvFolder brp = dvBushRef != null ? dvBushRef.getParent() : null;
            String pathStr = StringFun.trimOrNull((String)dsNode.getGroupName());
            DvFolder folder = null;
            if (pathStr == null) {
                folder = this$0.forest.getRoot();
            } else {
                String[] path = pathStr.split("/");
                folder = this$0.forest.ensureFolderPath(path);
            }
            if (brp == folder) continue;
            if (brp != null) {
                brp.excludeBushRef(br, false);
                DvFolder.resurrectBushRef$default(folder, br, false, 0, 4, null);
                continue;
            }
            folder.createNewInnerBush((BasicUniqueBush)dsNode);
        }
        return Unit.INSTANCE;
    }

    private static final Unit selfInspect$lambda$0(DvForestService this$0, ArrayList $problems, HashSet $orphans) {
        Iterator traversingFolders;
        Iterator iterator = traversingFolders = this$0.forest.getFoldersTree().traverseBreadthFirst();
        while (iterator.hasNext()) {
            int i2;
            DvFolder folder = (DvFolder)iterator.next();
            String folderPath = folder.getPath();
            int n = folder.getInnerFolders().size();
            for (i2 = 0; i2 < n; ++i2) {
                DvNiceFolder c2 = folder.getInnerFolders().get(i2);
                if (!Intrinsics.areEqual((Object)c2.getParent(), (Object)folder)) {
                    ((Collection)$problems).add(new Problem(c2, ProblemType.problemFoundling, "Folder '" + folder + "' has inner folder '" + c2 + "' but it's parent is '" + c2.getParent() + "'."));
                }
                if (c2.getPosition() == i2) continue;
                ((Collection)$problems).add(new Problem(c2, ProblemType.problemStrayPosition, "Folder '" + c2 + "' has position " + c2.getPosition() + " but it really stays at position " + i2 + "."));
            }
            n = folder.getInnerBushRefList().size();
            for (i2 = 0; i2 < n; ++i2) {
                Object obj;
                DataSourceNode dsn;
                DvBushRef<?> b = folder.getInnerBushRefList().get(i2);
                if (!Intrinsics.areEqual((Object)b.getParent(), (Object)folder)) {
                    Collection collection = $problems;
                    Intrinsics.checkNotNull(b);
                    collection.add(new Problem(b, ProblemType.problemFoundling, "Folder '" + folder + "' has bush ref '" + b + "' but it's parent is '" + b.getParent() + "'."));
                }
                if (b.getPosition() != i2) {
                    Collection collection = $problems;
                    Intrinsics.checkNotNull(b);
                    collection.add(new Problem(b, ProblemType.problemStrayPosition, "Bush ref '" + b + "' has position " + b.getPosition() + " but it really stays at position " + i2 + "."));
                }
                DataSourceNode dataSourceNode = dsn = (obj = b.getBush()) instanceof DataSourceNode ? (DataSourceNode)obj : null;
                if (dsn != null) {
                    ((Collection)$orphans).remove(dsn);
                    String dsnPath = StringFun.trimOrNull((String)dsn.dataSource.getGroupName());
                    if (Intrinsics.areEqual((Object)dsnPath, (Object)folderPath)) continue;
                    Collection collection = $problems;
                    Intrinsics.checkNotNull(b);
                    collection.add(new Problem(b, ProblemType.problemDataSourceWrongPath, "Data source " + b + " (" + dsn.getDisplayName() + ") has path '" + dsnPath + "' but the real path is '" + folderPath + "'."));
                    continue;
                }
                Collection collection = $problems;
                Intrinsics.checkNotNull(b);
                collection.add(new Problem(b, ProblemType.problemPhantomBush, "Folder '" + folder + "' has a phantom bush ref '" + b + "' (it's bush is null)."));
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit recoverProblems$lambda$1(Map $groupedProblems, DvForestService this$0) {
        block7: for (Map.Entry entry : $groupedProblems.entrySet()) {
            ProblemType type = (ProblemType)((Object)entry.getKey());
            List problems = (List)entry.getValue();
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    BasicNode foundling;
                    Iterator $this$filterIsInstanceTo$iv$iv;
                    Object $this$filterIsInstance$iv;
                    Object $this$mapTo$iv$iv;
                    Iterable $this$map$iv = problems;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void p0;
                        Object item$iv$iv = iterator.next();
                        Problem problem = (Problem)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(p0.node);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$filterIsInstance = false;
                    $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo2 = false;
                    iterator = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv$iv = iterator.next();
                        if (!(element$iv$iv instanceof DvArm)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List foundlings = (List)destination$iv$iv;
                    $this$filterIsInstance$iv = this$0.forest.getFoldersTree().traverseBreadthFirst();
                    while ($this$filterIsInstance$iv.hasNext()) {
                        DvFolder folder = (DvFolder)$this$filterIsInstance$iv.next();
                        $this$filterIsInstanceTo$iv$iv = foundlings.iterator();
                        while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                            foundling = (DvArm)$this$filterIsInstanceTo$iv$iv.next();
                            if (Intrinsics.areEqual((Object)((DvArm)foundling).getParent(), (Object)folder)) continue;
                            BasicNode $i$f$filterIsInstanceTo2 = foundling;
                            if ($i$f$filterIsInstanceTo2 instanceof DvNiceFolder) {
                                if (!folder.getInnerFolders().contains(foundling)) continue;
                                folder.excludeFolder((DvNiceFolder)foundling, true);
                                continue;
                            }
                            if (!($i$f$filterIsInstanceTo2 instanceof DvBushRef) || !folder.getInnerBushRefList().contains(foundling)) continue;
                            folder.excludeBushRef((DvBushRef)foundling, false);
                        }
                    }
                    continue block7;
                }
                case 2: {
                    BasicNode foundling;
                    Iterator<Object> iterator;
                    for (Object problem : problems) {
                        AbstractDataSource ds;
                        DataSourceNode dsn;
                        DvBushRef bushRef;
                        foundling = problem.node;
                        if ((foundling instanceof DvBushRef ? (DvBushRef)foundling : null) == null) continue;
                        bushRef = bushRef;
                        DvFolder parent = bushRef.getParent();
                        iterator = bushRef.getBush();
                        if ((iterator instanceof DataSourceNode ? (DataSourceNode)((Object)iterator) : null) == null) continue;
                        dsn = dsn;
                        RawDataSource rawDataSource = dsn.dataSource;
                        if ((rawDataSource instanceof AbstractDataSource ? (AbstractDataSource)rawDataSource : null) == null) continue;
                        ds = ds;
                        ds.setGroupName(parent.getPath());
                    }
                    continue block7;
                }
                case 3: {
                    Object problem;
                    Object $this$filterIsInstance$iv;
                    problem = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)problems), (Function1)((Function1)recoverProblems.1.huggerMaggerFolders.1.INSTANCE));
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)recoverProblems$lambda$1$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    Set huggerMaggerFolders2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)recoverProblems.1.huggerMaggerFolders.2.INSTANCE)));
                    $this$filterIsInstance$iv = huggerMaggerFolders2.iterator();
                    while ($this$filterIsInstance$iv.hasNext()) {
                        DvFolder hmFolder = (DvFolder)$this$filterIsInstance$iv.next();
                        hmFolder.fixFoldersPositions();
                        hmFolder.fixBushesPositions();
                    }
                    continue block7;
                }
                case 4: {
                    void $this$sortedByDescending$iv;
                    Object $this$filterIsInstance$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)problems), (Function1)((Function1)recoverProblems.1.phantoms.1.INSTANCE));
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)recoverProblems$lambda$1$$inlined$filterIsInstance$2.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    $this$filterIsInstance$iv = sequence;
                    boolean $i$f$sortedByDescending = false;
                    List phantoms2 = SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            DvBushRef p0 = (DvBushRef)b;
                            boolean bl = false;
                            Comparable comparable = Integer.valueOf(p0.getOrderId());
                            p0 = (DvBushRef)a;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(p0.getOrderId()));
                        }
                    }));
                    for (DvBushRef phantom : phantoms2) {
                        DvFolder p = phantom.getParent();
                        p.excludeBushRef(phantom, false);
                    }
                    continue block7;
                }
                case 5: {
                    DvForestService.importRestDataSources$default(this$0, false, 1, null);
                    continue block7;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit clearAll$lambda$0(DvForestService this$0) {
        this$0.forest.clearAll$intellij_database_core_impl();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006J\n\u0010\u0007\u001a\u00020\u0003H\u0096\u0080\u0004J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\r\u001a\u00020\u000eH\u00d6\u0081\u0004R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/explorer/forest/DvForestService$ForestState;", "", "data", "", "<init>", "(Ljava/lang/String;)V", "()V", "toString", "component1", "copy", "equals", "", "other", "hashCode", "", "intellij.database.core.impl"})
    public static final class ForestState {
        @JvmField
        @Nullable
        public String data;

        public ForestState(@Nullable String data) {
            this.data = data;
        }

        public ForestState() {
            this(null);
        }

        @NotNull
        public String toString() {
            String string = this.data;
            if (string == null) {
                string = "<nothing>";
            }
            return string;
        }

        @Nullable
        public final String component1() {
            return this.data;
        }

        @NotNull
        public final ForestState copy(@Nullable String data) {
            return new ForestState(data);
        }

        public static /* synthetic */ ForestState copy$default(ForestState forestState, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = forestState.data;
            }
            return forestState.copy(string);
        }

        public int hashCode() {
            return this.data == null ? 0 : this.data.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ForestState)) {
                return false;
            }
            ForestState forestState = (ForestState)other;
            return Intrinsics.areEqual((Object)this.data, (Object)forestState.data);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000b\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u000e\u0010\r\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u00c6\u0003J,\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\r\b\u0002\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0007H\u00d6\u0081\u0004R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/explorer/forest/DvForestService$Problem;", "", "node", "Lcom/intellij/database/model/basic/BasicNode;", "type", "Lcom/intellij/database/explorer/forest/DvForestService$ProblemType;", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/database/model/basic/BasicNode;Lcom/intellij/database/explorer/forest/DvForestService$ProblemType;Ljava/lang/String;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.database.core.impl"})
    public static final class Problem {
        @JvmField
        @NotNull
        public final BasicNode node;
        @JvmField
        @NotNull
        public final ProblemType type;
        @JvmField
        @NotNull
        public final String text;

        public Problem(@NotNull BasicNode node, @NotNull ProblemType type, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.node = node;
            this.type = type;
            this.text = text2;
        }

        @NotNull
        public final BasicNode component1() {
            return this.node;
        }

        @NotNull
        public final ProblemType component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.text;
        }

        @NotNull
        public final Problem copy(@NotNull BasicNode node, @NotNull ProblemType type, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new Problem(node, type, text2);
        }

        public static /* synthetic */ Problem copy$default(Problem problem, BasicNode basicNode, ProblemType problemType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                basicNode = problem.node;
            }
            if ((n & 2) != 0) {
                problemType = problem.type;
            }
            if ((n & 4) != 0) {
                string = problem.text;
            }
            return problem.copy(basicNode, problemType, string);
        }

        @NotNull
        public String toString() {
            return "Problem(node=" + this.node + ", type=" + this.type + ", text=" + this.text + ")";
        }

        public int hashCode() {
            int result = this.node.hashCode();
            result = result * 31 + this.type.hashCode();
            result = result * 31 + this.text.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Problem)) {
                return false;
            }
            Problem problem = (Problem)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)problem.node)) {
                return false;
            }
            if (this.type != problem.type) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.text, (Object)problem.text);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/intellij/database/explorer/forest/DvForestService$ProblemType;", "", "displayName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "problemFoundling", "problemStrayPosition", "problemPhantomBush", "problemDataSourceWrongPath", "problemOrphanDataSource", "intellij.database.core.impl"})
    public static final class ProblemType
    extends Enum<ProblemType> {
        @NotNull
        private final String displayName;
        public static final /* enum */ ProblemType problemFoundling = new ProblemType("Foundling");
        public static final /* enum */ ProblemType problemStrayPosition = new ProblemType("Stray position");
        public static final /* enum */ ProblemType problemPhantomBush = new ProblemType("Phantom bush");
        public static final /* enum */ ProblemType problemDataSourceWrongPath = new ProblemType("Wrong path");
        public static final /* enum */ ProblemType problemOrphanDataSource = new ProblemType("Orphan data source");
        private static final /* synthetic */ ProblemType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ProblemType(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static ProblemType[] values() {
            return (ProblemType[])$VALUES.clone();
        }

        public static ProblemType valueOf(String value) {
            return Enum.valueOf(ProblemType.class, value);
        }

        @NotNull
        public static EnumEntries<ProblemType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = problemTypeArray = new ProblemType[]{ProblemType.problemFoundling, ProblemType.problemStrayPosition, ProblemType.problemPhantomBush, ProblemType.problemDataSourceWrongPath, ProblemType.problemOrphanDataSource};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProblemType.values().length];
            try {
                nArray[ProblemType.problemFoundling.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemType.problemDataSourceWrongPath.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemType.problemStrayPosition.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemType.problemPhantomBush.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProblemType.problemOrphanDataSource.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

