/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.structure;

import com.intellij.codeWithMe.ClientId;
import com.intellij.database.BasicModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.explorer.forest.DvRootFolder;
import com.intellij.database.explorer.structure.DvDsGroup;
import com.intellij.database.explorer.structure.DvRootDsGroup;
import com.intellij.database.explorer.structure.DvSimpleDsGroup;
import com.intellij.database.explorer.structure.DvTreeAbstractLayer;
import com.intellij.database.explorer.structure.DvTreeStoreyLayer;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.common.AtomicIncrementalValueCache;
import com.intellij.database.util.common.MapFun;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.text.StringKt;
import java.lang.invoke.CallSite;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 C2\u00020\u0001:\u0002CDB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0010\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020#H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u000bH\u0002J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010$\u001a\u00020#H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010+\u001a\u00020&H\u0002J\u001e\u0010,\u001a\b\u0012\u0004\u0012\u00020-0)2\u0006\u0010+\u001a\u00020-2\u0006\u0010.\u001a\u00020\u000eH\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0)2\u0006\u0010+\u001a\u00020-H\u0002J\u0010\u00100\u001a\u00020\u00102\u0006\u0010$\u001a\u00020#H\u0016J\u0010\u00101\u001a\u00020\u00052\u0006\u0010$\u001a\u00020#H\u0016J\u0015\u00102\u001a\u00020\u00172\u0006\u00103\u001a\u000204H\u0010\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020\u00172\u0006\u00103\u001a\u000204H\u0010\u00a2\u0006\u0002\b7J\u001d\u00108\u001a\u00020\u00172\u0006\u00103\u001a\u0002042\u0006\u00109\u001a\u00020:H\u0010\u00a2\u0006\u0002\b;J\r\u0010<\u001a\u00020\u0017H\u0010\u00a2\u0006\u0002\b=J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u000b0)H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010$\u001a\u00020#H\u0016J\u0010\u0010A\u001a\u00020@2\u0006\u0010$\u001a\u00020#H\u0016J\b\u0010B\u001a\u00020\u0017H\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006E"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeDsFoldersLayer;", "Lcom/intellij/database/explorer/structure/DvTreeStoreyLayer;", "<init>", "()V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "dataSources", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lcom/intellij/database/view/DataSourceNode;", "groupsCache", "Lcom/intellij/database/util/common/AtomicIncrementalValueCache;", "Lcom/intellij/database/explorer/structure/DvTreeDsFoldersLayer$Groups;", "groupingOption", "", "grouping", "getGrouping", "()Z", "rootGroup", "Lcom/intellij/database/explorer/structure/DvRootDsGroup;", "setup", "", "base", "Lcom/intellij/database/explorer/structure/DvTreeAbstractLayer;", "setup$intellij_database_core_impl", "retrieveAllDataSources", "recomputeGroups", "oldGroups", "root", "Lcom/intellij/database/explorer/forest/DvRootFolder;", "getRoot", "()Lcom/intellij/database/explorer/forest/DvRootFolder;", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "groupOfDataSource", "Lcom/intellij/database/explorer/structure/DvDsGroup;", "dsn", "childrenOf", "Lkotlin/sequences/Sequence;", "childrenOfGroup", "group", "listNestedGroups", "Lcom/intellij/database/explorer/structure/DvSimpleDsGroup;", "groups", "listNestedDataSources", "isAlwaysLeaf", "presentableNameOf", "onDataSourceAdded", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceRemoved", "dbms", "Lcom/intellij/database/Dbms;", "onDataSourceRemoved$intellij_database_core_impl", "onViewOptionsChanged", "onViewOptionsChanged$intellij_database_core_impl", "listAllDataSourceNodes", "countAllChildrenOf", "", "countRealChildrenOf", "clearAll", "Companion", "Groups", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeDsFoldersLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeDsFoldersLayer.kt\ncom/intellij/database/explorer/structure/DvTreeDsFoldersLayer\n+ 2 DvTreeDsFoldersLayer.kt\ncom/intellij/database/explorer/structure/DvTreeDsFoldersLayer$Companion\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,294:1\n222#2:295\n42#3,3:296\n*S KotlinDebug\n*F\n+ 1 DvTreeDsFoldersLayer.kt\ncom/intellij/database/explorer/structure/DvTreeDsFoldersLayer\n*L\n67#1:295\n190#1:296,3\n*E\n"})
public final class DvTreeDsFoldersLayer
extends DvTreeStoreyLayer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentSkipListMap<String, DataSourceNode> dataSources = new ConcurrentSkipListMap();
    @NotNull
    private final AtomicIncrementalValueCache<Groups> groupsCache = new AtomicIncrementalValueCache((Object)noGroups, (Function1)new Function1<Groups, Groups>((Object)this){

        public final Groups invoke(Groups p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return DvTreeDsFoldersLayer.access$recomputeGroups((DvTreeDsFoldersLayer)this.receiver, p0);
        }
    });
    private volatile boolean groupingOption;
    @NotNull
    private final DvRootDsGroup rootGroup = new DvRootDsGroup();
    @Deprecated
    public static final char KS = '\u0001';
    @NotNull
    private static final Groups noGroups = new Groups();

    @Override
    @NotNull
    protected String getName() {
        return "Folders";
    }

    private final boolean getGrouping() {
        return this.groupingOption;
    }

    @Override
    public void setup$intellij_database_core_impl(@NotNull DvTreeAbstractLayer base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super.setup$intellij_database_core_impl(base);
        this.groupsCache.reset();
        this.groupingOption = this.getVo().getGroupDataSources();
        if (this.groupingOption) {
            this.retrieveAllDataSources();
        }
    }

    private final void retrieveAllDataSources() {
        for (DataSourceNode dsn : this.listAllDataSourceNodes()) {
            Map map = this.dataSources;
            Object object = Companion;
            DataSourceNode $this$key$iv = dsn;
            boolean $i$f$getKey = false;
            String string = $this$key$iv.getGroupName();
            if (string == null) {
                string = "";
            }
            object = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001\u0002\u0001", "\u0001", "\u0001"}, (String)string, $this$key$iv.getDisplayName(), $this$key$iv.getUniqueId());
            map.put(object, dsn);
        }
        this.groupsCache.invalidate();
    }

    private final Groups recomputeGroups(Groups oldGroups) {
        Collection<DataSourceNode> collection = this.dataSources.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        List paths = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)SequenceFun.asSequence(collection)), DvTreeDsFoldersLayer::recomputeGroups$lambda$0));
        Groups newGroups = !((Collection)paths).isEmpty() ? new Groups(paths, this.rootGroup, (Map<String, DvSimpleDsGroup>)oldGroups.all) : noGroups;
        return newGroups;
    }

    @Override
    @NotNull
    public DvRootFolder getRoot() {
        return this.rootGroup;
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.getGrouping()) {
            BasicNode basicNode2 = node;
            if (basicNode2 instanceof DataSourceNode) {
                DvDsGroup dvDsGroup = this.groupOfDataSource((DataSourceNode)node);
                basicNode = dvDsGroup != null ? (BasicNode)dvDsGroup : (BasicNode)this.getRoot();
            } else {
                basicNode = basicNode2 instanceof DvDsGroup ? (BasicNode)((DvDsGroup)node).getParent$intellij_database_core_impl() : this.getBase().parentOf(node);
            }
        } else {
            basicNode = node instanceof DvRootFolder ? null : this.getRoot();
        }
        return basicNode;
    }

    private final DvDsGroup groupOfDataSource(DataSourceNode dsn) {
        String path = dsn.getGroupName();
        CharSequence charSequence = path;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return ((Groups)this.groupsCache.getContent()).get(path);
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvDsGroup ? this.childrenOfGroup((DvDsGroup)node) : this.getBase().childrenOf(node);
    }

    private final Sequence<BasicNode> childrenOfGroup(DvDsGroup group) {
        if (!this.getGrouping()) {
            return this.getBase().childrenOf(group);
        }
        Groups groups = (Groups)this.groupsCache.getContent();
        Sequence<DvSimpleDsGroup> theGroups = null;
        Sequence theDataSources = null;
        DvDsGroup dvDsGroup = group;
        if (dvDsGroup instanceof DvRootFolder) {
            theGroups = (Sequence<DvSimpleDsGroup>)SequenceFun.asSequence((Collection)groups.top);
            theDataSources = (Sequence)SequenceFun.asSequence(this.dataSources.subMap((Object)"\u0001", (Object)"\u0001\uffff").values());
        } else if (dvDsGroup instanceof DvSimpleDsGroup) {
            theGroups = this.listNestedGroups((DvSimpleDsGroup)group, groups);
            theDataSources = this.listNestedDataSources((DvSimpleDsGroup)group);
        } else {
            return SequencesKt.emptySequence();
        }
        return SequencesKt.plus(theGroups, (Sequence)theDataSources);
    }

    private final Sequence<DvSimpleDsGroup> listNestedGroups(DvSimpleDsGroup group, Groups groups) {
        String path = group.path;
        String from = path + "/";
        String till = path + "/\uffff";
        Collection<DvSimpleDsGroup> collection = groups.all.subMap(from, till).values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return SequencesKt.filter((Sequence)((Sequence)SequenceFun.asSequence(collection)), arg_0 -> DvTreeDsFoldersLayer.listNestedGroups$lambda$0(group, arg_0));
    }

    private final Sequence<DataSourceNode> listNestedDataSources(DvSimpleDsGroup group) {
        String path = group.path;
        CallSite from = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001"}, (String)path);
        CallSite till = StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002", "\u0001\uffff"}, (String)path);
        return (Sequence)SequenceFun.asSequence(this.dataSources.subMap(from, till).values());
    }

    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvDsGroup ? false : this.getBase().isAlwaysLeaf(node);
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvSimpleDsGroup ? ((DvSimpleDsGroup)node).getDisplayName() : this.getBase().presentableNameOf(node);
    }

    @Override
    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.retrieveAllDataSources();
    }

    @Override
    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        MapFun.removeIf((Map)this.dataSources, arg_0 -> DvTreeDsFoldersLayer.onDataSourcePathChanged$lambda$0(dataSource, arg_0));
        this.retrieveAllDataSources();
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        MapFun.removeIf((Map)this.dataSources, arg_0 -> DvTreeDsFoldersLayer.onDataSourceRemoved$lambda$0(dataSource, arg_0));
        this.groupsCache.invalidate();
    }

    @Override
    public void onViewOptionsChanged$intellij_database_core_impl() {
        boolean newGroupingOption = this.getVo().getGroupDataSources();
        if (newGroupingOption == this.groupingOption) {
            return;
        }
        this.groupingOption = newGroupingOption;
        if (this.groupingOption) {
            this.retrieveAllDataSources();
        } else {
            this.groupsCache.reset();
        }
    }

    private final Sequence<DataSourceNode> listAllDataSourceNodes() {
        boolean $i$f$service = false;
        Class<BasicModelRegistry> serviceClass$iv = BasicModelRegistry.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((BasicModelRegistry)object).listDataSourceNodesForProject(this.getContext().project);
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvDsGroup ? SequenceFun.getSize(this.childrenOfGroup((DvDsGroup)node)) : this.getBase().countAllChildrenOf(node);
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return node instanceof DvDsGroup ? SequenceFun.getSize(this.childrenOfGroup((DvDsGroup)node)) : this.getBase().countRealChildrenOf(node);
    }

    @Override
    public void clearAll() {
        this.groupsCache.invalidate();
    }

    private static final String recomputeGroups$lambda$0(DataSourceNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getGroupName();
        return StringKt.nullize((String)(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null), (boolean)true);
    }

    private static final boolean listNestedGroups$lambda$0(DvSimpleDsGroup $group, DvSimpleDsGroup it) {
        return it.getParent$intellij_database_core_impl() == $group;
    }

    private static final boolean onDataSourcePathChanged$lambda$0(RawDataSource $dataSource, Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return ((DataSourceNode)e.getValue()).dataSource == $dataSource;
    }

    private static final boolean onDataSourceRemoved$lambda$0(RawDataSource $dataSource, Map.Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return ((DataSourceNode)e.getValue()).dataSource == $dataSource;
    }

    public static final /* synthetic */ Groups access$recomputeGroups(DvTreeDsFoldersLayer $this, Groups oldGroups) {
        return $this.recomputeGroups(oldGroups);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeDsFoldersLayer$Companion;", "", "<init>", "()V", "KS", "", "key", "", "Lcom/intellij/database/view/DataSourceNode;", "getKey", "(Lcom/intellij/database/view/DataSourceNode;)Ljava/lang/String;", "noGroups", "Lcom/intellij/database/explorer/structure/DvTreeDsFoldersLayer$Groups;", "getNoGroups", "()Lcom/intellij/database/explorer/structure/DvTreeDsFoldersLayer$Groups;", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getKey(@NotNull DataSourceNode $this$key) {
            Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
            boolean $i$f$getKey = false;
            String string = $this$key.getGroupName();
            if (string == null) {
                string = "";
            }
            return StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0002\u0001\u0002\u0001", "\u0001", "\u0001"}, (String)string, $this$key.getDisplayName(), $this$key.getUniqueId());
        }

        @NotNull
        public final Groups getNoGroups() {
            return noGroups;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B3\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bB\t\b\u0016\u00a2\u0006\u0004\b\n\u0010\fJ\u0013\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0004H\u0086\u0002J\n\u0010\u0015\u001a\u00020\u0004H\u0096\u0080\u0004R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u00108\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeDsFoldersLayer$Groups;", "", "paths", "", "", "root", "Lcom/intellij/database/explorer/structure/DvDsGroup;", "existentGroups", "", "Lcom/intellij/database/explorer/structure/DvSimpleDsGroup;", "<init>", "(Ljava/util/Collection;Lcom/intellij/database/explorer/structure/DvDsGroup;Ljava/util/Map;)V", "()V", "top", "", "all", "Ljava/util/NavigableMap;", "filled", "", "get", "path", "toString", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeDsFoldersLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeDsFoldersLayer.kt\ncom/intellij/database/explorer/structure/DvTreeDsFoldersLayer$Groups\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,294:1\n1021#2,2:295\n*S KotlinDebug\n*F\n+ 1 DvTreeDsFoldersLayer.kt\ncom/intellij/database/explorer/structure/DvTreeDsFoldersLayer$Groups\n*L\n275#1:295,2\n*E\n"})
    private static final class Groups {
        @JvmField
        @NotNull
        public final List<DvSimpleDsGroup> top;
        @JvmField
        @NotNull
        public final NavigableMap<String, DvSimpleDsGroup> all;
        @JvmField
        public final boolean filled;

        public Groups(@NotNull Collection<String> paths, @NotNull DvDsGroup root, @NotNull Map<String, DvSimpleDsGroup> existentGroups) {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(existentGroups, (String)"existentGroups");
            ArrayList<DvSimpleDsGroup> top = new ArrayList<DvSimpleDsGroup>();
            TreeMap<String, DvSimpleDsGroup> all = new TreeMap<String, DvSimpleDsGroup>();
            for (String path : paths) {
                Groups._init_$obtainGroup(all, existentGroups, root, top, path);
            }
            List $this$sortBy$iv = top;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        DvSimpleDsGroup it = (DvSimpleDsGroup)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)it.getName());
                        it = (DvSimpleDsGroup)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                    }
                });
            }
            this.all = all;
            this.top = top;
            this.filled = !((Map)all).isEmpty();
        }

        public Groups() {
            NavigableMap navigableMap = Collections.emptyNavigableMap();
            Intrinsics.checkNotNullExpressionValue(navigableMap, (String)"emptyNavigableMap(...)");
            this.all = navigableMap;
            List list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            this.top = list;
            this.filled = false;
        }

        @Nullable
        public final DvSimpleDsGroup get(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return (DvSimpleDsGroup)this.all.get(path);
        }

        @NotNull
        public String toString() {
            return "Groups(" + this.top.size() + " top, " + this.all.size() + " all)";
        }

        private static final void _init_$handleExistentGroup(DvDsGroup $root, ArrayList<DvSimpleDsGroup> top, TreeMap<String, DvSimpleDsGroup> all, DvSimpleDsGroup group) {
            DvDsGroup p = group.getParent$intellij_database_core_impl();
            if (p instanceof DvSimpleDsGroup) {
                Groups._init_$handleExistentGroup($root, top, all, (DvSimpleDsGroup)p);
            } else if (Intrinsics.areEqual((Object)p, (Object)$root) && !top.contains(group)) {
                ((Collection)top).add(group);
            }
            ((Map)all).put(group.path, group);
        }

        private static final DvSimpleDsGroup _init_$obtainGroup(TreeMap<String, DvSimpleDsGroup> all, Map<String, DvSimpleDsGroup> $existentGroups, DvDsGroup $root, ArrayList<DvSimpleDsGroup> top, String path) {
            DvSimpleDsGroup g = all.get(path);
            if (g == null && (g = $existentGroups.get(path)) != null) {
                Groups._init_$handleExistentGroup($root, top, all, g);
            }
            if (g == null) {
                int k = StringsKt.lastIndexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (k > 0) {
                    String string = path.substring(k + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String name = string;
                    String string2 = path.substring(0, k);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    String parentPath = string2;
                    DvSimpleDsGroup parent = Groups._init_$obtainGroup(all, $existentGroups, $root, top, parentPath);
                    g = new DvSimpleDsGroup(parent, name);
                } else {
                    g = new DvSimpleDsGroup($root, path);
                    ((Collection)top).add(g);
                }
                ((Map)all).put(path, g);
            }
            return g;
        }
    }
}

