/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.explorer.structure;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.explorer.structure.CollectionCache;
import com.intellij.database.explorer.structure.DvFun;
import com.intellij.database.explorer.structure.DvTreeAbstractLayer;
import com.intellij.database.explorer.structure.DvTreeStoreyLayer;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 P2\u00020\u0001:\u0001PB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0010\u00a2\u0006\u0002\b\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u000f*\u00020\u001bH\u0002J\u0014\u0010\u001c\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u001a\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030$0\"2\u0006\u0010%\u001a\u00020\u0019H\u0002J\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\"2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160\"2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160\"2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190\"2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\"2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\u001a\u0010,\u001a\n\u0012\u0004\u0012\u00020.\u0018\u00010-2\b\u0010\u001f\u001a\u0004\u0018\u00010/H\u0002J\u0012\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u0019H\u0002J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f04H\u0002J\u0010\u00105\u001a\u0002062\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0015\u00107\u001a\u00020\u00112\u0006\u00108\u001a\u000209H\u0010\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u00020\u00112\u0006\u00108\u001a\u000209H\u0010\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020\u00112\u0006\u00108\u001a\u000209H\u0010\u00a2\u0006\u0002\b>J\u001d\u0010?\u001a\u00020\u00112\u0006\u00108\u001a\u0002092\u0006\u0010@\u001a\u00020AH\u0010\u00a2\u0006\u0002\bBJ\u0010\u0010C\u001a\u00020\u000f2\u0006\u0010D\u001a\u000209H\u0002J\u0010\u0010E\u001a\u00020\u00112\u0006\u0010D\u001a\u000209H\u0002J\u0010\u0010F\u001a\u00020\u00112\u0006\u0010D\u001a\u000209H\u0002J\u0010\u0010G\u001a\u00020H2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010I\u001a\u00020H2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0014\u0010J\u001a\u00020H2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030$H\u0002J\u0010\u0010K\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0014\u0010L\u001a\u00020\u00052\n\u0010'\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0002J\b\u0010M\u001a\u00020\u0011H\u0002J\b\u0010N\u001a\u00020\u0011H\u0016J\u0010\u0010O\u001a\u0002062\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeModelLayer;", "Lcom/intellij/database/explorer/structure/DvTreeStoreyLayer;", "<init>", "()V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "getName", "()Ljava/lang/String;", "project", "Lcom/intellij/openapi/project/Project;", "knownViewOptionsCounter", "", "dataSources", "Lcom/intellij/database/explorer/structure/CollectionCache;", "Lcom/intellij/database/view/DataSourceNode;", "setup", "", "base", "Lcom/intellij/database/explorer/structure/DvTreeAbstractLayer;", "setup$intellij_database_core_impl", "parentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "parentOfElement", "Lcom/intellij/database/model/basic/BasicElement;", "dataSourceNode", "Lcom/intellij/database/model/basic/BasicRoot;", "parentOfFamily", "Lcom/intellij/database/model/families/HostFamily;", "getDataSourceNodeFor", "model", "Lcom/intellij/database/model/DasModel;", "childrenOf", "Lkotlin/sequences/Sequence;", "listElementFamilies", "Lcom/intellij/database/model/families/Family;", "element", "listFamilyChildren", "family", "listDatabases", "listSchemas", "listNamespacesToShow", "listRegularFamilyElements", "getObjectFilterForRegularObjects", "Ljava/util/function/Predicate;", "Lcom/intellij/database/model/DasObject;", "Lcom/intellij/database/model/basic/BasicModel;", "getScope", "Lcom/intellij/database/util/TreePattern;", "host", "retrieveAllDataSourceNodes", "", "isAlwaysLeaf", "", "onDataSourceAdded", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "onDataSourceAdded$intellij_database_core_impl", "onDataSourceChanged", "onDataSourceChanged$intellij_database_core_impl", "onDataSourcePathChanged", "onDataSourcePathChanged$intellij_database_core_impl", "onDataSourceRemoved", "dbms", "Lcom/intellij/database/Dbms;", "onDataSourceRemoved$intellij_database_core_impl", "getDSN", "ds", "addDSN", "removeDSN", "countAllChildrenOf", "", "countRealChildrenOf", "countRealChildrenOfFamily", "presentableNameOf", "presentableNameOfFamily", "invalidateCaches", "clearAll", "isValid", "Companion", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nDvTreeModelLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/explorer/structure/DvTreeModelLayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,249:1\n1#2:250\n*E\n"})
public final class DvTreeModelLayer
extends DvTreeStoreyLayer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private Project project;
    private long knownViewOptionsCounter = -1L;
    @NotNull
    private final CollectionCache<DataSourceNode> dataSources = new CollectionCache(() -> DvTreeModelLayer.dataSources$lambda$0(this));
    @NotNull
    private static final List<Class<?>> excluded = CollectionsKt.listOf(BasicArgument.class);
    @NotNull
    private static final List<Class<?>> alwaysLeafs;

    @Override
    @NotNull
    protected String getName() {
        return "Model";
    }

    @Override
    public void setup$intellij_database_core_impl(@NotNull DvTreeAbstractLayer base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        super.setup$intellij_database_core_impl(base);
        this.project = base.getContext().project;
        this.knownViewOptionsCounter = this.getVo().getModificationCount();
    }

    @Override
    @Nullable
    public BasicNode parentOf(@NotNull BasicNode node) {
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode2 = node;
        if (basicNode2 instanceof BasicElement) {
            basicNode = this.parentOfElement((BasicElement)node);
        } else if (basicNode2 instanceof HostFamily) {
            basicNode = this.parentOfFamily((HostFamily)node);
        } else if (basicNode2 instanceof DataSourceNode) {
            basicNode = this.getBase().parentOf(node);
            if (basicNode == null) {
                basicNode = this.getRoot();
            }
        } else {
            basicNode = this.getBase().parentOf(node);
        }
        return basicNode;
    }

    private final BasicNode parentOfElement(BasicElement node) {
        return node instanceof BasicRoot ? (BasicNode)this.getRoot() : (BasicNode)node.getParentFamily();
    }

    private final DataSourceNode dataSourceNode(BasicRoot $this$dataSourceNode) {
        BasicModel model;
        BasicModel basicModel = model = $this$dataSourceNode.getModel();
        return basicModel != null ? this.getDataSourceNodeFor(basicModel) : null;
    }

    private final BasicNode parentOfFamily(HostFamily<?> node) {
        DataSourceNode dsn;
        BasicElement basicElement = node.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        BasicNode parent = basicElement;
        if (parent instanceof BasicRoot && (dsn = this.dataSourceNode((BasicRoot)parent)) != null) {
            parent = dsn;
        }
        return parent;
    }

    private final DataSourceNode getDataSourceNodeFor(DasModel model) {
        return model instanceof BasicModel ? this.getContext().modelRegistry.getDataSourceNode((BasicModel)model) : null;
    }

    @Override
    @NotNull
    public Sequence<BasicNode> childrenOf(@NotNull BasicNode node) {
        Object object;
        BasicNode basicNode;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object object2 = this.isAlwaysLeaf(node) ? SequencesKt.emptySequence() : ((basicNode = node) instanceof BasicElement ? this.listElementFamilies((BasicElement)node) : (basicNode instanceof HostFamily ? this.listFamilyChildren((HostFamily)node) : (basicNode instanceof DataSourceNode ? ((object = ((DataSourceNode)node).getModelRoot()) != null && (object = object.getFamilies()) != null && (object = SequenceFun.asSequence((Collection)((Collection)object))) != null ? (Sequence)object : SequencesKt.emptySequence()) : this.getBase().childrenOf(node))));
        return object2;
    }

    private final Sequence<Family<?>> listElementFamilies(BasicElement element) {
        List<? extends Family<? extends BasicElement>> list = element.getFamilies();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getFamilies(...)");
        return SequencesKt.filter((Sequence)((Sequence)SequenceFun.asSequence((Collection)list)), arg_0 -> DvTreeModelLayer.listElementFamilies$lambda$0(this, arg_0));
    }

    private final Sequence<BasicNode> listFamilyChildren(HostFamily<?> family) {
        ObjectKind objectKind;
        return family.isEmpty() ? SequencesKt.emptySequence() : (DbImplUtilCore.DATABASE_KINDS.contains(objectKind = family.getChildrenKind()) ? this.listDatabases(family) : (DbImplUtilCore.SCHEMA_KINDS.contains(objectKind) ? this.listSchemas(family) : this.listRegularFamilyElements(family)));
    }

    private final Sequence<BasicNode> listDatabases(HostFamily<?> family) {
        return this.listNamespacesToShow(family);
    }

    private final Sequence<BasicNode> listSchemas(HostFamily<?> family) {
        return this.listNamespacesToShow(family);
    }

    private final Sequence<BasicElement> listNamespacesToShow(HostFamily<?> family) {
        BasicElement basicElement = family.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getHost(...)");
        TreePattern scope = this.getScope(basicElement);
        Sequence namespaces = scope == null ? (Sequence)ModelFun.asSequence(family) : (Intrinsics.areEqual((Object)scope, (Object)TreePattern.EMPTY) ? SequencesKt.emptySequence() : SequencesKt.filter((Sequence)((Sequence)ModelFun.asSequence(family)), arg_0 -> DvTreeModelLayer.listNamespacesToShow$lambda$0(scope, arg_0)));
        return namespaces;
    }

    private final Sequence<BasicElement> listRegularFamilyElements(HostFamily<?> family) {
        Sequence children = (Sequence)ModelFun.asSequence(family);
        Predicate<DasObject> filter = this.getObjectFilterForRegularObjects(family.getModel());
        if (filter != null) {
            children = SequencesKt.filter((Sequence)children, arg_0 -> DvTreeModelLayer.listRegularFamilyElements$lambda$0(filter, arg_0));
        }
        if (!this.getVo().getShowGeneratedObjects()) {
            children = SequencesKt.filter((Sequence)children, DvTreeModelLayer::listRegularFamilyElements$lambda$1);
        }
        return children;
    }

    private final Predicate<DasObject> getObjectFilterForRegularObjects(BasicModel model) {
        Predicate predicate;
        if (model == null) {
            return null;
        }
        RawDataSource rawDataSource = this.getContext().modelRegistry.getDataSource(model);
        if (rawDataSource == null) {
            return null;
        }
        RawDataSource ds = rawDataSource;
        try {
            predicate = (Predicate)DbImplUtilCore.buildObjectFilter(ds);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
        Predicate filter = predicate;
        return filter;
    }

    private final TreePattern getScope(BasicElement host) {
        if (this.getVo().getShowAllNamespaces()) {
            return null;
        }
        LocalDataSource localDataSource = this.getContext().modelRegistry.getLocalDataSource(host);
        if (localDataSource == null) {
            return null;
        }
        LocalDataSource lds = localDataSource;
        return lds.getIntrospectionScope();
    }

    private final Collection<DataSourceNode> retrieveAllDataSourceNodes() {
        BasicModelRegistry basicModelRegistry = this.getContext().modelRegistry;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            project = null;
        }
        return SequencesKt.toList(basicModelRegistry.listDataSourceNodesForProject(project));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAlwaysLeaf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!(node instanceof BasicElement)) return false;
        BasicMetaObject o = ((BasicElement)node).getMetaObject();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)o);
        if (Companion.kindOfAny(o, alwaysLeafs)) return true;
        Intrinsics.checkNotNullExpressionValue(o.children, (String)"children");
        if (((Object[])o.children).length != 0) return false;
        return true;
    }

    @Override
    public void onDataSourceAdded$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        } else {
            this.addDSN(dataSource);
        }
    }

    @Override
    public void onDataSourceChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        }
    }

    @Override
    public void onDataSourcePathChanged$intellij_database_core_impl(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        }
    }

    @Override
    public void onDataSourceRemoved$intellij_database_core_impl(@NotNull RawDataSource dataSource, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        if (Companion.getAlwaysInvalidateAll()) {
            this.invalidateCaches();
        } else {
            this.removeDSN(dataSource);
        }
    }

    private final DataSourceNode getDSN(RawDataSource ds) {
        return this.getContext().modelRegistry.getDataSourceNode(ds);
    }

    private final void addDSN(RawDataSource ds) {
        DataSourceNode dsn = this.getDSN(ds);
        this.dataSources.include(dsn);
    }

    private final void removeDSN(RawDataSource ds) {
        this.dataSources.exclude((Function1<DataSourceNode, Boolean>)((Function1)arg_0 -> DvTreeModelLayer.removeDSN$lambda$0(ds, arg_0)));
    }

    @Override
    public int countAllChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof Family ? ((Family)node).size() : (basicNode instanceof BasicElement ? ((BasicElement)node).getFamilies().size() : SequencesKt.count(this.childrenOf(node)));
    }

    @Override
    public int countRealChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        BasicNode basicNode = node;
        return basicNode instanceof Family ? this.countRealChildrenOfFamily((Family)node) : (basicNode instanceof BasicElement ? ((BasicElement)node).getFamilies().size() : SequencesKt.count(this.childrenOf(node)));
    }

    private final int countRealChildrenOfFamily(Family<?> family) {
        ObjectKind objectKind;
        return family instanceof HostFamily ? (Intrinsics.areEqual((Object)(objectKind = ((HostFamily)family).getChildrenKind()), (Object)ObjectKind.SCHEMA) ? SequenceFun.getSize(this.listSchemas((HostFamily)family)) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.DATABASE) ? SequenceFun.getSize(this.listDatabases((HostFamily)family)) : ((HostFamily)family).size())) : family.size();
    }

    @Override
    @NotNull
    public String presentableNameOf(@NotNull BasicNode node) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof HostFamily) {
            string = this.presentableNameOfFamily((HostFamily)node);
        } else {
            String string2 = node.getDisplayName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        }
        return string;
    }

    private final String presentableNameOfFamily(HostFamily<?> family) {
        BasicModel basicModel = family.getModel();
        if (basicModel == null) {
            return DvFun.getFamilyPresentableName(family);
        }
        BasicModel model = basicModel;
        ModelHelper helper = ModelFun.getHelper(model);
        String customName = helper.getCustomName(family.getChildrenKind(), true);
        String string = customName;
        if (string == null) {
            string = DvFun.getFamilyPresentableName(family);
        }
        return string;
    }

    private final void invalidateCaches() {
        this.dataSources.invalidate();
    }

    @Override
    public void clearAll() {
        this.invalidateCaches();
    }

    @Override
    public boolean isValid(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return !(node instanceof BasicModElement) || !((BasicModElement)node).isDropped();
    }

    private static final Iterable dataSources$lambda$0(DvTreeModelLayer this$0) {
        return this$0.retrieveAllDataSourceNodes();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean listElementFamilies$lambda$0(DvTreeModelLayer this$0, Family f) {
        if (!(f instanceof HostFamily)) return false;
        BasicMetaObject<?> basicMetaObject = ((HostFamily)f).getMetaObject();
        Intrinsics.checkNotNullExpressionValue(basicMetaObject, (String)"getMetaObject(...)");
        if (Companion.kindOfAny(basicMetaObject, excluded)) return false;
        if (this$0.getVo().getHiddenKinds().contains(((HostFamily)f).getChildrenKind().code())) return false;
        if (this$0.getVo().getShowEmptyGroups()) return true;
        if (DbImplUtilCore.NAMESPACE_KINDS.contains(((HostFamily)f).getChildrenKind())) return true;
        if (!((HostFamily)f).isNotEmpty()) return false;
        return true;
    }

    private static final boolean listNamespacesToShow$lambda$0(TreePattern $scope, BasicElement it) {
        return DataSourceSchemaMapping.matches($scope, it);
    }

    private static final boolean listRegularFamilyElements$lambda$0(Predicate $filter, BasicElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $filter.test(it);
    }

    private static final boolean listRegularFamilyElements$lambda$1(BasicElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isAutoCreated();
    }

    private static final boolean removeDSN$lambda$0(RawDataSource $ds, DataSourceNode dsn) {
        Intrinsics.checkNotNullParameter((Object)dsn, (String)"dsn");
        return dsn.dataSource == $ds;
    }

    static {
        Object[] objectArray = new Class[]{BasicSequence.class, BasicSynonym.class, BasicRoutine.class};
        alwaysLeafs = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u000b\u001a\u00020\f*\u0006\u0012\u0002\b\u00030\r2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005R\u001b\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/explorer/structure/DvTreeModelLayer$Companion;", "", "<init>", "()V", "excluded", "", "Ljava/lang/Class;", "getExcluded", "()Ljava/util/List;", "alwaysLeafs", "getAlwaysLeafs", "kindOfAny", "", "Lcom/intellij/database/model/meta/BasicMetaObject;", "classes", "alwaysInvalidateAll", "getAlwaysInvalidateAll", "()Z", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDvTreeModelLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/explorer/structure/DvTreeModelLayer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,249:1\n1807#2,3:250\n*S KotlinDebug\n*F\n+ 1 DvTreeModelLayer.kt\ncom/intellij/database/explorer/structure/DvTreeModelLayer$Companion\n*L\n241#1:250,3\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Class<?>> getExcluded() {
            return excluded;
        }

        @NotNull
        public final List<Class<?>> getAlwaysLeafs() {
            return alwaysLeafs;
        }

        public final boolean kindOfAny(@NotNull BasicMetaObject<?> $this$kindOfAny, @NotNull List<? extends Class<?>> classes) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter($this$kindOfAny, (String)"<this>");
                Intrinsics.checkNotNullParameter(classes, (String)"classes");
                Iterable $this$any$iv = classes;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Class it = (Class)element$iv;
                        boolean bl2 = false;
                        if (!$this$kindOfAny.kindOf(it)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public final boolean getAlwaysInvalidateAll() {
            return Registry.Companion.is("database.view.layers.model.alwaysInvalidateAll");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

