/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.CombinedIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTaskInnerHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternEntryKey;
import com.intellij.database.util.TreePatternFun;
import com.intellij.database.util.TreePatternNode;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0011\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/introspection/ScopeIntrospectionTask;", "Lcom/intellij/database/introspection/CombinedIntrospectionTask;", "dataSourceId", "", "scope", "Lcom/intellij/database/util/TreePattern;", "<init>", "(Ljava/lang/String;Lcom/intellij/database/util/TreePattern;)V", "getScope", "()Lcom/intellij/database/util/TreePattern;", "databaseName", "getDatabaseName", "()Ljava/lang/String;", "taskTypeOrder", "", "getTaskTypeOrder", "()B", "toString", "Companion", "intellij.database.core.impl"})
public final class ScopeIntrospectionTask
extends CombinedIntrospectionTask {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final TreePattern scope;
    @Nullable
    private final String databaseName;

    public ScopeIntrospectionTask(@NotNull String dataSourceId, @NotNull TreePattern scope) {
        Intrinsics.checkNotNullParameter((Object)dataSourceId, (String)"dataSourceId");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(dataSourceId, null);
        this.scope = scope;
        this.databaseName = Companion.determineSingleDatabase(this.scope);
        IntrospectionTaskInnerHelper.INSTANCE.recordCreation$intellij_database_core_impl(this);
    }

    @NotNull
    public final TreePattern getScope() {
        return this.scope;
    }

    @Override
    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public byte getTaskTypeOrder() {
        return 3;
    }

    @NotNull
    public String toString() {
        return "Introspect by scope: " + this.scope;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/database/introspection/ScopeIntrospectionTask$Companion;", "", "<init>", "()V", "determineSingleDatabase", "", "scope", "Lcom/intellij/database/util/TreePattern;", "intellij.database.core.impl"})
    private static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String determineSingleDatabase(@NotNull TreePattern scope) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            if (scope.isEmpty()) {
                return "@";
            }
            TreePatternNode treePatternNode = scope.root;
            Intrinsics.checkNotNullExpressionValue((Object)treePatternNode, (String)"root");
            ObjectKind objectKind = ObjectKind.DATABASE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"DATABASE");
            Map m = TreePatternFun.extractMap(treePatternNode, objectKind);
            if (m.isEmpty()) {
                return "@";
            }
            TreePatternEntryKey treePatternEntryKey = (TreePatternEntryKey)CollectionsKt.singleOrNull((Iterable)m.keySet());
            if (treePatternEntryKey == null) {
                return null;
            }
            TreePatternEntryKey theSingleKey = treePatternEntryKey;
            TreePatternEntryKey treePatternEntryKey2 = theSingleKey;
            if (Intrinsics.areEqual((Object)treePatternEntryKey2, (Object)TreePatternEntryKey.Cur.INSTANCE)) {
                return "@";
            }
            if (treePatternEntryKey2 instanceof TreePatternEntryKey.Plain) {
                return ((TreePatternEntryKey.Plain)theSingleKey).getName();
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

