/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.openapi.Disposable;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\b\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/model/ThrottledTask;", "Lcom/intellij/openapi/Disposable;", "task", "Ljava/lang/Runnable;", "<init>", "(Ljava/lang/Runnable;)V", "getTask", "()Ljava/lang/Runnable;", "scheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "future", "Ljava/util/concurrent/Future;", "schedule", "", "flush", "dispose", "perform", "intellij.database.core.impl"})
final class ThrottledTask
implements Disposable {
    @NotNull
    private final Runnable task;
    @NotNull
    private final AtomicBoolean scheduled;
    @Nullable
    private volatile Future<?> future;

    public ThrottledTask(@NotNull Runnable task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.task = task;
        this.scheduled = new AtomicBoolean();
    }

    @NotNull
    public final Runnable getTask() {
        return this.task;
    }

    public final void schedule() {
        boolean prev = this.scheduled.getAndSet(true);
        if (!prev) {
            this.future = AppExecutorUtil.getAppScheduledExecutorService().schedule(this::perform, 5L, TimeUnit.SECONDS);
        }
    }

    public final void flush() {
        Future<?> future = this.future;
        if (future != null) {
            future.cancel(false);
        }
        this.perform();
    }

    public void dispose() {
        this.flush();
        this.scheduled.set(true);
    }

    private final void perform() {
        this.scheduled.set(false);
        this.task.run();
    }
}

