/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorageScope;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicUniqueBush;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\n\u0010 \u001a\u00020\u0014H\u0096\u0080\u0004J\u0006\u0010!\u001a\u00020\u0007R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\"\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\n\u00a8\u0006$"}, d2={"Lcom/intellij/database/view/DataSourceNode;", "Lcom/intellij/database/model/basic/BasicUniqueBush;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "<init>", "(Lcom/intellij/database/model/RawDataSource;)V", "isGlobal", "", "isGlobal$annotations", "()V", "()Z", "dbms", "Lcom/intellij/database/Dbms;", "getDbms", "()Lcom/intellij/database/Dbms;", "modelRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "getModelRoot", "()Lcom/intellij/database/model/basic/BasicRoot;", "groupName", "", "getGroupName", "()Ljava/lang/String;", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getLocalDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "getUniqueId", "getName", "getDisplayName", "toString", "isIntrospectable", "levelAutoSelectable", "getLevelAutoSelectable", "intellij.database.core.impl"})
@ApiStatus.Experimental
public final class DataSourceNode
implements BasicUniqueBush {
    @JvmField
    @NotNull
    public final RawDataSource dataSource;

    public DataSourceNode(@NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        this.dataSource = dataSource;
    }

    public final boolean isGlobal() {
        return this.dataSource.getStorageScope() == DataSourceStorageScope.DSSS_APPLICATION;
    }

    @Deprecated(message="Use dataSource.storageScope instead", replaceWith=@ReplaceWith(expression="dataSource.storageScope == DataSourceStorageScope.DSSS_APPLICATION", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void isGlobal$annotations() {
    }

    @NotNull
    public final Dbms getDbms() {
        Dbms dbms = this.dataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return dbms;
    }

    @Nullable
    public final BasicRoot getModelRoot() {
        BasicModel basicModel = this.getModel();
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Nullable
    public final String getGroupName() {
        return this.dataSource.getGroupName();
    }

    @Nullable
    public final LocalDataSource getLocalDataSource() {
        RawDataSource rawDataSource = this.dataSource;
        return rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
    }

    @Override
    @Nullable
    public BasicModel getModel() {
        DasModel dasModel = this.dataSource.getModel();
        return dasModel instanceof BasicModel ? (BasicModel)dasModel : null;
    }

    @Override
    @NotNull
    public String getUniqueId() {
        String string = this.dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.dataSource.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.dataSource.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.dataSource.getName() + ": DSN";
    }

    public final boolean isIntrospectable() {
        DasModel dasModel = this.dataSource.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
        DasModel model = dasModel;
        if (model instanceof BasicModel) {
            return true;
        }
        return Intrinsics.areEqual((Object)model.getMetaModel(), (Object)MetaModel.EMPTY);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getLevelAutoSelectable() {
        if (!(this.dataSource instanceof LocalDataSource)) return false;
        Dbms dbms = ((LocalDataSource)this.dataSource).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        if (!DBIntrospectorFeatures.supportsMultilevelIntrospection(dbms)) return false;
        return true;
    }
}

