/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.ranges.RangesKt;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.util.SafeUtils;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0017\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b!\u001a8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a\"\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002\u001a(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0002\u001a(\u0010\u001c\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0002\u001a,\u0010\u001e\u001a\u00020\u00182\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u001a,\u0010 \u001a\u00020\u00182\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u001a*\u0010!\u001a\u00020\u00072\b\u0010\"\u001a\u0004\u0018\u00010\t2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0002\u001a0\u0010&\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0002\u001a0\u0010)\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007H\u0002\u001a8\u0010+\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u001a \u0010,\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u001a\u0010\u00107\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\u001a\u0010\u00108\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002\"2\u0010\u0000\u001a&\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002 \u0003*\u0012\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010\u0004\u001a&\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00050\u0005 \u0003*\u0012\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000f\u001a\n \u0003*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0011\u001a\n \u0003*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010-\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010.\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010/\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00100\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00101\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u00102\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00103\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00104\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00105\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u00106\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"sixtyFourKBHashTable", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "biggerHashTable", "", "compress64k", "", "src", "", "srcOff", "srcLen", "dest", "destOff", "destEnd", "intPlatformNative", "Ljava/lang/invoke/VarHandle;", "longPlatformNative", "readIntEquals", "", "buf", "i", "j", "safeIncrementalCopy", "", "matchOff", "dOff", "matchLen", "wildIncrementalCopy", "matchCopyEnd", "copy8Bytes", "sOff", "copy4Bytes", "commonBytes", "b", "o1", "o2", "limit", "commonBytesBackward", "l1", "l2", "wildArraycopy", "len", "lastLiterals", "writeLen", "MEMORY_USAGE", "NOT_COMPRESSIBLE_DETECTION_LEVEL", "MIN_MATCH", "HASH_LOG", "SKIP_STRENGTH", "COPY_LENGTH", "ML_BITS", "RUN_BITS", "RUN_MASK", "HASH_LOG_64K", "hash", "hash64k", "intellij.platform.util.ex"})
public final class Lz4Kt {
    private static final ThreadLocal<short[]> sixtyFourKBHashTable = ThreadLocal.withInitial(Lz4Kt::sixtyFourKBHashTable$lambda$0);
    private static final ThreadLocal<int[]> biggerHashTable = ThreadLocal.withInitial(Lz4Kt::biggerHashTable$lambda$0);
    private static final VarHandle intPlatformNative = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.nativeOrder());
    private static final VarHandle longPlatformNative = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder());
    private static final int MEMORY_USAGE = 14;
    private static final int NOT_COMPRESSIBLE_DETECTION_LEVEL = 6;
    private static final int MIN_MATCH = 4;
    private static final int HASH_LOG = 12;
    private static final int SKIP_STRENGTH = RangesKt.coerceAtLeast((int)6, (int)2);
    private static final int COPY_LENGTH = 8;
    private static final int ML_BITS = 4;
    private static final int RUN_BITS = 4;
    private static final int RUN_MASK = 15;
    private static final int HASH_LOG_64K = 13;

    private static final int compress64k(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destEnd) {
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int dOff = destOff;
        int anchor = srcOff;
        if (srcLen >= 13) {
            short[] hashTable = sixtyFourKBHashTable.get();
            Arrays.fill(hashTable, (short)0);
            int sOff = srcOff + 1;
            block0: while (true) {
                int forwardOff = sOff;
                int step = 1;
                int var16 = 1 << SKIP_STRENGTH;
                int ref = 0;
                int excess = 0;
                do {
                    sOff = forwardOff;
                    if ((forwardOff += (step = var16++ >>> SKIP_STRENGTH)) > mflimit) break block0;
                    excess = Lz4Kt.hash64k(SafeUtils.readInt((byte[])src, (int)sOff));
                    ref = srcOff + SafeUtils.readShort((short[])hashTable, (int)excess);
                    SafeUtils.writeShort((short[])hashTable, (int)excess, (int)(sOff - srcOff));
                } while (!Lz4Kt.readIntEquals(src, ref, sOff));
                excess = Lz4Kt.commonBytesBackward(src, ref, sOff, srcOff, anchor);
                ref -= excess;
                int runLen = (sOff -= excess) - anchor;
                int tokenOff = dOff++;
                if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                if (runLen >= 15) {
                    SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)240);
                    dOff = Lz4Kt.writeLen(runLen - 15, dest, dOff);
                } else {
                    SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)(runLen << 4));
                }
                Lz4Kt.wildArraycopy(src, anchor, dest, dOff, runLen);
                dOff += runLen;
                while (true) {
                    SafeUtils.writeShortLE((byte[])dest, (int)dOff, (int)((short)(sOff - ref)));
                    int matchLen = Lz4Kt.commonBytes(src, ref += 4, sOff += 4, srcLimit);
                    if ((dOff += 2) + 6 + (matchLen >>> 8) > destEnd) {
                        throw new LZ4Exception("maxDestLen is too small");
                    }
                    sOff += matchLen;
                    if (matchLen >= 15) {
                        SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)(SafeUtils.readByte((byte[])dest, (int)tokenOff) | 0xF));
                        dOff = Lz4Kt.writeLen(matchLen - 15, dest, dOff);
                    } else {
                        SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)(SafeUtils.readByte((byte[])dest, (int)tokenOff) | matchLen));
                    }
                    if (sOff > mflimit) {
                        anchor = sOff;
                        break block0;
                    }
                    SafeUtils.writeShort((short[])hashTable, (int)Lz4Kt.hash64k(SafeUtils.readInt((byte[])src, (int)(sOff - 2))), (int)(sOff - 2 - srcOff));
                    int h = Lz4Kt.hash64k(SafeUtils.readInt((byte[])src, (int)sOff));
                    ref = srcOff + SafeUtils.readShort((short[])hashTable, (int)h);
                    SafeUtils.writeShort((short[])hashTable, (int)h, (int)(sOff - srcOff));
                    if (!Lz4Kt.readIntEquals(src, sOff, ref)) {
                        anchor = sOff++;
                        continue block0;
                    }
                    tokenOff = dOff++;
                    SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)0);
                }
                break;
            }
        }
        dOff = Lz4Kt.lastLiterals(src, anchor, srcEnd - anchor, dest, dOff, destEnd);
        return dOff - destOff;
    }

    private static final boolean readIntEquals(byte[] buf, int i, int j) {
        return SafeUtils.readInt((byte[])buf, (int)i) == SafeUtils.readInt((byte[])buf, (int)j);
    }

    private static final void safeIncrementalCopy(byte[] dest, int matchOff, int dOff, int matchLen) {
        for (int i = 0; i < matchLen; ++i) {
            dest[dOff + i] = dest[matchOff + i];
        }
    }

    private static final void wildIncrementalCopy(byte[] dest, int matchOff, int dOff, int matchCopyEnd) {
        int dOff2 = dOff;
        int matchOff2 = matchOff;
        if (dOff2 - matchOff2 < 4) {
            boolean bl;
            for (int i = 0; i < 4; ++i) {
                dest[dOff2 + i] = dest[matchOff2 + i];
            }
            int dec = 0;
            boolean bl2 = bl = (dOff2 += 4) >= (matchOff2 += 4) && dOff2 - matchOff2 < 8;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            switch (dOff2 - matchOff2) {
                case 1: {
                    matchOff2 -= 3;
                    break;
                }
                case 2: {
                    matchOff2 -= 2;
                    break;
                }
                case 3: {
                    matchOff2 -= 3;
                    dec = -1;
                    break;
                }
                case 5: {
                    dec = 1;
                    break;
                }
                case 6: {
                    dec = 2;
                    break;
                }
                case 7: {
                    dec = 3;
                }
            }
            Lz4Kt.copy4Bytes(dest, matchOff2, dest, dOff2);
            dOff2 += 4;
            matchOff2 -= dec;
        } else if (dOff2 - matchOff2 < 8) {
            Lz4Kt.copy8Bytes(dest, matchOff2, dest, dOff2);
            dOff2 += dOff2 - matchOff2;
        }
        while (dOff2 < matchCopyEnd) {
            Lz4Kt.copy8Bytes(dest, matchOff2, dest, dOff2);
            dOff2 += 8;
            matchOff2 += 8;
        }
    }

    private static final void copy8Bytes(byte[] src, int sOff, byte[] dest, int dOff) {
        longPlatformNative.set(dest, dOff, longPlatformNative.get(src, sOff));
    }

    private static final void copy4Bytes(byte[] src, int sOff, byte[] dest, int dOff) {
        intPlatformNative.set(dest, dOff, intPlatformNative.get(src, sOff));
    }

    private static final int commonBytes(byte[] b, int o1, int o2, int limit) {
        int mismatch = Arrays.mismatch(b, o1, limit, b, o2, limit);
        return mismatch == -1 ? limit : mismatch;
    }

    private static final int commonBytesBackward(byte[] b, int o1, int o2, int l1, int l2) {
        int o12 = o1;
        int o22 = o2;
        int count = 0;
        while (o12 > l1 && o22 > l2 && b[--o12] == b[--o22]) {
            ++count;
        }
        return count;
    }

    private static final void wildArraycopy(byte[] src, int sOff, byte[] dest, int dOff, int len) {
        try {
            for (int i = 0; i < len; i += 8) {
                Lz4Kt.copy8Bytes(src, sOff + i, dest, dOff + i);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new LZ4Exception("Malformed input at offset " + sOff);
        }
    }

    private static final int lastLiterals(byte[] src, int sOff, int srcLen, byte[] dest, int dOff, int destEnd) {
        int dOff2 = dOff;
        if (dOff2 + srcLen + 1 + (srcLen + 255 - 15) / 255 > destEnd) {
            throw new LZ4Exception();
        }
        if (srcLen >= 15) {
            dest[dOff2++] = -16;
            dOff2 = Lz4Kt.writeLen(srcLen - 15, dest, dOff2);
        } else {
            dest[dOff2++] = (byte)(srcLen << 4);
        }
        System.arraycopy(src, sOff, dest, dOff2, srcLen);
        return dOff2 += srcLen;
    }

    private static final int writeLen(int len, byte[] dest, int dOff) {
        int len2;
        int dOff2 = dOff;
        for (len2 = len; len2 >= 255; len2 -= 255) {
            dest[dOff2++] = -1;
        }
        dest[dOff2++] = (byte)len2;
        return dOff2;
    }

    private static final int hash(int i) {
        return i * -1640531535 >>> 20;
    }

    private static final int hash64k(int i) {
        return i * -1640531535 >>> 19;
    }

    private static final short[] sixtyFourKBHashTable$lambda$0() {
        return new short[8192];
    }

    private static final int[] biggerHashTable$lambda$0() {
        return new int[4096];
    }

    public static final /* synthetic */ void access$wildArraycopy(byte[] src, int sOff, byte[] dest, int dOff, int len) {
        Lz4Kt.wildArraycopy(src, sOff, dest, dOff, len);
    }

    public static final /* synthetic */ void access$safeIncrementalCopy(byte[] dest, int matchOff, int dOff, int matchLen) {
        Lz4Kt.safeIncrementalCopy(dest, matchOff, dOff, matchLen);
    }

    public static final /* synthetic */ void access$wildIncrementalCopy(byte[] dest, int matchOff, int dOff, int matchCopyEnd) {
        Lz4Kt.wildIncrementalCopy(dest, matchOff, dOff, matchCopyEnd);
    }

    public static final /* synthetic */ int access$compress64k(byte[] src, int srcOff, int srcLen, byte[] dest, int destOff, int destEnd) {
        return Lz4Kt.compress64k(src, srcOff, srcLen, dest, destOff, destEnd);
    }

    public static final /* synthetic */ ThreadLocal access$getBiggerHashTable$p() {
        return biggerHashTable;
    }

    public static final /* synthetic */ int access$getSKIP_STRENGTH$p() {
        return SKIP_STRENGTH;
    }

    public static final /* synthetic */ int access$hash(int i) {
        return Lz4Kt.hash(i);
    }

    public static final /* synthetic */ boolean access$readIntEquals(byte[] buf, int i, int j) {
        return Lz4Kt.readIntEquals(buf, i, j);
    }

    public static final /* synthetic */ int access$commonBytesBackward(byte[] b, int o1, int o2, int l1, int l2) {
        return Lz4Kt.commonBytesBackward(b, o1, o2, l1, l2);
    }

    public static final /* synthetic */ int access$writeLen(int len, byte[] dest, int dOff) {
        return Lz4Kt.writeLen(len, dest, dOff);
    }

    public static final /* synthetic */ int access$commonBytes(byte[] b, int o1, int o2, int limit) {
        return Lz4Kt.commonBytes(b, o1, o2, limit);
    }

    public static final /* synthetic */ int access$lastLiterals(byte[] src, int sOff, int srcLen, byte[] dest, int dOff, int destEnd) {
        return Lz4Kt.lastLiterals(src, sOff, srcLen, dest, dOff, destEnd);
    }
}

