/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.table;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.table.JBTable;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiConsumer;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BaseTableView
extends JBTable {
    private static final Logger LOG = Logger.getInstance(BaseTableView.class);

    public BaseTableView(TableModel model) {
        super(model);
    }

    public BaseTableView(TableModel model, TableColumnModel columnModel) {
        super(model, columnModel);
    }

    @NonNls
    private static String orderPropertyName(int index) {
        return "Order" + index;
    }

    @NonNls
    private static String widthPropertyName(int index) {
        return "Width" + index;
    }

    public static void store(@NotNull PropertiesComponent propertyComponent, @NotNull String prefix, @NotNull JTable table) {
        if (propertyComponent == null) {
            BaseTableView.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            BaseTableView.$$$reportNull$$$0(1);
        }
        if (table == null) {
            BaseTableView.$$$reportNull$$$0(2);
        }
        TableColumnModel model = table.getTableHeader().getColumnModel();
        int columnCount = model.getColumnCount();
        boolean[] storedColumns = new boolean[columnCount];
        Arrays.fill(storedColumns, false);
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = model.getColumn(i);
            propertyComponent.setValue(prefix + BaseTableView.widthPropertyName(i), String.valueOf(column.getWidth()));
            int modelIndex = column.getModelIndex();
            propertyComponent.setValue(prefix + BaseTableView.orderPropertyName(i), String.valueOf(modelIndex));
            if (storedColumns[modelIndex]) {
                LOG.error("columnCount: " + columnCount + " current: " + i + " modelINdex: " + modelIndex);
            }
            storedColumns[modelIndex] = true;
        }
    }

    public static void storeWidth(@NotNull PropertiesComponent propertyComponent, @NotNull String prefix, @NotNull TableColumnModel columns) {
        if (propertyComponent == null) {
            BaseTableView.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            BaseTableView.$$$reportNull$$$0(4);
        }
        if (columns == null) {
            BaseTableView.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < columns.getColumnCount(); ++i) {
            propertyComponent.setValue(prefix + BaseTableView.widthPropertyName(i), String.valueOf(columns.getColumn(i).getWidth()));
        }
    }

    public static void storeWidth(@NotNull BiConsumer<? super String, ? super String> consumer, @NotNull TableColumnModel columns) {
        if (consumer == null) {
            BaseTableView.$$$reportNull$$$0(6);
        }
        if (columns == null) {
            BaseTableView.$$$reportNull$$$0(7);
        }
        for (int i = 0; i < columns.getColumnCount(); ++i) {
            consumer.accept(BaseTableView.widthPropertyName(i), String.valueOf(columns.getColumn(i).getWidth()));
        }
    }

    public static void restore(@NotNull PropertiesComponent propertyComponent, @NotNull String prefix, JTable table) {
        Object order;
        if (propertyComponent == null) {
            BaseTableView.$$$reportNull$$$0(8);
        }
        if (prefix == null) {
            BaseTableView.$$$reportNull$$$0(9);
        }
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        int index = 0;
        ArrayList<String> columnIndices = new ArrayList<String>();
        while ((order = propertyComponent.getValue(prefix + BaseTableView.orderPropertyName(index))) != null) {
            columnIndices.add((String)order);
            if (++index != table.getColumnCount()) continue;
            break;
        }
        index = 0;
        for (String columnIndex : columnIndices) {
            int modelColumnIndex = BaseTableView.indexByModelIndex(columnModel, Integer.parseInt(columnIndex));
            if (modelColumnIndex > 0 && modelColumnIndex < columnModel.getColumnCount()) {
                columnModel.moveColumn(modelColumnIndex, index);
            }
            ++index;
        }
        for (int i = 0; i < columnIndices.size(); ++i) {
            String width = propertyComponent.getValue(prefix + BaseTableView.widthPropertyName(i));
            if (width == null || width.isEmpty()) continue;
            try {
                columnModel.getColumn(i).setPreferredWidth(Integer.parseInt(width));
                continue;
            }
            catch (NumberFormatException e) {
                LOG.error("Bad width: " + width + " at column: " + i + " from: " + prefix + " actual columns count: " + columnModel.getColumnCount() + " info count: " + columnIndices.size(), (Throwable)e);
            }
        }
    }

    public static void restoreWidth(@NotNull PropertiesComponent propertyComponent, @NotNull String prefix, TableColumnModel columns) {
        if (propertyComponent == null) {
            BaseTableView.$$$reportNull$$$0(10);
        }
        if (prefix == null) {
            BaseTableView.$$$reportNull$$$0(11);
        }
        BaseTableView.restoreWidth((Function<? super String, String>)((Function)s -> propertyComponent.getValue(prefix + s)), columns);
    }

    public static void restoreWidth(@NotNull Function<? super String, String> map, TableColumnModel columns) {
        String widthValue;
        if (map == null) {
            BaseTableView.$$$reportNull$$$0(12);
        }
        int index = 0;
        while ((widthValue = (String)map.fun((Object)BaseTableView.widthPropertyName(index))) != null) {
            try {
                columns.getColumn(index).setPreferredWidth(Integer.parseInt(widthValue));
            }
            catch (NumberFormatException e) {
                LOG.error("Bad width: " + widthValue + " at column: " + index + " from: " + String.valueOf(map), (Throwable)e);
            }
            ++index;
        }
    }

    private static int indexByModelIndex(TableColumnModel model, int index) {
        for (int i = 0; i < model.getColumnCount(); ++i) {
            if (model.getColumn(i).getModelIndex() != index) continue;
            return i;
        }
        LOG.error("Total: " + model.getColumnCount() + " index: " + index);
        return index;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyComponent";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/table/BaseTableView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "store";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "storeWidth";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "restore";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreWidth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

