/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.dnd.SmoothAutoScroller;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.ide.util.treeView.CachedTreePresentation;
import com.intellij.ide.util.treeView.CachedTreePresentationSupport;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientSystemInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.ComponentWithFileColors;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ExpandableItemsHandlerFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.treeStructure.CachingTreePath;
import com.intellij.ui.treeStructure.TreeBulkExpansionEvent;
import com.intellij.ui.treeStructure.TreeBulkExpansionListener;
import com.intellij.ui.treeStructure.TreeNodeViewModel;
import com.intellij.ui.treeStructure.TreeStateListener;
import com.intellij.ui.treeStructure.TreeSwingModel;
import com.intellij.ui.treeStructure.TreeSwingModelListener;
import com.intellij.ui.treeStructure.TreeSwingModelScrollEvent;
import com.intellij.ui.treeStructure.TreeSwingModelSelectionEvent;
import com.intellij.ui.treeStructure.TreeUiBulkExpandCollapseSupport;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.im.InputMethodRequests;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tree
extends JTree
implements ComponentWithEmptyText,
ComponentWithExpandableItems<Integer>,
Queryable,
ComponentWithFileColors,
TreePathBackgroundSupplier,
CachedTreePresentationSupport {
    @ApiStatus.Internal
    public static final Key<Boolean> AUTO_SELECT_ON_MOUSE_PRESSED = Key.create((String)"allows to select a node automatically on right click");
    @ApiStatus.Internal
    public static final Key<Boolean> AUTO_SCROLL_FROM_SOURCE_BLOCKED = Key.create((String)"auto scroll from source temporarily blocked");
    @NotNull
    private static final Logger LOG = Logger.getInstance(Tree.class);
    private final StatusText myEmptyText;
    private final ExpandableItemsHandler<Integer> myExpandableItemsHandler;
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;
    private Rectangle myLastVisibleRec;
    private Dimension myHoldSize;
    private int myAdditionalRowsCount = -1;
    private final MySelectionModel mySelectionModel = new MySelectionModel();
    private ThreeState myHorizontalAutoScrolling = ThreeState.UNSURE;
    private TreePath rollOverPath;
    private final Timer autoScrollUnblockTimer = TimerUtil.createNamedTimer((String)"TreeAutoscrollUnblock", (int)500, e -> this.unblockAutoScrollFromSource());
    @NotNull
    private final ExpandImpl expandImpl;
    @NotNull
    private final AtomicInteger suspendedExpandAccessibilityAnnouncements = new AtomicInteger();
    @NotNull
    private final AtomicInteger bulkOperationsInProgress = new AtomicInteger();
    @NotNull
    private final AtomicBoolean applyingViewModelChanges = new AtomicBoolean();
    private transient boolean settingUI;
    private transient TreeExpansionListener uiTreeExpansionListener;
    @NotNull
    private final AtomicInteger processingDoubleClick = new AtomicInteger();
    @NotNull
    private final MyUISettingsListener myUISettingsListener = new MyUISettingsListener();
    private boolean initialized = false;

    @ApiStatus.Internal
    protected boolean isHorizontalAutoAlignEnabled() {
        return false;
    }

    @ApiStatus.Internal
    public void onPathExpanded(@NotNull TreePath path) {
        if (path == null) {
            Tree.$$$reportNull$$$0(0);
        }
        if (this.isHorizontalAutoAlignEnabled()) {
            this.alignTreePathToTheLeft(path);
        }
    }

    @ApiStatus.Internal
    public void onPathSelected(@NotNull TreePath path) {
        if (path == null) {
            Tree.$$$reportNull$$$0(1);
        }
        if (this.isHorizontalAutoAlignEnabled()) {
            this.alignTreePathToTheLeft(path);
        }
    }

    private void alignTreePathToTheLeft(@Nullable TreePath path) {
        SwingUtilities.invokeLater(() -> {
            int scrollToAlignRight;
            int scrollToAlignLeft;
            JViewport viewport;
            if (path == null) {
                return;
            }
            JScrollPane scrollPane2 = ComponentUtil.getScrollPane((Component)this);
            if (scrollPane2 == null) {
                return;
            }
            Rectangle pathBounds = this.getPathBounds(path);
            if (pathBounds == null) {
                return;
            }
            TreeModel model = this.getModel();
            if (model == null) {
                return;
            }
            Object node = path.getLastPathComponent();
            if (model.getChildCount(node) > 0) {
                int iconWidth = UIUtil.getTreeExpandedIcon().getIconWidth();
                pathBounds.x = Math.max(pathBounds.x - iconWidth, 0);
                pathBounds.width += iconWidth;
            }
            if ((viewport = scrollPane2.getViewport()) == null) {
                return;
            }
            Rectangle viewRect = viewport.getViewRect();
            if (pathBounds.x >= viewRect.x && pathBounds.x + pathBounds.width <= viewRect.x + viewRect.width) {
                return;
            }
            int targetX = pathBounds.x;
            if (pathBounds.x >= viewRect.x && (scrollToAlignLeft = pathBounds.x - viewRect.x) > (scrollToAlignRight = pathBounds.x + pathBounds.width - (viewRect.x + viewRect.width))) {
                targetX = Math.max(0, pathBounds.x + pathBounds.width - viewRect.width);
            }
            Rectangle targetBounds = new Rectangle(targetX, viewRect.y, viewRect.width, viewRect.height);
            this.scrollRectToVisible(targetBounds);
        });
    }

    @ApiStatus.Internal
    public static boolean isBulkExpandCollapseSupported() {
        return true;
    }

    @ApiStatus.Internal
    public static boolean isExpandWithSingleClickSettingEnabled() {
        return Registry.is((String)"ide.tree.show.expand.with.single.click.setting", (boolean)true);
    }

    private static boolean isCollapseRecursively() {
        return ApplicationManager.getApplication() != null ? AdvancedSettings.getBoolean((String)"ide.tree.collapse.recursively") : true;
    }

    public Tree() {
        this(new DefaultMutableTreeNode());
    }

    public Tree(TreeNode root) {
        this(new DefaultTreeModel(root, false));
    }

    public Tree(TreeModel treemodel) {
        super(treemodel);
        SmartExpander.setRecursiveCollapseEnabled((boolean)Tree.isCollapseRecursively());
        this.expandImpl = new ExpandImpl();
        this.myEmptyText = new StatusText(this){

            @Override
            protected boolean isStatusVisible() {
                return Tree.this.isEmptyTextVisible();
            }
        };
        this.myExpandableItemsHandler = ExpandableItemsHandlerFactory.install(this);
        this.initialized = true;
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point p = e.getPoint();
                    TreePath newPath = Tree.this.getPathForLocation(p.x, p.y);
                    if (newPath != null && !newPath.equals(Tree.this.rollOverPath)) {
                        TreeCellRenderer renderer = Tree.this.getCellRenderer();
                        Object object = newPath.getLastPathComponent();
                        if (object instanceof TreeNode) {
                            JComponent c;
                            TreeNode node = (TreeNode)object;
                            c.putClientProperty("JCheckBox.rollOver.rectangle", (c = (JComponent)renderer.getTreeCellRendererComponent(Tree.this, node, Tree.this.isPathSelected(newPath), Tree.this.isExpanded(newPath), Tree.this.getModel().isLeaf(node), Tree.this.getRowForPath(newPath), Tree.this.hasFocus())) instanceof JCheckBox ? Tree.this.getPathBounds(newPath) : node);
                            Tree.this.rollOverPath = newPath;
                            UIUtil.repaintViewport((JComponent)Tree.this);
                        }
                    }
                }
            });
        }
        this.addMouseListener(new MyMouseListener());
        this.addFocusListener(new MyFocusListener());
        this.setCellRenderer(new NodeRenderer());
        this.setSelectionModel(this.mySelectionModel);
        this.setOpaque(false);
        this.putClientProperty(UIUtil.NOT_IN_HIERARCHY_COMPONENTS, this.myEmptyText.getWrappedFragmentsIterable());
    }

    @Override
    public void setUI(TreeUI ui) {
        if (this.ui != ui) {
            this.settingUI = true;
            this.uiTreeExpansionListener = null;
            try {
                super.setUI(ui);
            }
            finally {
                this.settingUI = false;
            }
        }
    }

    @Override
    public void setToggleClickCount(int clickCount) {
        super.setToggleClickCount(clickCount);
        this.myUISettingsListener.setToggleClickCountCalled();
    }

    @Override
    public void addTreeExpansionListener(TreeExpansionListener listener2) {
        if (this.settingUI) {
            this.uiTreeExpansionListener = listener2;
        }
        super.addTreeExpansionListener(listener2);
    }

    @Override
    public void removeTreeExpansionListener(TreeExpansionListener listener2) {
        super.removeTreeExpansionListener(listener2);
        if (this.uiTreeExpansionListener == listener2) {
            this.uiTreeExpansionListener = null;
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @ApiStatus.Internal
    public void startMeasuringExpandDuration(@NotNull TreePath path) {
        if (path == null) {
            Tree.$$$reportNull$$$0(2);
        }
    }

    public boolean isEmpty() {
        return 0 >= this.getRowCount();
    }

    protected boolean isWideSelection() {
        return true;
    }

    @NotNull
    protected Condition<Integer> getWideSelectionBackgroundCondition() {
        Condition condition = Conditions.alwaysTrue();
        if (condition == null) {
            Tree.$$$reportNull$$$0(3);
        }
        return condition;
    }

    @Override
    public boolean isFileColorsEnabled() {
        return false;
    }

    protected boolean isEmptyTextVisible() {
        return this.isEmpty();
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        StatusText statusText = this.myEmptyText;
        if (statusText == null) {
            Tree.$$$reportNull$$$0(4);
        }
        return statusText;
    }

    @Override
    @NotNull
    public ExpandableItemsHandler<Integer> getExpandableItemsHandler() {
        ExpandableItemsHandler<Integer> expandableItemsHandler = this.myExpandableItemsHandler;
        if (expandableItemsHandler == null) {
            Tree.$$$reportNull$$$0(5);
        }
        return expandableItemsHandler;
    }

    @Override
    public void setExpandableItemsEnabled(boolean enabled) {
        this.myExpandableItemsHandler.setEnabled(enabled);
    }

    @Override
    public Color getBackground() {
        return this.isBackgroundSet() ? super.getBackground() : UIUtil.getTreeBackground();
    }

    @Override
    public Color getForeground() {
        return this.isForegroundSet() ? super.getForeground() : UIUtil.getTreeForeground();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("font", null, null);
        this.updateBusy();
        this.myUISettingsListener.connect();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose((Disposable)this.myBusyIcon);
            this.myBusyIcon = null;
        }
        this.myUISettingsListener.disconnect();
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.updateBusyIconLocation();
    }

    private void updateBusyIconLocation() {
        if (this.myBusyIcon != null) {
            this.myBusyIcon.updateLocation(this);
        }
    }

    @Override
    public void paint(Graphics g) {
        Rectangle visible = this.getVisibleRect();
        try {
            super.paint(g);
            if (!visible.equals(this.myLastVisibleRec)) {
                this.updateBusyIconLocation();
            }
            this.myLastVisibleRec = visible;
        }
        finally {
            this.mySelectionModel.unholdSelection();
        }
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        boolean shouldPaintBusyIcon;
        boolean bl = shouldPaintBusyIcon = this.myBusy && this.shouldShowBusyIconIfNeeded();
        if (shouldPaintBusyIcon) {
            if (this.myBusyIcon == null) {
                this.myBusyIcon = new AsyncProcessIcon(this.toString());
                this.myBusyIcon.setOpaque(false);
                this.myBusyIcon.setPaintPassiveIcon(false);
                this.myBusyIcon.setToolTipText(IdeBundle.message("tooltip.text.update.is.in.progress.click.to.cancel", new Object[0]));
                this.add(this.myBusyIcon);
            }
            this.myBusyIcon.resume();
            this.myBusyIcon.setVisible(true);
            this.updateBusyIconLocation();
        }
        if (!shouldPaintBusyIcon && this.myBusyIcon != null) {
            this.myBusyIcon.suspend();
            this.myBusyIcon.setVisible(false);
            SwingUtilities.invokeLater(() -> {
                if (this.myBusyIcon != null) {
                    this.repaint();
                }
            });
        }
    }

    protected boolean shouldShowBusyIconIfNeeded() {
        return this.hasFocus();
    }

    protected boolean paintNodes() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.paintNodes()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.isFileColorsEnabled()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintFileColorGutter(g);
        }
        super.paintComponent(g);
        this.myEmptyText.paint(this, g);
    }

    protected void paintFileColorGutter(Graphics g) {
        GraphicsConfig config = new GraphicsConfig(g);
        config.setupAAPainting();
        Rectangle rect = this.getVisibleRect();
        int firstVisibleRow = this.getClosestRowForLocation(rect.x, rect.y);
        int lastVisibleRow = this.getClosestRowForLocation(rect.x, rect.y + rect.height);
        Color prevColor = firstVisibleRow == 0 ? null : this.getFileColorForRow(firstVisibleRow - 1);
        Color curColor = this.getFileColorForRow(firstVisibleRow);
        for (int row = firstVisibleRow; row <= lastVisibleRow; ++row) {
            Color nextColor;
            Color color = nextColor = row + 1 < this.getRowCount() ? this.getFileColorForRow(row + 1) : null;
            if (curColor != null) {
                Rectangle bounds = this.getRowBounds(row);
                double x = JBUI.scale((int)4);
                double y = bounds.y;
                double w = JBUI.scale((int)4);
                double h = bounds.height;
                if (Registry.is((String)"ide.file.colors.at.left")) {
                    g.setColor(curColor);
                    if (curColor.equals(prevColor) && curColor.equals(nextColor)) {
                        RectanglePainter2D.FILL.paint((Graphics2D)g, x, y, w, h);
                    } else if (!curColor.equals(prevColor) && !curColor.equals(nextColor)) {
                        RectanglePainter2D.FILL.paint((Graphics2D)g, x, y + 2.0, w, h - 4.0, (Object)w);
                    } else if (curColor.equals(prevColor)) {
                        RectanglePainter2D.FILL.paint((Graphics2D)g, x, y - w, w, h + w - 2.0, (Object)w);
                    } else {
                        RectanglePainter2D.FILL.paint((Graphics2D)g, x, y + 2.0, w, h + w, (Object)w);
                    }
                } else {
                    g.setColor(curColor);
                    g.fillRect(0, bounds.y, this.getWidth(), bounds.height);
                }
            }
            prevColor = curColor;
            curColor = nextColor;
        }
        config.restore();
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row) {
        if (path == null) {
            Tree.$$$reportNull$$$0(6);
        }
        return this.isFileColorsEnabled() && !Registry.is((String)"ide.file.colors.at.left") ? this.getFileColorForPath(path) : null;
    }

    @Nullable
    public Color getFileColorForRow(int row) {
        TreePath path = this.getPathForRow(row);
        return path != null ? this.getFileColorForPath(path) : null;
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path) {
        Object[] pathObjects;
        Object component;
        if (path == null) {
            Tree.$$$reportNull$$$0(7);
        }
        if ((component = path.getLastPathComponent()) instanceof LoadingNode && (pathObjects = path.getPath()).length > 1) {
            component = pathObjects[pathObjects.length - 2];
        }
        return this.getFileColorFor(TreeUtil.getUserObject(component));
    }

    @Nullable
    public Color getFileColorFor(Object object) {
        return null;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        WriteIntentReadAction.run(() -> super.processKeyEvent(e));
    }

    @Override
    public boolean getDragEnabled() {
        return super.getDragEnabled() && this.processingDoubleClick.get() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processMouseEvent(MouseEvent e) {
        boolean isDoubleClick;
        MouseEvent e2 = e;
        if (ClientSystemInfo.isMac()) {
            e2 = MacUIUtil.fixMacContextMenuIssue((MouseEvent)e);
        }
        boolean bl = isDoubleClick = e.getClickCount() >= 2;
        if (isDoubleClick) {
            this.processingDoubleClick.incrementAndGet();
        }
        try {
            super.processMouseEvent(e2);
        }
        finally {
            if (isDoubleClick) {
                this.processingDoubleClick.decrementAndGet();
            }
        }
        if (e != e2 && e2.isConsumed()) {
            e.consume();
        }
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    public TreePath getPath(@NotNull PresentableNodeDescriptor node) {
        if (node == null) {
            Tree.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    CachingTreePath getPath(@Nullable TreeModelEvent event) {
        Object root;
        if (event == null) {
            return null;
        }
        TreePath path = event.getTreePath();
        TreeModel model = this.getModel();
        if (path == null && model != null && (root = model.getRoot()) != null) {
            return new CachingTreePath(root);
        }
        return CachingTreePath.ensureCaching(path);
    }

    public void expandPaths(@NotNull @NotNull Iterable<@NotNull TreePath> paths) {
        if (paths == null) {
            Tree.$$$reportNull$$$0(9);
        }
        if (!this.initialized) {
            for (TreePath path : paths) {
                super.expandPath(path);
            }
            return;
        }
        this.expandImpl.expandPaths(paths);
    }

    @Override
    public void collapsePath(TreePath path) {
        int row;
        int n = row = Tree.isCollapseRecursively() ? this.getRowForPath(path) : -1;
        if (row < 0) {
            super.collapsePath(path);
        } else if (!this.isAlwaysExpanded(path)) {
            TreePath next;
            ArrayDeque<TreePath> deque = new ArrayDeque<TreePath>();
            deque.addFirst(path);
            while (++row < this.getRowCount() && path.isDescendant(next = this.getPathForRow(row))) {
                if (!this.isExpanded(next)) continue;
                deque.addFirst(next);
            }
            this.collapsePaths(deque);
        }
    }

    public void collapsePaths(@NotNull @NotNull Iterable<@NotNull TreePath> paths) {
        if (paths == null) {
            Tree.$$$reportNull$$$0(10);
        }
        if (!this.initialized) {
            for (TreePath path : paths) {
                super.collapsePath(path);
            }
            return;
        }
        this.expandImpl.collapsePaths(paths);
    }

    private boolean isAlwaysExpanded(TreePath path) {
        return path != null && TreeUtil.getNodeDepth(this, path) <= 0;
    }

    @ApiStatus.Internal
    public void suspendExpandCollapseAccessibilityAnnouncements() {
        this.suspendedExpandAccessibilityAnnouncements.incrementAndGet();
    }

    @ApiStatus.Internal
    public void resumeExpandCollapseAccessibilityAnnouncements() {
        this.suspendedExpandAccessibilityAnnouncements.decrementAndGet();
    }

    @ApiStatus.Internal
    public void fireAccessibleTreeExpanded(@NotNull TreePath path) {
        if (path == null) {
            Tree.$$$reportNull$$$0(11);
        }
        if (this.accessibleContext != null) {
            ((JTree.AccessibleJTree)this.accessibleContext).treeExpanded(new TreeExpansionEvent(this, path));
        }
    }

    @ApiStatus.Internal
    public void fireAccessibleTreeCollapsed(@NotNull TreePath path) {
        if (path == null) {
            Tree.$$$reportNull$$$0(12);
        }
        if (this.accessibleContext != null) {
            ((JTree.AccessibleJTree)this.accessibleContext).treeCollapsed(new TreeExpansionEvent(this, path));
        }
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        TreeModel model = this.treeModel;
        if ("model".equals(propertyName)) {
            Object treeRoot;
            CachedTreePresentationSupport cps;
            if (oldValue instanceof CachedTreePresentationSupport) {
                cps = (CachedTreePresentationSupport)oldValue;
                cps.setCachedPresentation(null);
            }
            if (this.initialized && model != null && (treeRoot = model.getRoot()) != null && !model.isLeaf(treeRoot)) {
                super.clearToggledPaths();
                this.expandImpl.markPathExpanded(new CachingTreePath(treeRoot));
            }
            if (this.initialized && newValue instanceof CachedTreePresentationSupport) {
                cps = (CachedTreePresentationSupport)newValue;
                cps.setCachedPresentation(this.expandImpl.getCachedPresentation());
            }
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public void fireTreeExpanded(@NotNull TreePath path) {
        if (path == null) {
            Tree.$$$reportNull$$$0(13);
        }
        Object[] listeners = this.listenerList.getListenerList();
        TreeBulkExpansionEvent e = new TreeBulkExpansionEvent(this, path, this.isBulkOperationInProgress());
        if (this.uiTreeExpansionListener != null) {
            this.uiTreeExpansionListener.treeExpanded(e);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeExpansionListener.class || listeners[i + 1] == this.uiTreeExpansionListener || listeners[i + 1] == this.accessibleContext && !this.expandAccessibilityAnnouncementsAllowed()) continue;
            ((TreeExpansionListener)listeners[i + 1]).treeExpanded(e);
        }
    }

    @Override
    public void fireTreeCollapsed(@NotNull TreePath path) {
        if (path == null) {
            Tree.$$$reportNull$$$0(14);
        }
        Object[] listeners = this.listenerList.getListenerList();
        TreeBulkExpansionEvent e = new TreeBulkExpansionEvent(this, path, this.isBulkOperationInProgress());
        if (this.uiTreeExpansionListener != null) {
            this.uiTreeExpansionListener.treeCollapsed(e);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeExpansionListener.class || listeners[i + 1] == this.uiTreeExpansionListener || listeners[i + 1] == this.accessibleContext && !this.expandAccessibilityAnnouncementsAllowed()) continue;
            ((TreeExpansionListener)listeners[i + 1]).treeCollapsed(e);
        }
    }

    private boolean isBulkOperationInProgress() {
        return this.initialized && this.bulkOperationsInProgress.get() > 0;
    }

    private void fireBulkExpandStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeBulkExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object object;
            if (listeners[i] != TreeExpansionListener.class || !((object = listeners[i + 1]) instanceof TreeBulkExpansionListener)) continue;
            TreeBulkExpansionListener bulkExpansionListener = (TreeBulkExpansionListener)object;
            if (e == null) {
                e = new TreeBulkExpansionEvent(this, null, false);
            }
            bulkExpansionListener.treeBulkExpansionStarted(e);
        }
    }

    private void fireBulkExpandEnded() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeBulkExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object object;
            if (listeners[i] != TreeExpansionListener.class || !((object = listeners[i + 1]) instanceof TreeBulkExpansionListener)) continue;
            TreeBulkExpansionListener bulkExpansionListener = (TreeBulkExpansionListener)object;
            if (e == null) {
                e = new TreeBulkExpansionEvent(this, null, false);
            }
            bulkExpansionListener.treeBulkExpansionEnded(e);
        }
    }

    private void fireBulkCollapseStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeBulkExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object object;
            if (listeners[i] != TreeExpansionListener.class || !((object = listeners[i + 1]) instanceof TreeBulkExpansionListener)) continue;
            TreeBulkExpansionListener bulkExpansionListener = (TreeBulkExpansionListener)object;
            if (e == null) {
                e = new TreeBulkExpansionEvent(this, null, false);
            }
            bulkExpansionListener.treeBulkCollapseStarted(e);
        }
    }

    private void fireBulkCollapseEnded() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeBulkExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object object;
            if (listeners[i] != TreeExpansionListener.class || !((object = listeners[i + 1]) instanceof TreeBulkExpansionListener)) continue;
            TreeBulkExpansionListener bulkExpansionListener = (TreeBulkExpansionListener)object;
            if (e == null) {
                e = new TreeBulkExpansionEvent(this, null, false);
            }
            bulkExpansionListener.treeBulkCollapseEnded(e);
        }
    }

    @ApiStatus.Internal
    public void fireTreeStateRestoreStarted() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object object;
            if (listeners[i] != TreeExpansionListener.class || !((object = listeners[i + 1]) instanceof TreeStateListener)) continue;
            TreeStateListener stateListener = (TreeStateListener)object;
            if (e == null) {
                e = new TreeExpansionEvent(this, null);
            }
            stateListener.treeStateRestoreStarted(e);
        }
    }

    @ApiStatus.Internal
    public void fireTreeStateCachedStateRestored() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object object;
            if (listeners[i] != TreeExpansionListener.class || !((object = listeners[i + 1]) instanceof TreeStateListener)) continue;
            TreeStateListener stateListener = (TreeStateListener)object;
            if (e == null) {
                e = new TreeExpansionEvent(this, null);
            }
            stateListener.treeStateCachedStateRestored(e);
        }
    }

    @ApiStatus.Internal
    public void fireTreeStateRestoreFinished() {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            Object object;
            if (listeners[i] != TreeExpansionListener.class || !((object = listeners[i + 1]) instanceof TreeStateListener)) continue;
            TreeStateListener stateListener = (TreeStateListener)object;
            if (e == null) {
                e = new TreeExpansionEvent(this, null);
            }
            stateListener.treeStateRestoreFinished(e);
        }
    }

    private boolean expandAccessibilityAnnouncementsAllowed() {
        return this.suspendedExpandAccessibilityAnnouncements.get() == 0;
    }

    @NotNull
    public Set<TreePath> getExpandedPaths() {
        if (!this.initialized) {
            TreePath rootPath = this.getRootPath();
            if (rootPath == null || !super.isExpanded(rootPath)) {
                Set<TreePath> set = Collections.emptySet();
                if (set == null) {
                    Tree.$$$reportNull$$$0(15);
                }
                return set;
            }
            HashSet<TreePath> result2 = new HashSet<TreePath>();
            result2.add(rootPath);
            Enumeration<TreePath> more = super.getExpandedDescendants(rootPath);
            if (more != null) {
                while (more.hasMoreElements()) {
                    result2.add(more.nextElement());
                }
            }
            HashSet<TreePath> hashSet = result2;
            if (hashSet == null) {
                Tree.$$$reportNull$$$0(16);
            }
            return hashSet;
        }
        Set<TreePath> set = this.expandImpl.getExpandedPaths();
        if (set == null) {
            Tree.$$$reportNull$$$0(17);
        }
        return set;
    }

    @Nullable
    private TreePath getRootPath() {
        TreeModel model = this.treeModel;
        if (model == null) {
            return null;
        }
        Object rootObject = model.getRoot();
        if (rootObject == null) {
            return null;
        }
        return new CachingTreePath(rootObject);
    }

    @Override
    public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
        if (!this.initialized) {
            return super.getExpandedDescendants(parent);
        }
        return this.expandImpl.getExpandedDescendants(parent);
    }

    @Override
    public boolean hasBeenExpanded(TreePath path) {
        if (!this.initialized) {
            return super.hasBeenExpanded(path);
        }
        return this.expandImpl.hasBeenExpanded(path);
    }

    @Override
    public boolean isExpanded(TreePath path) {
        if (!this.initialized) {
            return super.isExpanded(path);
        }
        return this.expandImpl.isExpanded(path);
    }

    @Override
    public boolean isExpanded(int row) {
        if (!this.initialized) {
            return super.isExpanded(row);
        }
        return this.expandImpl.isExpanded(row);
    }

    @Override
    protected void setExpandedState(TreePath path, boolean state) {
        if (!this.initialized) {
            super.setExpandedState(path, state);
            return;
        }
        this.expandImpl.setExpandedState(path, state);
    }

    @Override
    protected Enumeration<TreePath> getDescendantToggledPaths(TreePath parent) {
        if (!this.initialized) {
            return super.getDescendantToggledPaths(parent);
        }
        return this.expandImpl.getDescendantToggledPaths(parent);
    }

    @Override
    protected void removeDescendantToggledPaths(Enumeration<TreePath> toRemove) {
        if (!this.initialized) {
            super.removeDescendantToggledPaths(toRemove);
            return;
        }
        this.expandImpl.removeDescendantToggledPaths(toRemove);
    }

    @Override
    protected void clearToggledPaths() {
        if (this.initialized) {
            this.expandImpl.clearToggledPaths();
        }
        super.clearToggledPaths();
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return new MyTreeModelListener();
    }

    private void blockAutoScrollFromSource() {
        ClientProperty.put((JComponent)this, AUTO_SCROLL_FROM_SOURCE_BLOCKED, (Object)true);
        this.autoScrollUnblockTimer.restart();
    }

    @ApiStatus.Internal
    public void unblockAutoScrollFromSource() {
        ClientProperty.remove((JComponent)this, AUTO_SCROLL_FROM_SOURCE_BLOCKED);
    }

    @Deprecated
    public final void setLineStyleAngled() {
    }

    public <T> T @NotNull [] getSelectedNodes(Class<T> nodeType, @Nullable NodeFilter<? super T> filter) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            Object[] objectArray = ArrayUtil.newArray(nodeType, (int)0);
            if (objectArray == null) {
                Tree.$$$reportNull$$$0(18);
            }
            return objectArray;
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (TreePath path : paths) {
            Object last = path.getLastPathComponent();
            if (!nodeType.isAssignableFrom(last.getClass()) || filter != null && !filter.accept(last)) continue;
            nodes.add(last);
        }
        Object[] result2 = ArrayUtil.newArray(nodeType, (int)nodes.size());
        nodes.toArray(result2);
        if (result2 == null) {
            Tree.$$$reportNull$$$0(19);
        }
        return result2;
    }

    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        TreePath[] selection;
        if (info == null) {
            Tree.$$$reportNull$$$0(20);
        }
        if ((selection = this.getSelectionPaths()) == null) {
            return;
        }
        StringBuilder nodesText = new StringBuilder();
        for (TreePath eachPath : selection) {
            Object eachNode = eachPath.getLastPathComponent();
            Component c = this.getCellRenderer().getTreeCellRendererComponent(this, eachNode, false, false, false, this.getRowForPath(eachPath), false);
            if (c == null) continue;
            if (!nodesText.isEmpty()) {
                nodesText.append(";");
            }
            nodesText.append(c);
        }
        if (!nodesText.isEmpty()) {
            info.put("selectedNodes", nodesText.toString());
        }
    }

    public void setHoldSize(boolean hold) {
        if (hold && this.myHoldSize == null) {
            this.myHoldSize = this.getPreferredSize();
        } else if (!hold && this.myHoldSize != null) {
            this.myHoldSize = null;
            this.revalidate();
        }
    }

    public void setAdditionalRowsCount(int additionalRowsCount) {
        int oldValue = this.myAdditionalRowsCount;
        this.myAdditionalRowsCount = additionalRowsCount;
        this.firePropertyChange("additionalRowsCount", oldValue, additionalRowsCount);
    }

    public int getAdditionalRowsCount() {
        return this.myAdditionalRowsCount;
    }

    public int getEffectiveAdditionalRowsCount() {
        int result2 = this.myAdditionalRowsCount;
        if (result2 == -1) {
            result2 = Registry.intValue((String)"ide.tree.additional.rows.count", (int)1, (int)0, (int)10);
        }
        return result2;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height += this.getAdditionalRowsHeight();
        if (this.myHoldSize != null) {
            size.width = Math.max(size.width, this.myHoldSize.width);
            size.height = Math.max(size.height, this.myHoldSize.height);
        }
        return size;
    }

    private int getAdditionalRowsHeight() {
        int additionalRowsCount = this.getEffectiveAdditionalRowsCount();
        if (additionalRowsCount == 0) {
            return 0;
        }
        int rowHeight = this.getDefaultRowHeight();
        if (rowHeight == 0) {
            return 0;
        }
        int extraHeight = rowHeight * additionalRowsCount;
        JViewport viewport = ComponentUtil.getViewport((Component)this);
        int viewportHeight = viewport == null ? 0 : viewport.getHeight();
        int maximumSensibleExtraHeight = viewportHeight - rowHeight;
        if (maximumSensibleExtraHeight < 0) {
            maximumSensibleExtraHeight = 0;
        }
        return Math.min(extraHeight, maximumSensibleExtraHeight);
    }

    private int getDefaultRowHeight() {
        int result2 = this.getRowHeight();
        if (result2 <= 0) {
            result2 = JBUI.CurrentTheme.Tree.rowHeight();
        }
        if (result2 <= 0) {
            result2 = 0;
        }
        return result2;
    }

    @Override
    public void scrollPathToVisible(@Nullable TreePath path) {
        if (path == null) {
            return;
        }
        this.makeVisible(path);
        TreeUtil.scrollToVisible(this, path, false);
    }

    public boolean isHorizontalAutoScrollingEnabled() {
        return this.myHorizontalAutoScrolling != ThreeState.UNSURE ? this.myHorizontalAutoScrolling == ThreeState.YES : Registry.is((String)"ide.tree.horizontal.default.autoscrolling", (boolean)false);
    }

    public void setHorizontalAutoScrollingEnabled(boolean enabled) {
        this.myHorizontalAutoScrolling = enabled ? ThreeState.YES : ThreeState.NO;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int increment = super.getScrollableUnitIncrement(visibleRect, orientation, direction);
        if (increment == 0 && orientation == 1 && direction < 0) {
            return visibleRect.y;
        }
        return increment;
    }

    @Nullable
    public Component getDeepestRendererComponentAt(int x, int y) {
        TreeCellRenderer renderer;
        int row = this.getRowForLocation(x, y);
        if (row >= 0 && (renderer = this.getCellRenderer()) != null) {
            TreePath path = this.getPathForRow(row);
            Object node = path.getLastPathComponent();
            Component component = renderer.getTreeCellRendererComponent(this, node, this.isRowSelected(row), this.isExpanded(row), this.getModel().isLeaf(node), row, true);
            Rectangle bounds = this.getPathBounds(path);
            if (bounds != null) {
                component.setBounds(bounds);
                component.doLayout();
                return SwingUtilities.getDeepestComponentAt(component, x - bounds.x, y - bounds.y);
            }
        }
        return null;
    }

    @Override
    public void setTransferHandler(TransferHandler handler) {
        SmoothAutoScroller.installDropTargetAsNecessary(this);
        super.setTransferHandler(handler);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        SpeedSearchSupply supply = SpeedSearchSupply.getSupply(this, true);
        if (supply == null) {
            return null;
        }
        return supply.getInputMethodRequests();
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public CachedTreePresentation getCachedPresentation() {
        return this.expandImpl.getCachedPresentation();
    }

    @Override
    @ApiStatus.Internal
    public void setCachedPresentation(@Nullable CachedTreePresentation presentation) {
        CachedTreePresentation oldValue = this.expandImpl.getCachedPresentation();
        this.expandImpl.setCachedPresentation(presentation);
        this.firePropertyChange("CACHED_TREE_PRESENTATION", oldValue, presentation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/treeStructure/Tree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/treeStructure/Tree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWideSelectionBackgroundCondition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandableItemsHandler";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedPaths";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onPathExpanded";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onPathSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startMeasuringExpandDuration";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathBackground";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileColorForPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expandPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collapsePaths";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fireAccessibleTreeExpanded";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fireAccessibleTreeCollapsed";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fireTreeExpanded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireTreeCollapsed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    private class MySelectionModel
    extends DefaultTreeSelectionModel {
        private TreePath[] myHeldSelection;

        private MySelectionModel() {
        }

        @Override
        protected void fireValueChanged(TreeSelectionEvent e) {
            if (this.myHeldSelection == null) {
                TreeModel treeModel;
                ActivityTracker.getInstance().inc();
                super.fireValueChanged(e);
                if (!Tree.this.applyingViewModelChanges.get() && (treeModel = Tree.this.treeModel) instanceof TreeSwingModel) {
                    TreeSwingModel swingModel = (TreeSwingModel)treeModel;
                    ArrayList<TreeNodeViewModel> newSelection = new ArrayList<TreeNodeViewModel>();
                    for (TreePath path : this.getSelectionPaths()) {
                        Object object = path.getLastPathComponent();
                        if (!(object instanceof TreeNodeViewModel)) continue;
                        TreeNodeViewModel viewModel = (TreeNodeViewModel)object;
                        newSelection.add(viewModel);
                    }
                    swingModel.getViewModel().setSelection(newSelection);
                }
            }
        }

        public void holdSelection() {
            this.myHeldSelection = this.getSelectionPaths();
        }

        public void unholdSelection() {
            if (this.myHeldSelection != null) {
                this.setSelectionPaths(this.myHeldSelection);
                this.myHeldSelection = null;
            }
        }
    }

    private class MyUISettingsListener
    implements UISettingsListener {
        private boolean applyingUiSettings = false;
        private boolean toggleClickCountOverridden;
        @Nullable
        private MessageBusConnection connection;

        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(@NotNull UISettings uiSettings) {
            if (uiSettings == null) {
                MyUISettingsListener.$$$reportNull$$$0(0);
            }
            if (this.applyingUiSettings) {
                LOG.warn(new Throwable("Reentrant com.intellij.ui.treeStructure.Tree.MyUISettingsListener.uiSettingsChanged call"));
                return;
            }
            this.applyingUiSettings = true;
            try {
                if (!this.toggleClickCountOverridden && Tree.isExpandWithSingleClickSettingEnabled()) {
                    Tree.this.setToggleClickCount(uiSettings.getExpandNodesWithSingleClick() ? 1 : 2);
                }
            }
            finally {
                this.applyingUiSettings = false;
            }
        }

        void setToggleClickCountCalled() {
            if (!this.applyingUiSettings) {
                this.toggleClickCountOverridden = true;
            }
        }

        void connect() {
            this.disconnect();
            this.connection = ApplicationManager.getApplication().getMessageBus().connect();
            this.connection.subscribe(TOPIC, (Object)this);
            this.uiSettingsChanged(UISettings.getInstance());
        }

        void disconnect() {
            if (this.connection != null) {
                Disposer.dispose((Disposable)this.connection);
                this.connection = null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/ui/treeStructure/Tree$MyUISettingsListener", "uiSettingsChanged"));
        }
    }

    private class ExpandImpl
    implements CachedTreePresentationSupport {
        private final Map<TreePath, Boolean> expandedState = new HashMap<TreePath, Boolean>();
        @Nullable
        private CachedPresentationImpl cachedPresentation;

        private ExpandImpl() {
            Enumeration toggled;
            TreePath rootPath = Tree.this.getRootPath();
            if (rootPath != null && (toggled = Tree.super.getDescendantToggledPaths(rootPath)) != null) {
                while (toggled.hasMoreElements()) {
                    TreePath toggledPath = (TreePath)toggled.nextElement();
                    this.expandedState.put(toggledPath, Tree.super.isExpanded(toggledPath));
                }
            }
        }

        @Override
        @Nullable
        public CachedTreePresentation getCachedPresentation() {
            return this.cachedPresentation != null ? this.cachedPresentation.cachedTree : null;
        }

        @Override
        public void setCachedPresentation(@Nullable CachedTreePresentation presentation) {
            TreeModel treeModel;
            TreePath rootPath;
            if (this.cachedPresentation != null && presentation != null) {
                return;
            }
            CachedPresentationImpl cachedPresentationImpl = this.cachedPresentation = presentation == null ? null : new CachedPresentationImpl(presentation);
            if (this.cachedPresentation != null && (rootPath = Tree.this.getRootPath()) != null) {
                presentation.rootLoaded(rootPath.getLastPathComponent());
                this.cachedPresentation.updateExpandedNodes(rootPath);
            }
            if ((treeModel = Tree.this.getModel()) instanceof CachedTreePresentationSupport) {
                CachedTreePresentationSupport cps = (CachedTreePresentationSupport)((Object)treeModel);
                cps.setCachedPresentation(presentation);
            }
        }

        void markPathExpanded(@NotNull TreePath path) {
            if (path == null) {
                ExpandImpl.$$$reportNull$$$0(0);
            }
            this.markPathExpandedState(path, true);
        }

        void markPathCollapsed(TreePath path) {
            this.markPathExpandedState(path, false);
        }

        private void markPathExpandedState(@NotNull TreePath path, boolean expanded) {
            Object object;
            if (path == null) {
                ExpandImpl.$$$reportNull$$$0(1);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(new Throwable((expanded ? "Expanding" : "Collapsing") + " " + String.valueOf(path)));
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((expanded ? "Expanding" : "Collapsing") + " " + String.valueOf(path));
            }
            TreeModel model = Tree.this.getModel();
            if (!expanded && model != null && model.isLeaf(path.getLastPathComponent())) {
                this.expandedState.remove(path);
            } else {
                this.expandedState.put(path, expanded);
            }
            if (this.cachedPresentation != null) {
                this.cachedPresentation.setExpanded(path, expanded);
            }
            if ((object = path.getLastPathComponent()) instanceof TreeNodeViewModel) {
                TreeNodeViewModel viewModel = (TreeNodeViewModel)object;
                if (Tree.this.applyingViewModelChanges.get()) {
                    LOG.debug("Not forwarding the new state to the view model because it came from the model itself");
                } else {
                    LOG.debug("Forwarding the new state to the view model");
                    viewModel.setExpanded(expanded);
                }
            }
        }

        @NotNull
        Set<TreePath> getExpandedPaths() {
            HashSet<TreePath> result2 = new HashSet<TreePath>();
            TreePath rootPath = Tree.this.getRootPath();
            if (!Tree.this.isRootVisible() || this.isExpanded(rootPath)) {
                result2.add(rootPath);
            }
            for (Map.Entry<TreePath, Boolean> e : this.expandedState.entrySet()) {
                if (!e.getValue().booleanValue()) continue;
                result2.add(e.getKey());
            }
            HashSet<TreePath> hashSet = result2;
            if (hashSet == null) {
                ExpandImpl.$$$reportNull$$$0(2);
            }
            return hashSet;
        }

        @Nullable
        Enumeration<TreePath> getExpandedDescendants(@Nullable TreePath parent) {
            if (parent == null || !this.isExpanded(parent)) {
                return null;
            }
            Set<TreePath> toggledPaths = this.expandedState.keySet();
            ArrayList<TreePath> elements = null;
            for (TreePath path : toggledPaths) {
                Boolean value2 = this.expandedState.get(path);
                if (path.equals(parent) || value2 == null || !value2.booleanValue() || !parent.isDescendant(path) || !Tree.this.isVisible(path)) continue;
                if (elements == null) {
                    elements = new ArrayList<TreePath>();
                }
                elements.add(path);
            }
            return elements == null ? Collections.emptyEnumeration() : Collections.enumeration(elements);
        }

        boolean hasBeenExpanded(@Nullable TreePath path) {
            return path != null && this.expandedState.get(path) != null;
        }

        boolean isExpanded(@Nullable TreePath path) {
            if (path == null) {
                return false;
            }
            do {
                Boolean value2;
                if ((value2 = this.expandedState.get(path)) != null && value2.booleanValue()) continue;
                return false;
            } while ((path = path.getParentPath()) != null);
            return true;
        }

        boolean isExpanded(int row) {
            TreePath path;
            TreeUI tree = Tree.this.getUI();
            if (tree != null && (path = tree.getPathForRow(Tree.this, row)) != null) {
                Boolean value2 = this.expandedState.get(path);
                return value2 != null && value2 != false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void expandPaths(@NotNull @NotNull Iterable<@NotNull TreePath> paths) {
            ArrayList<TreePath> pathList;
            if (paths == null) {
                ExpandImpl.$$$reportNull$$$0(3);
            }
            long started = 0L;
            long count = 0L;
            if (LOG.isDebugEnabled()) {
                started = System.currentTimeMillis();
            }
            if ((pathList = ExpandImpl.toList(paths)).size() == 1) {
                TreePath path = pathList.get(0);
                if (this.isNotLeaf(path)) {
                    this.setExpandedState(path, true);
                }
                return;
            }
            pathList.sort(Comparator.comparing(TreePath::getPathCount));
            LinkedHashSet<TreePath> toExpand = new LinkedHashSet<TreePath>();
            HashSet<TreePath> toNotExpand = new HashSet<TreePath>();
            for (TreePath path : pathList) {
                ++count;
                this.shouldAllParentsBeExpanded(path, toExpand, toNotExpand);
            }
            LinkedHashSet<TreePath> expandRoots = new LinkedHashSet<TreePath>();
            try {
                this.beginBulkOperation();
                Tree.this.fireBulkExpandStarted();
                Tree.this.suspendExpandCollapseAccessibilityAnnouncements();
                for (TreePath path : toExpand) {
                    if (!this.isNotLeaf(path)) continue;
                    this.markPathExpanded(path);
                    Tree.this.fireTreeExpanded(path);
                    TreePath parent = path.getParentPath();
                    if (expandRoots.size() >= 5 || parent != null && toExpand.contains(parent)) continue;
                    expandRoots.add(path);
                }
            }
            finally {
                Tree.this.resumeExpandCollapseAccessibilityAnnouncements();
                Tree.this.fireBulkExpandEnded();
                this.endBulkOperation();
            }
            if (Tree.this.accessibleContext != null) {
                for (TreePath expandRoot : expandRoots) {
                    Tree.this.fireAccessibleTreeExpanded(expandRoot);
                }
                ((JTree.AccessibleJTree)Tree.this.accessibleContext).fireVisibleDataPropertyChange();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Expanded " + count + " paths, time: " + (System.currentTimeMillis() - started) + " ms");
            }
        }

        private boolean isNotLeaf(@NotNull TreePath path) {
            TreeModel model;
            if (path == null) {
                ExpandImpl.$$$reportNull$$$0(4);
            }
            return (model = Tree.this.getModel()) != null && !model.isLeaf(path.getLastPathComponent());
        }

        private void beginBulkOperation() {
            Tree.this.bulkOperationsInProgress.incrementAndGet();
            TreeUI ui = Tree.this.getUI();
            if (ui instanceof TreeUiBulkExpandCollapseSupport) {
                TreeUiBulkExpandCollapseSupport bulk = (TreeUiBulkExpandCollapseSupport)((Object)ui);
                bulk.beginBulkOperation();
            }
        }

        private void endBulkOperation() {
            TreeUI ui = Tree.this.getUI();
            if (ui instanceof TreeUiBulkExpandCollapseSupport) {
                TreeUiBulkExpandCollapseSupport bulk = (TreeUiBulkExpandCollapseSupport)((Object)ui);
                bulk.endBulkOperation();
            }
            Tree.this.bulkOperationsInProgress.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void collapsePaths(@NotNull @NotNull Iterable<@NotNull TreePath> paths) {
            ArrayList<TreePath> pathList;
            if (paths == null) {
                ExpandImpl.$$$reportNull$$$0(5);
            }
            long started = 0L;
            long count = 0L;
            if (LOG.isDebugEnabled()) {
                started = System.currentTimeMillis();
            }
            if ((pathList = ExpandImpl.toList(paths)).size() == 1) {
                TreePath path = pathList.get(0);
                if (this.isNotLeaf(path)) {
                    this.setExpandedState(path, false);
                } else {
                    this.expandedState.remove(path);
                }
                return;
            }
            pathList.sort(Comparator.comparing(TreePath::getPathCount));
            LinkedHashSet<TreePath> toExpand = new LinkedHashSet<TreePath>();
            HashSet<TreePath> toNotExpand = new HashSet<TreePath>();
            LinkedHashSet<TreePath> toCollapse = new LinkedHashSet<TreePath>();
            LinkedHashSet<TreePath> collapseRoots = new LinkedHashSet<TreePath>();
            for (TreePath path : pathList) {
                ++count;
                TreePath parent = path.getParentPath();
                boolean parentWillBeCollapsed = toCollapse.contains(parent);
                boolean pathWillBeCollapsed = false;
                if (parent == null || toExpand.contains(parent) || parentWillBeCollapsed) {
                    toCollapse.add(path);
                    pathWillBeCollapsed = true;
                } else if (!toNotExpand.contains(parent) && this.shouldAllParentsBeExpanded(parent, toExpand, toNotExpand)) {
                    toCollapse.add(path);
                    pathWillBeCollapsed = true;
                }
                if (parentWillBeCollapsed || !pathWillBeCollapsed) continue;
                collapseRoots.add(path);
            }
            ArrayList toCollapseList = new ArrayList(toCollapse);
            Collections.reverse(toCollapseList);
            try {
                this.beginBulkOperation();
                Tree.this.fireBulkCollapseStarted();
                Tree.this.suspendExpandCollapseAccessibilityAnnouncements();
                for (TreePath path : toExpand) {
                    this.markPathExpanded(path);
                    Tree.this.fireTreeExpanded(path);
                }
                for (TreePath path : toCollapseList) {
                    if (this.isNotLeaf(path)) {
                        this.markPathCollapsed(path);
                        Tree.this.fireTreeCollapsed(path);
                        if (!Tree.this.removeDescendantSelectedPaths(path, false) || Tree.this.isPathSelected(path)) continue;
                        Tree.this.addSelectionPath(path);
                        continue;
                    }
                    this.expandedState.remove(path);
                }
            }
            finally {
                Tree.this.resumeExpandCollapseAccessibilityAnnouncements();
                Tree.this.fireBulkCollapseEnded();
                this.endBulkOperation();
            }
            if (Tree.this.accessibleContext != null) {
                for (TreePath collapseRoot : collapseRoots) {
                    Tree.this.fireAccessibleTreeCollapsed(collapseRoot);
                }
                ((JTree.AccessibleJTree)Tree.this.accessibleContext).fireVisibleDataPropertyChange();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Collapsed " + count + " paths, time: " + (System.currentTimeMillis() - started) + " ms");
            }
        }

        @NotNull
        private static ArrayList<TreePath> toList(@NotNull @NotNull Iterable<@NotNull TreePath> paths) {
            ArrayList<TreePath> pathList;
            if (paths == null) {
                ExpandImpl.$$$reportNull$$$0(6);
            }
            if (paths instanceof Collection) {
                Collection pathCollection = (Collection)paths;
                pathList = new ArrayList(pathCollection);
            } else {
                pathList = new ArrayList<TreePath>();
                paths.forEach(pathList::add);
            }
            ArrayList<TreePath> arrayList = pathList;
            if (arrayList == null) {
                ExpandImpl.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private boolean shouldAllParentsBeExpanded(@NotNull TreePath path, @NotNull @NotNull Set<@NotNull TreePath> toExpand, @NotNull @NotNull Set<@NotNull TreePath> toNotExpand) {
            if (path == null) {
                ExpandImpl.$$$reportNull$$$0(8);
            }
            if (toExpand == null) {
                ExpandImpl.$$$reportNull$$$0(9);
            }
            if (toNotExpand == null) {
                ExpandImpl.$$$reportNull$$$0(10);
            }
            ArrayDeque<TreePath> stack = null;
            TreePath parentPath = path;
            boolean result2 = true;
            while (parentPath != null) {
                if (this.isExpanded(parentPath) || toExpand.contains(parentPath)) {
                    parentPath = null;
                    continue;
                }
                if (toNotExpand.contains(parentPath)) {
                    parentPath = null;
                    result2 = false;
                    continue;
                }
                if (stack == null) {
                    stack = new ArrayDeque<TreePath>();
                }
                stack.push(parentPath);
                parentPath = parentPath.getParentPath();
            }
            while (stack != null && !stack.isEmpty()) {
                parentPath = (TreePath)stack.pop();
                if (result2) {
                    try {
                        Tree.this.fireTreeWillExpand(parentPath);
                    }
                    catch (ExpandVetoException eve) {
                        result2 = false;
                    }
                }
                if (result2) {
                    toExpand.add(parentPath);
                    continue;
                }
                toNotExpand.add(parentPath);
            }
            return result2;
        }

        void setExpandedState(@Nullable TreePath path, boolean state) {
            if (path == null) {
                return;
            }
            if (!this.expandParentPaths(path)) {
                return;
            }
            if (state) {
                this.expandPath(path);
            } else {
                this.collapsePath(path);
            }
        }

        void setExpandedStateFromViewModel(@NotNull TreePath path, boolean state) {
            if (path == null) {
                ExpandImpl.$$$reportNull$$$0(11);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting expanded state=" + state + " from the view model " + String.valueOf(path));
            }
            if (Tree.this.isVisible(path)) {
                this.setExpandedState(path, state);
            } else {
                this.markPathExpandedState(path, state);
            }
        }

        private boolean expandParentPaths(@NotNull TreePath path) {
            if (path == null) {
                ExpandImpl.$$$reportNull$$$0(12);
            }
            ArrayDeque<TreePath> stack = null;
            TreePath parentPath = path.getParentPath();
            while (parentPath != null) {
                if (this.isExpanded(parentPath)) {
                    parentPath = null;
                    continue;
                }
                if (stack == null) {
                    stack = new ArrayDeque<TreePath>();
                }
                stack.push(parentPath);
                parentPath = parentPath.getParentPath();
            }
            while (stack != null && !stack.isEmpty()) {
                parentPath = (TreePath)stack.pop();
                if (this.isExpanded(parentPath)) continue;
                try {
                    Tree.this.fireTreeWillExpand(parentPath);
                }
                catch (ExpandVetoException eve) {
                    return false;
                }
                this.markPathExpanded(parentPath);
                Tree.this.fireTreeExpanded(parentPath);
                if (Tree.this.accessibleContext == null) continue;
                ((JTree.AccessibleJTree)Tree.this.accessibleContext).fireVisibleDataPropertyChange();
            }
            return true;
        }

        private void expandPath(@NotNull TreePath path) {
            if (path == null) {
                ExpandImpl.$$$reportNull$$$0(13);
            }
            if (Boolean.TRUE.equals(this.expandedState.get(path))) {
                return;
            }
            try {
                Tree.this.fireTreeWillExpand(path);
            }
            catch (ExpandVetoException eve) {
                return;
            }
            this.markPathExpanded(path);
            Tree.this.fireTreeExpanded(path);
            if (Tree.this.accessibleContext != null) {
                ((JTree.AccessibleJTree)Tree.this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }

        private void collapsePath(@NotNull TreePath path) {
            if (path == null) {
                ExpandImpl.$$$reportNull$$$0(14);
            }
            if (!Boolean.TRUE.equals(this.expandedState.get(path))) {
                return;
            }
            try {
                Tree.this.fireTreeWillCollapse(path);
            }
            catch (ExpandVetoException eve) {
                return;
            }
            this.markPathCollapsed(path);
            Tree.this.fireTreeCollapsed(path);
            if (Tree.this.removeDescendantSelectedPaths(path, false) && !Tree.this.isPathSelected(path)) {
                Tree.this.addSelectionPath(path);
            }
            if (Tree.this.accessibleContext != null) {
                ((JTree.AccessibleJTree)Tree.this.accessibleContext).fireVisibleDataPropertyChange();
            }
        }

        @Nullable
        Enumeration<TreePath> getDescendantToggledPaths(@Nullable TreePath parent) {
            if (parent == null) {
                return null;
            }
            ArrayList<TreePath> descendants = new ArrayList<TreePath>();
            Set<TreePath> nodes = this.expandedState.keySet();
            for (TreePath path : nodes) {
                if (!parent.isDescendant(path)) continue;
                descendants.add(path);
            }
            return Collections.enumeration(descendants);
        }

        void removeDescendantToggledPaths(Enumeration<TreePath> toRemove) {
            if (toRemove == null) {
                return;
            }
            while (toRemove.hasMoreElements()) {
                Enumeration<TreePath> descendants = this.getDescendantToggledPaths(toRemove.nextElement());
                if (descendants == null) continue;
                while (descendants.hasMoreElements()) {
                    this.expandedState.remove(descendants.nextElement());
                }
            }
        }

        void clearToggledPaths() {
            this.expandedState.clear();
        }

        TreeModelListener createTreeModelListener() {
            return new TreeModelListenerImpl();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/treeStructure/Tree$ExpandImpl";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toExpand";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toNotExpand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/treeStructure/Tree$ExpandImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpandedPaths";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "markPathExpanded";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "markPathExpandedState";
                    break;
                }
                case 2: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "expandPaths";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isNotLeaf";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "collapsePaths";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "toList";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "shouldAllParentsBeExpanded";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "setExpandedStateFromViewModel";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "expandParentPaths";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "expandPath";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "collapsePath";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 7 -> new IllegalStateException(string);
            };
        }

        private class TreeModelListenerImpl
        implements TreeSwingModelListener {
            private TreeModelListenerImpl() {
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TreePath path = e.getTreePath();
                Object object = path.getLastPathComponent();
                if (object instanceof TreeNodeViewModel) {
                    TreeNodeViewModel viewModel = (TreeNodeViewModel)object;
                    this.applyViewModelChange(() -> Tree.this.expandImpl.setExpandedStateFromViewModel(path, viewModel.stateSnapshot().isExpanded()));
                }
            }

            private void applyViewModelChange(@NotNull Runnable runnable) {
                if (runnable == null) {
                    TreeModelListenerImpl.$$$reportNull$$$0(0);
                }
                if (!Tree.this.applyingViewModelChanges.compareAndSet(false, true)) {
                    throw new IllegalStateException("Already applying a view model change, changes should not be recursive, it's a bug");
                }
                try {
                    runnable.run();
                }
                finally {
                    Tree.this.applyingViewModelChanges.set(false);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreeModel model = Tree.this.getModel();
                CachingTreePath path = Tree.this.getPath(e);
                if (model == null || path == null) {
                    return;
                }
                Object parent = path.getLastPathComponent();
                int childCount = model.getChildCount(parent);
                for (int i : e.getChildIndices()) {
                    if (i < 0 || i >= childCount) continue;
                    Object newChild = model.getChild(parent, i);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Inserted child " + i + " " + String.valueOf(newChild) + " of parent " + String.valueOf(parent));
                    }
                    TreePath childPath = path.pathByAddingChild(newChild);
                    if (newChild instanceof TreeNodeViewModel) {
                        this.applyViewModelChange(() -> this.applyNewNodeExpandedState(model, childPath));
                    }
                    if (ExpandImpl.this.cachedPresentation == null) continue;
                    ExpandImpl.this.cachedPresentation.updateExpandedNodes(childPath);
                }
            }

            private void applyNewNodeExpandedState(@NotNull TreeModel model, @NotNull TreePath path) {
                if (model == null) {
                    TreeModelListenerImpl.$$$reportNull$$$0(1);
                }
                if (path == null) {
                    TreeModelListenerImpl.$$$reportNull$$$0(2);
                }
                TreeNodeViewModel node = (TreeNodeViewModel)path.getLastPathComponent();
                boolean isExpanded = node.stateSnapshot().isExpanded();
                Tree.this.expandImpl.setExpandedStateFromViewModel(path, isExpanded);
                if (isExpanded) {
                    int childCount = model.getChildCount(node);
                    for (int i = 0; i < childCount; ++i) {
                        Object child = model.getChild(node, i);
                        if (!(child instanceof TreeNodeViewModel)) continue;
                        this.applyNewNodeExpandedState(model, path.pathByAddingChild(child));
                    }
                }
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                if (e == null) {
                    return;
                }
                CachingTreePath parent = Tree.this.getPath(e);
                if (parent == null) {
                    return;
                }
                if (((TreePath)parent).getPathCount() == 1) {
                    ExpandImpl.this.clearToggledPaths();
                    Object treeRoot = Tree.this.treeModel.getRoot();
                    if (treeRoot != null && !Tree.this.treeModel.isLeaf(treeRoot)) {
                        ExpandImpl.this.markPathExpanded(parent);
                    }
                } else if (ExpandImpl.this.expandedState.get(parent) != null) {
                    ArrayList<CachingTreePath> toRemove = new ArrayList<CachingTreePath>(1);
                    boolean isExpanded = ExpandImpl.this.isExpanded(parent);
                    toRemove.add(parent);
                    ExpandImpl.this.removeDescendantToggledPaths(Collections.enumeration(toRemove));
                    if (isExpanded) {
                        TreeModel model = Tree.this.getModel();
                        if (model == null || model.isLeaf(parent.getLastPathComponent())) {
                            ExpandImpl.this.collapsePath(parent);
                        } else {
                            ExpandImpl.this.markPathExpanded(parent);
                        }
                    }
                }
                Tree.this.removeDescendantSelectedPaths(parent, false);
                if (ExpandImpl.this.cachedPresentation != null) {
                    ExpandImpl.this.cachedPresentation.updateExpandedNodes(parent);
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                TreeModel model;
                if (e == null) {
                    return;
                }
                CachingTreePath parent = Tree.this.getPath(e);
                Object[] children = e.getChildren();
                if (children == null || parent == null) {
                    return;
                }
                ArrayList<TreePath> toRemove = new ArrayList<TreePath>(Math.max(1, children.length));
                for (int counter = children.length - 1; counter >= 0; --counter) {
                    TreePath path = ((TreePath)parent).pathByAddingChild(children[counter]);
                    if (ExpandImpl.this.expandedState.get(path) == null) continue;
                    toRemove.add(path);
                }
                if (!toRemove.isEmpty()) {
                    ExpandImpl.this.removeDescendantToggledPaths(Collections.enumeration(toRemove));
                }
                if ((model = Tree.this.getModel()) == null || model.isLeaf(parent.getLastPathComponent())) {
                    ExpandImpl.this.expandedState.remove(parent);
                }
                this.removeDescendantSelectedPaths(e);
            }

            private void removeDescendantSelectedPaths(TreeModelEvent e) {
                CachingTreePath pPath = Tree.this.getPath(e);
                if (pPath == null) {
                    return;
                }
                Object[] oldChildren = e.getChildren();
                TreeSelectionModel sm = Tree.this.getSelectionModel();
                if (sm != null && oldChildren != null && oldChildren.length > 0) {
                    for (int counter = oldChildren.length - 1; counter >= 0; --counter) {
                        Tree.this.removeDescendantSelectedPaths(((TreePath)pPath).pathByAddingChild(oldChildren[counter]), true);
                    }
                }
            }

            @Override
            public void selectionChanged(@NotNull TreeSwingModelSelectionEvent event) {
                if (event == null) {
                    TreeModelListenerImpl.$$$reportNull$$$0(3);
                }
                this.applyViewModelChange(() -> Tree.this.setSelectionPaths(event.getNewSelection()));
            }

            @Override
            public void scrollRequested(@NotNull TreeSwingModelScrollEvent event) {
                if (event == null) {
                    TreeModelListenerImpl.$$$reportNull$$$0(4);
                }
                this.applyViewModelChange(() -> TreeUtil.scrollToVisible(Tree.this, event.getScrollTo(), Registry.is((String)"ide.tree.autoscrollToVCenter", (boolean)false)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runnable";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "model";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/ui/treeStructure/Tree$ExpandImpl$TreeModelListenerImpl";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyViewModelChange";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applyNewNodeExpandedState";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "scrollRequested";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        @Nullable
        private TreePath treePathUnderMouse = null;

        private MyMouseListener() {
            Tree.this.autoScrollUnblockTimer.setRepeats(false);
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.treePathUnderMouse = Tree.this.getPathForLocation(event.getX(), event.getY());
            if (!Tree.this.hasFocus()) {
                Tree.this.blockAutoScrollFromSource();
            }
            this.setPressed(event, true);
            if (Boolean.FALSE.equals(UIUtil.getClientProperty((Object)event.getSource(), AUTO_SELECT_ON_MOUSE_PRESSED)) && Tree.this.getSelectionModel().getSelectionCount() > 1) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(event) && (SwingUtilities.isRightMouseButton(event) || SwingUtilities.isMiddleMouseButton(event))) {
                TreePath[] selectionPaths;
                TreePath path = Tree.this.getClosestPathForLocation(event.getX(), event.getY());
                if (path == null) {
                    return;
                }
                Rectangle bounds = Tree.this.getPathBounds(path);
                if (bounds != null && bounds.y + bounds.height < event.getY()) {
                    return;
                }
                if (Tree.this.getSelectionModel().getSelectionMode() != 1 && (selectionPaths = Tree.this.getSelectionModel().getSelectionPaths()) != null) {
                    for (TreePath selectionPath : selectionPaths) {
                        if (selectionPath == null || !selectionPath.equals(path)) continue;
                        return;
                    }
                }
                Tree.this.getSelectionModel().setSelectionPath(path);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            TreePath treePathUnderMouseAfterEvent = Tree.this.getPathForLocation(event.getX(), event.getY());
            if (!Comparing.equal((Object)this.treePathUnderMouse, (Object)treePathUnderMouseAfterEvent)) {
                event.consume();
            }
            this.treePathUnderMouse = null;
            this.setPressed(event, false);
            if (event.getButton() == 1 && event.getClickCount() == 2 && TreeUtil.isLocationInExpandControl(Tree.this, event.getX(), event.getY())) {
                event.consume();
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (UIUtil.isUnderWin10LookAndFeel() && Tree.this.rollOverPath != null) {
                TreeCellRenderer renderer = Tree.this.getCellRenderer();
                Object object = Tree.this.rollOverPath.getLastPathComponent();
                if (object instanceof TreeNode) {
                    TreeNode node = (TreeNode)object;
                    JComponent c = (JComponent)renderer.getTreeCellRendererComponent(Tree.this, node, Tree.this.isPathSelected(Tree.this.rollOverPath), Tree.this.isExpanded(Tree.this.rollOverPath), Tree.this.getModel().isLeaf(node), Tree.this.getRowForPath(Tree.this.rollOverPath), Tree.this.hasFocus());
                    c.putClientProperty("JCheckBox.rollOver.rectangle", null);
                    Tree.this.rollOverPath = null;
                    UIUtil.repaintViewport((JComponent)Tree.this);
                }
            }
        }

        private void setPressed(MouseEvent e, boolean pressed) {
            if (UIUtil.isUnderWin10LookAndFeel()) {
                Object object;
                Point p = e.getPoint();
                TreePath path = Tree.this.getPathForLocation(p.x, p.y);
                if (path != null && (object = path.getLastPathComponent()) instanceof TreeNode) {
                    TreeNode node = (TreeNode)object;
                    JComponent c = (JComponent)Tree.this.getCellRenderer().getTreeCellRendererComponent(Tree.this, node, Tree.this.isPathSelected(path), Tree.this.isExpanded(path), Tree.this.getModel().isLeaf(node), Tree.this.getRowForPath(path), Tree.this.hasFocus());
                    if (pressed) {
                        c.putClientProperty("JCheckBox.pressed.rectangle", c instanceof JCheckBox ? Tree.this.getPathBounds(path) : node);
                    } else {
                        c.putClientProperty("JCheckBox.pressed.rectangle", null);
                    }
                    UIUtil.repaintViewport((JComponent)Tree.this);
                }
            }
        }
    }

    private class MyFocusListener
    extends FocusAdapter {
        private MyFocusListener() {
        }

        private void focusChanges() {
            TreePath[] paths = Tree.this.getSelectionPaths();
            if (paths != null) {
                TreeUI ui = Tree.this.getUI();
                for (int i = paths.length - 1; i >= 0; --i) {
                    Rectangle bounds = ui.getPathBounds(Tree.this, paths[i]);
                    if (bounds == null) continue;
                    Tree.this.repaint(bounds);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focusChanges();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusChanges();
        }
    }

    private class MyTreeModelListener
    implements TreeSwingModelListener {
        @NotNull
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull LazyInitializer.LazyValue<@NotNull TreeModelListener> delegate = LazyInitializer.create(() -> Tree.this.expandImpl.createTreeModelListener());

        private MyTreeModelListener() {
        }

        @Nullable
        private TreeModelListener delegate() {
            return Tree.this.initialized ? (TreeModelListener)this.delegate.get() : null;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreeModelListener delegate = this.delegate();
            if (delegate != null) {
                delegate.treeNodesChanged(e);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreeModelListener delegate = this.delegate();
            if (delegate != null) {
                delegate.treeNodesInserted(e);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreeModelListener delegate = this.delegate();
            if (delegate != null) {
                delegate.treeNodesRemoved(e);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreeModelListener delegate = this.delegate();
            if (delegate != null) {
                delegate.treeStructureChanged(e);
            }
        }

        @Override
        public void selectionChanged(@NotNull TreeSwingModelSelectionEvent event) {
            TreeModelListener treeModelListener;
            if (event == null) {
                MyTreeModelListener.$$$reportNull$$$0(0);
            }
            if ((treeModelListener = this.delegate()) instanceof TreeSwingModelListener) {
                TreeSwingModelListener treeSwingModelListener = (TreeSwingModelListener)treeModelListener;
                treeSwingModelListener.selectionChanged(event);
            }
        }

        @Override
        public void scrollRequested(@NotNull TreeSwingModelScrollEvent event) {
            TreeModelListener treeModelListener;
            if (event == null) {
                MyTreeModelListener.$$$reportNull$$$0(1);
            }
            if ((treeModelListener = this.delegate()) instanceof TreeSwingModelListener) {
                TreeSwingModelListener treeSwingModelListener = (TreeSwingModelListener)treeModelListener;
                treeSwingModelListener.scrollRequested(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ui/treeStructure/Tree$MyTreeModelListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "scrollRequested";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface NodeFilter<T> {
        public boolean accept(T var1);
    }

    private class CachedPresentationImpl {
        @NotNull
        private final CachedTreePresentation cachedTree;

        CachedPresentationImpl(CachedTreePresentation cachedTree) {
            if (cachedTree == null) {
                CachedPresentationImpl.$$$reportNull$$$0(0);
            }
            this.cachedTree = cachedTree;
        }

        void setExpanded(@NotNull TreePath path, boolean isExpanded) {
            if (path == null) {
                CachedPresentationImpl.$$$reportNull$$$0(1);
            }
            this.cachedTree.setExpanded(path, isExpanded);
        }

        void updateExpandedNodes(@NotNull TreePath parent) {
            if (parent == null) {
                CachedPresentationImpl.$$$reportNull$$$0(2);
            }
            Tree.this.expandPaths(this.collectCachedExpandedPaths(parent));
        }

        @NotNull
        private Iterable<TreePath> collectCachedExpandedPaths(@NotNull TreePath parent) {
            TreeModel model;
            if (parent == null) {
                CachedPresentationImpl.$$$reportNull$$$0(3);
            }
            if ((model = Tree.this.getModel()) == null) {
                List<TreePath> list = Collections.emptyList();
                if (list == null) {
                    CachedPresentationImpl.$$$reportNull$$$0(4);
                }
                return list;
            }
            Collection<TreePath> collection = this.cachedTree.getExpandedDescendants(model, parent);
            if (collection == null) {
                CachedPresentationImpl.$$$reportNull$$$0(5);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cachedTree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/treeStructure/Tree$CachedPresentationImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/treeStructure/Tree$CachedPresentationImpl";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectCachedExpandedPaths";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setExpanded";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateExpandedNodes";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "collectCachedExpandedPaths";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

